/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.dropdown;

import com.google.gwtmockito.GwtMockitoTestRunner;
import elemental2.dom.HTMLElement;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.drools.workbench.screens.scenariosimulation.client.dropdown.AbstractScenarioSimulationDropdownTest;
import org.drools.workbench.screens.scenariosimulation.client.dropdown.ScenarioSimulationAssetsDropdownProvider;
import org.drools.workbench.screens.scenariosimulation.client.dropdown.ScenarioSimulationDropdown;
import org.drools.workbench.screens.scenariosimulation.client.dropdown.ScenarioSimulationDropdownView;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.widgets.client.assets.dropdown.KieAssetsDropdown;
import org.kie.workbench.common.widgets.client.assets.dropdown.KieAssetsDropdownItem;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.mvp.Command;

@RunWith(value=GwtMockitoTestRunner.class)
public class ScenarioSimulationDropdownTest
extends AbstractScenarioSimulationDropdownTest {
    @Mock
    private ScenarioSimulationDropdownView viewMock;
    @Mock
    private ScenarioSimulationAssetsDropdownProvider dataProviderMock;
    @Mock
    private HTMLElement htmlElementMock;
    @Mock
    private Command onValueChangeHandlerMock;
    private ScenarioSimulationDropdown scenarioSimulationDropdown;
    private List<KieAssetsDropdownItem> assetList = IntStream.range(0, 3).mapToObj(i -> new KieAssetsDropdownItem("File_" + i + ".txt", "", "DEFAULT_VALUE", new HashMap())).collect(Collectors.toList());

    @Override
    @Before
    public void setup() {
        super.setup();
        Mockito.when((Object)this.viewMock.getElement()).thenReturn((Object)this.htmlElementMock);
        Mockito.when((Object)this.viewMock.getValue()).thenReturn((Object)"DEFAULT_VALUE");
        this.scenarioSimulationDropdown = (ScenarioSimulationDropdown)Mockito.spy((Object)new ScenarioSimulationDropdown(this.viewMock, this.dataProviderMock){
            {
                this.onValueChangeHandler = ScenarioSimulationDropdownTest.this.onValueChangeHandlerMock;
                this.kieAssets.addAll(ScenarioSimulationDropdownTest.this.assetList);
            }
        });
    }

    @Test
    public void init() {
        this.scenarioSimulationDropdown.init();
        ((ScenarioSimulationDropdownView)Mockito.verify((Object)this.viewMock, (VerificationMode)Mockito.times((int)1))).init((KieAssetsDropdown)Matchers.eq((Object)this.scenarioSimulationDropdown));
    }

    @Test
    public void loadAssets() {
        this.scenarioSimulationDropdown.loadAssets();
        ((ScenarioSimulationDropdown)Mockito.verify((Object)this.scenarioSimulationDropdown, (VerificationMode)Mockito.times((int)1))).clear();
        ((ScenarioSimulationDropdown)Mockito.verify((Object)this.scenarioSimulationDropdown, (VerificationMode)Mockito.times((int)1))).initializeDropdown();
    }

    @Test
    public void initialize() {
        this.scenarioSimulationDropdown.initialize();
        ((ScenarioSimulationDropdownView)Mockito.verify((Object)this.viewMock, (VerificationMode)Mockito.times((int)1))).refreshSelectPicker();
    }

    @Test
    public void clear() {
        this.scenarioSimulationDropdown.clear();
        ((ScenarioSimulationDropdownView)Mockito.verify((Object)this.viewMock, (VerificationMode)Mockito.times((int)1))).clear();
    }

    @Test
    public void getElement() {
        HTMLElement retrieved = this.scenarioSimulationDropdown.getElement();
        ((ScenarioSimulationDropdownView)Mockito.verify((Object)this.viewMock, (VerificationMode)Mockito.times((int)1))).getElement();
        Assert.assertEquals((Object)this.htmlElementMock, (Object)retrieved);
    }

    @Test
    public void getValue() {
        Mockito.when((Object)this.viewMock.getValue()).thenReturn((Object)"DEFAULT_VALUE");
        Optional retrieved = this.scenarioSimulationDropdown.getValue();
        Assert.assertNotNull((Object)retrieved);
        Assert.assertTrue((boolean)retrieved.isPresent());
        ((ScenarioSimulationDropdownView)Mockito.verify((Object)this.viewMock, (VerificationMode)Mockito.times((int)1))).getValue();
        Mockito.reset((Object[])new ScenarioSimulationDropdownView[]{this.viewMock});
        Mockito.when((Object)this.viewMock.getValue()).thenReturn((Object)"UNKNOWN");
        retrieved = this.scenarioSimulationDropdown.getValue();
        Assert.assertNotNull((Object)retrieved);
        Assert.assertFalse((boolean)retrieved.isPresent());
    }

    @Test
    public void onValueChanged() {
        this.scenarioSimulationDropdown.onValueChanged();
        ((Command)Mockito.verify((Object)this.onValueChangeHandlerMock, (VerificationMode)Mockito.times((int)1))).execute();
    }

    @Test
    public void addValue() {
        this.scenarioSimulationDropdown.addValue(this.kieAssetsDropdownItemMock);
        ((ScenarioSimulationDropdownView)Mockito.verify((Object)this.viewMock, (VerificationMode)Mockito.times((int)1))).addValue((KieAssetsDropdownItem)Matchers.eq((Object)this.kieAssetsDropdownItemMock));
    }

    @Test
    public void initializeDropdown() {
        this.scenarioSimulationDropdown.initializeDropdown();
        ((ScenarioSimulationAssetsDropdownProvider)Mockito.verify((Object)this.dataProviderMock, (VerificationMode)Mockito.times((int)1))).getItems((Consumer)Matchers.isA(Consumer.class));
    }
}

