/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.dropdown;

import com.google.gwtmockito.GwtMockitoTestRunner;
import elemental2.dom.DOMTokenList;
import elemental2.dom.HTMLOptionElement;
import elemental2.dom.HTMLSelectElement;
import elemental2.dom.Node;
import org.drools.workbench.screens.scenariosimulation.client.dropdown.AbstractScenarioSimulationDropdownTest;
import org.drools.workbench.screens.scenariosimulation.client.dropdown.ScenarioSimulationDropdown;
import org.drools.workbench.screens.scenariosimulation.client.dropdown.ScenarioSimulationDropdownView;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.client.views.pfly.selectpicker.JQuerySelectPicker;

@RunWith(value=GwtMockitoTestRunner.class)
public class ScenarioSimulationDropdownViewTest
extends AbstractScenarioSimulationDropdownTest {
    @Mock
    private HTMLSelectElement nativeSelectMock;
    @Mock
    private DOMTokenList nativeSelectClassListMock;
    @Mock
    private HTMLOptionElement htmlOptionElementMock;
    @Mock
    private HTMLOptionElement htmlOptionElementClonedMock;
    @Mock
    private TranslationService translationServiceMock;
    @Mock
    private ScenarioSimulationDropdown presenterMock;
    @Mock
    private JQuerySelectPicker dropdownMock;
    @Mock
    private JQuerySelectPicker.CallbackFunction onDropdownChangeHandlerMock;
    private ScenarioSimulationDropdownView scenarioSimulationDropdownView;

    @Override
    @Before
    public void setup() {
        super.setup();
        this.nativeSelectMock.classList = this.nativeSelectClassListMock;
        Mockito.when((Object)this.htmlOptionElementMock.cloneNode(Matchers.eq((boolean)false))).thenReturn((Object)this.htmlOptionElementClonedMock);
        Mockito.when((Object)this.translationServiceMock.format((String)Matchers.eq((Object)"KieAssetsDropdownView.Select"), new Object[0])).thenReturn((Object)"KIEASSETSDROPDOWNVIEW_SELECT");
        this.scenarioSimulationDropdownView = (ScenarioSimulationDropdownView)Mockito.spy((Object)new ScenarioSimulationDropdownView(this.nativeSelectMock, this.htmlOptionElementMock, this.translationServiceMock){
            {
                this.presenter = ScenarioSimulationDropdownViewTest.this.presenterMock;
            }

            protected JQuerySelectPicker dropdown() {
                return ScenarioSimulationDropdownViewTest.this.dropdownMock;
            }

            protected JQuerySelectPicker.CallbackFunction getOnDropdownChangeHandler() {
                return ScenarioSimulationDropdownViewTest.this.onDropdownChangeHandlerMock;
            }
        });
        ((JQuerySelectPicker)Mockito.doReturn((Object)"DEFAULT_VALUE").when((Object)this.dropdownMock)).val();
    }

    @Test
    public void init() {
        this.scenarioSimulationDropdownView.init();
        Assert.assertFalse((boolean)this.nativeSelectMock.hidden);
        ((JQuerySelectPicker)Mockito.verify((Object)this.dropdownMock, (VerificationMode)Mockito.times((int)1))).on((String)Matchers.eq((Object)"hidden.bs.select"), (JQuerySelectPicker.CallbackFunction)Matchers.eq((Object)this.onDropdownChangeHandlerMock));
    }

    @Test
    public void addValue() {
        this.scenarioSimulationDropdownView.addValue(this.kieAssetsDropdownItemMock);
        ((HTMLSelectElement)Mockito.verify((Object)this.nativeSelectMock, (VerificationMode)Mockito.times((int)1))).appendChild((Node)Matchers.isA(HTMLOptionElement.class));
    }

    @Test
    public void initialize() {
        this.scenarioSimulationDropdownView.initialize();
        ((JQuerySelectPicker)Mockito.verify((Object)this.dropdownMock, (VerificationMode)Mockito.times((int)1))).selectpicker((String)Matchers.eq((Object)"val"), (String)Matchers.eq((Object)""));
    }

    @Test
    public void refreshSelectPicker() {
        this.scenarioSimulationDropdownView.refreshSelectPicker();
        ((JQuerySelectPicker)Mockito.verify((Object)this.dropdownMock, (VerificationMode)Mockito.times((int)1))).selectpicker((String)Matchers.eq((Object)"refresh"));
    }

    @Test
    public void getValue() {
        String retrieved = this.scenarioSimulationDropdownView.getValue();
        Assert.assertEquals((Object)"DEFAULT_VALUE", (Object)retrieved);
        ((JQuerySelectPicker)Mockito.verify((Object)this.dropdownMock, (VerificationMode)Mockito.times((int)1))).val();
    }
}

