/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.handlers;

import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwtmockito.GwtMockitoTestRunner;
import org.drools.workbench.screens.scenariosimulation.client.dropdown.ScenarioSimulationDropdown;
import org.drools.workbench.screens.scenariosimulation.client.handlers.AbstractNewScenarioTest;
import org.drools.workbench.screens.scenariosimulation.client.handlers.TitledAttachmentFileWidget;
import org.drools.workbench.screens.scenariosimulation.client.resources.i18n.ScenarioSimulationEditorConstants;
import org.gwtbootstrap3.client.ui.FormLabel;
import org.gwtbootstrap3.client.ui.html.Span;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=GwtMockitoTestRunner.class)
public class TitledAttachmentFileWidgetTest
extends AbstractNewScenarioTest {
    @Mock
    private FlowPanel fieldsMock;
    @Mock
    private FormLabel titleLabelMock;
    @Mock
    private Span errorLabelMock;
    private TitledAttachmentFileWidget titledAttachmentFileWidget;

    @Override
    @Before
    public void setup() throws Exception {
        super.setup();
        this.titledAttachmentFileWidget = (TitledAttachmentFileWidget)Mockito.spy((Object)new TitledAttachmentFileWidget(ScenarioSimulationEditorConstants.INSTANCE.chooseDMN(), this.scenarioSimulationServiceMock, this.scenarioSimulationDropdownMock){
            {
                this.fields = TitledAttachmentFileWidgetTest.this.fieldsMock;
                this.titleLabel = TitledAttachmentFileWidgetTest.this.titleLabelMock;
                this.errorLabel = TitledAttachmentFileWidgetTest.this.errorLabelMock;
            }
        });
    }

    @Test
    public void clearStatus() {
        this.titledAttachmentFileWidget.selectedPath = "SELECTED_PATH";
        Assert.assertNotNull((Object)this.titledAttachmentFileWidget.selectedPath);
        this.titledAttachmentFileWidget.clearStatus();
        ((ScenarioSimulationDropdown)Mockito.verify((Object)this.scenarioSimulationDropdownMock, (VerificationMode)Mockito.times((int)1))).clear();
        ((TitledAttachmentFileWidget)Mockito.verify((Object)this.titledAttachmentFileWidget, (VerificationMode)Mockito.times((int)1))).updateAssetList();
        ((Span)Mockito.verify((Object)this.errorLabelMock, (VerificationMode)Mockito.times((int)1))).setText((String)Matchers.eq(null));
        Assert.assertNull((Object)this.titledAttachmentFileWidget.selectedPath);
    }

    @Test
    public void updateAssetList() {
        this.titledAttachmentFileWidget.updateAssetList();
        ((ScenarioSimulationDropdown)Mockito.verify((Object)this.scenarioSimulationDropdownMock, (VerificationMode)Mockito.times((int)1))).clear();
        ((ScenarioSimulationDropdown)Mockito.verify((Object)this.scenarioSimulationDropdownMock, (VerificationMode)Mockito.times((int)1))).loadAssets();
    }

    @Test
    public void validateNullPath() {
        this.commonValidate(null, false);
    }

    @Test
    public void validateEmptyPath() {
        this.commonValidate("", false);
    }

    @Test
    public void validatePopulatedPath() {
        this.commonValidate("SELECTED_PATH", true);
    }

    private void commonValidate(String selectedPath, boolean expected) {
        this.titledAttachmentFileWidget.selectedPath = selectedPath;
        boolean retrieved = this.titledAttachmentFileWidget.validate();
        if (expected) {
            ((Span)Mockito.verify((Object)this.errorLabelMock, (VerificationMode)Mockito.times((int)1))).setText((String)Matchers.eq(null));
            Assert.assertTrue((boolean)retrieved);
        } else {
            ((Span)Mockito.verify((Object)this.errorLabelMock, (VerificationMode)Mockito.times((int)1))).setText((String)Matchers.eq((Object)ScenarioSimulationEditorConstants.INSTANCE.chooseValidDMNAsset()));
            Assert.assertFalse((boolean)retrieved);
        }
    }
}

