/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.rightpanel;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.scenariosimulation.api.model.Scenario;
import org.drools.scenariosimulation.api.model.ScenarioSimulationModel;
import org.drools.scenariosimulation.api.model.ScenarioWithIndex;
import org.drools.scenariosimulation.api.model.SimulationRunMetadata;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.CoverageDecisionElementPresenter;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.CoverageReportDonutPresenter;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.CoverageReportPresenter;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.CoverageReportView;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.CoverageScenarioListPresenter;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=GwtMockitoTestRunner.class)
public class CoverageReportPresenterTest {
    @Mock
    protected CoverageReportDonutPresenter coverageReportDonutPresenterMock;
    @Mock
    protected CoverageDecisionElementPresenter coverageDecisionElementPresenterMock;
    @Mock
    protected CoverageScenarioListPresenter coverageScenarioListPresenterMock;
    @Mock
    protected CoverageReportView coverageReportViewMock;
    @InjectMocks
    protected CoverageReportPresenter presenter;
    protected CoverageReportPresenter presenterSpy;
    protected SimulationRunMetadata simulationRunMetadataLocal;
    private Map<String, Integer> outputCounterLocal;
    private Map<ScenarioWithIndex, List<String>> scenarioCounterLocal;
    private int availableLocal;
    private int executedLocal;
    private double coverageLocal;

    @Before
    public void setup() {
        this.presenterSpy = (CoverageReportPresenter)Mockito.spy((Object)this.presenter);
        this.availableLocal = 10;
        this.executedLocal = 5;
        this.coverageLocal = (double)this.executedLocal / (double)this.availableLocal * 100.0;
        this.outputCounterLocal = new HashMap<String, Integer>();
        this.outputCounterLocal.put("d1", 1);
        this.outputCounterLocal.put("d2", 2);
        this.scenarioCounterLocal = new HashMap<ScenarioWithIndex, List<String>>();
        this.scenarioCounterLocal.put(new ScenarioWithIndex(1, new Scenario()), Arrays.asList("d1", "d2"));
        this.scenarioCounterLocal.put(new ScenarioWithIndex(2, new Scenario()), Collections.singletonList("d2"));
        this.simulationRunMetadataLocal = new SimulationRunMetadata(this.availableLocal, this.executedLocal, this.outputCounterLocal, this.scenarioCounterLocal);
    }

    @Test
    public void populateCoverageReport() {
        this.presenterSpy.populateCoverageReport(ScenarioSimulationModel.Type.DMN, this.simulationRunMetadataLocal);
        ((CoverageReportPresenter)Mockito.verify((Object)this.presenterSpy, (VerificationMode)Mockito.times((int)1))).setSimulationRunMetadata((SimulationRunMetadata)Matchers.eq((Object)this.simulationRunMetadataLocal));
        Mockito.reset((Object[])new CoverageReportPresenter[]{this.presenterSpy});
        this.presenterSpy.populateCoverageReport(ScenarioSimulationModel.Type.DMN, null);
        ((CoverageReportPresenter)Mockito.verify((Object)this.presenterSpy, (VerificationMode)Mockito.times((int)1))).showEmptyStateMessage((ScenarioSimulationModel.Type)Matchers.eq((Object)ScenarioSimulationModel.Type.DMN));
        Mockito.reset((Object[])new CoverageReportPresenter[]{this.presenterSpy});
        this.presenterSpy.populateCoverageReport(ScenarioSimulationModel.Type.RULE, (SimulationRunMetadata)Mockito.mock(SimulationRunMetadata.class));
        ((CoverageReportPresenter)Mockito.verify((Object)this.presenterSpy, (VerificationMode)Mockito.times((int)1))).showEmptyStateMessage((ScenarioSimulationModel.Type)Matchers.eq((Object)ScenarioSimulationModel.Type.RULE));
    }

    @Test
    public void setSimulationRunMetadata() {
        this.presenterSpy.setSimulationRunMetadata(this.simulationRunMetadataLocal);
        ((CoverageReportPresenter)Mockito.verify((Object)this.presenterSpy, (VerificationMode)Mockito.times((int)1))).populateSummary(Matchers.eq((int)this.availableLocal), Matchers.eq((int)this.executedLocal), Matchers.eq((double)this.coverageLocal));
        ((CoverageReportPresenter)Mockito.verify((Object)this.presenterSpy, (VerificationMode)Mockito.times((int)1))).populateDecisionList((Map)Matchers.eq(this.outputCounterLocal));
        ((CoverageReportPresenter)Mockito.verify((Object)this.presenterSpy, (VerificationMode)Mockito.times((int)1))).populateScenarioList((Map)Matchers.eq(this.scenarioCounterLocal));
        ((CoverageReportView)Mockito.verify((Object)this.coverageReportViewMock, (VerificationMode)Mockito.times((int)1))).show();
    }

    @Test
    public void populateSummary() {
        this.presenterSpy.populateSummary(this.availableLocal, this.executedLocal, this.coverageLocal);
        ((CoverageReportView)Mockito.verify((Object)this.coverageReportViewMock, (VerificationMode)Mockito.times((int)1))).setReportAvailable((String)Matchers.eq((Object)(this.availableLocal + "")));
        ((CoverageReportView)Mockito.verify((Object)this.coverageReportViewMock, (VerificationMode)Mockito.times((int)1))).setReportExecuted((String)Matchers.eq((Object)(this.executedLocal + "")));
        ((CoverageReportView)Mockito.verify((Object)this.coverageReportViewMock, (VerificationMode)Mockito.times((int)1))).setReportCoverage((String)Matchers.eq((Object)(this.coverageLocal + "%")));
        int delta = this.availableLocal - this.executedLocal;
        ((CoverageReportDonutPresenter)Mockito.verify((Object)this.coverageReportDonutPresenterMock, (VerificationMode)Mockito.times((int)1))).showCoverageReport(Matchers.eq((int)this.executedLocal), Matchers.eq((int)delta));
    }

    @Test
    public void populateDecisionList() {
        this.presenterSpy.populateDecisionList(this.outputCounterLocal);
        ((CoverageDecisionElementPresenter)Mockito.verify((Object)this.coverageDecisionElementPresenterMock, (VerificationMode)Mockito.times((int)1))).clear();
        ((CoverageDecisionElementPresenter)Mockito.verify((Object)this.coverageDecisionElementPresenterMock, (VerificationMode)Mockito.times((int)this.outputCounterLocal.size()))).addDecisionElementView(Matchers.anyString(), Matchers.anyString());
    }

    @Test
    public void populateScenarioList() {
        this.presenterSpy.populateScenarioList(this.scenarioCounterLocal);
        ((CoverageScenarioListPresenter)Mockito.verify((Object)this.coverageScenarioListPresenterMock, (VerificationMode)Mockito.times((int)1))).clear();
        ((CoverageScenarioListPresenter)Mockito.verify((Object)this.coverageScenarioListPresenterMock, (VerificationMode)Mockito.times((int)this.scenarioCounterLocal.size()))).addScenarioGroup((ScenarioWithIndex)Matchers.any(), (List)Matchers.any());
    }

    @Test
    public void showEmptyStateMessage() {
        this.presenterSpy.showEmptyStateMessage(null);
        ((CoverageReportView)Mockito.verify((Object)this.coverageReportViewMock, (VerificationMode)Mockito.times((int)1))).setEmptyStatusText(Matchers.anyString());
        ((CoverageReportView)Mockito.verify((Object)this.coverageReportViewMock, (VerificationMode)Mockito.times((int)1))).hide();
    }

    @Test
    public void resetTest() {
        this.presenterSpy.reset();
        ((CoverageReportView)Mockito.verify((Object)this.coverageReportViewMock, (VerificationMode)Mockito.times((int)1))).reset();
    }
}

