/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.domelements;

import com.ait.lienzo.test.LienzoMockitoTestRunner;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.user.client.ui.AbsolutePanel;
import org.drools.workbench.screens.scenariosimulation.client.domelements.ScenarioHeaderTextAreaDOMElement;
import org.drools.workbench.screens.scenariosimulation.client.events.SetHeaderCellValueEvent;
import org.drools.workbench.screens.scenariosimulation.client.factories.AbstractFactoriesTest;
import org.drools.workbench.screens.scenariosimulation.client.metadata.ScenarioHeaderMetaData;
import org.drools.workbench.screens.scenariosimulation.client.models.ScenarioGridModel;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;
import org.uberfire.ext.wires.core.grids.client.widget.layer.GridLayer;

@RunWith(value=LienzoMockitoTestRunner.class)
public class ScenarioHeaderTextAreaDOMElementTest
extends AbstractFactoriesTest {
    private ScenarioHeaderTextAreaDOMElement scenarioHeaderTextAreaDOMElement;
    @Mock
    private ScenarioHeaderMetaData scenarioHeaderMetaDataMock;

    @Override
    @Before
    public void setup() {
        super.setup();
        Mockito.when((Object)this.scenarioGridLayerMock.getDomElementContainer()).thenReturn((Object)new AbsolutePanel());
        this.scenarioHeaderTextAreaDOMElement = (ScenarioHeaderTextAreaDOMElement)Mockito.spy((Object)new ScenarioHeaderTextAreaDOMElement(this.textAreaMock, (GridLayer)this.scenarioGridLayerMock, (GridWidget)this.scenarioGridMock){
            {
                this.context = ScenarioHeaderTextAreaDOMElementTest.this.contextMock;
            }
        });
    }

    @Test
    public void flushMetadataEqualsValue() {
        Mockito.when((Object)this.scenarioHeaderMetaDataMock.getTitle()).thenReturn((Object)"MULTIPART.VALUE");
        this.scenarioHeaderTextAreaDOMElement.setScenarioHeaderMetaData(this.scenarioHeaderMetaDataMock);
        this.scenarioHeaderTextAreaDOMElement.flush("MULTIPART.VALUE");
        ((ScenarioHeaderTextAreaDOMElement)Mockito.verify((Object)this.scenarioHeaderTextAreaDOMElement, (VerificationMode)Mockito.never())).internalFlush((String)Matchers.eq((Object)"MULTIPART.VALUE"));
    }

    @Test
    public void flushMetadataNotEqualsValue() {
        Mockito.when((Object)this.scenarioHeaderMetaDataMock.getTitle()).thenReturn((Object)"NOT_VALUE");
        this.scenarioHeaderTextAreaDOMElement.setScenarioHeaderMetaData(this.scenarioHeaderMetaDataMock);
        this.scenarioHeaderTextAreaDOMElement.flush("MULTIPART.VALUE");
        ((ScenarioHeaderTextAreaDOMElement)Mockito.verify((Object)this.scenarioHeaderTextAreaDOMElement, (VerificationMode)Mockito.times((int)1))).internalFlush((String)Matchers.eq((Object)"MULTIPART.VALUE"));
    }

    @Test
    public void flushNullMetadata() {
        this.scenarioHeaderTextAreaDOMElement.setScenarioHeaderMetaData(null);
        this.scenarioHeaderTextAreaDOMElement.flush("MULTIPART.VALUE");
        ((ScenarioHeaderTextAreaDOMElement)Mockito.verify((Object)this.scenarioHeaderTextAreaDOMElement, (VerificationMode)Mockito.times((int)1))).internalFlush((String)Matchers.eq((Object)"MULTIPART.VALUE"));
    }

    @Test
    public void internalFlushInvalidHeader() {
        this.scenarioHeaderTextAreaDOMElement.internalFlush("MULTIPART.VALUE");
        ((ScenarioGridModel)Mockito.verify((Object)this.scenarioGridModelMock, (VerificationMode)Mockito.never())).updateHeader(Matchers.eq((int)3), Matchers.eq((int)2), (String)Matchers.eq((Object)"MULTIPART.VALUE"));
    }

    @Test
    public void internalFlushValidHeader() {
        this.scenarioHeaderTextAreaDOMElement.internalFlush("MULTIPART.VALUE");
        ((EventBus)Mockito.verify((Object)this.eventBusMock, (VerificationMode)Mockito.times((int)1))).fireEvent((GwtEvent)Matchers.isA(SetHeaderCellValueEvent.class));
    }

    @Test
    public void testDetachCancelEditMode() {
        this.scenarioHeaderTextAreaDOMElement.setScenarioHeaderMetaData(this.scenarioHeaderMetaDataMock);
        this.scenarioHeaderTextAreaDOMElement.detach();
        ((ScenarioHeaderMetaData)Mockito.verify((Object)this.scenarioHeaderMetaDataMock)).setEditingMode(false);
    }
}

