/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.rightpanel;

import com.google.gwt.dom.client.ButtonElement;
import com.google.gwt.dom.client.InputElement;
import com.google.gwt.dom.client.SpanElement;
import com.google.gwt.dom.client.Style;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Optional;
import org.drools.scenariosimulation.api.model.ScenarioSimulationModel;
import org.drools.scenariosimulation.api.model.SimulationDescriptor;
import org.drools.workbench.screens.scenariosimulation.client.dropdown.SettingsScenarioSimulationDropdown;
import org.drools.workbench.screens.scenariosimulation.client.resources.i18n.ScenarioSimulationEditorConstants;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.AbstractSettingsTest;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.SettingsPresenter;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.SettingsView;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.widgets.client.assets.dropdown.KieAssetsDropdownItem;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.mvp.Command;

@RunWith(value=GwtMockitoTestRunner.class)
public class SettingsPresenterTest
extends AbstractSettingsTest {
    private SettingsPresenter settingsPresenter;
    @Mock
    private SettingsView settingsViewMock;
    @Mock
    private SimulationDescriptor simulationDescriptorMock;
    @Mock
    private Command saveCommandMock;
    @Mock
    private SettingsScenarioSimulationDropdown settingsScenarioSimulationDropdownMock;

    @Override
    @Before
    public void setup() {
        super.setup();
        Mockito.when((Object)this.settingsViewMock.getNameLabel()).thenReturn((Object)this.nameLabelMock);
        Mockito.when((Object)this.settingsViewMock.getFileName()).thenReturn((Object)this.fileNameMock);
        Mockito.when((Object)this.settingsViewMock.getTypeLabel()).thenReturn((Object)this.typeLabelMock);
        Mockito.when((Object)this.settingsViewMock.getScenarioType()).thenReturn((Object)this.scenarioTypeMock);
        Mockito.when((Object)this.settingsViewMock.getRuleSettings()).thenReturn((Object)this.ruleSettingsMock);
        Mockito.when((Object)this.settingsViewMock.getDmoSession()).thenReturn((Object)this.dmoSessionMock);
        Mockito.when((Object)this.settingsViewMock.getRuleFlowGroup()).thenReturn((Object)this.ruleFlowGroupMock);
        Mockito.when((Object)this.settingsViewMock.getDmnSettings()).thenReturn((Object)this.dmnSettingsMock);
        Mockito.when((Object)this.settingsViewMock.getDmnFileLabel()).thenReturn((Object)this.dmnModelLabelMock);
        Mockito.when((Object)this.settingsViewMock.getDmnFilePathPlaceholder()).thenReturn((Object)this.dmnFilePathPlaceholderMock);
        Mockito.when((Object)this.settingsViewMock.getDmnFilePathErrorLabel()).thenReturn((Object)this.dmnFilePathErrorLabelMock);
        Mockito.when((Object)this.settingsViewMock.getDmnNamespaceLabel()).thenReturn((Object)this.dmnNamespaceLabelMock);
        Mockito.when((Object)this.settingsViewMock.getDmnNamespace()).thenReturn((Object)this.dmnNamespaceMock);
        Mockito.when((Object)this.settingsViewMock.getDmnNameLabel()).thenReturn((Object)this.dmnNameLabelMock);
        Mockito.when((Object)this.settingsViewMock.getDmnName()).thenReturn((Object)this.dmnNameMock);
        Mockito.when((Object)this.settingsViewMock.getSkipFromBuild()).thenReturn((Object)this.skipFromBuildMock);
        Mockito.when((Object)this.settingsViewMock.getSaveButton()).thenReturn((Object)this.saveButtonMock);
        Mockito.when((Object)this.settingsViewMock.getStateless()).thenReturn((Object)this.statelessMock);
        Mockito.when((Object)this.simulationDescriptorMock.getRuleFlowGroup()).thenReturn((Object)"RULE_FLOW_GROUP");
        Mockito.when((Object)this.simulationDescriptorMock.getDmoSession()).thenReturn((Object)"DMO_SESSION");
        Mockito.when((Object)this.simulationDescriptorMock.getDmnFilePath()).thenReturn((Object)"DMN_FILE_PATH");
        Mockito.when((Object)this.simulationDescriptorMock.getDmnNamespace()).thenReturn((Object)"DMN_NAMESPACE");
        Mockito.when((Object)this.simulationDescriptorMock.getDmnName()).thenReturn((Object)"DMN_NAME");
        Mockito.when((Object)this.simulationDescriptorMock.isStateless()).thenReturn((Object)true);
        KieAssetsDropdownItem item = new KieAssetsDropdownItem("DMNFile", "", "DMN_FILE_PATH", null);
        Mockito.when((Object)this.settingsScenarioSimulationDropdownMock.getValue()).thenReturn(Optional.of(item));
        this.settingsPresenter = (SettingsPresenter)Mockito.spy((Object)new SettingsPresenter(this.settingsScenarioSimulationDropdownMock, this.settingsViewMock){
            {
                this.simulationDescriptor = SettingsPresenterTest.this.simulationDescriptorMock;
                this.settingsScenarioSimulationDropdown = SettingsPresenterTest.this.settingsScenarioSimulationDropdownMock;
                this.saveCommand = SettingsPresenterTest.this.saveCommandMock;
            }
        });
    }

    @Test
    public void onSetup() {
        this.settingsPresenter.setup();
        ((SettingsView)Mockito.verify((Object)this.settingsViewMock, (VerificationMode)Mockito.times((int)1))).init((Object)this.settingsPresenter);
    }

    @Test
    public void getTitle() {
        Assert.assertEquals((Object)ScenarioSimulationEditorConstants.INSTANCE.settings(), (Object)this.settingsPresenter.getTitle());
    }

    @Test
    public void onSaveButtonSkipTrue() {
        Mockito.when((Object)this.skipFromBuildMock.isChecked()).thenReturn((Object)true);
        this.settingsPresenter.onSaveButton(ScenarioSimulationModel.Type.RULE.name());
        ((SimulationDescriptor)Mockito.verify((Object)this.simulationDescriptorMock, (VerificationMode)Mockito.times((int)1))).setSkipFromBuild(Matchers.eq((boolean)true));
        ((SettingsPresenter)Mockito.verify((Object)this.settingsPresenter, (VerificationMode)Mockito.times((int)1))).saveRuleSettings();
        ((Command)Mockito.verify((Object)this.saveCommandMock, (VerificationMode)Mockito.times((int)1))).execute();
        Mockito.reset((Object[])new Command[]{this.saveCommandMock});
        Mockito.reset((Object[])new SimulationDescriptor[]{this.simulationDescriptorMock});
        this.settingsPresenter.onSaveButton(ScenarioSimulationModel.Type.DMN.name());
        ((SimulationDescriptor)Mockito.verify((Object)this.simulationDescriptorMock, (VerificationMode)Mockito.times((int)1))).setSkipFromBuild(Matchers.eq((boolean)true));
        ((SettingsPresenter)Mockito.verify((Object)this.settingsPresenter, (VerificationMode)Mockito.times((int)1))).saveDMNSettings();
        ((Command)Mockito.verify((Object)this.saveCommandMock, (VerificationMode)Mockito.times((int)1))).execute();
    }

    @Test
    public void onSaveButtonSkipFalse() {
        Mockito.when((Object)this.skipFromBuildMock.isChecked()).thenReturn((Object)false);
        this.settingsPresenter.onSaveButton(ScenarioSimulationModel.Type.RULE.name());
        ((SettingsPresenter)Mockito.verify((Object)this.settingsPresenter, (VerificationMode)Mockito.times((int)1))).saveRuleSettings();
        ((SimulationDescriptor)Mockito.verify((Object)this.simulationDescriptorMock, (VerificationMode)Mockito.times((int)1))).setSkipFromBuild(Matchers.eq((boolean)false));
        ((Command)Mockito.verify((Object)this.saveCommandMock, (VerificationMode)Mockito.times((int)1))).execute();
        Mockito.reset((Object[])new Command[]{this.saveCommandMock});
        Mockito.reset((Object[])new SimulationDescriptor[]{this.simulationDescriptorMock});
        this.settingsPresenter.onSaveButton(ScenarioSimulationModel.Type.DMN.name());
        ((SimulationDescriptor)Mockito.verify((Object)this.simulationDescriptorMock, (VerificationMode)Mockito.times((int)1))).setSkipFromBuild(Matchers.eq((boolean)false));
        ((SettingsPresenter)Mockito.verify((Object)this.settingsPresenter, (VerificationMode)Mockito.times((int)1))).saveDMNSettings();
        ((Command)Mockito.verify((Object)this.saveCommandMock, (VerificationMode)Mockito.times((int)1))).execute();
    }

    @Test
    public void setScenarioTypeRULESkipTrue() {
        Mockito.when((Object)this.simulationDescriptorMock.isSkipFromBuild()).thenReturn((Object)true);
        this.settingsPresenter.setScenarioType(ScenarioSimulationModel.Type.RULE, this.simulationDescriptorMock, "FILE_NAME");
        ((SettingsView)Mockito.verify((Object)this.settingsViewMock, (VerificationMode)Mockito.times((int)1))).getScenarioType();
        ((SpanElement)Mockito.verify((Object)this.scenarioTypeMock, (VerificationMode)Mockito.times((int)1))).setInnerText((String)Matchers.eq((Object)ScenarioSimulationModel.Type.RULE.name()));
        ((SettingsView)Mockito.verify((Object)this.settingsViewMock, (VerificationMode)Mockito.times((int)1))).getFileName();
        ((InputElement)Mockito.verify((Object)this.fileNameMock, (VerificationMode)Mockito.times((int)1))).setValue((String)Matchers.eq((Object)"FILE_NAME"));
        ((InputElement)Mockito.verify((Object)this.skipFromBuildMock, (VerificationMode)Mockito.times((int)1))).setChecked(Matchers.eq((boolean)true));
        ((ButtonElement)Mockito.verify((Object)this.saveButtonMock, (VerificationMode)Mockito.times((int)1))).setDisabled(Matchers.eq((boolean)false));
        ((SettingsPresenter)Mockito.verify((Object)this.settingsPresenter, (VerificationMode)Mockito.times((int)1))).setRuleSettings(this.simulationDescriptorMock);
    }

    @Test
    public void setScenarioTypeRULESkipFalse() {
        Mockito.when((Object)this.simulationDescriptorMock.isSkipFromBuild()).thenReturn((Object)false);
        this.settingsPresenter.setScenarioType(ScenarioSimulationModel.Type.RULE, this.simulationDescriptorMock, "FILE_NAME");
        ((SettingsView)Mockito.verify((Object)this.settingsViewMock, (VerificationMode)Mockito.times((int)1))).getScenarioType();
        ((SpanElement)Mockito.verify((Object)this.scenarioTypeMock, (VerificationMode)Mockito.times((int)1))).setInnerText((String)Matchers.eq((Object)ScenarioSimulationModel.Type.RULE.name()));
        ((SettingsView)Mockito.verify((Object)this.settingsViewMock, (VerificationMode)Mockito.times((int)1))).getFileName();
        ((InputElement)Mockito.verify((Object)this.fileNameMock, (VerificationMode)Mockito.times((int)1))).setValue((String)Matchers.eq((Object)"FILE_NAME"));
        ((InputElement)Mockito.verify((Object)this.skipFromBuildMock, (VerificationMode)Mockito.times((int)1))).setChecked(Matchers.eq((boolean)false));
        ((ButtonElement)Mockito.verify((Object)this.saveButtonMock, (VerificationMode)Mockito.times((int)1))).setDisabled(Matchers.eq((boolean)false));
        ((SettingsPresenter)Mockito.verify((Object)this.settingsPresenter, (VerificationMode)Mockito.times((int)1))).setRuleSettings(this.simulationDescriptorMock);
    }

    @Test
    public void setScenarioTypeDMNSkipTrue() {
        Mockito.when((Object)this.simulationDescriptorMock.isSkipFromBuild()).thenReturn((Object)true);
        this.settingsPresenter.setScenarioType(ScenarioSimulationModel.Type.DMN, this.simulationDescriptorMock, "FILE_NAME");
        ((SettingsView)Mockito.verify((Object)this.settingsViewMock, (VerificationMode)Mockito.times((int)1))).getScenarioType();
        ((SpanElement)Mockito.verify((Object)this.scenarioTypeMock, (VerificationMode)Mockito.times((int)1))).setInnerText((String)Matchers.eq((Object)ScenarioSimulationModel.Type.DMN.name()));
        ((SettingsView)Mockito.verify((Object)this.settingsViewMock, (VerificationMode)Mockito.times((int)1))).getFileName();
        ((InputElement)Mockito.verify((Object)this.fileNameMock, (VerificationMode)Mockito.times((int)1))).setValue((String)Matchers.eq((Object)"FILE_NAME"));
        ((InputElement)Mockito.verify((Object)this.skipFromBuildMock, (VerificationMode)Mockito.times((int)1))).setChecked(Matchers.eq((boolean)true));
        ((ButtonElement)Mockito.verify((Object)this.saveButtonMock, (VerificationMode)Mockito.times((int)1))).setDisabled(Matchers.eq((boolean)false));
        ((SettingsPresenter)Mockito.verify((Object)this.settingsPresenter, (VerificationMode)Mockito.times((int)1))).setDMNSettings(this.simulationDescriptorMock);
    }

    @Test
    public void setScenarioTypeDMNSkipFalse() {
        Mockito.when((Object)this.simulationDescriptorMock.isSkipFromBuild()).thenReturn((Object)false);
        this.settingsPresenter.setScenarioType(ScenarioSimulationModel.Type.DMN, this.simulationDescriptorMock, "FILE_NAME");
        ((SettingsView)Mockito.verify((Object)this.settingsViewMock, (VerificationMode)Mockito.times((int)1))).getScenarioType();
        ((SpanElement)Mockito.verify((Object)this.scenarioTypeMock, (VerificationMode)Mockito.times((int)1))).setInnerText((String)Matchers.eq((Object)ScenarioSimulationModel.Type.DMN.name()));
        ((SettingsView)Mockito.verify((Object)this.settingsViewMock, (VerificationMode)Mockito.times((int)1))).getFileName();
        ((InputElement)Mockito.verify((Object)this.fileNameMock, (VerificationMode)Mockito.times((int)1))).setValue((String)Matchers.eq((Object)"FILE_NAME"));
        ((InputElement)Mockito.verify((Object)this.skipFromBuildMock, (VerificationMode)Mockito.times((int)1))).setChecked(Matchers.eq((boolean)false));
        ((ButtonElement)Mockito.verify((Object)this.saveButtonMock, (VerificationMode)Mockito.times((int)1))).setDisabled(Matchers.eq((boolean)false));
        ((SettingsPresenter)Mockito.verify((Object)this.settingsPresenter, (VerificationMode)Mockito.times((int)1))).setDMNSettings(this.simulationDescriptorMock);
    }

    @Test
    public void setRuleSettings() {
        this.settingsPresenter.setRuleSettings(this.simulationDescriptorMock);
        ((SettingsView)Mockito.verify((Object)this.settingsViewMock, (VerificationMode)Mockito.times((int)1))).getDmnSettings();
        ((Style)Mockito.verify((Object)this.dmnSettingsStyleMock, (VerificationMode)Mockito.times((int)1))).setDisplay((Style.Display)Matchers.eq((Object)Style.Display.NONE));
        ((SettingsView)Mockito.verify((Object)this.settingsViewMock, (VerificationMode)Mockito.times((int)1))).getRuleSettings();
        ((Style)Mockito.verify((Object)this.ruleSettingsStyleMock, (VerificationMode)Mockito.times((int)1))).setDisplay((Style.Display)Matchers.eq((Object)Style.Display.INLINE));
        ((SettingsView)Mockito.verify((Object)this.settingsViewMock, (VerificationMode)Mockito.times((int)1))).getDmoSession();
        ((InputElement)Mockito.verify((Object)this.dmoSessionMock, (VerificationMode)Mockito.times((int)1))).setValue((String)Matchers.eq((Object)"DMO_SESSION"));
        ((SettingsView)Mockito.verify((Object)this.settingsViewMock, (VerificationMode)Mockito.times((int)1))).getRuleFlowGroup();
        ((InputElement)Mockito.verify((Object)this.ruleFlowGroupMock, (VerificationMode)Mockito.times((int)1))).setValue((String)Matchers.eq((Object)"RULE_FLOW_GROUP"));
        ((InputElement)Mockito.verify((Object)this.statelessMock, (VerificationMode)Mockito.times((int)1))).setChecked(Matchers.eq((boolean)this.simulationDescriptorMock.isStateless()));
    }

    @Test
    public void setDMNSettings() {
        this.settingsPresenter.setDMNSettings(this.simulationDescriptorMock);
        ((SettingsView)Mockito.verify((Object)this.settingsViewMock, (VerificationMode)Mockito.times((int)1))).getRuleSettings();
        ((Style)Mockito.verify((Object)this.ruleSettingsStyleMock, (VerificationMode)Mockito.times((int)1))).setDisplay((Style.Display)Matchers.eq((Object)Style.Display.NONE));
        ((SettingsView)Mockito.verify((Object)this.settingsViewMock, (VerificationMode)Mockito.times((int)1))).getDmnSettings();
        ((Style)Mockito.verify((Object)this.dmnSettingsStyleMock, (VerificationMode)Mockito.times((int)1))).setDisplay((Style.Display)Matchers.eq((Object)Style.Display.INLINE));
        ((SettingsView)Mockito.verify((Object)this.settingsViewMock, (VerificationMode)Mockito.times((int)1))).getDmnName();
        ((InputElement)Mockito.verify((Object)this.dmnNameMock, (VerificationMode)Mockito.times((int)1))).setValue((String)Matchers.eq((Object)"DMN_NAME"));
        ((SettingsView)Mockito.verify((Object)this.settingsViewMock, (VerificationMode)Mockito.times((int)1))).getDmnNamespace();
        ((InputElement)Mockito.verify((Object)this.dmnNamespaceMock, (VerificationMode)Mockito.times((int)1))).setValue((String)Matchers.eq((Object)"DMN_NAMESPACE"));
        ((SettingsView)Mockito.verify((Object)this.settingsViewMock, (VerificationMode)Mockito.times((int)2))).getDmnFilePathErrorLabel();
        ((Style)Mockito.verify((Object)this.dmnFilePathErrorLabelStyleMock, (VerificationMode)Mockito.times((int)1))).setDisplay((Style.Display)Matchers.eq((Object)Style.Display.NONE));
        ((SpanElement)Mockito.verify((Object)this.dmnFilePathErrorLabelMock, (VerificationMode)Mockito.times((int)1))).setInnerText((String)Matchers.eq((Object)""));
        ((SettingsScenarioSimulationDropdown)Mockito.verify((Object)this.settingsScenarioSimulationDropdownMock, (VerificationMode)Mockito.times((int)1))).registerOnMissingValueHandler((Command)Matchers.isA(Command.class));
        ((SettingsScenarioSimulationDropdown)Mockito.verify((Object)this.settingsScenarioSimulationDropdownMock, (VerificationMode)Mockito.times((int)1))).registerOnChangeHandler((Command)Matchers.isA(Command.class));
        ((SettingsScenarioSimulationDropdown)Mockito.verify((Object)this.settingsScenarioSimulationDropdownMock, (VerificationMode)Mockito.times((int)1))).loadAssets((String)Matchers.eq((Object)"DMN_FILE_PATH"));
    }

    @Test
    public void saveRuleSettings() {
        Mockito.when((Object)this.skipFromBuildMock.isChecked()).thenReturn((Object)true);
        this.settingsPresenter.saveRuleSettings();
        ((SimulationDescriptor)Mockito.verify((Object)this.simulationDescriptorMock, (VerificationMode)Mockito.times((int)1))).setDmoSession((String)Matchers.eq((Object)"DMO_SESSION"));
        ((SettingsView)Mockito.verify((Object)this.settingsViewMock, (VerificationMode)Mockito.times((int)1))).getDmoSession();
        ((SettingsView)Mockito.verify((Object)this.settingsViewMock, (VerificationMode)Mockito.times((int)1))).getRuleFlowGroup();
        ((SimulationDescriptor)Mockito.verify((Object)this.simulationDescriptorMock, (VerificationMode)Mockito.times((int)1))).setRuleFlowGroup((String)Matchers.eq((Object)"RULE_FLOW_GROUP"));
        ((SimulationDescriptor)Mockito.verify((Object)this.simulationDescriptorMock, (VerificationMode)Mockito.times((int)1))).setStateless(Matchers.eq((boolean)false));
    }

    @Test
    public void saveDMNSettings() {
        this.settingsPresenter.saveDMNSettings();
        ((SettingsScenarioSimulationDropdown)Mockito.verify((Object)this.settingsScenarioSimulationDropdownMock, (VerificationMode)Mockito.times((int)1))).getValue();
        ((SimulationDescriptor)Mockito.verify((Object)this.simulationDescriptorMock, (VerificationMode)Mockito.times((int)1))).setDmnFilePath((String)Matchers.eq((Object)"DMN_FILE_PATH"));
    }

    @Test
    public void resetTest() {
        this.settingsPresenter.reset();
        ((SettingsView)Mockito.verify((Object)this.settingsViewMock, (VerificationMode)Mockito.times((int)1))).reset();
        ((SettingsScenarioSimulationDropdown)Mockito.verify((Object)this.settingsScenarioSimulationDropdownMock, (VerificationMode)Mockito.times((int)1))).clear();
    }

    @Test
    public void setDmnErrorPath() {
        this.settingsPresenter.setDmnErrorPath();
        ((SimulationDescriptor)Mockito.verify((Object)this.simulationDescriptorMock, (VerificationMode)Mockito.times((int)1))).getDmnFilePath();
        ((Style)Mockito.verify((Object)this.dmnFilePathErrorLabelStyleMock, (VerificationMode)Mockito.times((int)1))).setDisplay((Style.Display)Matchers.eq((Object)Style.Display.INLINE));
        ((SpanElement)Mockito.verify((Object)this.dmnFilePathErrorLabelMock, (VerificationMode)Mockito.times((int)1))).setInnerText((String)Matchers.eq((Object)ScenarioSimulationEditorConstants.INSTANCE.dmnPathErrorLabel(this.simulationDescriptorMock.getDmnFilePath())));
        ((ButtonElement)Mockito.verify((Object)this.saveButtonMock, (VerificationMode)Mockito.times((int)1))).setDisabled(Matchers.eq((boolean)true));
    }

    @Test
    public void validateDmnPath_Valid() {
        this.settingsPresenter.validateDmnPath();
        ((SettingsScenarioSimulationDropdown)Mockito.verify((Object)this.settingsScenarioSimulationDropdownMock, (VerificationMode)Mockito.times((int)1))).getValue();
        ((Style)Mockito.verify((Object)this.dmnFilePathErrorLabelStyleMock, (VerificationMode)Mockito.times((int)1))).setDisplay((Style.Display)Matchers.eq((Object)Style.Display.NONE));
        ((SpanElement)Mockito.verify((Object)this.dmnFilePathErrorLabelMock, (VerificationMode)Mockito.times((int)1))).setInnerText((String)Matchers.eq((Object)""));
        ((ButtonElement)Mockito.verify((Object)this.saveButtonMock, (VerificationMode)Mockito.times((int)1))).setDisabled(Matchers.eq((boolean)false));
    }

    @Test
    public void validateDmnPath_Invalid() {
        KieAssetsDropdownItem item = new KieAssetsDropdownItem("DMNFile", "", "", null);
        Mockito.when((Object)this.settingsScenarioSimulationDropdownMock.getValue()).thenReturn(Optional.of(item));
        this.settingsPresenter.validateDmnPath();
        ((SettingsScenarioSimulationDropdown)Mockito.verify((Object)this.settingsScenarioSimulationDropdownMock, (VerificationMode)Mockito.times((int)1))).getValue();
        ((Style)Mockito.verify((Object)this.dmnFilePathErrorLabelStyleMock, (VerificationMode)Mockito.times((int)1))).setDisplay((Style.Display)Matchers.eq((Object)Style.Display.INLINE));
        ((SpanElement)Mockito.verify((Object)this.dmnFilePathErrorLabelMock, (VerificationMode)Mockito.times((int)1))).setInnerText((String)Matchers.eq((Object)ScenarioSimulationEditorConstants.INSTANCE.chooseValidDMNAsset()));
        ((ButtonElement)Mockito.verify((Object)this.saveButtonMock, (VerificationMode)Mockito.times((int)1))).setDisabled(Matchers.eq((boolean)true));
    }
}

