/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.handlers;

import com.ait.lienzo.client.core.types.Point2D;
import com.google.gwt.event.shared.GwtEvent;
import java.util.Optional;
import javax.enterprise.context.Dependent;
import org.drools.scenariosimulation.api.model.FactMapping;
import org.drools.scenariosimulation.api.model.FactMappingValueStatus;
import org.drools.scenariosimulation.api.model.Scenario;
import org.drools.workbench.screens.scenariosimulation.client.events.SetGridCellValueEvent;
import org.drools.workbench.screens.scenariosimulation.client.handlers.AbstractScenarioSimulationGridPanelHandler;
import org.drools.workbench.screens.scenariosimulation.client.metadata.ScenarioHeaderMetaData;
import org.drools.workbench.screens.scenariosimulation.client.popover.ErrorReportPopoverPresenter;
import org.drools.workbench.screens.scenariosimulation.client.popover.PopoverView;
import org.drools.workbench.screens.scenariosimulation.client.resources.i18n.ScenarioSimulationEditorConstants;
import org.drools.workbench.screens.scenariosimulation.client.utils.ScenarioSimulationUtils;
import org.drools.workbench.screens.scenariosimulation.client.widgets.ScenarioGridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;
import org.uberfire.ext.wires.core.grids.client.widget.layer.GridLayer;

@Dependent
public class CommonOnMoveHandler
extends AbstractScenarioSimulationGridPanelHandler {
    private static int POPOVER_WIDTH = 200;
    private static String NULL = "null";
    protected ErrorReportPopoverPresenter errorReportPopupPresenter;
    protected Integer currentlyShownBodyRowIndex = -1;
    protected Integer currentlyShownBodyColumnIndex = -1;

    public void handleOnMove(int mx, int my) {
        this.manageCoordinates(mx, my);
    }

    public void hidePopover() {
        this.errorReportPopupPresenter.hide();
    }

    public void setErrorReportPopupPresenter(ErrorReportPopoverPresenter errorReportPopupPresenter) {
        this.errorReportPopupPresenter = errorReportPopupPresenter;
    }

    @Override
    protected boolean manageGivenExpectHeaderCoordinates(ScenarioHeaderMetaData clickedScenarioHeaderMetadata, ScenarioGridColumn scenarioGridColumn, String group, Integer uiColumnIndex) {
        return false;
    }

    @Override
    protected boolean manageBodyCoordinates(Integer uiRowIndex, Integer uiColumnIndex) {
        if (uiColumnIndex == -1 || uiRowIndex == -1) {
            return false;
        }
        if (uiRowIndex.equals(this.currentlyShownBodyRowIndex) && uiColumnIndex.equals(this.currentlyShownBodyColumnIndex) && this.errorReportPopupPresenter.isShown()) {
            return true;
        }
        Scenario scenarioByIndex = this.scenarioGrid.getModel().getSimulation().get().getScenarioByIndex(uiRowIndex.intValue());
        FactMapping factMapping = this.scenarioGrid.getModel().getSimulation().get().getSimulationDescriptor().getFactMappingByIndex(uiColumnIndex.intValue());
        Optional factMappingValueOptional = scenarioByIndex.getFactMappingValue(factMapping);
        factMappingValueOptional.ifPresent(factMappingValue -> {
            if (factMappingValue.getStatus() != null && FactMappingValueStatus.SUCCESS != factMappingValue.getStatus()) {
                this.currentlyShownBodyRowIndex = uiRowIndex;
                this.currentlyShownBodyColumnIndex = uiColumnIndex;
                GridColumn column = (GridColumn)this.scenarioGrid.getModel().getColumns().get(uiColumnIndex);
                Point2D xYCell = this.retrieveCellMiddleXYPosition(column, uiRowIndex);
                PopoverView.Position position = PopoverView.Position.RIGHT;
                int xMiddleWidth = (int)column.getWidth() / 2;
                int xPosition = (int)xYCell.getX() + xMiddleWidth;
                if (xPosition + POPOVER_WIDTH > this.scenarioGrid.getLayer().getWidth()) {
                    xPosition = (int)xYCell.getX() - xMiddleWidth;
                    position = PopoverView.Position.LEFT;
                }
                int scrollX = this.scenarioGridPanel.getScrollPanel().getElement().getScrollLeft();
                xPosition -= scrollX;
                int yPosition = (int)xYCell.getY();
                int scrollY = this.scenarioGridPanel.getScrollPanel().getElement().getScrollTop();
                yPosition -= scrollY;
                Object expectedValue = factMappingValue.getRawValue();
                Object errorValue = factMappingValue.getErrorValue();
                if (FactMappingValueStatus.FAILED_WITH_ERROR == factMappingValue.getStatus()) {
                    this.errorReportPopupPresenter.show(ScenarioSimulationEditorConstants.INSTANCE.errorReason(), ScenarioSimulationEditorConstants.INSTANCE.errorPopoverMessageFailedWithError(expectedValue != null ? expectedValue.toString() : NULL, errorValue != null ? errorValue.toString() : NULL), ScenarioSimulationEditorConstants.INSTANCE.keep(), ScenarioSimulationEditorConstants.INSTANCE.apply(), () -> this.scenarioGrid.getEventBus().fireEvent((GwtEvent)new SetGridCellValueEvent(uiRowIndex, uiColumnIndex, errorValue != null ? errorValue.toString() : NULL)), xPosition, yPosition, position);
                } else {
                    this.errorReportPopupPresenter.show(ScenarioSimulationEditorConstants.INSTANCE.errorReason(), ScenarioSimulationEditorConstants.INSTANCE.errorPopoverMessageFailedWithException(factMappingValue.getExceptionMessage()), ScenarioSimulationEditorConstants.INSTANCE.close(), xPosition, yPosition, position);
                }
            }
        });
        return true;
    }

    protected Point2D retrieveCellMiddleXYPosition(GridColumn<?> column, int uiRowIndex) {
        return ScenarioSimulationUtils.getMiddleXYCell((GridWidget)this.scenarioGrid, column, false, uiRowIndex, (GridLayer)this.scenarioGrid.getLayer());
    }
}

