/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.rightpanel;

import com.google.gwt.dom.client.ButtonElement;
import com.google.gwt.dom.client.DivElement;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.InputElement;
import com.google.gwt.dom.client.LabelElement;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.KeyDownEvent;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.user.client.ui.Composite;
import java.util.Arrays;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import org.drools.workbench.screens.scenariosimulation.client.resources.i18n.ScenarioSimulationEditorConstants;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.TestToolsView;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.Templated;

@ApplicationScoped
@Templated(stylesheet="/org/drools/workbench/screens/scenariosimulation/client/resources/css/ScenarioSimulationEditorStyles.css")
public class TestToolsViewImpl
extends Composite
implements TestToolsView {
    protected TestToolsView.Presenter presenter;
    @DataField(value="clearSearchButton")
    protected ButtonElement clearSearchButton = Document.get().createButtonElement();
    @DataField(value="searchButton")
    protected ButtonElement searchButton = Document.get().createButtonElement();
    @DataField(value="inputSearch")
    protected InputElement inputSearch = Document.get().createTextInputElement();
    @DataField(value="nameField")
    protected InputElement nameField = Document.get().createTextInputElement();
    @DataField(value="dataObjectListContainer-separator")
    protected LabelElement dataObjectListContainerSeparator = Document.get().createLabelElement();
    @DataField(value="dataObjectListContainer")
    protected DivElement dataObjectListContainer = Document.get().createDivElement();
    @DataField(value="simpleJavaTypeListContainer-separator")
    protected LabelElement simpleJavaTypeListContainerSeparator = Document.get().createLabelElement();
    @DataField(value="simpleJavaTypeListContainer")
    protected DivElement simpleJavaTypeListContainer = Document.get().createDivElement();
    @DataField(value="instanceListContainer-separator")
    protected LabelElement instanceListContainerSeparator = Document.get().createLabelElement();
    @DataField(value="instanceListContainer")
    protected DivElement instanceListContainer = Document.get().createDivElement();
    @DataField(value="simpleJavaInstanceListContainer-separator")
    protected LabelElement simpleJavaInstanceListContainerSeparator = Document.get().createLabelElement();
    @DataField(value="simpleJavaInstanceListContainer")
    protected DivElement simpleJavaInstanceListContainer = Document.get().createDivElement();
    @DataField(value="conditionsButton")
    protected ButtonElement conditionsButton = Document.get().createButtonElement();
    @DataField(value="addButton")
    protected ButtonElement addButton = Document.get().createButtonElement();
    @DataField(value="kieTestToolsContent")
    protected DivElement kieTestToolsContent = Document.get().createDivElement();
    protected List<DivElement> managedDivElements = Arrays.asList(this.dataObjectListContainer, this.simpleJavaTypeListContainer, this.instanceListContainer, this.simpleJavaTypeListContainer);

    public void init(TestToolsView.Presenter presenter) {
        this.presenter = presenter;
        this.disableEditorTab();
        this.addButton.setDisabled(true);
        this.dataObjectListContainerSeparator.setInnerText(ScenarioSimulationEditorConstants.INSTANCE.complexTypes());
        this.simpleJavaTypeListContainerSeparator.setInnerText(ScenarioSimulationEditorConstants.INSTANCE.simpleTypes());
        this.instanceListContainerSeparator.setInnerText(ScenarioSimulationEditorConstants.INSTANCE.complexCustomInstances());
        this.simpleJavaInstanceListContainerSeparator.setInnerText(ScenarioSimulationEditorConstants.INSTANCE.simpleCustomInstances());
    }

    @Override
    public TestToolsView.Presenter getPresenter() {
        return this.presenter;
    }

    @Override
    public void reset() {
        this.dataObjectListContainerSeparator.getStyle().setDisplay(Style.Display.NONE);
        this.dataObjectListContainer.removeAllChildren();
        this.simpleJavaTypeListContainerSeparator.getStyle().setDisplay(Style.Display.NONE);
        this.simpleJavaTypeListContainer.removeAllChildren();
        this.instanceListContainerSeparator.getStyle().setDisplay(Style.Display.NONE);
        this.instanceListContainer.removeAllChildren();
        this.simpleJavaInstanceListContainerSeparator.getStyle().setDisplay(Style.Display.NONE);
        this.simpleJavaInstanceListContainer.removeAllChildren();
    }

    @EventHandler(value={"clearSearchButton"})
    public void onClearSearchButtonClick(ClickEvent event) {
        this.presenter.onUndoSearch();
    }

    @EventHandler(value={"inputSearch"})
    public void onInputSearchKeyUp(KeyUpEvent event) {
        this.presenter.onShowClearButton();
    }

    @EventHandler(value={"inputSearch"})
    public void onInputSearchKeyDownEvent(KeyDownEvent event) {
        if (event.getNativeKeyCode() == 13) {
            this.presenter.onSearchedEvent(this.inputSearch.getValue());
        }
    }

    @EventHandler(value={"searchButton"})
    public void onSearchButtonClicked(ClickEvent event) {
        this.presenter.onSearchedEvent(this.inputSearch.getValue());
    }

    @EventHandler(value={"addButton"})
    public void onAddButtonClicked(ClickEvent event) {
        this.presenter.onModifyColumn();
        this.addButton.setDisabled(true);
        this.presenter.onDisableEditorTab();
    }

    @Override
    public void clearInputSearch() {
        this.inputSearch.setValue("");
    }

    @Override
    public void clearNameField() {
        this.nameField.setValue("");
    }

    @Override
    public void hideClearButton() {
        this.clearSearchButton.setDisabled(true);
        this.clearSearchButton.setAttribute("style", "display: none;");
    }

    @Override
    public void showClearButton() {
        this.clearSearchButton.setDisabled(false);
        this.clearSearchButton.removeAttribute("style");
    }

    @Override
    public LabelElement getDataObjectListContainerSeparator() {
        return this.dataObjectListContainerSeparator;
    }

    @Override
    public DivElement getDataObjectListContainer() {
        return this.dataObjectListContainer;
    }

    @Override
    public LabelElement getSimpleJavaTypeListContainerSeparator() {
        return this.simpleJavaTypeListContainerSeparator;
    }

    @Override
    public DivElement getSimpleJavaTypeListContainer() {
        return this.simpleJavaTypeListContainer;
    }

    @Override
    public LabelElement getInstanceListContainerSeparator() {
        return this.instanceListContainerSeparator;
    }

    @Override
    public DivElement getInstanceListContainer() {
        return this.instanceListContainer;
    }

    @Override
    public LabelElement getSimpleJavaInstanceListContainerSeparator() {
        return this.simpleJavaInstanceListContainerSeparator;
    }

    @Override
    public DivElement getSimpleJavaInstanceListContainer() {
        return this.simpleJavaInstanceListContainer;
    }

    @Override
    public void enableEditorTab() {
        this.setDisabledStatus(false);
    }

    @Override
    public void disableEditorTab() {
        this.setDisabledStatus(true);
    }

    @Override
    public void enableSearch() {
        this.clearSearchButton.setDisabled(false);
        this.searchButton.setDisabled(false);
        this.inputSearch.setDisabled(false);
    }

    @Override
    public void disableSearch() {
        this.hideClearButton();
        this.searchButton.setDisabled(true);
        this.inputSearch.setDisabled(true);
        this.inputSearch.setValue("");
    }

    @Override
    public void enableAddButton() {
        this.addButton.setDisabled(false);
    }

    @Override
    public void disableAddButton() {
        this.addButton.setDisabled(true);
    }

    protected void setDisabledStatus(boolean disabled) {
        this.nameField.setDisabled(disabled);
        this.conditionsButton.setDisabled(disabled);
        this.setContainersDisabledStatus(disabled);
        if (disabled) {
            this.kieTestToolsContent.addClassName("disabled");
            this.disableSearch();
            this.disableAddButton();
        } else {
            this.kieTestToolsContent.removeClassName("disabled");
        }
    }

    protected void setContainersDisabledStatus(boolean disabled) {
        if (disabled) {
            this.managedDivElements.forEach(divElement -> divElement.addClassName("disabled"));
        } else {
            this.managedDivElements.forEach(divElement -> divElement.removeClassName("disabled"));
        }
    }
}

