/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.widgets;

import com.ait.lienzo.shared.core.types.EventPropagationMode;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.GwtEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.IntStream;
import org.drools.scenariosimulation.api.model.FactIdentifier;
import org.drools.scenariosimulation.api.model.FactMapping;
import org.drools.scenariosimulation.api.model.FactMappingType;
import org.drools.scenariosimulation.api.model.Scenario;
import org.drools.scenariosimulation.api.model.ScenarioSimulationModel;
import org.drools.scenariosimulation.api.model.Simulation;
import org.drools.scenariosimulation.api.utils.ScenarioSimulationSharedUtils;
import org.drools.workbench.screens.scenariosimulation.client.events.DisableTestToolsEvent;
import org.drools.workbench.screens.scenariosimulation.client.events.EnableTestToolsEvent;
import org.drools.workbench.screens.scenariosimulation.client.events.ReloadTestToolsEvent;
import org.drools.workbench.screens.scenariosimulation.client.handlers.ScenarioSimulationGridWidgetMouseEventHandler;
import org.drools.workbench.screens.scenariosimulation.client.menu.ScenarioContextMenuRegistry;
import org.drools.workbench.screens.scenariosimulation.client.metadata.ScenarioHeaderMetaData;
import org.drools.workbench.screens.scenariosimulation.client.models.ScenarioGridModel;
import org.drools.workbench.screens.scenariosimulation.client.renderers.ScenarioGridRenderer;
import org.drools.workbench.screens.scenariosimulation.client.resources.i18n.ScenarioSimulationEditorConstants;
import org.drools.workbench.screens.scenariosimulation.client.utils.ScenarioSimulationBuilders;
import org.drools.workbench.screens.scenariosimulation.client.utils.ScenarioSimulationGridHeaderUtilities;
import org.drools.workbench.screens.scenariosimulation.client.utils.ScenarioSimulationUtils;
import org.drools.workbench.screens.scenariosimulation.client.widgets.ScenarioGridColumn;
import org.drools.workbench.screens.scenariosimulation.client.widgets.ScenarioGridLayer;
import org.drools.workbench.screens.scenariosimulation.client.widgets.ScenarioGridRow;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.model.GridRow;
import org.uberfire.ext.wires.core.grids.client.util.ColumnIndexUtilities;
import org.uberfire.ext.wires.core.grids.client.widget.grid.NodeMouseEventHandler;
import org.uberfire.ext.wires.core.grids.client.widget.grid.impl.BaseGridWidget;
import org.uberfire.ext.wires.core.grids.client.widget.grid.impl.DefaultGridWidgetCellSelectorMouseEventHandler;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.grids.GridRenderer;
import org.uberfire.ext.wires.core.grids.client.widget.grid.selections.SelectionExtension;
import org.uberfire.ext.wires.core.grids.client.widget.layer.GridSelectionManager;
import org.uberfire.ext.wires.core.grids.client.widget.layer.pinning.GridPinnedModeManager;

public class ScenarioGrid
extends BaseGridWidget {
    private ScenarioContextMenuRegistry scenarioContextMenuRegistry;
    private EventBus eventBus;

    public ScenarioGrid(ScenarioGridModel model, ScenarioGridLayer scenarioGridLayer, ScenarioGridRenderer renderer, ScenarioContextMenuRegistry scenarioContextMenuRegistry) {
        super((GridData)model, (GridSelectionManager)scenarioGridLayer, (GridPinnedModeManager)scenarioGridLayer, (GridRenderer)renderer);
        this.scenarioContextMenuRegistry = scenarioContextMenuRegistry;
        this.setDraggable(false);
        this.setEventPropagationMode(EventPropagationMode.NO_ANCESTORS);
    }

    public void setContent(Simulation simulation) {
        ((ScenarioGridModel)this.model).clear();
        ((ScenarioGridModel)this.model).bindContent(simulation);
        this.setHeaderColumns(simulation);
        this.appendRows(simulation);
    }

    public EventBus getEventBus() {
        return this.eventBus;
    }

    public void setEventBus(EventBus eventBus) {
        this.eventBus = eventBus;
        ((ScenarioGridModel)this.model).setEventBus(eventBus);
        this.scenarioContextMenuRegistry.setEventBus(eventBus);
    }

    public ScenarioGridModel getModel() {
        return (ScenarioGridModel)this.model;
    }

    public void clearSelections() {
        this.model.clearSelections();
    }

    public void setSelectedColumnAndHeader(int headerRowIndex, int columnIndex) {
        ((ScenarioGridModel)this.model).selectColumn(columnIndex);
        this.model.selectHeaderCell(headerRowIndex, columnIndex);
    }

    protected List<NodeMouseEventHandler> getNodeMouseClickEventHandlers(GridSelectionManager selectionManager) {
        ArrayList<NodeMouseEventHandler> handlers = new ArrayList<NodeMouseEventHandler>();
        handlers.add((NodeMouseEventHandler)new DefaultGridWidgetCellSelectorMouseEventHandler(selectionManager));
        return handlers;
    }

    protected List<NodeMouseEventHandler> getNodeMouseDoubleClickEventHandlers(GridSelectionManager selectionManager, GridPinnedModeManager pinnedModeManager) {
        ArrayList<NodeMouseEventHandler> handlers = new ArrayList<NodeMouseEventHandler>();
        handlers.add((NodeMouseEventHandler)new ScenarioSimulationGridWidgetMouseEventHandler());
        return handlers;
    }

    protected void setHeaderColumns(Simulation simulation) {
        List factMappings = simulation.getSimulationDescriptor().getUnmodifiableFactMappings();
        boolean editableHeaders = !simulation.getSimulationDescriptor().getType().equals((Object)ScenarioSimulationModel.Type.DMN);
        IntStream.range(0, factMappings.size()).forEach(columnIndex -> this.setHeaderColumn(columnIndex, (FactMapping)factMappings.get(columnIndex), editableHeaders));
    }

    protected void setHeaderColumn(int columnIndex, FactMapping factMapping, boolean editableHeaders) {
        FactIdentifier factIdentifier = factMapping.getFactIdentifier();
        String columnId = factMapping.getExpressionIdentifier().getName();
        String instanceTitle = factMapping.getFactAlias();
        String propertyTitle = factMapping.getExpressionAlias();
        String columnGroup = factMapping.getExpressionIdentifier().getType().name();
        boolean isInstanceAssigned = this.isInstanceAssigned(factIdentifier);
        boolean isPropertyAssigned = this.isPropertyAssigned(isInstanceAssigned, factMapping);
        String placeHolder = this.getPlaceholder(isPropertyAssigned, factMapping);
        ScenarioGridColumn scenarioGridColumn = this.getScenarioGridColumnLocal(instanceTitle, propertyTitle, columnId, columnGroup, factMapping.getExpressionIdentifier().getType(), placeHolder);
        scenarioGridColumn.setInstanceAssigned(isInstanceAssigned);
        scenarioGridColumn.setPropertyAssigned(isPropertyAssigned);
        scenarioGridColumn.setFactIdentifier(factIdentifier);
        scenarioGridColumn.setEditableHeaders(editableHeaders);
        if (FactMappingType.OTHER.equals((Object)factMapping.getExpressionIdentifier().getType())) {
            scenarioGridColumn.setColumnWidthMode(GridColumn.ColumnWidthMode.FIXED);
            scenarioGridColumn.setMinimumWidth(scenarioGridColumn.getWidth());
        }
        if (isPropertyAssigned) {
            this.setDOMElementFactory(scenarioGridColumn, factMapping.getClassName());
        }
        ((ScenarioGridModel)this.model).insertColumnGridOnly(columnIndex, (GridColumn<?>)scenarioGridColumn);
    }

    protected void setDOMElementFactory(ScenarioGridColumn scenarioGridColumn, String className) {
        if (ScenarioSimulationSharedUtils.isCollection((String)className)) {
            scenarioGridColumn.setFactory(((ScenarioGridModel)this.model).getCollectionEditorSingletonDOMElementFactory());
        }
    }

    protected boolean isInstanceAssigned(FactIdentifier factIdentifier) {
        if (FactIdentifier.DESCRIPTION.equals((Object)factIdentifier)) {
            return true;
        }
        return !FactIdentifier.EMPTY.equals((Object)factIdentifier) && !FactIdentifier.INDEX.equals((Object)factIdentifier);
    }

    protected boolean isPropertyAssigned(boolean instanceAssigned, FactMapping factMapping) {
        if (FactIdentifier.DESCRIPTION.equals((Object)factMapping.getFactIdentifier())) {
            return true;
        }
        return instanceAssigned && (ScenarioSimulationUtils.isSimpleJavaType(factMapping.getClassName()) || !factMapping.getExpressionElements().isEmpty());
    }

    protected String getPlaceholder(boolean isPropertyAssigned, FactMapping factMapping) {
        String editableCellPlaceholder = ScenarioSimulationUtils.getPlaceholder(factMapping.getClassName());
        return isPropertyAssigned ? editableCellPlaceholder : ScenarioSimulationEditorConstants.INSTANCE.defineValidType();
    }

    protected ScenarioGridColumn getScenarioGridColumnLocal(String instanceTitle, String propertyTitle, String columnId, String columnGroup, FactMappingType factMappingType, String placeHolder) {
        ScenarioSimulationBuilders.HeaderBuilder headerBuilder = this.getHeaderBuilderLocal(instanceTitle, propertyTitle, columnId, columnGroup, factMappingType);
        return this.getScenarioGridColumnLocal(headerBuilder, placeHolder);
    }

    protected ScenarioGridColumn getScenarioGridColumnLocal(ScenarioSimulationBuilders.HeaderBuilder headerBuilder, String placeHolder) {
        return ScenarioSimulationUtils.getScenarioGridColumn(headerBuilder, ((ScenarioGridModel)this.model).getScenarioCellTextAreaSingletonDOMElementFactory(), placeHolder);
    }

    protected ScenarioSimulationBuilders.HeaderBuilder getHeaderBuilderLocal(String instanceTitle, String propertyTitle, String columnId, String columnGroup, FactMappingType factMappingType) {
        return ScenarioSimulationUtils.getHeaderBuilder(instanceTitle, propertyTitle, columnId, columnGroup, factMappingType, ((ScenarioGridModel)this.model).getScenarioHeaderTextBoxSingletonDOMElementFactory());
    }

    protected void appendRows(Simulation simulation) {
        List scenarios = simulation.getUnmodifiableScenarios();
        IntStream.range(0, scenarios.size()).forEach(rowIndex -> this.appendRow(rowIndex, (Scenario)scenarios.get(rowIndex)));
    }

    protected void appendRow(int rowIndex, Scenario scenario) {
        ((ScenarioGridModel)this.model).insertRowGridOnly(rowIndex, (GridRow)new ScenarioGridRow(), scenario);
    }

    public boolean adjustSelection(SelectionExtension direction, boolean isShiftKeyDown) {
        boolean selectionChanged = super.adjustSelection(direction, isShiftKeyDown);
        this.signalTestTools();
        this.scenarioContextMenuRegistry.hideMenus();
        this.scenarioContextMenuRegistry.hideErrorReportPopover();
        return selectionChanged;
    }

    protected void signalTestTools() {
        this.eventBus.fireEvent((GwtEvent)new DisableTestToolsEvent());
        if (this.model.getSelectedHeaderCells().size() > 0) {
            GridData.SelectedCell cell = (GridData.SelectedCell)this.model.getSelectedHeaderCells().get(0);
            int uiColumnIndex = ColumnIndexUtilities.findUiColumnIndex((List)this.model.getColumns(), (int)cell.getColumnIndex());
            int uiRowIndex = cell.getRowIndex();
            this.setSelectedColumnAndHeader(uiRowIndex, uiColumnIndex);
            GridColumn column = (GridColumn)this.model.getColumns().get(uiColumnIndex);
            if (uiRowIndex > 0 && column instanceof ScenarioGridColumn) {
                this.signalTestToolsHeaderCellSelected((ScenarioGridColumn)column, cell, uiColumnIndex);
            }
        }
    }

    protected void signalTestToolsHeaderCellSelected(ScenarioGridColumn scenarioGridColumn, GridData.SelectedCell selectedHeaderCell, int uiColumnIndex) {
        ScenarioHeaderMetaData scenarioHeaderMetaData = this.getColumnScenarioHeaderMetaData(scenarioGridColumn, selectedHeaderCell.getRowIndex());
        if (scenarioGridColumn.isInstanceAssigned() && scenarioHeaderMetaData.getMetadataType().equals((Object)ScenarioHeaderMetaData.MetadataType.INSTANCE)) {
            this.eventBus.fireEvent((GwtEvent)new ReloadTestToolsEvent(true, true));
        } else {
            String group = ScenarioSimulationUtils.getOriginalColumnGroup(scenarioHeaderMetaData.getColumnGroup());
            EnableTestToolsEvent enableTestToolsEvent = this.getEnableTestToolsEvent(this, scenarioGridColumn, scenarioHeaderMetaData, uiColumnIndex, group);
            this.eventBus.fireEvent((GwtEvent)enableTestToolsEvent);
        }
    }

    protected ScenarioHeaderMetaData getColumnScenarioHeaderMetaData(ScenarioGridColumn scenarioGridColumn, int rowIndex) {
        return ScenarioSimulationGridHeaderUtilities.getColumnScenarioHeaderMetaData(scenarioGridColumn, rowIndex);
    }

    protected EnableTestToolsEvent getEnableTestToolsEvent(ScenarioGrid scenarioGrid, ScenarioGridColumn scenarioGridColumn, ScenarioHeaderMetaData scenarioHeaderMetaData, int uiColumnIndex, String group) {
        return ScenarioSimulationGridHeaderUtilities.getEnableTestToolsEvent(scenarioGrid, scenarioGridColumn, scenarioHeaderMetaData, uiColumnIndex, group);
    }
}

