/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.editor.strategies;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.drools.scenariosimulation.api.model.ExpressionElement;
import org.drools.scenariosimulation.api.model.FactMappingType;
import org.drools.scenariosimulation.api.model.ScenarioSimulationModel;
import org.drools.scenariosimulation.api.model.SimulationDescriptor;
import org.drools.workbench.screens.scenariosimulation.client.commands.ScenarioSimulationContext;
import org.drools.workbench.screens.scenariosimulation.client.editor.strategies.DataManagementStrategy;
import org.drools.workbench.screens.scenariosimulation.client.models.ScenarioGridModel;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.TestToolsView;
import org.drools.workbench.screens.scenariosimulation.client.widgets.ScenarioGridColumn;
import org.drools.workbench.screens.scenariosimulation.model.typedescriptor.FactModelTree;
import org.drools.workbench.screens.scenariosimulation.model.typedescriptor.FactModelTuple;

public abstract class AbstractDataManagementStrategy
implements DataManagementStrategy {
    protected ScenarioSimulationModel model;
    protected ScenarioSimulationContext scenarioSimulationContext;
    protected ResultHolder factModelTreeHolder = new ResultHolder();

    @Override
    public void setModel(ScenarioSimulationModel model) {
        this.model = model;
    }

    public static FactModelTree getSimpleClassFactModelTree(String simpleClass, String canonicalName) {
        String key = simpleClass;
        HashMap<String, String> simpleProperties = new HashMap<String, String>();
        String fullName = canonicalName;
        simpleProperties.put("value", fullName);
        String packageName = fullName.substring(0, fullName.lastIndexOf("."));
        FactModelTree toReturn = new FactModelTree(key, packageName, simpleProperties, new HashMap());
        toReturn.setSimple(true);
        return toReturn;
    }

    public Map<String, List<List<String>>> getPropertiesToHide(ScenarioGridModel scenarioGridModel) {
        HashMap<String, List<List<String>>> toReturn = new HashMap<String, List<List<String>>>();
        ScenarioGridColumn selectedColumn = (ScenarioGridColumn)scenarioGridModel.getSelectedColumn();
        if (selectedColumn != null && selectedColumn.isInstanceAssigned()) {
            toReturn.put(selectedColumn.getInformationHeaderMetaData().getTitle(), this.getPropertiesToHide(selectedColumn, scenarioGridModel));
        }
        return toReturn;
    }

    protected List<List<String>> getPropertiesToHide(ScenarioGridColumn selectedColumn, ScenarioGridModel scenarioGridModel) {
        ArrayList<List<String>> toReturn = new ArrayList<List<String>>();
        if (!selectedColumn.isPropertyAssigned()) {
            scenarioGridModel.getSimulation().ifPresent(simulation -> {
                SimulationDescriptor simulationDescriptor = simulation.getSimulationDescriptor();
                List<ScenarioGridColumn> instanceColumns = scenarioGridModel.getInstanceScenarioGridColumns(selectedColumn);
                toReturn.addAll(instanceColumns.stream().filter(ScenarioGridColumn::isPropertyAssigned).map(instanceColumn -> scenarioGridModel.getColumns().indexOf(instanceColumn)).map(columnIndex -> {
                    List propertyNameElements = simulationDescriptor.getFactMappingByIndex(columnIndex.intValue()).getExpressionElementsWithoutClass().stream().map(ExpressionElement::getStep).collect(Collectors.toList());
                    if (propertyNameElements.isEmpty()) {
                        propertyNameElements.add("value");
                    }
                    return Collections.unmodifiableList(propertyNameElements);
                }).collect(Collectors.toList()));
            });
        }
        return toReturn;
    }

    public void storeData(FactModelTuple factModelTuple, TestToolsView.Presenter testToolsPresenter, ScenarioGridModel scenarioGridModel) {
        Map<String, List<List<String>>> propertiesToHide = this.getPropertiesToHide(scenarioGridModel);
        SortedMap visibleFacts = factModelTuple.getVisibleFacts();
        Map<Boolean, List<Map.Entry>> partitionBy = visibleFacts.entrySet().stream().collect(Collectors.partitioningBy(stringFactModelTreeEntry -> ((FactModelTree)stringFactModelTreeEntry.getValue()).isSimple()));
        TreeMap<String, FactModelTree> complexDataObjects = new TreeMap<String, FactModelTree>(partitionBy.get(false).stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
        TreeMap<String, FactModelTree> simpleDataObjects = new TreeMap<String, FactModelTree>(partitionBy.get(true).stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
        SortedMap<String, FactModelTree> instanceFieldsMap = this.getInstanceMap(complexDataObjects);
        SortedMap<String, FactModelTree> simpleJavaTypeInstanceFieldsMap = this.getInstanceMap(simpleDataObjects);
        testToolsPresenter.setDataObjectFieldsMap(complexDataObjects);
        testToolsPresenter.setSimpleJavaTypeFieldsMap(simpleDataObjects);
        testToolsPresenter.setInstanceFieldsMap(instanceFieldsMap);
        testToolsPresenter.setSimpleJavaInstanceFieldsMap(simpleJavaTypeInstanceFieldsMap);
        testToolsPresenter.setHiddenFieldsMap(factModelTuple.getHiddenFacts());
        testToolsPresenter.hideProperties(propertiesToHide);
        TreeMap<String, FactModelTree> context = new TreeMap<String, FactModelTree>();
        context.putAll(visibleFacts);
        context.putAll(factModelTuple.getHiddenFacts());
        this.scenarioSimulationContext.setDataObjectFieldsMap(context);
        HashSet<String> dataObjectsInstancesName = new HashSet<String>(visibleFacts.keySet());
        dataObjectsInstancesName.addAll(instanceFieldsMap.keySet());
        scenarioGridModel.setDataObjectsInstancesName(dataObjectsInstancesName);
        HashSet<String> simpleJavaTypeInstancesName = new HashSet<String>(simpleDataObjects.keySet());
        simpleJavaTypeInstancesName.addAll(simpleJavaTypeInstanceFieldsMap.keySet());
        scenarioGridModel.setSimpleJavaTypeInstancesName(simpleJavaTypeInstancesName);
    }

    public SortedMap<String, FactModelTree> getInstanceMap(SortedMap<String, FactModelTree> sourceMap) {
        TreeMap<String, FactModelTree> toReturn = new TreeMap<String, FactModelTree>();
        if (this.model != null) {
            SimulationDescriptor simulationDescriptor = this.model.getSimulation().getSimulationDescriptor();
            simulationDescriptor.getUnmodifiableFactMappings().stream().filter(factMapping -> !Objects.equals(FactMappingType.OTHER, factMapping.getExpressionIdentifier().getType())).forEach(factMapping -> {
                FactModelTree factModelTree;
                String dataObjectName = factMapping.getFactIdentifier().getClassNameWithoutPackage();
                String instanceName = factMapping.getFactAlias();
                if (!instanceName.equals(dataObjectName) && (factModelTree = (FactModelTree)sourceMap.get(dataObjectName)) != null) {
                    toReturn.put(instanceName, factModelTree);
                }
            });
        }
        return toReturn;
    }

    public static class ResultHolder {
        FactModelTuple factModelTuple;

        public FactModelTuple getFactModelTuple() {
            return this.factModelTuple;
        }

        public void setFactModelTuple(FactModelTuple factModelTuple) {
            this.factModelTuple = factModelTuple;
        }
    }
}

