/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.models;

import com.ait.lienzo.test.LienzoMockitoTestRunner;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.GwtEvent;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import org.drools.scenariosimulation.api.model.ExpressionIdentifier;
import org.drools.scenariosimulation.api.model.FactIdentifier;
import org.drools.scenariosimulation.api.model.FactMapping;
import org.drools.scenariosimulation.api.model.FactMappingValue;
import org.drools.scenariosimulation.api.model.FactMappingValueStatus;
import org.drools.scenariosimulation.api.model.Scenario;
import org.drools.scenariosimulation.api.model.Simulation;
import org.drools.scenariosimulation.api.model.SimulationDescriptor;
import org.drools.workbench.screens.scenariosimulation.client.AbstractScenarioSimulationTest;
import org.drools.workbench.screens.scenariosimulation.client.TestProperties;
import org.drools.workbench.screens.scenariosimulation.client.events.ReloadTestToolsEvent;
import org.drools.workbench.screens.scenariosimulation.client.metadata.ScenarioHeaderMetaData;
import org.drools.workbench.screens.scenariosimulation.client.models.ScenarioGridModel;
import org.drools.workbench.screens.scenariosimulation.client.values.ScenarioGridCellValue;
import org.drools.workbench.screens.scenariosimulation.client.widgets.ScenarioGridCell;
import org.drools.workbench.screens.scenariosimulation.client.widgets.ScenarioGridColumn;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.wires.core.grids.client.model.GridCell;
import org.uberfire.ext.wires.core.grids.client.model.GridCellValue;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.model.GridRow;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridRow;

@RunWith(value=LienzoMockitoTestRunner.class)
public class ScenarioGridModelTest
extends AbstractScenarioSimulationTest {
    private ScenarioGridModel scenarioGridModel;
    @Mock
    private ScenarioGridColumn scenarioIndexGridColumnMock;
    @Mock
    private BaseGridRow gridRowMock;
    @Mock
    private ScenarioHeaderMetaData groupHeaderMetaDataMock;
    @Mock
    private ScenarioHeaderMetaData indexHeaderMetaDataMock;
    @Mock
    private ScenarioGridCell gridCellMock;
    @Mock
    private ScenarioGridCellValue gridCellValueMock;
    @Mock
    private Scenario scenarioMock;
    private Supplier<GridCell<?>> gridCellSupplier;

    @Override
    @Before
    public void setup() {
        super.setup();
        TestProperties.HEADER_META_DATA.add((GridColumn.HeaderMetaData)this.groupHeaderMetaDataMock);
        TestProperties.HEADER_META_DATA.add((GridColumn.HeaderMetaData)this.informationHeaderMetaDataMock);
        TestProperties.HEADER_META_DATA.add((GridColumn.HeaderMetaData)this.propertyHeaderMetaDataMock);
        ((ScenarioGridCell)Mockito.doReturn((Object)this.gridCellValueMock).when((Object)this.gridCellMock)).getValue();
        Mockito.when((Object)this.informationHeaderMetaDataMock.getMetadataType()).thenReturn((Object)ScenarioHeaderMetaData.MetadataType.INSTANCE);
        Mockito.when((Object)this.informationHeaderMetaDataMock.getTitle()).thenReturn((Object)"GRID_COLUMN_TITLE");
        Mockito.when((Object)this.informationHeaderMetaDataMock.getColumnGroup()).thenReturn((Object)"GIVEN");
        Mockito.when((Object)this.informationHeaderMetaDataMock.getColumnId()).thenReturn((Object)"GRID_COLUMN_ID");
        Mockito.when((Object)this.indexHeaderMetaDataMock.getTitle()).thenReturn((Object)ExpressionIdentifier.INDEX.getName());
        Mockito.when((Object)this.scenarioIndexGridColumnMock.getInformationHeaderMetaData()).thenReturn((Object)this.indexHeaderMetaDataMock);
        Mockito.when((Object)this.gridColumnMock.getHeaderMetaData()).thenReturn(TestProperties.HEADER_META_DATA);
        Mockito.when((Object)this.gridCellMock.getValue()).thenReturn((Object)this.gridCellValueMock);
        Mockito.when((Object)this.gridCellValueMock.getValue()).thenReturn((Object)"GRID_CELL_TEXT");
        Mockito.when((Object)this.scenarioMock.getUnmodifiableFactMappingValues()).thenReturn((Object)this.factMappingValuesLocal);
        TestProperties.GRID_ROWS.clear();
        IntStream.range(0, 3).forEach(rowIndex -> {
            Mockito.when((Object)this.simulationMock.addScenario(rowIndex)).thenReturn((Object)this.scenarioMock);
            Mockito.when((Object)this.simulationMock.getScenarioByIndex(rowIndex)).thenReturn((Object)this.scenarioMock);
            Mockito.when((Object)this.simulationMock.cloneScenario(rowIndex, rowIndex + 1)).thenReturn((Object)this.scenarioMock);
            TestProperties.GRID_ROWS.add((GridRow)this.gridRowMock);
        });
        Mockito.when((Object)this.simulationMock.addScenario(3)).thenReturn((Object)this.scenarioMock);
        Mockito.when((Object)this.simulationMock.getScenarioByIndex(3)).thenReturn((Object)this.scenarioMock);
        Mockito.when((Object)this.simulationMock.cloneScenario(3, 4)).thenReturn((Object)this.scenarioMock);
        Mockito.when((Object)this.scenarioMock.getFactMappingValue((FactIdentifier)Matchers.any(), (ExpressionIdentifier)Matchers.any())).thenReturn(Optional.of(this.factMappingValueMock));
        Mockito.when((Object)this.scenarioMock.getFactMappingValue((FactMapping)Matchers.isA(FactMapping.class))).thenReturn(Optional.of(this.factMappingValueMock));
        Mockito.when((Object)this.factMappingValueMock.getStatus()).thenReturn((Object)FactMappingValueStatus.FAILED_WITH_ERROR);
        this.gridCellSupplier = () -> this.gridCellMock;
        this.scenarioGridModel = (ScenarioGridModel)Mockito.spy((Object)new ScenarioGridModel(false){
            {
                this.simulation = ScenarioGridModelTest.this.simulationMock;
                this.eventBus = ScenarioGridModelTest.this.eventBusMock;
                this.rows = TestProperties.GRID_ROWS;
                this.columns = ScenarioGridModelTest.this.gridColumns;
            }

            public void deleteColumn(GridColumn<?> column) {
            }

            public GridCell<?> getCell(int rowIndex, int columnIndex) {
                if (rowIndex < 0 || rowIndex > this.rows.size() - 1) {
                    return null;
                }
                return ScenarioGridModelTest.this.gridCellMock;
            }
        });
    }

    @Test
    public void bindContent() {
        Assert.assertTrue((boolean)this.scenarioGridModel.getSimulation().isPresent());
    }

    @Test
    public void setEventBus() {
        this.scenarioGridModel.setEventBus(this.eventBusMock);
        Assert.assertEquals((Object)this.eventBusMock, (Object)this.scenarioGridModel.eventBus);
    }

    @Test
    public void appendRow() {
        this.scenarioGridModel.appendRow((GridRow)this.gridRowMock);
        ((ScenarioGridModel)Mockito.verify((Object)this.scenarioGridModel, (VerificationMode)Mockito.atLeast((int)1))).checkSimulation();
        ((ScenarioGridModel)Mockito.verify((Object)this.scenarioGridModel, (VerificationMode)Mockito.times((int)1))).commonAddRow(Matchers.eq((int)3));
    }

    @Test
    public void insertRowGridOnly() {
        int setCellInvocations = this.scenarioMock.getUnmodifiableFactMappingValues().size();
        this.scenarioGridModel.insertRowGridOnly(2, (GridRow)this.gridRowMock, this.scenarioMock);
        ((ScenarioGridModel)Mockito.verify((Object)this.scenarioGridModel, (VerificationMode)Mockito.atLeast((int)1))).checkSimulation();
        ((ScenarioGridModel)Mockito.verify((Object)this.scenarioGridModel, (VerificationMode)Mockito.never())).insertRow(Matchers.eq((int)2), (GridRow)Matchers.eq((Object)this.gridRowMock));
        ((ScenarioGridModel)Mockito.verify((Object)this.scenarioGridModel, (VerificationMode)Mockito.times((int)1))).updateIndexColumn();
        ((ScenarioGridModel)Mockito.verify((Object)this.scenarioGridModel, (VerificationMode)Mockito.times((int)setCellInvocations))).setCell(Matchers.anyInt(), Matchers.anyInt(), (Supplier)Matchers.isA(Supplier.class));
        Mockito.reset((Object[])new ScenarioGridModel[]{this.scenarioGridModel});
        FactMapping factMappingByIndexMock = (FactMapping)Mockito.mock(FactMapping.class);
        Mockito.when((Object)factMappingByIndexMock.getClassName()).thenReturn((Object)List.class.getName());
        Mockito.when((Object)this.simulationDescriptorMock.getFactMappingByIndex(2)).thenReturn((Object)factMappingByIndexMock);
        this.scenarioGridModel.insertRowGridOnly(2, (GridRow)this.gridRowMock, this.scenarioMock);
        ((ScenarioGridModel)Mockito.verify((Object)this.scenarioGridModel, (VerificationMode)Mockito.atLeast((int)1))).checkSimulation();
        ((ScenarioGridModel)Mockito.verify((Object)this.scenarioGridModel, (VerificationMode)Mockito.never())).insertRow(Matchers.eq((int)2), (GridRow)Matchers.eq((Object)this.gridRowMock));
        ((ScenarioGridModel)Mockito.verify((Object)this.scenarioGridModel, (VerificationMode)Mockito.times((int)1))).updateIndexColumn();
        ((ScenarioGridModel)Mockito.verify((Object)this.scenarioGridModel, (VerificationMode)Mockito.times((int)setCellInvocations))).setCell(Matchers.anyInt(), Matchers.anyInt(), (Supplier)Matchers.isA(Supplier.class));
    }

    @Test
    public void insertRow() {
        this.scenarioGridModel.insertRow(2, (GridRow)this.gridRowMock);
        ((ScenarioGridModel)Mockito.verify((Object)this.scenarioGridModel, (VerificationMode)Mockito.atLeast((int)1))).checkSimulation();
        ((ScenarioGridModel)Mockito.verify((Object)this.scenarioGridModel, (VerificationMode)Mockito.times((int)1))).commonAddRow(Matchers.eq((int)2));
        ((ScenarioGridModel)Mockito.verify((Object)this.scenarioGridModel, (VerificationMode)Mockito.times((int)1))).updateIndexColumn();
    }

    @Test
    public void deleteRow() {
        this.scenarioGridModel.deleteRow(2);
        ((ScenarioGridModel)Mockito.verify((Object)this.scenarioGridModel, (VerificationMode)Mockito.atLeast((int)1))).checkSimulation();
        ((Simulation)Mockito.verify((Object)this.simulationMock, (VerificationMode)Mockito.times((int)1))).removeScenarioByIndex(Matchers.eq((int)2));
        ((ScenarioGridModel)Mockito.verify((Object)this.scenarioGridModel, (VerificationMode)Mockito.times((int)1))).updateIndexColumn();
    }

    @Test
    public void duplicateRow() {
        this.scenarioGridModel.duplicateRow(2, (GridRow)this.gridRowMock);
        ((ScenarioGridModel)Mockito.verify((Object)this.scenarioGridModel, (VerificationMode)Mockito.atLeast((int)1))).checkSimulation();
        ((Simulation)Mockito.verify((Object)this.simulationMock, (VerificationMode)Mockito.times((int)1))).cloneScenario(Matchers.eq((int)2), Matchers.eq((int)3));
        ((ScenarioGridModel)Mockito.verify((Object)this.scenarioGridModel, (VerificationMode)Mockito.times((int)1))).insertRowGridOnly(Matchers.eq((int)3), (GridRow)Matchers.eq((Object)this.gridRowMock), (Scenario)Matchers.isA(Scenario.class));
        ((ScenarioGridModel)Mockito.verify((Object)this.scenarioGridModel, (VerificationMode)Mockito.never())).insertRow(Matchers.eq((int)2), (GridRow)Matchers.eq((Object)this.gridRowMock));
        ((ScenarioGridModel)Mockito.verify((Object)this.scenarioGridModel, (VerificationMode)Mockito.times((int)1))).updateIndexColumn();
    }

    @Test
    public void duplicateColumnValues() {
        this.scenarioGridModel.duplicateColumnValues(3, 2);
        ((ScenarioGridModel)Mockito.verify((Object)this.scenarioGridModel, (VerificationMode)Mockito.times((int)this.scenarioGridModel.getRowCount()))).getCell(Matchers.anyInt(), Matchers.eq((int)3));
        ((ScenarioGridModel)Mockito.verify((Object)this.scenarioGridModel, (VerificationMode)Mockito.times((int)this.scenarioGridModel.getRowCount()))).setCellValue(Matchers.anyInt(), Matchers.eq((int)2), (GridCellValue)Matchers.any());
        Assert.assertTrue((boolean)IntStream.range(0, this.scenarioGridModel.getRowCount()).allMatch(i -> this.scenarioGridModel.getCell(i, 3).getValue().equals(this.scenarioGridModel.getCell(i, 3).getValue())));
    }

    @Test
    public void insertColumnGridOnly() {
        this.scenarioGridModel.insertColumnGridOnly(3, (GridColumn)this.gridColumnMock);
        ((ScenarioGridModel)Mockito.verify((Object)this.scenarioGridModel, (VerificationMode)Mockito.times((int)1))).checkSimulation();
    }

    @Test
    public void insertColumn() {
        this.scenarioGridModel.insertColumn(3, (GridColumn)this.gridColumnMock);
        ((ScenarioGridModel)Mockito.verify((Object)this.scenarioGridModel, (VerificationMode)Mockito.times((int)1))).checkSimulation();
        ((ScenarioGridModel)Mockito.verify((Object)this.scenarioGridModel, (VerificationMode)Mockito.times((int)1))).commonAddColumn(Matchers.eq((int)3), (GridColumn)Matchers.eq((Object)this.gridColumnMock));
    }

    @Test
    public void deleteColumn() {
        this.scenarioGridModel.deleteColumn(3);
        ((ScenarioGridModel)Mockito.verify((Object)this.scenarioGridModel, (VerificationMode)Mockito.times((int)1))).checkSimulation();
        ((ScenarioGridModel)Mockito.verify((Object)this.scenarioGridModel, (VerificationMode)Mockito.times((int)1))).deleteColumn((GridColumn)Matchers.eq((Object)this.gridColumnMock));
        ((Simulation)Mockito.verify((Object)this.simulationMock, (VerificationMode)Mockito.times((int)1))).removeFactMappingByIndex(Matchers.eq((int)3));
    }

    @Test
    public void updateColumnTypeFalse() {
        this.scenarioGridModel.updateColumnProperty(3, (GridColumn)this.gridColumnMock, TestProperties.MULTIPART_VALUE_ELEMENTS, TestProperties.VALUE_CLASS_NAME, false);
        ((ScenarioGridModel)Mockito.verify((Object)this.scenarioGridModel, (VerificationMode)Mockito.times((int)2))).checkSimulation();
        ((ScenarioGridModel)Mockito.verify((Object)this.scenarioGridModel, (VerificationMode)Mockito.times((int)1))).deleteColumn(Matchers.eq((int)3));
        ((ScenarioGridModel)Mockito.verify((Object)this.scenarioGridModel, (VerificationMode)Mockito.times((int)1))).commonAddColumn(Matchers.eq((int)3), (GridColumn)Matchers.eq((Object)this.gridColumnMock), (ExpressionIdentifier)Matchers.isA(ExpressionIdentifier.class));
    }

    @Test
    public void updateColumnTypeTrue() {
        this.scenarioGridModel.updateColumnProperty(3, (GridColumn)this.gridColumnMock, TestProperties.MULTIPART_VALUE_ELEMENTS, TestProperties.VALUE_CLASS_NAME, true);
        ((ScenarioGridModel)Mockito.verify((Object)this.scenarioGridModel, (VerificationMode)Mockito.atLeast((int)2))).checkSimulation();
        ((ScenarioGridModel)Mockito.verify((Object)this.scenarioGridModel, (VerificationMode)Mockito.atLeast((int)2))).getCell(Matchers.anyInt(), Matchers.eq((int)3));
        ((ScenarioGridModel)Mockito.verify((Object)this.scenarioGridModel, (VerificationMode)Mockito.times((int)1))).deleteColumn(Matchers.eq((int)3));
        ((ScenarioGridModel)Mockito.verify((Object)this.scenarioGridModel, (VerificationMode)Mockito.times((int)1))).commonAddColumn(Matchers.eq((int)3), (GridColumn)Matchers.eq((Object)this.gridColumnMock), (ExpressionIdentifier)Matchers.isA(ExpressionIdentifier.class));
        ((ScenarioGridModel)Mockito.verify((Object)this.scenarioGridModel, (VerificationMode)Mockito.atLeast((int)2))).setCellValue(Matchers.anyInt(), Matchers.eq((int)3), (GridCellValue)Matchers.isA(ScenarioGridCellValue.class));
    }

    @Test
    public void replaceColumnTest() {
        this.scenarioGridModel.replaceColumn(2, (GridColumn)this.gridColumnMock);
        ((ScenarioGridColumn)Mockito.verify((Object)this.gridColumnMock, (VerificationMode)Mockito.times((int)4))).getWidth();
        ((ScenarioGridColumn)Mockito.verify((Object)this.gridColumnMock, (VerificationMode)Mockito.times((int)4))).setWidth(Matchers.anyDouble());
        ((ScenarioGridModel)Mockito.verify((Object)this.scenarioGridModel, (VerificationMode)Mockito.times((int)1))).deleteColumn(Matchers.eq((int)2));
        ((ScenarioGridModel)Mockito.verify((Object)this.scenarioGridModel, (VerificationMode)Mockito.times((int)1))).commonAddColumn(Matchers.eq((int)2), (GridColumn)Matchers.eq((Object)this.gridColumnMock), (ExpressionIdentifier)Matchers.isA(ExpressionIdentifier.class));
    }

    @Test
    public void setCellGridOnly() {
        this.scenarioGridModel.setCellGridOnly(2, 3, this.gridCellSupplier);
        ((ScenarioGridModel)Mockito.verify((Object)this.scenarioGridModel, (VerificationMode)Mockito.times((int)1))).checkSimulation();
    }

    @Test
    public void setCell() {
        this.scenarioGridModel.setCell(2, 3, this.gridCellSupplier);
        ((ScenarioGridModel)Mockito.verify((Object)this.scenarioGridModel, (VerificationMode)Mockito.times((int)1))).setCell(Matchers.eq((int)2), Matchers.eq((int)3), (Supplier)Matchers.eq(this.gridCellSupplier));
    }

    @Test
    public void getInstancesCount() {
        long count = this.scenarioGridModel.getInstancesCount("test.scesim.TestClass");
        Assert.assertEquals((long)1L, (long)count);
    }

    @Test
    public void getInstanceLimits() {
        GridData.Range retrieved = this.scenarioGridModel.getInstanceLimits(2);
        Assert.assertNotNull((Object)retrieved);
        Assert.assertEquals((long)1L, (long)retrieved.getMinRowIndex());
        Assert.assertEquals((long)3L, (long)retrieved.getMaxRowIndex());
    }

    @Test
    public void getInstanceScenarioGridColumns() {
        List retrieved = this.scenarioGridModel.getInstanceScenarioGridColumns((ScenarioGridColumn)this.gridColumns.get(3));
        Assert.assertNotNull((Object)retrieved);
        Assert.assertEquals((long)4L, (long)retrieved.size());
    }

    @Test
    public void updateHeader() {
        String newValue = "NEW_VALUE";
        this.scenarioGridModel.updateHeader(3, 1, newValue);
        ((EventBus)Mockito.verify((Object)this.eventBusMock, (VerificationMode)Mockito.times((int)1))).fireEvent((GwtEvent)Matchers.isA(ReloadTestToolsEvent.class));
        Mockito.reset((Object[])new EventBus[]{this.eventBusMock});
        this.scenarioGridModel.updateHeader(3, 2, newValue);
        ((EventBus)Mockito.verify((Object)this.eventBusMock, (VerificationMode)Mockito.never())).fireEvent((GwtEvent)Matchers.any());
        Mockito.reset((Object[])new EventBus[]{this.eventBusMock});
        String title = ((GridColumn.HeaderMetaData)((GridColumn)this.scenarioGridModel.getColumns().get(3)).getHeaderMetaData().get(1)).getTitle();
        this.scenarioGridModel.updateHeader(3, 1, title);
        ((EventBus)Mockito.verify((Object)this.eventBusMock, (VerificationMode)Mockito.never())).fireEvent((GwtEvent)Matchers.any());
    }

    @Test
    public void updateFactMappingInstance() {
        boolean INDEX = false;
        String ALIAS_1 = "ALIAS_1";
        String ALIAS_2 = "ALIAS_2";
        FactMapping factMappingReference = (FactMapping)Mockito.mock(FactMapping.class);
        FactMapping factMappingToCheck = (FactMapping)Mockito.mock(FactMapping.class);
        FactIdentifier factIdentifier1 = (FactIdentifier)Mockito.mock(FactIdentifier.class);
        FactIdentifier factIdentifier2 = (FactIdentifier)Mockito.mock(FactIdentifier.class);
        Mockito.when((Object)factMappingReference.getFactIdentifier()).thenReturn((Object)FactIdentifier.EMPTY);
        Mockito.when((Object)factMappingToCheck.getFactIdentifier()).thenReturn((Object)FactIdentifier.EMPTY);
        Mockito.when((Object)factMappingReference.getFactAlias()).thenReturn((Object)"ALIAS_1");
        Mockito.when((Object)factMappingToCheck.getFactAlias()).thenReturn((Object)"ALIAS_1");
        Mockito.when((Object)this.simulationDescriptorMock.getFactMappingByIndex(0)).thenReturn((Object)factMappingToCheck);
        this.scenarioGridModel.updateFactMapping(this.simulationDescriptorMock, factMappingReference, 0, "MULTIPART.VALUE", ScenarioHeaderMetaData.MetadataType.INSTANCE);
        ((ScenarioHeaderMetaData)Mockito.verify((Object)this.informationHeaderMetaDataMock, (VerificationMode)Mockito.times((int)1))).setTitle((String)Matchers.eq((Object)"MULTIPART.VALUE"));
        ((FactMapping)Mockito.verify((Object)factMappingToCheck, (VerificationMode)Mockito.times((int)1))).setFactAlias((String)Matchers.eq((Object)"MULTIPART.VALUE"));
        Mockito.reset((Object[])new ScenarioHeaderMetaData[]{this.informationHeaderMetaDataMock});
        Mockito.reset((Object[])new FactMapping[]{factMappingToCheck});
        Mockito.when((Object)factMappingToCheck.getFactAlias()).thenReturn((Object)"ALIAS_2");
        this.scenarioGridModel.updateFactMapping(this.simulationDescriptorMock, factMappingReference, 0, "MULTIPART.VALUE", ScenarioHeaderMetaData.MetadataType.INSTANCE);
        ((ScenarioHeaderMetaData)Mockito.verify((Object)this.informationHeaderMetaDataMock, (VerificationMode)Mockito.never())).setTitle((String)Matchers.eq((Object)"MULTIPART.VALUE"));
        ((FactMapping)Mockito.verify((Object)factMappingToCheck, (VerificationMode)Mockito.never())).setFactAlias((String)Matchers.eq((Object)"MULTIPART.VALUE"));
        Mockito.reset((Object[])new ScenarioHeaderMetaData[]{this.informationHeaderMetaDataMock});
        Mockito.reset((Object[])new FactMapping[]{factMappingToCheck});
        Mockito.when((Object)factMappingReference.getFactIdentifier()).thenReturn((Object)factIdentifier1);
        Mockito.when((Object)factMappingToCheck.getFactAlias()).thenReturn((Object)"ALIAS_1");
        this.scenarioGridModel.updateFactMapping(this.simulationDescriptorMock, factMappingReference, 0, "MULTIPART.VALUE", ScenarioHeaderMetaData.MetadataType.INSTANCE);
        ((ScenarioHeaderMetaData)Mockito.verify((Object)this.informationHeaderMetaDataMock, (VerificationMode)Mockito.never())).setTitle((String)Matchers.eq((Object)"MULTIPART.VALUE"));
        ((FactMapping)Mockito.verify((Object)factMappingToCheck, (VerificationMode)Mockito.never())).setFactAlias((String)Matchers.eq((Object)"MULTIPART.VALUE"));
        Mockito.reset((Object[])new ScenarioHeaderMetaData[]{this.informationHeaderMetaDataMock});
        Mockito.reset((Object[])new FactMapping[]{factMappingToCheck});
        Mockito.when((Object)factMappingToCheck.getFactIdentifier()).thenReturn((Object)factIdentifier1);
        this.scenarioGridModel.updateFactMapping(this.simulationDescriptorMock, factMappingReference, 0, "MULTIPART.VALUE", ScenarioHeaderMetaData.MetadataType.INSTANCE);
        ((ScenarioHeaderMetaData)Mockito.verify((Object)this.informationHeaderMetaDataMock, (VerificationMode)Mockito.times((int)1))).setTitle((String)Matchers.eq((Object)"MULTIPART.VALUE"));
        ((FactMapping)Mockito.verify((Object)factMappingToCheck, (VerificationMode)Mockito.times((int)1))).setFactAlias((String)Matchers.eq((Object)"MULTIPART.VALUE"));
        Mockito.reset((Object[])new ScenarioHeaderMetaData[]{this.informationHeaderMetaDataMock});
        Mockito.reset((Object[])new FactMapping[]{factMappingToCheck});
        Mockito.when((Object)factMappingToCheck.getFactIdentifier()).thenReturn((Object)factIdentifier2);
        this.scenarioGridModel.updateFactMapping(this.simulationDescriptorMock, factMappingReference, 0, "MULTIPART.VALUE", ScenarioHeaderMetaData.MetadataType.INSTANCE);
        ((ScenarioHeaderMetaData)Mockito.verify((Object)this.informationHeaderMetaDataMock, (VerificationMode)Mockito.never())).setTitle((String)Matchers.eq((Object)"MULTIPART.VALUE"));
        ((FactMapping)Mockito.verify((Object)factMappingToCheck, (VerificationMode)Mockito.never())).setFactAlias((String)Matchers.eq((Object)"MULTIPART.VALUE"));
    }

    @Test
    public void updateFactMappingProperty() {
        boolean INDEX = false;
        String ALIAS_1 = "ALIAS_1";
        String ALIAS_2 = "ALIAS_2";
        FactMapping factMappingReference = (FactMapping)Mockito.mock(FactMapping.class);
        FactMapping factMappingToCheck = (FactMapping)Mockito.mock(FactMapping.class);
        FactIdentifier factIdentifier1 = (FactIdentifier)Mockito.mock(FactIdentifier.class);
        Mockito.when((Object)factMappingReference.getFactIdentifier()).thenReturn((Object)FactIdentifier.EMPTY);
        Mockito.when((Object)factMappingToCheck.getFactIdentifier()).thenReturn((Object)FactIdentifier.EMPTY);
        Mockito.when((Object)factMappingReference.getFactAlias()).thenReturn((Object)"ALIAS_1");
        Mockito.when((Object)factMappingToCheck.getFactAlias()).thenReturn((Object)"ALIAS_1");
        Mockito.when((Object)factMappingReference.getFullExpression()).thenReturn((Object)"ALIAS_1");
        Mockito.when((Object)factMappingToCheck.getFullExpression()).thenReturn((Object)"ALIAS_1");
        Mockito.when((Object)this.simulationDescriptorMock.getFactMappingByIndex(0)).thenReturn((Object)factMappingToCheck);
        this.scenarioGridModel.updateFactMapping(this.simulationDescriptorMock, factMappingReference, 0, "MULTIPART.VALUE", ScenarioHeaderMetaData.MetadataType.PROPERTY);
        ((ScenarioHeaderMetaData)Mockito.verify((Object)this.propertyHeaderMetaDataMock, (VerificationMode)Mockito.times((int)1))).setTitle((String)Matchers.eq((Object)"MULTIPART.VALUE"));
        ((FactMapping)Mockito.verify((Object)factMappingToCheck, (VerificationMode)Mockito.times((int)1))).setExpressionAlias((String)Matchers.eq((Object)"MULTIPART.VALUE"));
        Mockito.reset((Object[])new ScenarioHeaderMetaData[]{this.propertyHeaderMetaDataMock});
        Mockito.reset((Object[])new FactMapping[]{factMappingToCheck});
        Mockito.when((Object)factMappingToCheck.getFactAlias()).thenReturn((Object)"ALIAS_2");
        this.scenarioGridModel.updateFactMapping(this.simulationDescriptorMock, factMappingReference, 0, "MULTIPART.VALUE", ScenarioHeaderMetaData.MetadataType.PROPERTY);
        ((ScenarioHeaderMetaData)Mockito.verify((Object)this.propertyHeaderMetaDataMock, (VerificationMode)Mockito.never())).setTitle((String)Matchers.eq((Object)"MULTIPART.VALUE"));
        ((FactMapping)Mockito.verify((Object)factMappingToCheck, (VerificationMode)Mockito.never())).setExpressionAlias((String)Matchers.eq((Object)"MULTIPART.VALUE"));
        Mockito.reset((Object[])new ScenarioHeaderMetaData[]{this.propertyHeaderMetaDataMock});
        Mockito.reset((Object[])new FactMapping[]{factMappingToCheck});
        Mockito.when((Object)factMappingReference.getFactIdentifier()).thenReturn((Object)factIdentifier1);
        Mockito.when((Object)factMappingToCheck.getFactAlias()).thenReturn((Object)"ALIAS_1");
        Mockito.when((Object)factMappingToCheck.getFullExpression()).thenReturn((Object)"ALIAS_2");
        this.scenarioGridModel.updateFactMapping(this.simulationDescriptorMock, factMappingReference, 0, "MULTIPART.VALUE", ScenarioHeaderMetaData.MetadataType.PROPERTY);
        ((ScenarioHeaderMetaData)Mockito.verify((Object)this.propertyHeaderMetaDataMock, (VerificationMode)Mockito.never())).setTitle((String)Matchers.eq((Object)"MULTIPART.VALUE"));
        ((FactMapping)Mockito.verify((Object)factMappingToCheck, (VerificationMode)Mockito.never())).setExpressionAlias((String)Matchers.eq((Object)"MULTIPART.VALUE"));
    }

    @Test
    public void commonAddColumn() {
        this.scenarioGridModel.commonAddColumn(3, (GridColumn)this.gridColumnMock);
        ((ScenarioGridModel)Mockito.verify((Object)this.scenarioGridModel, (VerificationMode)Mockito.times((int)0))).checkSimulation();
    }

    @Test
    public void commonAddRow() {
        this.scenarioGridModel.commonAddRow(2);
    }

    @Test
    public void updateIndexColumn() {
        this.scenarioGridModel.updateIndexColumn();
        ((ScenarioGridModel)Mockito.verify((Object)this.scenarioGridModel, (VerificationMode)Mockito.never())).setCellValue(Matchers.anyInt(), Matchers.anyInt(), (GridCellValue)Matchers.isA(ScenarioGridCellValue.class));
        Mockito.reset((Object[])new ScenarioGridModel[]{this.scenarioGridModel});
        Mockito.when((Object)this.scenarioGridModel.getRowCount()).thenReturn((Object)3);
        int indexColumnPosition = 0;
        this.gridColumns.add(indexColumnPosition, this.scenarioIndexGridColumnMock);
        Mockito.when((Object)this.scenarioGridModel.getColumns()).thenReturn((Object)this.gridColumns);
        this.scenarioGridModel.updateIndexColumn();
    }

    @Test
    public void isSameInstanceHeaderDifferent() {
        this.commonCheckSameInstanceHeader("TestClass", "TOAST", false);
    }

    @Test
    public void isSameInstanceHeaderEqualWithoutPackage() {
        this.commonCheckSameInstanceHeader("TestClass", "TestClass", true);
    }

    @Test
    public void isSameInstanceHeaderEqualWithPackage() {
        this.commonCheckSameInstanceHeader("test.scesim.TestClass", "TestClass", false);
    }

    @Test
    public void isSameInstanceHeader_Different() {
        this.isSameInstanceType("TestClass", "TOAST", false);
    }

    @Test
    public void isSameInstanceHeader_Equal() {
        this.isSameInstanceType("TestClass", "TestClass", true);
    }

    @Test
    public void refreshErrorsTest() {
        int expectedCalls = this.scenarioGridModel.getRowCount() * this.scenarioGridModel.getColumnCount();
        this.scenarioGridModel.refreshErrors();
        ((ScenarioGridCell)Mockito.verify((Object)this.gridCellMock, (VerificationMode)Mockito.times((int)expectedCalls))).setErrorMode(Matchers.eq((boolean)true));
        Mockito.when((Object)this.factMappingValueMock.getStatus()).thenReturn((Object)FactMappingValueStatus.SUCCESS);
        this.scenarioGridModel.refreshErrors();
        ((ScenarioGridCell)Mockito.verify((Object)this.gridCellMock, (VerificationMode)Mockito.times((int)expectedCalls))).setErrorMode(Matchers.eq((boolean)false));
    }

    @Test
    public void refreshErrorsRow() {
        int expectedCalls = this.scenarioGridModel.getColumnCount();
        FactMappingValue factMappingValue = (FactMappingValue)Mockito.mock(FactMappingValue.class);
        Mockito.when((Object)factMappingValue.getStatus()).thenReturn((Object)FactMappingValueStatus.FAILED_WITH_ERROR);
        Mockito.when((Object)this.scenarioMock.getFactMappingValue((FactIdentifier)Matchers.any(), (ExpressionIdentifier)Matchers.any())).thenReturn(Optional.empty());
        this.scenarioGridModel.refreshErrorsRow(0);
        ((ScenarioGridCell)Mockito.verify((Object)this.gridCellMock, (VerificationMode)Mockito.times((int)expectedCalls))).setErrorMode(false);
        Mockito.when((Object)this.scenarioMock.getFactMappingValue((FactIdentifier)Matchers.any(), (ExpressionIdentifier)Matchers.any())).thenReturn(Optional.of(factMappingValue));
        this.scenarioGridModel.refreshErrorsRow(0);
        ((ScenarioGridCell)Mockito.verify((Object)this.gridCellMock, (VerificationMode)Mockito.times((int)expectedCalls))).setErrorMode(true);
    }

    @Test
    public void validateInstanceHeaderUpdate() throws Exception {
        this.commonValidateInstanceHeaderUpdate(1, false, false, false, false);
        this.commonValidateInstanceHeaderUpdate(1, false, false, true, true);
        this.commonValidateInstanceHeaderUpdate(1, false, true, false, false);
        this.commonValidateInstanceHeaderUpdate(1, false, true, true, true);
        this.commonValidateInstanceHeaderUpdate(1, true, false, false, false);
        this.commonValidateInstanceHeaderUpdate(1, true, false, true, false);
        this.commonValidateInstanceHeaderUpdate(1, true, true, false, false);
        this.commonValidateInstanceHeaderUpdate(1, true, true, true, false);
    }

    @Test
    public void validatePropertyHeaderUpdate() throws Exception {
        this.commonValidatePropertyUpdate(1, false, false, false, false);
        this.commonValidatePropertyUpdate(1, false, false, true, true);
        this.commonValidatePropertyUpdate(1, false, true, false, false);
        this.commonValidatePropertyUpdate(1, false, true, true, true);
        this.commonValidatePropertyUpdate(1, true, false, false, false);
        this.commonValidatePropertyUpdate(1, true, false, true, false);
        this.commonValidatePropertyUpdate(1, true, true, false, false);
        this.commonValidatePropertyUpdate(1, true, true, true, false);
    }

    private void isSameInstanceType(String columnClassName, String value, boolean expectedResult) {
        FactIdentifier factIdentifierMock = (FactIdentifier)Mockito.mock(FactIdentifier.class);
        Mockito.when((Object)factIdentifierMock.getClassNameWithoutPackage()).thenReturn((Object)columnClassName);
        Mockito.when((Object)this.factMappingMock.getFactIdentifier()).thenReturn((Object)factIdentifierMock);
        Mockito.when((Object)this.simulationDescriptorMock.getFactMappingByIndex(3)).thenReturn((Object)this.factMappingMock);
        boolean result = this.scenarioGridModel.isSameInstanceType(3, value);
        ((Simulation)Mockito.verify((Object)this.simulationMock, (VerificationMode)Mockito.times((int)1))).getSimulationDescriptor();
        ((SimulationDescriptor)Mockito.verify((Object)this.simulationDescriptorMock, (VerificationMode)Mockito.times((int)1))).getFactMappingByIndex(Matchers.eq((int)3));
        Assert.assertEquals((Object)result, (Object)expectedResult);
    }

    private void commonCheckSameInstanceHeader(String columnClassName, String value, boolean expected) {
        block2: {
            FactIdentifier factIdentifierMock = (FactIdentifier)Mockito.mock(FactIdentifier.class);
            Mockito.when((Object)factIdentifierMock.getClassNameWithoutPackage()).thenReturn((Object)columnClassName);
            Mockito.when((Object)this.factMappingMock.getFactIdentifier()).thenReturn((Object)factIdentifierMock);
            Mockito.when((Object)this.simulationDescriptorMock.getFactMappingByIndex(3)).thenReturn((Object)this.factMappingMock);
            try {
                this.scenarioGridModel.checkSameInstanceHeader(3, value);
                ((ScenarioGridModel)Mockito.verify((Object)this.scenarioGridModel, (VerificationMode)Mockito.times((int)1))).isSameInstanceType(Matchers.eq((int)3), (String)Matchers.eq((Object)value));
            }
            catch (Exception e) {
                if (!expected) break block2;
                Assert.fail((String)("No exception expected, retrieved " + e.getMessage()));
            }
        }
    }

    private void commonValidateInstanceHeaderUpdate(int columnIndex, boolean isADataType, boolean isSameInstanceHeader, boolean isUnique, boolean expectedValid) throws Exception {
        block6: {
            if (isSameInstanceHeader) {
                ((ScenarioGridModel)Mockito.doThrow((Throwable)new Exception("isSameInstanceHeader")).when((Object)this.scenarioGridModel)).checkSameInstanceHeader(columnIndex, TestProperties.MULTIPART_VALUE_ELEMENTS.get(TestProperties.MULTIPART_VALUE_ELEMENTS.size() - 1));
            } else {
                ((ScenarioGridModel)Mockito.doNothing().when((Object)this.scenarioGridModel)).checkSameInstanceHeader(columnIndex, TestProperties.MULTIPART_VALUE_ELEMENTS.get(TestProperties.MULTIPART_VALUE_ELEMENTS.size() - 1));
            }
            if (isUnique) {
                ((ScenarioGridModel)Mockito.doNothing().when((Object)this.scenarioGridModel)).checkValidAndUniqueInstanceHeaderTitle("MULTIPART.VALUE", columnIndex);
            } else {
                ((ScenarioGridModel)Mockito.doThrow((Throwable)new Exception("isUnique")).when((Object)this.scenarioGridModel)).checkValidAndUniqueInstanceHeaderTitle("MULTIPART.VALUE", columnIndex);
            }
            try {
                this.scenarioGridModel.validateInstanceHeaderUpdate("MULTIPART.VALUE", columnIndex, isADataType);
            }
            catch (Exception e) {
                if (!expectedValid) break block6;
                Assert.fail((String)("No exception expected, retrieved:  " + e.getMessage()));
            }
        }
        Mockito.reset((Object[])new EventBus[]{this.eventBusMock});
    }

    private void commonValidatePropertyUpdate(int columnIndex, boolean isPropertyType, boolean isSamePropertyHeader, boolean isUnique, boolean expectedValid) throws Exception {
        block6: {
            if (isSamePropertyHeader) {
                ((ScenarioGridModel)Mockito.doThrow((Throwable)new Exception("isSamePropertyHeader")).when((Object)this.scenarioGridModel)).checkSamePropertyHeader(columnIndex, TestProperties.MULTIPART_VALUE_ELEMENTS);
            } else {
                ((ScenarioGridModel)Mockito.doNothing().when((Object)this.scenarioGridModel)).checkSamePropertyHeader(columnIndex, TestProperties.MULTIPART_VALUE_ELEMENTS);
            }
            if (isUnique) {
                ((ScenarioGridModel)Mockito.doNothing().when((Object)this.scenarioGridModel)).checkValidAndUniquePropertyHeaderTitle("MULTIPART.VALUE", columnIndex);
            } else {
                ((ScenarioGridModel)Mockito.doThrow((Throwable)new Exception("isUnique")).when((Object)this.scenarioGridModel)).checkValidAndUniquePropertyHeaderTitle("MULTIPART.VALUE", columnIndex);
            }
            try {
                this.scenarioGridModel.validatePropertyHeaderUpdate("MULTIPART.VALUE", columnIndex, isPropertyType);
            }
            catch (Exception e) {
                if (!expectedValid) break block6;
                Assert.fail((String)("No exception expected, retrieved:  " + e.getMessage()));
            }
        }
        Mockito.reset((Object[])new EventBus[]{this.eventBusMock});
    }

    @Test
    public void resetError() {
        this.scenarioGridModel = (ScenarioGridModel)Mockito.spy((Object)new ScenarioGridModel(false){
            {
                this.simulation = ScenarioGridModelTest.this.simulationMock;
                this.eventBus = ScenarioGridModelTest.this.eventBusMock;
                this.rows = TestProperties.GRID_ROWS;
                this.columns = ScenarioGridModelTest.this.gridColumns;
            }

            public void refreshErrors() {
            }

            public GridCell<?> getCell(int rowIndex, int columnIndex) {
                if (rowIndex < 0 || rowIndex > this.rows.size() - 1) {
                    return null;
                }
                return ScenarioGridModelTest.this.gridCellMock;
            }
        });
        this.scenarioGridModel.resetError(2, 3);
        ((Simulation)Mockito.verify((Object)this.simulationMock, (VerificationMode)Mockito.times((int)1))).getScenarioByIndex(Matchers.eq((int)2));
        ((SimulationDescriptor)Mockito.verify((Object)this.simulationDescriptorMock, (VerificationMode)Mockito.times((int)1))).getFactMappingByIndex(Matchers.eq((int)3));
        ((Scenario)Mockito.verify((Object)this.scenarioMock, (VerificationMode)Mockito.times((int)1))).getFactMappingValue((FactMapping)Matchers.eq((Object)this.factMappingMock));
        ((FactMappingValue)Mockito.verify((Object)this.factMappingValueMock, (VerificationMode)Mockito.times((int)1))).resetStatus();
        ((ScenarioGridModel)Mockito.verify((Object)this.scenarioGridModel, (VerificationMode)Mockito.times((int)1))).refreshErrors();
    }

    @Test
    public void synchronizeFactMappingsWidths() {
        this.scenarioGridModel.synchronizeFactMappingsWidths();
        ((ScenarioGridModel)Mockito.verify((Object)this.scenarioGridModel, (VerificationMode)Mockito.times((int)this.gridColumns.size()))).synchronizeFactMappingWidth((GridColumn)Matchers.isA(GridColumn.class));
    }

    @Test
    public void synchronizeFactMappingWidth() {
        Mockito.when((Object)this.gridColumnMock.isVisible()).thenReturn((Object)true);
        this.scenarioGridModel.synchronizeFactMappingWidth((GridColumn)this.gridColumnMock);
        ((FactMapping)Mockito.verify((Object)this.factMappingMock, (VerificationMode)Mockito.times((int)1))).setColumnWidth(Double.valueOf(Matchers.eq((double)this.gridColumnMock.getWidth())));
    }

    @Test
    public void synchronizeFactMappingWidth_NotVisibleColumn() {
        Mockito.when((Object)this.gridColumnMock.isVisible()).thenReturn((Object)false);
        this.scenarioGridModel.synchronizeFactMappingWidth((GridColumn)this.gridColumnMock);
        ((FactMapping)Mockito.verify((Object)this.factMappingMock, (VerificationMode)Mockito.never())).setColumnWidth((Double)Matchers.any());
    }

    @Test
    public void loadFactMappingsWidth_FactMappingWithoutWidth() {
        Mockito.when((Object)this.factMappingMock.getColumnWidth()).thenReturn(null);
        this.gridColumns.clear();
        this.gridColumns.add(this.gridColumnMock);
        this.scenarioGridModel.loadFactMappingsWidth();
        ((ScenarioGridColumn)Mockito.verify((Object)this.gridColumnMock, (VerificationMode)Mockito.never())).setWidth(Matchers.anyDouble());
    }

    @Test
    public void loadFactMappingsWidth_FactMappingWithWidth() {
        Mockito.when((Object)this.factMappingMock.getColumnWidth()).thenReturn((Object)54.32);
        this.gridColumns.clear();
        this.gridColumns.add(this.gridColumnMock);
        this.scenarioGridModel.loadFactMappingsWidth();
        ((FactMapping)Mockito.verify((Object)this.factMappingMock, (VerificationMode)Mockito.never())).setColumnWidth(Double.valueOf(Matchers.anyDouble()));
        ((ScenarioGridColumn)Mockito.verify((Object)this.gridColumnMock, (VerificationMode)Mockito.times((int)1))).setWidth(((Double)Matchers.eq((Object)this.factMappingMock.getColumnWidth())).doubleValue());
    }
}

