/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.collectioneditor;

import com.google.gwt.dom.client.LIElement;
import com.google.gwt.dom.client.Node;
import com.google.gwt.dom.client.Style;
import com.google.gwt.dom.client.UListElement;
import com.google.gwt.json.client.JSONArray;
import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONParser;
import com.google.gwt.json.client.JSONString;
import com.google.gwt.json.client.JSONValue;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.inject.Inject;
import org.drools.workbench.screens.scenariosimulation.client.collectioneditor.CollectionView;
import org.drools.workbench.screens.scenariosimulation.client.collectioneditor.ItemElementPresenter;
import org.drools.workbench.screens.scenariosimulation.client.collectioneditor.KeyValueElementPresenter;
import org.drools.workbench.screens.scenariosimulation.client.collectioneditor.editingbox.ItemEditingBoxPresenter;
import org.drools.workbench.screens.scenariosimulation.client.collectioneditor.editingbox.KeyValueEditingBoxPresenter;
import org.drools.workbench.screens.scenariosimulation.client.popup.ConfirmPopupPresenter;
import org.drools.workbench.screens.scenariosimulation.client.popup.ScenarioConfirmationPopupPresenter;
import org.drools.workbench.screens.scenariosimulation.client.resources.i18n.ScenarioSimulationEditorConstants;
import org.drools.workbench.screens.scenariosimulation.client.utils.ViewsProvider;
import org.uberfire.mvp.Command;

public class CollectionPresenter
implements CollectionView.Presenter {
    @Inject
    protected ItemElementPresenter listElementPresenter;
    @Inject
    protected KeyValueElementPresenter mapElementPresenter;
    @Inject
    protected ViewsProvider viewsProvider;
    @Inject
    protected ItemEditingBoxPresenter listEditingBoxPresenter;
    @Inject
    protected KeyValueEditingBoxPresenter mapEditingBoxPresenter;
    @Inject
    protected ScenarioConfirmationPopupPresenter scenarioConfirmationPopupPresenter;
    @Inject
    protected ConfirmPopupPresenter confirmPopupPresenter;
    protected Map<String, Map<String, String>> simplePropertiesMap = new HashMap<String, Map<String, String>>();
    protected Map<String, Map<String, Map<String, String>>> expandablePropertiesMap = new HashMap<String, Map<String, Map<String, String>>>();
    protected CollectionView collectionView;
    protected LIElement objectSeparatorLI;

    @Override
    public void initListStructure(String key, Map<String, String> simplePropertiesMap, Map<String, Map<String, String>> expandablePropertiesMap, CollectionView collectionView) {
        this.commonInit(key, collectionView);
        this.simplePropertiesMap.put(key, simplePropertiesMap);
        this.expandablePropertiesMap.put(key, expandablePropertiesMap);
        this.listEditingBoxPresenter.setCollectionEditorPresenter(this);
        this.listElementPresenter.setCollectionEditorPresenter(this);
        this.listElementPresenter.onToggleRowExpansion(false);
    }

    @Override
    public void initMapStructure(String key, Map<String, String> keyPropertyMap, Map<String, String> valuePropertyMap, CollectionView collectionView) {
        this.commonInit(key, collectionView);
        this.simplePropertiesMap.put(key + "#key", keyPropertyMap);
        this.simplePropertiesMap.put(key + "#value", valuePropertyMap);
        this.mapEditingBoxPresenter.setCollectionEditorPresenter(this);
        this.mapElementPresenter.setCollectionEditorPresenter(this);
        this.mapElementPresenter.onToggleRowExpansion(false);
    }

    @Override
    public void setValue(String jsonString) {
        if (jsonString == null || jsonString.isEmpty()) {
            return;
        }
        JSONValue jsonValue = this.getJSONValue(jsonString);
        if (this.collectionView.isListWidget()) {
            this.populateList(jsonValue);
        } else {
            this.populateMap(jsonValue);
        }
    }

    @Override
    public void showEditingBox() {
        String key = this.collectionView.getEditorTitle().getInnerText();
        if (this.collectionView.isListWidget()) {
            LIElement editingBox = this.listEditingBoxPresenter.getEditingBox(key, this.simplePropertiesMap.get(key), this.expandablePropertiesMap.get(key));
            this.collectionView.getElementsContainer().appendChild((Node)editingBox);
        } else {
            LIElement editingBox = this.mapEditingBoxPresenter.getEditingBox(key, this.simplePropertiesMap.get(key + "#key"), this.simplePropertiesMap.get(key + "#value"));
            this.collectionView.getElementsContainer().appendChild((Node)editingBox);
        }
        this.toggleEditingStatus(true);
    }

    @Override
    public void onToggleRowExpansion(boolean isShown) {
        this.collectionView.toggleRowExpansion();
        if (this.collectionView.isListWidget()) {
            this.listElementPresenter.onToggleRowExpansion(isShown);
        } else {
            this.mapElementPresenter.onToggleRowExpansion(isShown);
        }
    }

    @Override
    public void updateRowExpansionStatus(boolean isShown) {
        this.collectionView.updateRowExpansionStatus(isShown);
    }

    @Override
    public void addListItem(Map<String, String> simplePropertiesValues, Map<String, Map<String, String>> expandablePropertiesValues) {
        UListElement elementsContainer = this.collectionView.getElementsContainer();
        String itemId = String.valueOf(elementsContainer.getChildCount() - 1);
        LIElement itemElement = this.listElementPresenter.getItemContainer(itemId, simplePropertiesValues, expandablePropertiesValues);
        elementsContainer.appendChild((Node)itemElement);
        this.toggleEditingStatus(false);
    }

    @Override
    public void addMapItem(Map<String, String> keyPropertiesValues, Map<String, String> valuePropertiesValues) {
        UListElement elementsContainer = this.collectionView.getElementsContainer();
        String itemId = String.valueOf(elementsContainer.getChildCount() - 1);
        LIElement itemElement = this.mapElementPresenter.getKeyValueContainer(itemId, keyPropertiesValues, valuePropertiesValues);
        elementsContainer.appendChild((Node)itemElement);
        this.toggleEditingStatus(false);
    }

    @Override
    public void save() {
        try {
            String updatedValue = this.collectionView.isListWidget() ? this.getListValue() : this.getMapValue();
            this.collectionView.updateValue(updatedValue);
        }
        catch (IllegalStateException e) {
            this.confirmPopupPresenter.show(ScenarioSimulationEditorConstants.INSTANCE.collectionError(), e.getMessage());
        }
    }

    @Override
    public void remove() {
        Command okRemoveCommand = this::okRemoveCommandMethod;
        this.scenarioConfirmationPopupPresenter.show(ScenarioSimulationEditorConstants.INSTANCE.removeCollectionMainTitle(), ScenarioSimulationEditorConstants.INSTANCE.removeCollectionMainQuestion(), ScenarioSimulationEditorConstants.INSTANCE.removeCollectionText1(), ScenarioSimulationEditorConstants.INSTANCE.removeCollectionQuestion(), ScenarioSimulationEditorConstants.INSTANCE.removeCollectionWarningText(), ScenarioSimulationEditorConstants.INSTANCE.remove(), okRemoveCommand);
    }

    @Override
    public void toggleEditingStatus(boolean toDisable) {
        this.collectionView.getAddItemButton().setDisabled(toDisable);
        this.collectionView.getCancelButton().setDisabled(toDisable);
        this.collectionView.getRemoveButton().setDisabled(toDisable);
        this.collectionView.getSaveButton().setDisabled(toDisable);
        this.mapElementPresenter.toggleEditingStatus(toDisable);
        this.listElementPresenter.toggleEditingStatus(toDisable);
    }

    protected void okRemoveCommandMethod() {
        if (this.collectionView.isListWidget()) {
            this.listElementPresenter.remove();
        } else {
            this.mapElementPresenter.remove();
        }
        this.collectionView.updateValue(null);
        this.collectionView.close();
    }

    protected void commonInit(String key, CollectionView collectionView) {
        this.collectionView = collectionView;
        String propertyName = key.substring(key.lastIndexOf("#") + 1);
        this.collectionView.getEditorTitle().setInnerText(key);
        this.collectionView.getPropertyTitle().setInnerText(propertyName);
        this.objectSeparatorLI = collectionView.getObjectSeparator();
        this.objectSeparatorLI.addClassName("kie-object-list");
        this.objectSeparatorLI.getStyle().setPadding(5.0, Style.Unit.PX);
    }

    protected void populateList(JSONValue jsonValue) {
        JSONArray array = jsonValue.isArray();
        for (int i = 0; i < array.size(); ++i) {
            JSONObject jsonObject = array.get(i).isObject();
            Map<String, String> propertiesValues = this.getSimplePropertiesMap(jsonObject);
            Map<String, Map<String, String>> expandablePropertiesValues = this.getExpandablePropertiesValues(jsonObject);
            this.addListItem(propertiesValues, expandablePropertiesValues);
        }
    }

    protected void populateMap(JSONValue jsonValue) {
        JSONObject jsValueObject = jsonValue.isObject();
        jsValueObject.keySet().forEach(key -> {
            HashMap<String, String> keyPropertiesValues = new HashMap<String, String>();
            HashMap<String, String> valuePropertiesValues = new HashMap<String, String>();
            JSONObject jsonObjectKey = this.getJSONObject((String)key);
            if (jsonObjectKey == null) {
                keyPropertiesValues.put("value", (String)key);
            } else {
                jsonObjectKey.keySet().forEach(propertyName -> keyPropertiesValues.put((String)propertyName, jsonObjectKey.get(propertyName).isString().stringValue()));
            }
            JSONObject jsonObjectValue = jsValueObject.get(key).isObject();
            if (jsonObjectValue != null) {
                jsonObjectValue.keySet().forEach(propertyName -> valuePropertiesValues.put((String)propertyName, jsonObjectValue.get(propertyName).isString().stringValue()));
            } else {
                valuePropertiesValues.put("value", jsValueObject.get(key).toString());
            }
            this.addMapItem(keyPropertiesValues, valuePropertiesValues);
        });
    }

    protected JSONObject getJSONObject(String jsonString) {
        try {
            return this.getJSONValue(jsonString).isObject();
        }
        catch (Exception e) {
            return null;
        }
    }

    protected JSONValue getJSONValue(String jsonString) {
        try {
            return JSONParser.parseStrict((String)jsonString);
        }
        catch (Exception e) {
            return null;
        }
    }

    protected String getListValue() {
        Map<String, Map<String, String>> simpleItemsProperties = this.listElementPresenter.getSimpleItemsProperties();
        Map<String, Map<String, Map<String, String>>> nestedItemsProperties = this.listElementPresenter.getExpandableItemsProperties();
        JSONArray jsonArray = new JSONArray();
        AtomicInteger counter = new AtomicInteger();
        simpleItemsProperties.forEach((itemId, simpleProperties) -> {
            JSONObject jsonObject = this.getJSONObject((Map<String, String>)simpleProperties);
            Map nestedProperties = (Map)nestedItemsProperties.get(itemId);
            if (nestedProperties != null) {
                nestedProperties.forEach((nestedPropertyName, nestedPropertyValues) -> {
                    JSONObject nestedJSONObject = this.getJSONObject((Map<String, String>)nestedPropertyValues);
                    jsonObject.put(nestedPropertyName, (JSONValue)nestedJSONObject);
                });
            }
            jsonArray.set(counter.getAndIncrement(), (JSONValue)jsonObject);
        });
        return jsonArray.toString();
    }

    protected JSONObject getJSONObject(Map<String, String> properties) {
        JSONObject toReturn = new JSONObject();
        properties.forEach((propertyName, propertyValue) -> toReturn.put(propertyName, (JSONValue)new JSONString(propertyValue)));
        return toReturn;
    }

    protected Map<String, String> getSimplePropertiesMap(JSONObject jsonObject) {
        HashMap<String, String> toReturn = new HashMap<String, String>();
        jsonObject.keySet().forEach(propertyName -> {
            JSONValue jsonValue = jsonObject.get(propertyName);
            if (jsonValue.isString() != null) {
                toReturn.put((String)propertyName, jsonValue.isString().stringValue());
            }
        });
        return toReturn;
    }

    protected Map<String, Map<String, String>> getExpandablePropertiesValues(JSONObject jsonObject) {
        HashMap<String, Map<String, String>> toReturn = new HashMap<String, Map<String, String>>();
        jsonObject.keySet().forEach(propertyName -> {
            JSONValue jsonValue = jsonObject.get(propertyName);
            if (jsonValue.isObject() != null) {
                Map<String, String> simplePropertiesMap = this.getSimplePropertiesMap(jsonValue.isObject());
                toReturn.put((String)propertyName, simplePropertiesMap);
            }
        });
        return toReturn;
    }

    protected String getMapValue() throws IllegalStateException {
        Map<Map<String, String>, Map<String, String>> itemsProperties = this.mapElementPresenter.getItemsProperties();
        JSONObject toReturnModel = new JSONObject();
        itemsProperties.forEach((keyPropertiesValues, valuePropertiesMap) -> {
            String jsonKey;
            if (keyPropertiesValues.size() == 1) {
                jsonKey = (String)keyPropertiesValues.values().iterator().next();
            } else {
                JSONObject nestedKey = new JSONObject();
                keyPropertiesValues.forEach((propertyName, propertyValue) -> nestedKey.put(propertyName, (JSONValue)new JSONString(propertyValue)));
                jsonKey = nestedKey.toString();
            }
            JSONObject nestedValue = new JSONObject();
            valuePropertiesMap.forEach((propertyName, propertyValue) -> nestedValue.put(propertyName, (JSONValue)new JSONString(propertyValue)));
            toReturnModel.put(jsonKey, (JSONValue)nestedValue);
        });
        return toReturnModel.toString();
    }
}

