/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.commands.actualcommands;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.SortedMap;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.drools.scenariosimulation.api.model.ExpressionElement;
import org.drools.scenariosimulation.api.model.FactIdentifier;
import org.drools.scenariosimulation.api.model.FactMapping;
import org.drools.scenariosimulation.api.model.FactMappingType;
import org.drools.scenariosimulation.api.model.ScenarioSimulationModel;
import org.drools.scenariosimulation.api.utils.ScenarioSimulationSharedUtils;
import org.drools.workbench.screens.scenariosimulation.client.commands.ScenarioSimulationContext;
import org.drools.workbench.screens.scenariosimulation.client.commands.actualcommands.AbstractScenarioSimulationCommand;
import org.drools.workbench.screens.scenariosimulation.client.metadata.ScenarioHeaderMetaData;
import org.drools.workbench.screens.scenariosimulation.client.resources.i18n.ScenarioSimulationEditorConstants;
import org.drools.workbench.screens.scenariosimulation.client.utils.ScenarioSimulationUtils;
import org.drools.workbench.screens.scenariosimulation.client.widgets.ScenarioGridColumn;
import org.drools.workbench.screens.scenariosimulation.model.typedescriptor.FactModelTree;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridData;

public abstract class AbstractSelectedColumnCommand
extends AbstractScenarioSimulationCommand {
    public AbstractSelectedColumnCommand() {
        super(true);
    }

    protected abstract void executeIfSelectedColumn(ScenarioSimulationContext var1, ScenarioGridColumn var2);

    @Override
    protected void internalExecute(ScenarioSimulationContext context) {
        this.getSelectedColumn(context).ifPresent(selectedColumn -> this.executeIfSelectedColumn(context, (ScenarioGridColumn)((Object)selectedColumn)));
    }

    protected ScenarioGridColumn insertNewColumn(ScenarioSimulationContext context, ScenarioGridColumn selectedColumn, int columnPosition, boolean cloneInstance) {
        ScenarioHeaderMetaData selectedInformationHeaderMetaData = selectedColumn.getInformationHeaderMetaData();
        String columnGroup = selectedInformationHeaderMetaData.getColumnGroup();
        String originalInstanceTitle = selectedInformationHeaderMetaData.getTitle();
        FactMappingType factMappingType = FactMappingType.valueOf((String)columnGroup.toUpperCase());
        Map.Entry<String, String> validPlaceholders = context.getModel().getValidPlaceholders();
        String instanceTitle = cloneInstance ? originalInstanceTitle : validPlaceholders.getKey();
        String propertyTitle = validPlaceholders.getValue();
        String placeHolder = ScenarioSimulationEditorConstants.INSTANCE.defineValidType();
        ScenarioGridColumn scenarioGridColumnLocal = this.getScenarioGridColumnLocal(instanceTitle, propertyTitle, String.valueOf(new Date().getTime()), columnGroup, factMappingType, context.getScenarioHeaderTextBoxSingletonDOMElementFactory(), context.getScenarioCellTextAreaSingletonDOMElementFactory(), placeHolder);
        if (cloneInstance) {
            scenarioGridColumnLocal.setFactIdentifier(selectedColumn.getFactIdentifier());
        }
        scenarioGridColumnLocal.setInstanceAssigned(cloneInstance);
        scenarioGridColumnLocal.setPropertyAssigned(false);
        context.getModel().insertColumn(columnPosition, (GridColumn<?>)scenarioGridColumnLocal);
        return scenarioGridColumnLocal;
    }

    protected void setInstanceHeader(ScenarioSimulationContext context, ScenarioGridColumn selectedColumn, String alias, String fullClassName) {
        int columnIndex = context.getModel().getColumns().indexOf((Object)selectedColumn);
        FactIdentifier factIdentifier = this.setEditableHeadersAndGetFactIdentifier(context, selectedColumn, alias, fullClassName);
        this.setInstanceHeaderMetaData(selectedColumn, alias, factIdentifier);
        ScenarioHeaderMetaData propertyHeaderMetaData = selectedColumn.getPropertyHeaderMetaData();
        this.setPropertyMetaData(propertyHeaderMetaData, FactMapping.getPropertyPlaceHolder((int)columnIndex), false, selectedColumn, ScenarioSimulationEditorConstants.INSTANCE.defineValidType());
        context.getModel().updateColumnInstance(columnIndex, (GridColumn<?>)selectedColumn);
        if (context.getScenarioSimulationEditorPresenter() != null) {
            context.getScenarioSimulationEditorPresenter().reloadTestTools(false);
        }
    }

    protected Optional<ScenarioGridColumn> getSelectedColumn(ScenarioSimulationContext context) {
        return Optional.ofNullable((ScenarioGridColumn)context.getModel().getSelectedColumn());
    }

    protected String getFullPackage(ScenarioSimulationContext context) {
        String fullPackage = context.getStatus().getFullPackage();
        if (!fullPackage.endsWith(".")) {
            fullPackage = fullPackage + ".";
        }
        return fullPackage;
    }

    protected FactIdentifier setEditableHeadersAndGetFactIdentifier(ScenarioSimulationContext context, ScenarioGridColumn selectedColumn, String aliasName, String canonicalClassName) {
        ScenarioSimulationModel.Type simulationModelType = context.getModel().getSimulation().get().getSimulationDescriptor().getType();
        selectedColumn.setEditableHeaders(!simulationModelType.equals((Object)ScenarioSimulationModel.Type.DMN));
        String nameToUseForCreation = simulationModelType.equals((Object)ScenarioSimulationModel.Type.DMN) ? aliasName : selectedColumn.getInformationHeaderMetaData().getColumnId();
        return this.getFactIdentifierByColumnTitle(aliasName, context).orElseGet(() -> FactIdentifier.create((String)nameToUseForCreation, (String)canonicalClassName));
    }

    protected void setInstanceHeaderMetaData(ScenarioGridColumn selectedColumn, String aliasName, FactIdentifier factIdentifier) {
        selectedColumn.getInformationHeaderMetaData().setTitle(aliasName);
        selectedColumn.setInstanceAssigned(true);
        selectedColumn.setFactIdentifier(factIdentifier);
    }

    protected void setPropertyHeader(ScenarioSimulationContext context, ScenarioGridColumn selectedColumn, List<String> propertyNameElements, String propertyClass) {
        String instanceAliasName = propertyNameElements.get(0);
        String canonicalClassName = this.getFullPackage(context) + instanceAliasName;
        FactIdentifier factIdentifier = this.setEditableHeadersAndGetFactIdentifier(context, selectedColumn, instanceAliasName, canonicalClassName);
        String propertyTitle = this.getPropertyHeaderTitle(context, propertyNameElements, factIdentifier);
        this.setPropertyHeader(context, selectedColumn, factIdentifier, propertyNameElements, propertyClass, propertyTitle);
    }

    protected void setPropertyHeader(ScenarioSimulationContext context, ScenarioGridColumn selectedColumn, List<String> propertyNameElements, String propertyClass, String propertyTitle) {
        String instanceAliasName = propertyNameElements.get(0);
        String canonicalClassName = this.getFullPackage(context) + instanceAliasName;
        FactIdentifier factIdentifier = this.setEditableHeadersAndGetFactIdentifier(context, selectedColumn, instanceAliasName, canonicalClassName);
        this.setPropertyHeader(context, selectedColumn, factIdentifier, propertyNameElements, propertyClass, propertyTitle);
    }

    protected void setPropertyHeader(ScenarioSimulationContext context, ScenarioGridColumn selectedColumn, FactIdentifier factIdentifier, List<String> propertyNameElements, String propertyClass, String propertyTitle) {
        if (propertyTitle == null) {
            throw new IllegalArgumentException("Property title can not be null");
        }
        int columnIndex = context.getModel().getColumns().indexOf((Object)selectedColumn);
        String instanceAliasName = propertyNameElements.get(0);
        if (selectedColumn.isInstanceAssigned() && !instanceAliasName.equals(selectedColumn.getInformationHeaderMetaData().getTitle())) {
            throw new IllegalArgumentException("It's not possible to assign this property");
        }
        String className = factIdentifier.getClassName();
        GridData.Range instanceLimits = context.getModel().getInstanceLimits(columnIndex);
        IntStream.range(instanceLimits.getMinRowIndex(), instanceLimits.getMaxRowIndex() + 1).forEach(index -> {
            ScenarioGridColumn scenarioGridColumn = (ScenarioGridColumn)((Object)((Object)context.getModel().getColumns().get(index)));
            if (!scenarioGridColumn.isInstanceAssigned()) {
                this.setInstanceHeaderMetaData(scenarioGridColumn, instanceAliasName, factIdentifier);
            }
        });
        selectedColumn.getPropertyHeaderMetaData().setColumnGroup(ScenarioSimulationUtils.getColumnSubGroup(selectedColumn.getInformationHeaderMetaData().getColumnGroup()));
        String editableCellPlaceholder = ScenarioSimulationUtils.getPlaceholder(propertyClass);
        this.setPropertyMetaData(selectedColumn.getPropertyHeaderMetaData(), propertyTitle, false, selectedColumn, editableCellPlaceholder);
        selectedColumn.setPropertyAssigned(true);
        context.getModel().updateColumnProperty(columnIndex, (GridColumn<?>)selectedColumn, propertyNameElements, propertyClass, context.getStatus().isKeepData());
        if (ScenarioSimulationSharedUtils.isCollection((String)propertyClass)) {
            this.manageCollectionProperty(context, selectedColumn, className, columnIndex, propertyNameElements);
        } else {
            selectedColumn.setFactory(context.getScenarioCellTextAreaSingletonDOMElementFactory());
        }
        if (context.getScenarioSimulationEditorPresenter() != null) {
            context.getScenarioSimulationEditorPresenter().reloadTestTools(false);
        }
    }

    protected void setPropertyMetaData(ScenarioHeaderMetaData propertyHeaderMetaData, String title, boolean readOnly, ScenarioGridColumn selectedColumn, String placeHolder) {
        propertyHeaderMetaData.setTitle(title);
        propertyHeaderMetaData.setReadOnly(readOnly);
        selectedColumn.setPlaceHolder(placeHolder);
    }

    protected void manageCollectionProperty(ScenarioSimulationContext context, ScenarioGridColumn selectedColumn, String className, int columnIndex, List<String> fullPropertyPathElements) {
        SortedMap<String, FactModelTree> dataObjectFieldsMap = context.getDataObjectFieldsMap();
        if (className.contains(".")) {
            className = className.substring(className.lastIndexOf(".") + 1);
        }
        FactModelTree factModelTree = (FactModelTree)dataObjectFieldsMap.get(className);
        FactMapping factMapping = context.getModel().getSimulation().get().getSimulationDescriptor().getFactMappingByIndex(columnIndex);
        selectedColumn.setFactory(context.getCollectionEditorSingletonDOMElementFactory());
        if (factModelTree.isSimple()) {
            factMapping.setGenericTypes(factModelTree.getGenericTypeInfo("value"));
        } else {
            FactModelTree nestedFactModelTree = this.navigateComplexObject(factModelTree, fullPropertyPathElements, dataObjectFieldsMap);
            factMapping.setGenericTypes(nestedFactModelTree.getGenericTypeInfo(fullPropertyPathElements.get(fullPropertyPathElements.size() - 1)));
        }
    }

    protected FactModelTree navigateComplexObject(FactModelTree factModelTree, List<String> pathElements, SortedMap<String, FactModelTree> dataObjectFieldsMap) {
        FactModelTree nestedFactModelTree = factModelTree;
        if (pathElements.size() > 2) {
            for (String step : pathElements.subList(1, pathElements.size() - 1)) {
                if (!nestedFactModelTree.getExpandableProperties().containsKey(step)) continue;
                nestedFactModelTree = (FactModelTree)dataObjectFieldsMap.get(factModelTree.getExpandableProperties().get(step));
            }
        }
        return nestedFactModelTree;
    }

    protected String getPropertyHeaderTitle(ScenarioSimulationContext context, List<String> propertyNameElements, FactIdentifier factIdentifier) {
        String propertyPathPart = propertyNameElements.size() > 1 ? String.join((CharSequence)".", propertyNameElements.subList(1, propertyNameElements.size())) : "value";
        List<String> propertyNameElementsClone = ScenarioSimulationUtils.getPropertyNameElementsWithoutAlias(propertyNameElements, factIdentifier);
        return this.getMatchingExpressionAlias(context, propertyNameElementsClone, factIdentifier).orElse(propertyPathPart);
    }

    protected Optional<String> getMatchingExpressionAlias(ScenarioSimulationContext context, List<String> propertyNameElements, FactIdentifier factIdentifier) {
        List factMappingsByFactName = context.getStatus().getSimulation().getSimulationDescriptor().getFactMappingsByFactName(factIdentifier.getName());
        return factMappingsByFactName.stream().filter(factMapping -> {
            List expressionElements = factMapping.getExpressionElements().stream().map(ExpressionElement::getStep).collect(Collectors.toList());
            return Objects.equals(expressionElements, propertyNameElements);
        }).findFirst().map(FactMapping::getExpressionAlias);
    }
}

