/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.commands;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Optional;
import org.drools.workbench.screens.scenariosimulation.client.AbstractScenarioSimulationTest;
import org.drools.workbench.screens.scenariosimulation.client.commands.ScenarioCommandRegistry;
import org.drools.workbench.screens.scenariosimulation.client.commands.ScenarioSimulationContext;
import org.drools.workbench.screens.scenariosimulation.client.commands.actualcommands.AbstractScenarioGridCommand;
import org.drools.workbench.screens.scenariosimulation.client.commands.actualcommands.AppendRowCommand;
import org.drools.workbench.screens.scenariosimulation.client.editor.ScenarioSimulationEditorPresenter;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.command.client.Command;
import org.kie.workbench.common.command.client.CommandResult;
import org.kie.workbench.common.command.client.CommandResultBuilder;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=GwtMockitoTestRunner.class)
public class ScenarioCommandRegistryTest
extends AbstractScenarioSimulationTest {
    private ScenarioCommandRegistry scenarioCommandRegistrySpy;

    @Override
    @Before
    public void setup() {
        super.setup();
        this.scenarioCommandRegistrySpy = (ScenarioCommandRegistry)Mockito.spy((Object)new ScenarioCommandRegistry(){});
    }

    @Test
    public void register() {
        this.scenarioCommandRegistrySpy.undoneCommands.add(Mockito.mock(AbstractScenarioGridCommand.class));
        Assert.assertFalse((boolean)this.scenarioCommandRegistrySpy.undoneCommands.isEmpty());
        this.scenarioCommandRegistrySpy.register(this.scenarioSimulationContextLocal, (AbstractScenarioGridCommand)Mockito.mock(AbstractScenarioGridCommand.class));
        Assert.assertTrue((boolean)this.scenarioCommandRegistrySpy.undoneCommands.isEmpty());
        ((ScenarioCommandRegistry)Mockito.verify((Object)this.scenarioCommandRegistrySpy, (VerificationMode)Mockito.times((int)1))).setUndoRedoButtonStatus((ScenarioSimulationContext)Matchers.eq((Object)this.scenarioSimulationContextLocal));
    }

    @Test
    public void undoEmpty() {
        this.scenarioCommandRegistrySpy.undoneCommands.clear();
        CommandResult retrieved = this.scenarioCommandRegistrySpy.undo(this.scenarioSimulationContextLocal);
        Assert.assertEquals((Object)CommandResult.Type.WARNING, (Object)retrieved.getType());
        ((ScenarioCommandRegistry)Mockito.verify((Object)this.scenarioCommandRegistrySpy, (VerificationMode)Mockito.never())).commonUndoRedoOperation((ScenarioSimulationContext)Matchers.eq((Object)this.scenarioSimulationContextLocal), (AbstractScenarioGridCommand)Matchers.eq((Object)this.appendRowCommandMock), Matchers.eq((boolean)true));
        ((ScenarioCommandRegistry)Mockito.verify((Object)this.scenarioCommandRegistrySpy, (VerificationMode)Mockito.times((int)1))).setUndoRedoButtonStatus((ScenarioSimulationContext)Matchers.eq((Object)this.scenarioSimulationContextLocal));
    }

    @Test
    public void undoNotEmptySameGrid() {
        this.scenarioCommandRegistrySpy.undoneCommands.clear();
        AbstractScenarioGridCommand commandMock = (AbstractScenarioGridCommand)Mockito.mock(AbstractScenarioGridCommand.class);
        this.scenarioCommandRegistrySpy.register((Command)commandMock);
        ((ScenarioCommandRegistry)Mockito.doReturn((Object)CommandResultBuilder.SUCCESS).when((Object)this.scenarioCommandRegistrySpy)).commonUndoRedoOperation((ScenarioSimulationContext)Matchers.any(), (AbstractScenarioGridCommand)Matchers.any(), Matchers.anyBoolean());
        ((ScenarioCommandRegistry)Mockito.doReturn(Optional.empty()).when((Object)this.scenarioCommandRegistrySpy)).commonUndoRedoPreexecution((ScenarioSimulationContext)Matchers.any(), (AbstractScenarioGridCommand)Matchers.any());
        CommandResult retrieved = this.scenarioCommandRegistrySpy.undo(this.scenarioSimulationContextLocal);
        Assert.assertEquals((Object)CommandResult.Type.INFO, (Object)retrieved.getType());
        ((ScenarioCommandRegistry)Mockito.verify((Object)this.scenarioCommandRegistrySpy, (VerificationMode)Mockito.times((int)1))).commonUndoRedoOperation((ScenarioSimulationContext)Matchers.eq((Object)this.scenarioSimulationContextLocal), (AbstractScenarioGridCommand)Matchers.eq((Object)commandMock), Matchers.eq((boolean)true));
        ((ScenarioCommandRegistry)Mockito.verify((Object)this.scenarioCommandRegistrySpy, (VerificationMode)Mockito.times((int)1))).setUndoRedoButtonStatus((ScenarioSimulationContext)Matchers.eq((Object)this.scenarioSimulationContextLocal));
    }

    @Test
    public void undoNotEmptyDifferentGrid() {
        int currentSize = this.scenarioCommandRegistrySpy.undoneCommands.size();
        this.scenarioCommandRegistrySpy.register(this.scenarioSimulationContextLocal, (AbstractScenarioGridCommand)this.appendRowCommandMock);
        ((ScenarioCommandRegistry)Mockito.verify((Object)this.scenarioCommandRegistrySpy, (VerificationMode)Mockito.times((int)1))).setUndoRedoButtonStatus((ScenarioSimulationContext)Matchers.eq((Object)this.scenarioSimulationContextLocal));
        ((AppendRowCommand)Mockito.doReturn(Optional.of(CommandResultBuilder.SUCCESS)).when((Object)this.appendRowCommandMock)).commonUndoRedoPreexecution((ScenarioSimulationContext)Matchers.eq((Object)this.scenarioSimulationContextLocal));
        this.scenarioCommandRegistrySpy.undo(this.scenarioSimulationContextLocal);
        Assert.assertEquals((long)currentSize, (long)this.scenarioCommandRegistrySpy.undoneCommands.size());
        ((ScenarioCommandRegistry)Mockito.verify((Object)this.scenarioCommandRegistrySpy, (VerificationMode)Mockito.never())).commonUndoRedoOperation((ScenarioSimulationContext)Matchers.eq((Object)this.scenarioSimulationContextLocal), (AbstractScenarioGridCommand)Matchers.eq((Object)this.appendRowCommandMock), Matchers.eq((boolean)true));
        ((ScenarioCommandRegistry)Mockito.verify((Object)this.scenarioCommandRegistrySpy, (VerificationMode)Mockito.times((int)1))).setUndoRedoButtonStatus((ScenarioSimulationContext)Matchers.eq((Object)this.scenarioSimulationContextLocal));
    }

    @Test
    public void redoEmpty() {
        this.scenarioCommandRegistrySpy.undoneCommands.clear();
        this.scenarioCommandRegistrySpy.redo(this.scenarioSimulationContextLocal);
        ((ScenarioCommandRegistry)Mockito.verify((Object)this.scenarioCommandRegistrySpy, (VerificationMode)Mockito.never())).commonUndoRedoOperation((ScenarioSimulationContext)Matchers.eq((Object)this.scenarioSimulationContextLocal), (AbstractScenarioGridCommand)Matchers.eq((Object)this.appendRowCommandMock), Matchers.eq((boolean)true));
        ((ScenarioCommandRegistry)Mockito.verify((Object)this.scenarioCommandRegistrySpy, (VerificationMode)Mockito.times((int)1))).setUndoRedoButtonStatus((ScenarioSimulationContext)Matchers.eq((Object)this.scenarioSimulationContextLocal));
    }

    @Test
    public void redoNotEmptySameGrid() {
        this.scenarioCommandRegistrySpy.undoneCommands.clear();
        AbstractScenarioGridCommand commandMock = (AbstractScenarioGridCommand)Mockito.mock(AbstractScenarioGridCommand.class);
        this.scenarioCommandRegistrySpy.undoneCommands.add(commandMock);
        ((ScenarioCommandRegistry)Mockito.doReturn((Object)CommandResultBuilder.SUCCESS).when((Object)this.scenarioCommandRegistrySpy)).commonUndoRedoOperation((ScenarioSimulationContext)Matchers.any(), (AbstractScenarioGridCommand)Matchers.any(), Matchers.anyBoolean());
        ((ScenarioCommandRegistry)Mockito.doReturn(Optional.empty()).when((Object)this.scenarioCommandRegistrySpy)).commonUndoRedoPreexecution((ScenarioSimulationContext)Matchers.any(), (AbstractScenarioGridCommand)Matchers.any());
        CommandResult retrieved = this.scenarioCommandRegistrySpy.redo(this.scenarioSimulationContextLocal);
        Assert.assertEquals((Object)CommandResult.Type.INFO, (Object)retrieved.getType());
        ((ScenarioCommandRegistry)Mockito.verify((Object)this.scenarioCommandRegistrySpy, (VerificationMode)Mockito.never())).commonUndoRedoOperation((ScenarioSimulationContext)Matchers.eq((Object)this.scenarioSimulationContextLocal), (AbstractScenarioGridCommand)Matchers.eq((Object)commandMock), Matchers.eq((boolean)true));
        ((ScenarioCommandRegistry)Mockito.verify((Object)this.scenarioCommandRegistrySpy, (VerificationMode)Mockito.times((int)1))).setUndoRedoButtonStatus((ScenarioSimulationContext)Matchers.eq((Object)this.scenarioSimulationContextLocal));
    }

    @Test
    public void redoNotEmptyDifferentGrid() {
        this.scenarioCommandRegistrySpy.undoneCommands.push(this.appendRowCommandMock);
        ((AppendRowCommand)Mockito.doReturn(Optional.of(CommandResultBuilder.SUCCESS)).when((Object)this.appendRowCommandMock)).commonUndoRedoPreexecution((ScenarioSimulationContext)Matchers.eq((Object)this.scenarioSimulationContextLocal));
        int currentSize = this.scenarioCommandRegistrySpy.undoneCommands.size();
        this.scenarioCommandRegistrySpy.redo(this.scenarioSimulationContextLocal);
        Assert.assertEquals((long)currentSize, (long)this.scenarioCommandRegistrySpy.undoneCommands.size());
        ((ScenarioCommandRegistry)Mockito.verify((Object)this.scenarioCommandRegistrySpy, (VerificationMode)Mockito.never())).commonUndoRedoOperation((ScenarioSimulationContext)Matchers.eq((Object)this.scenarioSimulationContextLocal), (AbstractScenarioGridCommand)Matchers.eq((Object)this.appendRowCommandMock), Matchers.eq((boolean)false));
        ((ScenarioCommandRegistry)Mockito.verify((Object)this.scenarioCommandRegistrySpy, (VerificationMode)Mockito.never())).setUndoRedoButtonStatus((ScenarioSimulationContext)Matchers.eq((Object)this.scenarioSimulationContextLocal));
    }

    @Test
    public void setUndoRedoButtonStatus() {
        this.scenarioCommandRegistrySpy.clear();
        this.scenarioCommandRegistrySpy.undoneCommands.clear();
        this.scenarioCommandRegistrySpy.setUndoRedoButtonStatus(this.scenarioSimulationContextLocal);
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.scenarioSimulationEditorPresenterMock, (VerificationMode)Mockito.times((int)1))).setUndoButtonEnabledStatus(Matchers.eq((boolean)false));
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.scenarioSimulationEditorPresenterMock, (VerificationMode)Mockito.times((int)1))).setRedoButtonEnabledStatus(Matchers.eq((boolean)false));
        Mockito.reset((Object[])new ScenarioSimulationEditorPresenter[]{this.scenarioSimulationEditorPresenterMock});
        this.scenarioCommandRegistrySpy.register((Command)this.appendRowCommandMock);
        this.scenarioCommandRegistrySpy.setUndoRedoButtonStatus(this.scenarioSimulationContextLocal);
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.scenarioSimulationEditorPresenterMock, (VerificationMode)Mockito.times((int)1))).setUndoButtonEnabledStatus(Matchers.eq((boolean)true));
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.scenarioSimulationEditorPresenterMock, (VerificationMode)Mockito.times((int)1))).setRedoButtonEnabledStatus(Matchers.eq((boolean)false));
        Mockito.reset((Object[])new ScenarioSimulationEditorPresenter[]{this.scenarioSimulationEditorPresenterMock});
        this.scenarioCommandRegistrySpy.undoneCommands.push(this.appendRowCommandMock);
        this.scenarioCommandRegistrySpy.setUndoRedoButtonStatus(this.scenarioSimulationContextLocal);
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.scenarioSimulationEditorPresenterMock, (VerificationMode)Mockito.times((int)1))).setUndoButtonEnabledStatus(Matchers.eq((boolean)true));
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.scenarioSimulationEditorPresenterMock, (VerificationMode)Mockito.times((int)1))).setRedoButtonEnabledStatus(Matchers.eq((boolean)true));
    }

    @Test
    public void commonOperationUndo() {
        this.scenarioCommandRegistrySpy.commonUndoRedoOperation(this.scenarioSimulationContextLocal, (AbstractScenarioGridCommand)this.appendRowCommandMock, true);
        ((AppendRowCommand)Mockito.verify((Object)this.appendRowCommandMock, (VerificationMode)Mockito.times((int)1))).undo((ScenarioSimulationContext)Matchers.eq((Object)this.scenarioSimulationContextLocal));
        ((AppendRowCommand)Mockito.verify((Object)this.appendRowCommandMock, (VerificationMode)Mockito.never())).redo((ScenarioSimulationContext)Matchers.eq((Object)this.scenarioSimulationContextLocal));
    }

    @Test
    public void commonOperationRedo() {
        this.scenarioCommandRegistrySpy.commonUndoRedoOperation(this.scenarioSimulationContextLocal, (AbstractScenarioGridCommand)this.appendRowCommandMock, false);
        ((AppendRowCommand)Mockito.verify((Object)this.appendRowCommandMock, (VerificationMode)Mockito.times((int)1))).redo((ScenarioSimulationContext)Matchers.eq((Object)this.scenarioSimulationContextLocal));
        ((AppendRowCommand)Mockito.verify((Object)this.appendRowCommandMock, (VerificationMode)Mockito.never())).undo((ScenarioSimulationContext)Matchers.eq((Object)this.scenarioSimulationContextLocal));
    }
}

