/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.commands.actualcommands;

import java.util.Optional;
import org.drools.scenariosimulation.api.model.AbstractScesimModel;
import org.drools.scenariosimulation.api.model.Background;
import org.drools.scenariosimulation.api.model.ScenarioSimulationModel;
import org.drools.scenariosimulation.api.model.Simulation;
import org.drools.workbench.screens.scenariosimulation.client.AbstractScenarioSimulationTest;
import org.drools.workbench.screens.scenariosimulation.client.commands.ScenarioSimulationContext;
import org.drools.workbench.screens.scenariosimulation.client.commands.actualcommands.AbstractScenarioGridCommand;
import org.drools.workbench.screens.scenariosimulation.client.editor.ScenarioSimulationEditorPresenter;
import org.drools.workbench.screens.scenariosimulation.client.enums.GridWidget;
import org.drools.workbench.screens.scenariosimulation.client.models.BackgroundGridModel;
import org.drools.workbench.screens.scenariosimulation.client.models.ScenarioGridModel;
import org.drools.workbench.screens.scenariosimulation.client.widgets.ScenarioGrid;
import org.drools.workbench.screens.scenariosimulation.client.widgets.ScenarioGridPanel;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.workbench.common.command.client.CommandResult;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public abstract class AbstractScenarioGridCommandTest
extends AbstractScenarioSimulationTest {
    protected AbstractScenarioGridCommand commandSpy;

    @Override
    @Before
    public void setup() {
        super.setup();
    }

    @Test
    public void undoWithRestorable() {
        this.commandSpy.restorableStatus = this.scenarioSimulationContextLocal.getStatus();
        this.commandSpy.undo(this.scenarioSimulationContextLocal);
        ((AbstractScenarioGridCommand)Mockito.verify((Object)this.commandSpy, (VerificationMode)Mockito.times((int)1))).setCurrentContext((ScenarioSimulationContext)Matchers.eq((Object)this.scenarioSimulationContextLocal));
    }

    @Test(expected=IllegalStateException.class)
    public void undoWithoutRestorable() {
        this.commandSpy.restorableStatus = null;
        this.commandSpy.undo(this.scenarioSimulationContextLocal);
    }

    @Test
    public void redoWithRestorable() {
        this.commandSpy.restorableStatus = this.scenarioSimulationContextLocal.getStatus();
        this.commandSpy.redo(this.scenarioSimulationContextLocal);
        ((AbstractScenarioGridCommand)Mockito.verify((Object)this.commandSpy, (VerificationMode)Mockito.times((int)1))).setCurrentContext((ScenarioSimulationContext)Matchers.eq((Object)this.scenarioSimulationContextLocal));
    }

    @Test(expected=IllegalStateException.class)
    public void redoWithoutRestorable() {
        this.commandSpy.restorableStatus = null;
        this.commandSpy.redo(this.scenarioSimulationContextLocal);
    }

    @Test
    public void execute() {
        ScenarioSimulationContext.Status status = this.scenarioSimulationContextLocal.getStatus();
        this.commandSpy.execute(this.scenarioSimulationContextLocal);
        try {
            ((AbstractScenarioGridCommand)Mockito.verify((Object)this.commandSpy, (VerificationMode)Mockito.times((int)1))).internalExecute((ScenarioSimulationContext)Matchers.eq((Object)this.scenarioSimulationContextLocal));
            Assert.assertNotEquals((Object)status, (Object)this.commandSpy.restorableStatus);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void setCurrentContextNoSimulationNoBackground() {
        ScenarioSimulationContext.Status status;
        this.commandSpy.restorableStatus = status = this.scenarioSimulationContextLocal.getStatus();
        this.commandSpy.restorableStatus.setSimulation(null);
        this.commandSpy.restorableStatus.setBackground(null);
        CommandResult retrieved = this.commandSpy.setCurrentContext(this.scenarioSimulationContextLocal);
        Assert.assertEquals((Object)CommandResult.Type.ERROR, (Object)retrieved.getType());
        ((ScenarioGridModel)Mockito.verify((Object)this.scenarioGridModelMock, (VerificationMode)Mockito.never())).clearSelections();
        ((BackgroundGridModel)Mockito.verify((Object)this.backgroundGridModelMock, (VerificationMode)Mockito.never())).clearSelections();
        ((ScenarioGrid)Mockito.verify((Object)this.scenarioGridMock, (VerificationMode)Mockito.never())).setContent((AbstractScesimModel)Matchers.eq((Object)this.simulationMock), (ScenarioSimulationModel.Type)Matchers.eq((Object)this.scenarioSimulationContextLocal.getSettings().getType()));
        ((ScenarioSimulationModel)Mockito.verify((Object)this.scenarioSimulationModelMock, (VerificationMode)Mockito.never())).setSimulation((Simulation)Matchers.eq((Object)this.simulationMock));
        ((ScenarioGrid)Mockito.verify((Object)this.backgroundGridMock, (VerificationMode)Mockito.never())).setContent((AbstractScesimModel)Matchers.eq((Object)this.simulationMock), (ScenarioSimulationModel.Type)Matchers.eq((Object)this.scenarioSimulationContextLocal.getSettings().getType()));
        ((ScenarioSimulationModel)Mockito.verify((Object)this.scenarioSimulationModelMock, (VerificationMode)Mockito.never())).setBackground((Background)Matchers.eq((Object)this.backgroundMock));
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.scenarioSimulationEditorPresenterMock, (VerificationMode)Mockito.never())).reloadTestTools(Matchers.eq((boolean)true));
        ((AbstractScenarioGridCommand)Mockito.verify((Object)this.commandSpy, (VerificationMode)Mockito.never())).commonExecution((ScenarioSimulationContext)Matchers.eq((Object)this.scenarioSimulationContextLocal));
        Assert.assertEquals((Object)status, (Object)this.commandSpy.restorableStatus);
    }

    @Test
    public void setCurrentContextSimulationBackground() {
        ScenarioSimulationContext.Status status;
        this.commandSpy.restorableStatus = status = this.scenarioSimulationContextLocal.getStatus();
        CommandResult retrieved = this.commandSpy.setCurrentContext(this.scenarioSimulationContextLocal);
        Assert.assertEquals((Object)CommandResult.Type.INFO, (Object)retrieved.getType());
        ((ScenarioGridModel)Mockito.verify((Object)this.scenarioGridModelMock, (VerificationMode)Mockito.times((int)1))).clearSelections();
        ((BackgroundGridModel)Mockito.verify((Object)this.backgroundGridModelMock, (VerificationMode)Mockito.times((int)1))).clearSelections();
        ((ScenarioGrid)Mockito.verify((Object)this.scenarioGridMock, (VerificationMode)Mockito.times((int)1))).setContent((AbstractScesimModel)Matchers.eq((Object)this.simulationMock), (ScenarioSimulationModel.Type)Matchers.eq((Object)this.scenarioSimulationContextLocal.getSettings().getType()));
        ((ScenarioSimulationModel)Mockito.verify((Object)this.scenarioSimulationModelMock, (VerificationMode)Mockito.times((int)1))).setSimulation((Simulation)Matchers.eq((Object)this.simulationMock));
        ((ScenarioGrid)Mockito.verify((Object)this.backgroundGridMock, (VerificationMode)Mockito.times((int)1))).setContent((AbstractScesimModel)Matchers.eq((Object)this.backgroundMock), (ScenarioSimulationModel.Type)Matchers.eq((Object)this.scenarioSimulationContextLocal.getSettings().getType()));
        ((ScenarioSimulationModel)Mockito.verify((Object)this.scenarioSimulationModelMock, (VerificationMode)Mockito.times((int)1))).setBackground((Background)Matchers.eq((Object)this.backgroundMock));
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.scenarioSimulationEditorPresenterMock, (VerificationMode)Mockito.times((int)1))).reloadTestTools(Matchers.eq((boolean)true));
        ((AbstractScenarioGridCommand)Mockito.verify((Object)this.commandSpy, (VerificationMode)Mockito.times((int)1))).commonExecution((ScenarioSimulationContext)Matchers.eq((Object)this.scenarioSimulationContextLocal));
        Assert.assertNotEquals((Object)status, (Object)this.commandSpy.restorableStatus);
    }

    @Test
    public void commonUndoRedoPreexecutionSameGrid() {
        Mockito.when((Object)this.backgroundGridWidgetSpy.isSelected()).thenReturn((Object)false);
        Mockito.when((Object)this.scenarioGridWidgetSpy.isSelected()).thenReturn((Object)true);
        this.commandSpy.gridWidget = GridWidget.SIMULATION;
        Optional retrieved = this.commandSpy.commonUndoRedoPreexecution(this.scenarioSimulationContextLocal);
        Assert.assertFalse((boolean)retrieved.isPresent());
        ((ScenarioGridPanel)Mockito.verify((Object)this.scenarioGridPanelMock, (VerificationMode)Mockito.never())).onResize();
        ((ScenarioGridPanel)Mockito.verify((Object)this.scenarioGridPanelMock, (VerificationMode)Mockito.never())).select();
    }

    @Test
    public void commonUndoRedoPreexecutionDifferentGridSIMULATION() {
        Mockito.when((Object)this.backgroundGridWidgetSpy.isSelected()).thenReturn((Object)true);
        Mockito.when((Object)this.scenarioGridWidgetSpy.isSelected()).thenReturn((Object)false);
        this.commandSpy.gridWidget = GridWidget.SIMULATION;
        Optional retrieved = this.commandSpy.commonUndoRedoPreexecution(this.scenarioSimulationContextLocal);
        Assert.assertTrue((boolean)retrieved.isPresent());
        Assert.assertEquals((Object)CommandResult.Type.INFO, (Object)((CommandResult)retrieved.get()).getType());
        ((ScenarioGridPanel)Mockito.verify((Object)this.scenarioGridPanelMock, (VerificationMode)Mockito.times((int)1))).onResize();
        ((ScenarioGridPanel)Mockito.verify((Object)this.scenarioGridPanelMock, (VerificationMode)Mockito.times((int)1))).select();
    }

    @Test
    public void commonUndoRedoPreexecutionDifferentGridBACKGROUND() {
        Mockito.when((Object)this.backgroundGridWidgetSpy.isSelected()).thenReturn((Object)false);
        Mockito.when((Object)this.scenarioGridWidgetSpy.isSelected()).thenReturn((Object)true);
        this.commandSpy.gridWidget = GridWidget.BACKGROUND;
        Optional retrieved = this.commandSpy.commonUndoRedoPreexecution(this.scenarioSimulationContextLocal);
        Assert.assertTrue((boolean)retrieved.isPresent());
        Assert.assertEquals((Object)CommandResult.Type.INFO, (Object)((CommandResult)retrieved.get()).getType());
        ((ScenarioGridPanel)Mockito.verify((Object)this.backgroundGridPanelMock, (VerificationMode)Mockito.times((int)1))).onResize();
        ((ScenarioGridPanel)Mockito.verify((Object)this.backgroundGridPanelMock, (VerificationMode)Mockito.times((int)1))).select();
    }

    @Test
    public void commonUndoRedoPreexecutionDifferentGridCheckSwitch() {
        for (GridWidget gridWidget : GridWidget.values()) {
            Mockito.when((Object)this.scenarioGridWidgetSpy.isSelected()).thenReturn((Object)GridWidget.BACKGROUND.equals((Object)gridWidget));
            Mockito.when((Object)this.backgroundGridWidgetSpy.isSelected()).thenReturn((Object)GridWidget.SIMULATION.equals((Object)gridWidget));
            this.commandSpy.gridWidget = gridWidget;
            this.commandSpy.commonUndoRedoPreexecution(this.scenarioSimulationContextLocal);
        }
    }

    @Test
    public void commonExecutionSIMULATION() {
        Mockito.when((Object)this.backgroundGridWidgetSpy.isSelected()).thenReturn((Object)false);
        Mockito.when((Object)this.scenarioGridWidgetSpy.isSelected()).thenReturn((Object)true);
        this.commandSpy.commonExecution(this.scenarioSimulationContextLocal);
        ((ScenarioGridPanel)Mockito.verify((Object)this.scenarioGridPanelMock, (VerificationMode)Mockito.times((int)1))).onResize();
        ((ScenarioGridPanel)Mockito.verify((Object)this.scenarioGridPanelMock, (VerificationMode)Mockito.times((int)1))).select();
        ((ScenarioGridPanel)Mockito.verify((Object)this.backgroundGridPanelMock, (VerificationMode)Mockito.never())).onResize();
        ((ScenarioGridPanel)Mockito.verify((Object)this.backgroundGridPanelMock, (VerificationMode)Mockito.never())).select();
    }

    @Test
    public void commonExecutionBACKGROUND() {
        Mockito.when((Object)this.backgroundGridWidgetSpy.isSelected()).thenReturn((Object)true);
        Mockito.when((Object)this.scenarioGridWidgetSpy.isSelected()).thenReturn((Object)false);
        this.commandSpy.commonExecution(this.scenarioSimulationContextLocal);
        ((ScenarioGridPanel)Mockito.verify((Object)this.backgroundGridPanelMock, (VerificationMode)Mockito.times((int)1))).onResize();
        ((ScenarioGridPanel)Mockito.verify((Object)this.backgroundGridPanelMock, (VerificationMode)Mockito.times((int)1))).select();
        ((ScenarioGridPanel)Mockito.verify((Object)this.scenarioGridPanelMock, (VerificationMode)Mockito.never())).onResize();
        ((ScenarioGridPanel)Mockito.verify((Object)this.scenarioGridPanelMock, (VerificationMode)Mockito.never())).select();
    }

    @Test
    public void commonExecutionNone() {
        Mockito.when((Object)this.backgroundGridWidgetSpy.isSelected()).thenReturn((Object)false);
        Mockito.when((Object)this.scenarioGridWidgetSpy.isSelected()).thenReturn((Object)false);
        this.commandSpy.commonExecution(this.scenarioSimulationContextLocal);
        ((ScenarioGridPanel)Mockito.verify((Object)this.scenarioGridPanelMock, (VerificationMode)Mockito.never())).onResize();
        ((ScenarioGridPanel)Mockito.verify((Object)this.scenarioGridPanelMock, (VerificationMode)Mockito.never())).select();
        ((ScenarioGridPanel)Mockito.verify((Object)this.backgroundGridPanelMock, (VerificationMode)Mockito.never())).onResize();
        ((ScenarioGridPanel)Mockito.verify((Object)this.backgroundGridPanelMock, (VerificationMode)Mockito.never())).select();
    }
}

