/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.commands.actualcommands;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import org.drools.scenariosimulation.api.model.ScesimModelDescriptor;
import org.drools.workbench.screens.scenariosimulation.client.TestProperties;
import org.drools.workbench.screens.scenariosimulation.client.commands.ScenarioSimulationContext;
import org.drools.workbench.screens.scenariosimulation.client.commands.actualcommands.AbstractScenarioGridCommand;
import org.drools.workbench.screens.scenariosimulation.client.commands.actualcommands.AbstractScenarioGridCommandTest;
import org.drools.workbench.screens.scenariosimulation.client.commands.actualcommands.SetHeaderCellValueCommand;
import org.drools.workbench.screens.scenariosimulation.client.enums.GridWidget;
import org.drools.workbench.screens.scenariosimulation.client.models.ScenarioGridModel;
import org.drools.workbench.screens.scenariosimulation.model.typedescriptor.FactModelTree;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=GwtMockitoTestRunner.class)
public class SetHeaderCellValueCommandTest
extends AbstractScenarioGridCommandTest {
    @Override
    @Before
    public void setup() {
        super.setup();
        this.commandSpy = (AbstractScenarioGridCommand)Mockito.spy((Object)new SetHeaderCellValueCommand(GridWidget.SIMULATION, false, false));
        this.scenarioSimulationContextLocal.getStatus().setRowIndex(2);
        this.scenarioSimulationContextLocal.getStatus().setColumnIndex(3);
        this.scenarioSimulationContextLocal.getStatus().setGridCellValue("MULTIPART.VALUE");
    }

    @Test
    public void executeInstanceHeaderValid() throws Exception {
        this.commonExecute(true, false, true);
    }

    @Test
    public void executeInstanceHeaderInvalid() throws Exception {
        this.commonExecute(true, false, false);
    }

    @Test
    public void executePropertyHeaderValid() throws Exception {
        this.commonExecute(false, true, true);
    }

    @Test
    public void executePropertyHeaderInvalid() throws Exception {
        this.commonExecute(false, true, false);
    }

    @Test
    public void executeOtherHeader() throws Exception {
        this.commonExecute(false, false, false);
    }

    @Test
    public void validateInstanceHeader() throws Exception {
        this.commonValidateInstanceHeader(false);
        this.commonValidateInstanceHeader(true);
    }

    @Test
    public void validatePropertyHeaderNoFactModelMapped() throws Exception {
        this.commonValidatePropertyHeader(false, false);
    }

    @Test
    public void validatePropertyHeaderFactModelMappedNoProperty() throws Exception {
        this.commonValidatePropertyHeader(true, false);
    }

    @Test
    public void validatePropertyHeaderFactModelMappedProperty() throws Exception {
        this.commonValidatePropertyHeader(true, true);
    }

    @Test
    public void recursivelyFindIsPropertyType() {
        HashMap<String, String> bookSimpleProperties = new HashMap<String, String>();
        bookSimpleProperties.put("name", "String");
        HashMap<String, String> bookExpandableProperties = new HashMap<String, String>();
        bookExpandableProperties.put("author", "Author");
        HashMap<String, String> authorSimpleProperties = new HashMap<String, String>();
        authorSimpleProperties.put("books", "List");
        HashMap<String, String> authorExpandableProperties = new HashMap<String, String>();
        FactModelTree bookFactModelTreeMock = this.getMockedFactModelTree(bookSimpleProperties, bookExpandableProperties);
        FactModelTree authorFactModelTreeMock = this.getMockedFactModelTree(authorSimpleProperties, authorExpandableProperties);
        Mockito.when(this.dataObjectFieldsMapMock.get("Author")).thenReturn((Object)authorFactModelTreeMock);
        Mockito.when(this.dataObjectFieldsMapMock.get("Book")).thenReturn((Object)bookFactModelTreeMock);
        Assert.assertFalse((boolean)((SetHeaderCellValueCommand)this.commandSpy).recursivelyFindIsPropertyType(this.scenarioSimulationContextLocal, bookFactModelTreeMock, Collections.singletonList("not-existing")));
        Assert.assertTrue((boolean)((SetHeaderCellValueCommand)this.commandSpy).recursivelyFindIsPropertyType(this.scenarioSimulationContextLocal, bookFactModelTreeMock, Collections.singletonList("name")));
        Assert.assertFalse((boolean)((SetHeaderCellValueCommand)this.commandSpy).recursivelyFindIsPropertyType(this.scenarioSimulationContextLocal, bookFactModelTreeMock, Arrays.asList("author", "not-existing")));
        Assert.assertTrue((boolean)((SetHeaderCellValueCommand)this.commandSpy).recursivelyFindIsPropertyType(this.scenarioSimulationContextLocal, bookFactModelTreeMock, Arrays.asList("author", "books")));
    }

    private FactModelTree getMockedFactModelTree(Map<String, String> simpleProperties, Map<String, String> expandableProperties) {
        FactModelTree toReturn = (FactModelTree)Mockito.mock(FactModelTree.class);
        Mockito.when((Object)toReturn.getSimpleProperties()).thenReturn(simpleProperties);
        Mockito.when((Object)toReturn.getExpandableProperties()).thenReturn(expandableProperties);
        return toReturn;
    }

    private void commonExecute(boolean isInstanceHeader, boolean isPropertyHeader, boolean isValid) throws Exception {
        ((SetHeaderCellValueCommand)this.commandSpy).isInstanceHeader = isInstanceHeader;
        ((SetHeaderCellValueCommand)this.commandSpy).isPropertyHeader = isPropertyHeader;
        this.scenarioSimulationContextLocal.getStatus().setHeaderCellValue("MULTIPART.VALUE");
        ((SetHeaderCellValueCommand)Mockito.doNothing().when((Object)((SetHeaderCellValueCommand)this.commandSpy))).validateInstanceHeader((ScenarioSimulationContext)Matchers.eq((Object)this.scenarioSimulationContextLocal), (String)Matchers.eq((Object)"MULTIPART.VALUE"), Matchers.eq((int)3));
        ((SetHeaderCellValueCommand)Mockito.doNothing().when((Object)((SetHeaderCellValueCommand)this.commandSpy))).validatePropertyHeader((ScenarioSimulationContext)Matchers.eq((Object)this.scenarioSimulationContextLocal), (String)Matchers.eq((Object)"MULTIPART.VALUE"), Matchers.eq((int)3));
        this.commandSpy.execute(this.scenarioSimulationContextLocal);
        if (isInstanceHeader) {
            ((SetHeaderCellValueCommand)Mockito.verify((Object)((SetHeaderCellValueCommand)this.commandSpy), (VerificationMode)Mockito.times((int)1))).validateInstanceHeader((ScenarioSimulationContext)Matchers.eq((Object)this.scenarioSimulationContextLocal), (String)Matchers.eq((Object)"MULTIPART.VALUE"), Matchers.eq((int)3));
        } else if (isPropertyHeader) {
            ((SetHeaderCellValueCommand)Mockito.verify((Object)((SetHeaderCellValueCommand)this.commandSpy), (VerificationMode)Mockito.times((int)1))).validatePropertyHeader((ScenarioSimulationContext)Matchers.eq((Object)this.scenarioSimulationContextLocal), (String)Matchers.eq((Object)"MULTIPART.VALUE"), Matchers.eq((int)3));
        } else {
            ((SetHeaderCellValueCommand)Mockito.verify((Object)((SetHeaderCellValueCommand)this.commandSpy), (VerificationMode)Mockito.never())).validateInstanceHeader((ScenarioSimulationContext)Matchers.eq((Object)this.scenarioSimulationContextLocal), (String)Matchers.eq((Object)"MULTIPART.VALUE"), Matchers.eq((int)3));
            ((SetHeaderCellValueCommand)Mockito.verify((Object)((SetHeaderCellValueCommand)this.commandSpy), (VerificationMode)Mockito.never())).validateInstanceHeader((ScenarioSimulationContext)Matchers.eq((Object)this.scenarioSimulationContextLocal), (String)Matchers.eq((Object)"MULTIPART.VALUE"), Matchers.eq((int)3));
        }
        if (isValid) {
            ((ScenarioGridModel)Mockito.verify((Object)this.scenarioGridModelMock, (VerificationMode)Mockito.times((int)1))).updateHeader(Matchers.eq((int)3), Matchers.eq((int)2), (String)Matchers.eq((Object)"MULTIPART.VALUE"));
        }
    }

    private void commonValidateInstanceHeader(boolean isADataType) throws Exception {
        ((SortedMap)Mockito.doReturn((Object)isADataType).when((Object)this.dataObjectFieldsMapMock)).containsKey("value");
        ((ScenarioGridModel)Mockito.doNothing().when((Object)this.scenarioGridModelMock)).validateInstanceHeaderUpdate((String)Matchers.eq((Object)"value"), Matchers.eq((int)3), Matchers.eq((boolean)isADataType));
        ((SetHeaderCellValueCommand)this.commandSpy).validateInstanceHeader(this.scenarioSimulationContextLocal, "value", 3);
        ((SortedMap)Mockito.verify((Object)this.dataObjectFieldsMapMock, (VerificationMode)Mockito.times((int)1))).containsKey(Matchers.eq((Object)"value"));
        ((ScenarioGridModel)Mockito.verify((Object)this.scenarioGridModelMock, (VerificationMode)Mockito.times((int)1))).validateInstanceHeaderUpdate((String)Matchers.eq((Object)"value"), Matchers.eq((int)3), Matchers.eq((boolean)isADataType));
        Mockito.reset((Object[])new SortedMap[]{this.dataObjectFieldsMapMock});
        Mockito.reset((Object[])new ScenarioGridModel[]{this.scenarioGridModelMock});
    }

    private void commonValidatePropertyHeader(boolean factModelPresent, boolean simplePropertyPresent) throws Exception {
        FactModelTree factModelTreeMock = (FactModelTree)Mockito.mock(FactModelTree.class);
        ((SetHeaderCellValueCommand)Mockito.doReturn((Object)simplePropertyPresent).when((Object)((SetHeaderCellValueCommand)this.commandSpy))).recursivelyFindIsPropertyType((ScenarioSimulationContext)Matchers.eq((Object)this.scenarioSimulationContextLocal), (FactModelTree)Matchers.eq((Object)factModelTreeMock), (List)Matchers.eq(TestProperties.MULTIPART_VALUE_ELEMENTS));
        if (factModelPresent) {
            Map simplePropertiesMock = (Map)Mockito.mock(SortedMap.class);
            Mockito.when((Object)factModelTreeMock.getSimpleProperties()).thenReturn((Object)simplePropertiesMock);
            Map expandablePropertiesMock = (Map)Mockito.mock(SortedMap.class);
            Mockito.when((Object)factModelTreeMock.getExpandableProperties()).thenReturn((Object)expandablePropertiesMock);
            Mockito.when(this.dataObjectFieldsMapMock.get(Matchers.anyString())).thenReturn((Object)factModelTreeMock);
            ((Map)Mockito.doReturn((Object)simplePropertyPresent).when((Object)simplePropertiesMock)).containsKey(Matchers.eq((Object)TestProperties.MULTIPART_VALUE_ELEMENTS.get(0)));
            ((Map)Mockito.doReturn((Object)simplePropertyPresent).when((Object)expandablePropertiesMock)).containsKey(Matchers.eq((Object)TestProperties.MULTIPART_VALUE_ELEMENTS.get(0)));
        } else {
            Mockito.when(this.dataObjectFieldsMapMock.get(Matchers.anyString())).thenReturn(null);
        }
        boolean isPropertyType = factModelPresent && simplePropertyPresent;
        ((ScenarioGridModel)Mockito.doNothing().when((Object)this.scenarioGridModelMock)).validatePropertyHeaderUpdate((String)Matchers.eq((Object)"MULTIPART.VALUE"), Matchers.eq((int)3), Matchers.eq((boolean)isPropertyType));
        ((SetHeaderCellValueCommand)this.commandSpy).validatePropertyHeader(this.scenarioSimulationContextLocal, "MULTIPART.VALUE", 3);
        ((ScesimModelDescriptor)Mockito.verify((Object)this.simulationDescriptorMock, (VerificationMode)Mockito.times((int)1))).getFactMappingByIndex(Matchers.eq((int)3));
        ((ScenarioGridModel)Mockito.verify((Object)this.scenarioGridModelMock, (VerificationMode)Mockito.times((int)1))).validatePropertyHeaderUpdate((String)Matchers.eq((Object)"MULTIPART.VALUE"), Matchers.eq((int)3), Matchers.eq((boolean)isPropertyType));
        Mockito.reset((Object[])new ScesimModelDescriptor[]{this.simulationDescriptorMock});
        Mockito.reset((Object[])new ScenarioGridModel[]{this.scenarioGridModelMock});
    }
}

