/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.editor.menu;

import com.google.gwt.dom.client.LIElement;
import com.google.gwt.dom.client.Node;
import com.google.gwt.dom.client.Style;
import com.google.gwt.dom.client.UListElement;
import com.google.gwtmockito.GwtMockitoTestRunner;
import com.google.web.bindery.event.shared.Event;
import org.drools.workbench.screens.scenariosimulation.client.editor.menu.BaseMenuView;
import org.drools.workbench.screens.scenariosimulation.client.editor.menu.UnmodifiableColumnGridContextMenu;
import org.drools.workbench.screens.scenariosimulation.client.enums.GridWidget;
import org.drools.workbench.screens.scenariosimulation.client.events.DeleteRowEvent;
import org.drools.workbench.screens.scenariosimulation.client.events.DuplicateRowEvent;
import org.drools.workbench.screens.scenariosimulation.client.events.InsertRowEvent;
import org.drools.workbench.screens.scenariosimulation.client.events.RunSingleScenarioEvent;
import org.drools.workbench.screens.scenariosimulation.client.resources.i18n.ScenarioSimulationEditorConstants;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=GwtMockitoTestRunner.class)
public class UnmodifiableColumnGridContextMenuTest {
    @Mock
    private LIElement insertRowAboveLIElementMock;
    @Mock
    private LIElement insertRowBelowLIElementMock;
    @Mock
    private LIElement duplicateRowLIElementMock;
    @Mock
    private LIElement deleteRowLIElementMock;
    @Mock
    private LIElement runSingleScenarioElementMock;
    @Mock
    private LIElement createdElementMock;
    @Mock
    private BaseMenuView viewMock;
    @Mock
    private UListElement contextMenuDropdownMock;
    @Mock
    private Style styleMock;
    private UnmodifiableColumnGridContextMenu unmodifiableColumnGridContextMenuSpy;

    @Before
    public void setup() {
        Mockito.when((Object)this.contextMenuDropdownMock.getStyle()).thenReturn((Object)this.styleMock);
        Mockito.when((Object)this.viewMock.getContextMenuDropdown()).thenReturn((Object)this.contextMenuDropdownMock);
        this.unmodifiableColumnGridContextMenuSpy = (UnmodifiableColumnGridContextMenu)Mockito.spy((Object)new UnmodifiableColumnGridContextMenu(){
            {
                this.insertRowAboveLIElement = UnmodifiableColumnGridContextMenuTest.this.insertRowAboveLIElementMock;
                this.insertRowBelowLIElement = UnmodifiableColumnGridContextMenuTest.this.insertRowBelowLIElementMock;
                this.duplicateRowLIElement = UnmodifiableColumnGridContextMenuTest.this.duplicateRowLIElementMock;
                this.deleteRowLIElement = UnmodifiableColumnGridContextMenuTest.this.deleteRowLIElementMock;
                this.runSingleScenarioElement = UnmodifiableColumnGridContextMenuTest.this.runSingleScenarioElementMock;
                this.view = UnmodifiableColumnGridContextMenuTest.this.viewMock;
            }

            public LIElement addExecutableMenuItem(String id, String label, String i18n) {
                return UnmodifiableColumnGridContextMenuTest.this.createdElementMock;
            }

            public void mapEvent(LIElement executableMenuItem, Event toBeMapped) {
            }

            public void hide() {
            }

            public void show(GridWidget gridWidget, int mx, int my) {
            }
        });
    }

    @Test
    public void initMenu() {
        this.unmodifiableColumnGridContextMenuSpy.initMenu();
        ((UnmodifiableColumnGridContextMenu)Mockito.verify((Object)this.unmodifiableColumnGridContextMenuSpy, (VerificationMode)Mockito.times((int)1))).addExecutableMenuItem((String)Matchers.eq((Object)"ucgridcontextmenu-insert-row-above"), (String)Matchers.eq((Object)ScenarioSimulationEditorConstants.INSTANCE.insertRowAbove()), (String)Matchers.eq((Object)"insertRowAbove"));
        ((UnmodifiableColumnGridContextMenu)Mockito.verify((Object)this.unmodifiableColumnGridContextMenuSpy, (VerificationMode)Mockito.times((int)1))).addExecutableMenuItem((String)Matchers.eq((Object)"ucgridcontextmenu-insert-row-below"), (String)Matchers.eq((Object)ScenarioSimulationEditorConstants.INSTANCE.insertRowBelow()), (String)Matchers.eq((Object)"insertRowBelow"));
        ((UnmodifiableColumnGridContextMenu)Mockito.verify((Object)this.unmodifiableColumnGridContextMenuSpy, (VerificationMode)Mockito.times((int)1))).addExecutableMenuItem((String)Matchers.eq((Object)"ucgridcontextmenu-duplicate-row"), (String)Matchers.eq((Object)ScenarioSimulationEditorConstants.INSTANCE.duplicateRow()), (String)Matchers.eq((Object)"duplicateRow"));
        ((UnmodifiableColumnGridContextMenu)Mockito.verify((Object)this.unmodifiableColumnGridContextMenuSpy, (VerificationMode)Mockito.times((int)1))).addExecutableMenuItem((String)Matchers.eq((Object)"ucgridcontextmenu-delete-row"), (String)Matchers.eq((Object)ScenarioSimulationEditorConstants.INSTANCE.deleteRow()), (String)Matchers.eq((Object)"deleteRow"));
        ((UnmodifiableColumnGridContextMenu)Mockito.verify((Object)this.unmodifiableColumnGridContextMenuSpy, (VerificationMode)Mockito.times((int)1))).addExecutableMenuItem((String)Matchers.eq((Object)"ucgridcontextmenu-run-single-scenario"), (String)Matchers.eq((Object)ScenarioSimulationEditorConstants.INSTANCE.runSingleScenario()), (String)Matchers.eq((Object)"runSingleScenario"));
    }

    @Test
    public void show_Simulation_NullRunScenarioElement() {
        this.unmodifiableColumnGridContextMenuSpy.runSingleScenarioElement = null;
        this.unmodifiableColumnGridContextMenuSpy.show(GridWidget.SIMULATION, 0, 0, 1);
        ((UnmodifiableColumnGridContextMenu)Mockito.verify((Object)this.unmodifiableColumnGridContextMenuSpy, (VerificationMode)Mockito.times((int)1))).show((GridWidget)Matchers.eq((Object)GridWidget.SIMULATION), Matchers.eq((int)0), Matchers.eq((int)0));
        ((UnmodifiableColumnGridContextMenu)Mockito.verify((Object)this.unmodifiableColumnGridContextMenuSpy, (VerificationMode)Mockito.times((int)1))).mapEvent((LIElement)Matchers.eq((Object)this.insertRowAboveLIElementMock), (Event)Matchers.isA(InsertRowEvent.class));
        ((UnmodifiableColumnGridContextMenu)Mockito.verify((Object)this.unmodifiableColumnGridContextMenuSpy, (VerificationMode)Mockito.times((int)1))).mapEvent((LIElement)Matchers.eq((Object)this.insertRowBelowLIElementMock), (Event)Matchers.isA(InsertRowEvent.class));
        ((UnmodifiableColumnGridContextMenu)Mockito.verify((Object)this.unmodifiableColumnGridContextMenuSpy, (VerificationMode)Mockito.times((int)1))).mapEvent((LIElement)Matchers.eq((Object)this.duplicateRowLIElementMock), (Event)Matchers.isA(DuplicateRowEvent.class));
        ((UnmodifiableColumnGridContextMenu)Mockito.verify((Object)this.unmodifiableColumnGridContextMenuSpy, (VerificationMode)Mockito.times((int)1))).mapEvent((LIElement)Matchers.eq((Object)this.deleteRowLIElementMock), (Event)Matchers.isA(DeleteRowEvent.class));
        ((UnmodifiableColumnGridContextMenu)Mockito.verify((Object)this.unmodifiableColumnGridContextMenuSpy, (VerificationMode)Mockito.times((int)1))).addExecutableMenuItem((String)Matchers.eq((Object)"ucgridcontextmenu-run-single-scenario"), (String)Matchers.eq((Object)ScenarioSimulationEditorConstants.INSTANCE.runSingleScenario()), (String)Matchers.eq((Object)"runSingleScenario"));
        ((UnmodifiableColumnGridContextMenu)Mockito.verify((Object)this.unmodifiableColumnGridContextMenuSpy, (VerificationMode)Mockito.times((int)1))).mapEvent((LIElement)Matchers.eq((Object)this.createdElementMock), (Event)Matchers.isA(RunSingleScenarioEvent.class));
    }

    @Test
    public void show_Simulation_NotNullRunScenarioElement() {
        this.unmodifiableColumnGridContextMenuSpy.show(GridWidget.SIMULATION, 0, 0, 1);
        ((UnmodifiableColumnGridContextMenu)Mockito.verify((Object)this.unmodifiableColumnGridContextMenuSpy, (VerificationMode)Mockito.times((int)1))).show((GridWidget)Matchers.eq((Object)GridWidget.SIMULATION), Matchers.eq((int)0), Matchers.eq((int)0));
        ((UnmodifiableColumnGridContextMenu)Mockito.verify((Object)this.unmodifiableColumnGridContextMenuSpy, (VerificationMode)Mockito.times((int)1))).mapEvent((LIElement)Matchers.eq((Object)this.insertRowAboveLIElementMock), (Event)Matchers.isA(InsertRowEvent.class));
        ((UnmodifiableColumnGridContextMenu)Mockito.verify((Object)this.unmodifiableColumnGridContextMenuSpy, (VerificationMode)Mockito.times((int)1))).mapEvent((LIElement)Matchers.eq((Object)this.insertRowBelowLIElementMock), (Event)Matchers.isA(InsertRowEvent.class));
        ((UnmodifiableColumnGridContextMenu)Mockito.verify((Object)this.unmodifiableColumnGridContextMenuSpy, (VerificationMode)Mockito.times((int)1))).mapEvent((LIElement)Matchers.eq((Object)this.duplicateRowLIElementMock), (Event)Matchers.isA(DuplicateRowEvent.class));
        ((UnmodifiableColumnGridContextMenu)Mockito.verify((Object)this.unmodifiableColumnGridContextMenuSpy, (VerificationMode)Mockito.times((int)1))).mapEvent((LIElement)Matchers.eq((Object)this.deleteRowLIElementMock), (Event)Matchers.isA(DeleteRowEvent.class));
        ((UnmodifiableColumnGridContextMenu)Mockito.verify((Object)this.unmodifiableColumnGridContextMenuSpy, (VerificationMode)Mockito.never())).addExecutableMenuItem((String)Matchers.eq((Object)"ucgridcontextmenu-run-single-scenario"), (String)Matchers.eq((Object)ScenarioSimulationEditorConstants.INSTANCE.runSingleScenario()), (String)Matchers.eq((Object)"runSingleScenario"));
        ((UnmodifiableColumnGridContextMenu)Mockito.verify((Object)this.unmodifiableColumnGridContextMenuSpy, (VerificationMode)Mockito.times((int)1))).mapEvent((LIElement)Matchers.eq((Object)this.runSingleScenarioElementMock), (Event)Matchers.isA(RunSingleScenarioEvent.class));
    }

    @Test
    public void show_Background_NullRunScenarioElement() {
        this.unmodifiableColumnGridContextMenuSpy.runSingleScenarioElement = null;
        this.unmodifiableColumnGridContextMenuSpy.show(GridWidget.BACKGROUND, 0, 0, 1);
        ((UnmodifiableColumnGridContextMenu)Mockito.verify((Object)this.unmodifiableColumnGridContextMenuSpy, (VerificationMode)Mockito.times((int)1))).show((GridWidget)Matchers.eq((Object)GridWidget.BACKGROUND), Matchers.eq((int)0), Matchers.eq((int)0));
        ((UnmodifiableColumnGridContextMenu)Mockito.verify((Object)this.unmodifiableColumnGridContextMenuSpy, (VerificationMode)Mockito.times((int)1))).mapEvent((LIElement)Matchers.eq((Object)this.insertRowAboveLIElementMock), (Event)Matchers.isA(InsertRowEvent.class));
        ((UnmodifiableColumnGridContextMenu)Mockito.verify((Object)this.unmodifiableColumnGridContextMenuSpy, (VerificationMode)Mockito.times((int)1))).mapEvent((LIElement)Matchers.eq((Object)this.insertRowBelowLIElementMock), (Event)Matchers.isA(InsertRowEvent.class));
        ((UnmodifiableColumnGridContextMenu)Mockito.verify((Object)this.unmodifiableColumnGridContextMenuSpy, (VerificationMode)Mockito.times((int)1))).mapEvent((LIElement)Matchers.eq((Object)this.duplicateRowLIElementMock), (Event)Matchers.isA(DuplicateRowEvent.class));
        ((UnmodifiableColumnGridContextMenu)Mockito.verify((Object)this.unmodifiableColumnGridContextMenuSpy, (VerificationMode)Mockito.times((int)1))).mapEvent((LIElement)Matchers.eq((Object)this.deleteRowLIElementMock), (Event)Matchers.isA(DeleteRowEvent.class));
        ((UnmodifiableColumnGridContextMenu)Mockito.verify((Object)this.unmodifiableColumnGridContextMenuSpy, (VerificationMode)Mockito.never())).addExecutableMenuItem((String)Matchers.eq((Object)"ucgridcontextmenu-run-single-scenario"), (String)Matchers.eq((Object)ScenarioSimulationEditorConstants.INSTANCE.runSingleScenario()), (String)Matchers.eq((Object)"runSingleScenario"));
        ((UnmodifiableColumnGridContextMenu)Mockito.verify((Object)this.unmodifiableColumnGridContextMenuSpy, (VerificationMode)Mockito.never())).mapEvent((LIElement)Matchers.eq((Object)this.createdElementMock), (Event)Matchers.isA(RunSingleScenarioEvent.class));
    }

    @Test
    public void show_Background_NotNullRunScenarioElement() {
        this.unmodifiableColumnGridContextMenuSpy.show(GridWidget.BACKGROUND, 0, 0, 1);
        ((UnmodifiableColumnGridContextMenu)Mockito.verify((Object)this.unmodifiableColumnGridContextMenuSpy, (VerificationMode)Mockito.times((int)1))).show((GridWidget)Matchers.eq((Object)GridWidget.BACKGROUND), Matchers.eq((int)0), Matchers.eq((int)0));
        ((UnmodifiableColumnGridContextMenu)Mockito.verify((Object)this.unmodifiableColumnGridContextMenuSpy, (VerificationMode)Mockito.times((int)1))).mapEvent((LIElement)Matchers.eq((Object)this.insertRowAboveLIElementMock), (Event)Matchers.isA(InsertRowEvent.class));
        ((UnmodifiableColumnGridContextMenu)Mockito.verify((Object)this.unmodifiableColumnGridContextMenuSpy, (VerificationMode)Mockito.times((int)1))).mapEvent((LIElement)Matchers.eq((Object)this.insertRowBelowLIElementMock), (Event)Matchers.isA(InsertRowEvent.class));
        ((UnmodifiableColumnGridContextMenu)Mockito.verify((Object)this.unmodifiableColumnGridContextMenuSpy, (VerificationMode)Mockito.times((int)1))).mapEvent((LIElement)Matchers.eq((Object)this.duplicateRowLIElementMock), (Event)Matchers.isA(DuplicateRowEvent.class));
        ((UnmodifiableColumnGridContextMenu)Mockito.verify((Object)this.unmodifiableColumnGridContextMenuSpy, (VerificationMode)Mockito.times((int)1))).mapEvent((LIElement)Matchers.eq((Object)this.deleteRowLIElementMock), (Event)Matchers.isA(DeleteRowEvent.class));
        ((UnmodifiableColumnGridContextMenu)Mockito.verify((Object)this.unmodifiableColumnGridContextMenuSpy, (VerificationMode)Mockito.never())).addExecutableMenuItem((String)Matchers.eq((Object)"ucgridcontextmenu-run-single-scenario"), (String)Matchers.eq((Object)ScenarioSimulationEditorConstants.INSTANCE.runSingleScenario()), (String)Matchers.eq((Object)"runSingleScenario"));
        ((UnmodifiableColumnGridContextMenu)Mockito.verify((Object)this.unmodifiableColumnGridContextMenuSpy, (VerificationMode)Mockito.never())).mapEvent((LIElement)Matchers.eq((Object)this.createdElementMock), (Event)Matchers.isA(RunSingleScenarioEvent.class));
        ((UListElement)Mockito.verify((Object)this.contextMenuDropdownMock, (VerificationMode)Mockito.times((int)1))).removeChild((Node)Matchers.eq((Object)this.runSingleScenarioElementMock));
    }
}

