/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.rightpanel;

import com.google.gwtmockito.GwtMockitoTestRunner;
import elemental2.dom.HTMLLIElement;
import elemental2.dom.HTMLUListElement;
import elemental2.dom.Node;
import java.util.HashMap;
import org.drools.scenariosimulation.api.model.Scenario;
import org.drools.scenariosimulation.api.model.ScenarioSimulationModel;
import org.drools.scenariosimulation.api.model.ScenarioWithIndex;
import org.drools.workbench.screens.scenariosimulation.client.resources.i18n.ScenarioSimulationEditorConstants;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.CoverageScenarioListPresenter;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.CoverageScenarioListView;
import org.drools.workbench.screens.scenariosimulation.client.utils.ViewsProvider;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=GwtMockitoTestRunner.class)
public class CoverageScenarioListPresenterTest {
    @Mock
    private ViewsProvider viewsProviderMock;
    @Mock
    private CoverageScenarioListView coverageScenarioListViewMock;
    @Mock
    private HTMLLIElement scenarioElementMock;
    @Mock
    private HTMLUListElement scenarioContentListMock;
    @Mock
    private HTMLUListElement scenarioList;
    private CoverageScenarioListPresenter coverageScenarioListPresenterSpy;

    @Before
    public void setup() {
        this.coverageScenarioListPresenterSpy = (CoverageScenarioListPresenter)Mockito.spy(CoverageScenarioListPresenter.class);
        this.coverageScenarioListPresenterSpy.viewsProvider = this.viewsProviderMock;
        this.coverageScenarioListPresenterSpy.initScenarioList(this.scenarioList);
        Mockito.when((Object)this.viewsProviderMock.getCoverageScenarioListView()).thenReturn((Object)this.coverageScenarioListViewMock);
        Mockito.when((Object)this.coverageScenarioListViewMock.getScenarioElement()).thenReturn((Object)this.scenarioElementMock);
        Mockito.when((Object)this.coverageScenarioListViewMock.getScenarioElement()).thenReturn((Object)this.scenarioElementMock);
        Mockito.when((Object)this.coverageScenarioListViewMock.getScenarioContentList()).thenReturn((Object)this.scenarioContentListMock);
    }

    @Test
    public void addScesimDataGroup_DMN() {
        int scenarioIndex = 1;
        String scenarioDescription = "description";
        String expectedLabel = ScenarioSimulationEditorConstants.INSTANCE.decisionsEvaluated() + " " + scenarioIndex + ": " + scenarioDescription;
        this.commonAddScesimDataGroup(ScenarioSimulationModel.Type.DMN, scenarioIndex, scenarioDescription, expectedLabel);
    }

    @Test
    public void addScesimDataGroup_RULE() {
        int scenarioIndex = 1;
        String scenarioDescription = "description";
        String expectedLabel = ScenarioSimulationEditorConstants.INSTANCE.rulesFired() + " " + scenarioIndex + ": " + scenarioDescription;
        this.commonAddScesimDataGroup(ScenarioSimulationModel.Type.RULE, scenarioIndex, scenarioDescription, expectedLabel);
    }

    private void commonAddScesimDataGroup(ScenarioSimulationModel.Type type, int scenarioIndex, String scenarioDescription, String expectedLabel) {
        Scenario scenario = new Scenario();
        scenario.setDescription(scenarioDescription);
        ScenarioWithIndex scenarioWithIndex = new ScenarioWithIndex(scenarioIndex, scenario);
        HashMap resultCounter = new HashMap();
        this.coverageScenarioListPresenterSpy.addScesimDataGroup(scenarioWithIndex, resultCounter, type);
        ((ViewsProvider)Mockito.verify((Object)this.viewsProviderMock, (VerificationMode)Mockito.times((int)1))).getCoverageScenarioListView();
        ((CoverageScenarioListView)Mockito.verify((Object)this.coverageScenarioListViewMock, (VerificationMode)Mockito.times((int)1))).setPresenter((CoverageScenarioListView.Presenter)Matchers.eq((Object)this.coverageScenarioListPresenterSpy));
        ((CoverageScenarioListView)Mockito.verify((Object)this.coverageScenarioListViewMock, (VerificationMode)Mockito.times((int)1))).setVisible(Matchers.eq((boolean)false));
        ((CoverageScenarioListView)Mockito.verify((Object)this.coverageScenarioListViewMock, (VerificationMode)Mockito.times((int)1))).getScenarioElement();
        ((CoverageScenarioListView)Mockito.verify((Object)this.coverageScenarioListViewMock, (VerificationMode)Mockito.times((int)1))).setItemLabel((String)Matchers.eq((Object)expectedLabel));
        ((HTMLLIElement)Mockito.verify((Object)this.scenarioElementMock, (VerificationMode)Mockito.times((int)1))).appendChild((Node)Matchers.isA(HTMLUListElement.class));
    }
}

