/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.editor.strategies;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.drools.scenariosimulation.api.model.AbstractScesimData;
import org.drools.scenariosimulation.api.model.AbstractScesimModel;
import org.drools.scenariosimulation.api.model.ExpressionElement;
import org.drools.scenariosimulation.api.model.FactMappingType;
import org.drools.scenariosimulation.api.model.ScenarioSimulationModel;
import org.drools.scenariosimulation.api.model.ScesimModelDescriptor;
import org.drools.workbench.screens.scenariosimulation.client.commands.ScenarioSimulationContext;
import org.drools.workbench.screens.scenariosimulation.client.editor.strategies.DataManagementStrategy;
import org.drools.workbench.screens.scenariosimulation.client.enums.GridWidget;
import org.drools.workbench.screens.scenariosimulation.client.models.AbstractScesimGridModel;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.TestToolsPresenterData;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.TestToolsView;
import org.drools.workbench.screens.scenariosimulation.client.widgets.ScenarioGridColumn;
import org.drools.workbench.screens.scenariosimulation.model.typedescriptor.FactModelTree;
import org.drools.workbench.screens.scenariosimulation.model.typedescriptor.FactModelTuple;

public abstract class AbstractDataManagementStrategy
implements DataManagementStrategy {
    protected ScenarioSimulationModel model;
    protected ResultHolder factModelTreeHolder = new ResultHolder();

    @Override
    public void setModel(ScenarioSimulationModel model) {
        this.model = model;
    }

    public static FactModelTree getSimpleClassFactModelTree(String simpleClass, String canonicalName) {
        String key = simpleClass;
        HashMap<String, String> simpleProperties = new HashMap<String, String>();
        String fullName = canonicalName;
        simpleProperties.put("value", fullName);
        String packageName = fullName.substring(0, fullName.lastIndexOf(46));
        FactModelTree toReturn = new FactModelTree(key, packageName, simpleProperties, new HashMap());
        toReturn.setSimple(true);
        return toReturn;
    }

    public <T extends AbstractScesimModel<E>, E extends AbstractScesimData> Map<String, List<List<String>>> getPropertiesToHide(AbstractScesimGridModel<T, E> abstractScesimGridModel) {
        HashMap<String, List<List<String>>> toReturn = new HashMap<String, List<List<String>>>();
        ScenarioGridColumn selectedColumn = (ScenarioGridColumn)abstractScesimGridModel.getSelectedColumn();
        if (selectedColumn != null && selectedColumn.isInstanceAssigned()) {
            toReturn.put(selectedColumn.getInformationHeaderMetaData().getTitle(), this.getPropertiesToHide(selectedColumn, abstractScesimGridModel));
        }
        return toReturn;
    }

    protected <T extends AbstractScesimModel<E>, E extends AbstractScesimData> List<List<String>> getPropertiesToHide(ScenarioGridColumn selectedColumn, AbstractScesimGridModel<T, E> abstractScesimGridModel) {
        ArrayList<List<String>> toReturn = new ArrayList<List<String>>();
        if (!selectedColumn.isPropertyAssigned()) {
            abstractScesimGridModel.getAbstractScesimModel().ifPresent(simulation -> {
                ScesimModelDescriptor simulationDescriptor = simulation.getScesimModelDescriptor();
                List<ScenarioGridColumn> instanceColumns = abstractScesimGridModel.getInstanceScenarioGridColumns(selectedColumn);
                toReturn.addAll(instanceColumns.stream().filter(ScenarioGridColumn::isPropertyAssigned).map(instanceColumn -> abstractScesimGridModel.getColumns().indexOf(instanceColumn)).map(columnIndex -> {
                    List propertyNameElements = simulationDescriptor.getFactMappingByIndex(columnIndex.intValue()).getExpressionElementsWithoutClass().stream().map(ExpressionElement::getStep).collect(Collectors.toList());
                    if (propertyNameElements.isEmpty()) {
                        propertyNameElements.add("value");
                    }
                    return Collections.unmodifiableList(propertyNameElements);
                }).collect(Collectors.toList()));
            });
        }
        return toReturn;
    }

    public void storeData(FactModelTuple factModelTuple, TestToolsView.Presenter testToolsPresenter, ScenarioSimulationContext context, GridWidget gridWidget) {
        Map<String, List<List<String>>> propertiesToHide = this.getPropertiesToHide(context.getAbstractScesimGridModelByGridWidget(gridWidget));
        SortedMap visibleFacts = factModelTuple.getVisibleFacts();
        Map<Boolean, List<Map.Entry>> partitionBy = visibleFacts.entrySet().stream().collect(Collectors.partitioningBy(stringFactModelTreeEntry -> ((FactModelTree)stringFactModelTreeEntry.getValue()).isSimple()));
        TreeMap<String, FactModelTree> complexDataObjects = new TreeMap<String, FactModelTree>(partitionBy.get(false).stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
        TreeMap<String, FactModelTree> simpleDataObjects = new TreeMap<String, FactModelTree>(partitionBy.get(true).stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
        TreeMap<String, FactModelTree> dataObjectFieldsMap = new TreeMap<String, FactModelTree>();
        dataObjectFieldsMap.putAll(visibleFacts);
        dataObjectFieldsMap.putAll(factModelTuple.getHiddenFacts());
        context.setDataObjectFieldsMap(dataObjectFieldsMap);
        TreeMap<String, FactModelTree> instanceFieldsMap = new TreeMap();
        SortedMap<String, FactModelTree> simpleJavaTypeInstanceFieldsMap = new TreeMap<String, FactModelTree>();
        if (GridWidget.SIMULATION.equals((Object)gridWidget)) {
            instanceFieldsMap = this.getInstanceMap(complexDataObjects);
            simpleJavaTypeInstanceFieldsMap = this.getInstanceMap(simpleDataObjects);
            HashSet<String> dataObjectsInstancesName = new HashSet<String>(visibleFacts.keySet());
            dataObjectsInstancesName.addAll(instanceFieldsMap.keySet());
            context.setDataObjectsInstancesName(dataObjectsInstancesName);
            HashSet<String> simpleJavaTypeInstancesName = new HashSet<String>(simpleDataObjects.keySet());
            simpleJavaTypeInstancesName.addAll(simpleJavaTypeInstanceFieldsMap.keySet());
            context.getAbstractScesimGridModelByGridWidget(gridWidget).setSimpleJavaTypeInstancesName(simpleJavaTypeInstancesName);
        }
        TestToolsPresenterData testToolsPresenterData = new TestToolsPresenterData(complexDataObjects, simpleDataObjects, instanceFieldsMap, simpleJavaTypeInstanceFieldsMap, factModelTuple.getHiddenFacts(), propertiesToHide, gridWidget);
        testToolsPresenter.populateTestTools(testToolsPresenterData);
    }

    public SortedMap<String, FactModelTree> getInstanceMap(SortedMap<String, FactModelTree> sourceMap) {
        TreeMap<String, FactModelTree> toReturn = new TreeMap<String, FactModelTree>();
        if (this.model != null) {
            ScesimModelDescriptor simulationDescriptor = this.model.getSimulation().getScesimModelDescriptor();
            simulationDescriptor.getUnmodifiableFactMappings().stream().filter(factMapping -> !Objects.equals(FactMappingType.OTHER, factMapping.getExpressionIdentifier().getType())).forEach(factMapping -> {
                FactModelTree factModelTree;
                String dataObjectName = factMapping.getFactIdentifier().getClassNameWithoutPackage();
                String instanceName = factMapping.getFactAlias();
                if (!instanceName.equals(dataObjectName) && (factModelTree = (FactModelTree)sourceMap.get(dataObjectName)) != null) {
                    toReturn.put(instanceName, factModelTree);
                }
            });
        }
        return toReturn;
    }

    public static class ResultHolder {
        FactModelTuple factModelTuple;

        public FactModelTuple getFactModelTuple() {
            return this.factModelTuple;
        }

        public void setFactModelTuple(FactModelTuple factModelTuple) {
            this.factModelTuple = factModelTuple;
        }
    }
}

