/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.rightpanel;

import com.google.gwt.dom.client.AnchorElement;
import com.google.gwt.dom.client.ButtonElement;
import com.google.gwt.dom.client.DivElement;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.InputElement;
import com.google.gwt.dom.client.LabelElement;
import com.google.gwt.dom.client.Node;
import com.google.gwt.dom.client.ParagraphElement;
import com.google.gwt.dom.client.SpanElement;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.KeyDownEvent;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.user.client.ui.Composite;
import java.util.Arrays;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import org.drools.workbench.screens.scenariosimulation.client.resources.i18n.ScenarioSimulationEditorConstants;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.TestToolsView;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.Templated;

@ApplicationScoped
@Templated(stylesheet="/org/drools/workbench/screens/scenariosimulation/client/resources/css/ScenarioSimulationEditorStyles.css")
public class TestToolsViewImpl
extends Composite
implements TestToolsView {
    protected TestToolsView.Presenter presenter;
    @DataField(value="testToolsDescriptionElement")
    protected ParagraphElement testToolsDescriptionElement = Document.get().createPElement();
    @DataField(value="testToolObjectSelectionTitleElement")
    protected LabelElement testToolObjectSelectionTitleElement = Document.get().createLabelElement();
    @DataField(value="clearSelectionElement")
    protected AnchorElement clearSelectionElement = Document.get().createAnchorElement();
    @DataField(value="infoSelectDataObjectElement")
    protected SpanElement infoSelectDataObjectElement = Document.get().createSpanElement();
    @DataField(value="clearSearchButton")
    protected ButtonElement clearSearchButton = Document.get().createPushButtonElement();
    @DataField(value="searchButton")
    protected ButtonElement searchButton = Document.get().createPushButtonElement();
    @DataField(value="inputSearch")
    protected InputElement inputSearch = Document.get().createTextInputElement();
    @DataField(value="dataObjectListContainer")
    protected DivElement dataObjectListContainer = Document.get().createDivElement();
    @DataField(value="simpleJavaTypeListContainer")
    protected DivElement simpleJavaTypeListContainer = Document.get().createDivElement();
    @DataField(value="instanceListContainer-separator")
    protected SpanElement instanceListContainerSeparator = Document.get().createSpanElement();
    @DataField(value="instanceListContainer")
    protected DivElement instanceListContainer = Document.get().createDivElement();
    @DataField(value="simpleJavaInstanceListContainer")
    protected DivElement simpleJavaInstanceListContainer = Document.get().createDivElement();
    @DataField(value="addButtonLabel")
    protected DivElement addButtonLabel = Document.get().createDivElement();
    @DataField(value="addButton")
    protected ButtonElement addButton = Document.get().createPushButtonElement();
    @DataField(value="kieTestToolsContent")
    protected DivElement kieTestToolsContent = Document.get().createDivElement();
    protected List<DivElement> managedDivElements = Arrays.asList(this.dataObjectListContainer, this.simpleJavaTypeListContainer, this.instanceListContainer, this.simpleJavaTypeListContainer);

    public void init(TestToolsView.Presenter presenter) {
        this.presenter = presenter;
        this.disableEditorTab();
        this.testToolsDescriptionElement.setInnerText(ScenarioSimulationEditorConstants.INSTANCE.testToolsDescription());
        this.testToolObjectSelectionTitleElement.setInnerText(ScenarioSimulationEditorConstants.INSTANCE.testToolObjectSelectionTitle());
        this.clearSelectionElement.setInnerText(ScenarioSimulationEditorConstants.INSTANCE.testToolClearSelection());
        this.addButton.setInnerText(ScenarioSimulationEditorConstants.INSTANCE.testToolsAddButton());
        this.addButtonLabel.setInnerText(ScenarioSimulationEditorConstants.INSTANCE.testToolsAddButtonLabel());
        this.instanceListContainerSeparator.setInnerText(ScenarioSimulationEditorConstants.INSTANCE.dataObjectInstances());
        this.infoSelectDataObjectElement.setAttribute("title", ScenarioSimulationEditorConstants.INSTANCE.testToolObjectSelectionTooltip());
    }

    @Override
    public TestToolsView.Presenter getPresenter() {
        return this.presenter;
    }

    @Override
    public void reset() {
        this.clearDataObjectList();
        this.clearSimpleJavaTypeList();
        this.showInstanceListContainerSeparator(false);
        this.clearInstanceList();
        this.clearSimpleJavaInstanceFieldList();
    }

    @EventHandler(value={"clearSearchButton"})
    public void onClearSearchButtonClick(ClickEvent event) {
        this.presenter.onUndoSearch();
    }

    @EventHandler(value={"inputSearch"})
    public void onInputSearchKeyUp(KeyUpEvent event) {
        this.presenter.onShowClearButton();
    }

    @EventHandler(value={"inputSearch"})
    public void onInputSearchKeyDownEvent(KeyDownEvent event) {
        if (event.getNativeKeyCode() == 13) {
            this.presenter.onSearchedEvent(this.inputSearch.getValue());
        }
    }

    @EventHandler(value={"clearSelectionElement"})
    public void onClearSelectionElementClicked(ClickEvent event) {
        this.presenter.clearSelection();
    }

    @EventHandler(value={"searchButton"})
    public void onSearchButtonClicked(ClickEvent event) {
        this.presenter.onSearchedEvent(this.inputSearch.getValue());
    }

    @EventHandler(value={"addButton"})
    public void onAddButtonClicked(ClickEvent event) {
        this.presenter.onModifyColumn();
        this.addButton.setDisabled(true);
        this.presenter.onDisableEditorTab();
    }

    @Override
    public void clearInputSearch() {
        this.inputSearch.setValue("");
    }

    @Override
    public void hideClearButton() {
        this.clearSearchButton.setDisabled(true);
        this.clearSearchButton.setAttribute("style", "display: none;");
    }

    @Override
    public void showClearButton() {
        this.clearSearchButton.setDisabled(false);
        this.clearSearchButton.removeAttribute("style");
    }

    @Override
    public void clearDataObjectList() {
        this.dataObjectListContainer.removeAllChildren();
        this.dataObjectListContainer.getStyle().setDisplay(Style.Display.NONE);
    }

    @Override
    public void clearSimpleJavaTypeList() {
        this.simpleJavaTypeListContainer.removeAllChildren();
        this.simpleJavaTypeListContainer.getStyle().setDisplay(Style.Display.NONE);
    }

    @Override
    public void clearInstanceList() {
        this.instanceListContainer.removeAllChildren();
        this.instanceListContainer.getStyle().setDisplay(Style.Display.NONE);
    }

    @Override
    public void clearSimpleJavaInstanceFieldList() {
        this.simpleJavaInstanceListContainer.removeAllChildren();
        this.simpleJavaInstanceListContainer.getStyle().setDisplay(Style.Display.NONE);
    }

    @Override
    public void addDataObjectListGroupItem(DivElement item) {
        this.dataObjectListContainer.getStyle().setDisplay(Style.Display.BLOCK);
        this.dataObjectListContainer.appendChild((Node)item);
    }

    @Override
    public void addSimpleJavaTypeListGroupItem(DivElement item) {
        this.simpleJavaTypeListContainer.getStyle().setDisplay(Style.Display.BLOCK);
        this.simpleJavaTypeListContainer.appendChild((Node)item);
    }

    @Override
    public void addInstanceListGroupItem(DivElement item) {
        this.instanceListContainer.getStyle().setDisplay(Style.Display.BLOCK);
        this.instanceListContainer.appendChild((Node)item);
    }

    @Override
    public void addSimpleJavaInstanceListGroupItem(DivElement item) {
        this.simpleJavaInstanceListContainer.getStyle().setDisplay(Style.Display.BLOCK);
        this.simpleJavaInstanceListContainer.appendChild((Node)item);
    }

    @Override
    public void updateInstanceListSeparator(boolean show) {
        if (!show || this.instanceListContainer.getChildCount() < 1 && this.simpleJavaInstanceListContainer.getChildCount() < 1) {
            this.instanceListContainerSeparator.getStyle().setDisplay(Style.Display.NONE);
        } else {
            this.instanceListContainerSeparator.getStyle().setDisplay(Style.Display.BLOCK);
        }
    }

    @Override
    public void showInstanceListContainerSeparator(boolean show) {
        if (show) {
            this.instanceListContainerSeparator.getStyle().setDisplay(Style.Display.BLOCK);
        } else {
            this.instanceListContainerSeparator.getStyle().setDisplay(Style.Display.NONE);
        }
    }

    @Override
    public void enableEditorTab() {
        this.setDisabledStatus(false);
    }

    @Override
    public void disableEditorTab() {
        this.setDisabledStatus(true);
    }

    @Override
    public void enableSearch() {
        this.clearSearchButton.setDisabled(false);
        this.searchButton.setDisabled(false);
        this.inputSearch.setDisabled(false);
    }

    @Override
    public void disableSearch() {
        this.hideClearButton();
        this.searchButton.setDisabled(true);
        this.inputSearch.setDisabled(true);
        this.inputSearch.setValue("");
    }

    @Override
    public void enableAddButton() {
        this.addButton.setDisabled(false);
    }

    @Override
    public void disableAddButton() {
        this.addButton.setDisabled(true);
    }

    protected void setDisabledStatus(boolean disabled) {
        this.setClearSelectionAnchorDisabledStatus(disabled);
        this.setInfoSelectDataObjectElementDisabledStatus(disabled);
        this.setContainersDisabledStatus(disabled);
        if (disabled) {
            this.kieTestToolsContent.addClassName("disabled");
            this.disableSearch();
            this.disableAddButton();
        } else {
            this.kieTestToolsContent.removeClassName("disabled");
        }
    }

    protected void setContainersDisabledStatus(boolean disabled) {
        if (disabled) {
            this.managedDivElements.forEach(divElement -> divElement.addClassName("disabled"));
        } else {
            this.managedDivElements.forEach(divElement -> divElement.removeClassName("disabled"));
        }
    }

    protected void setClearSelectionAnchorDisabledStatus(boolean disabled) {
        if (disabled) {
            this.clearSelectionElement.addClassName("disabled");
        } else {
            this.clearSelectionElement.removeClassName("disabled");
        }
    }

    protected void setInfoSelectDataObjectElementDisabledStatus(boolean disabled) {
        if (disabled) {
            this.infoSelectDataObjectElement.addClassName("disabled");
        } else {
            this.infoSelectDataObjectElement.removeClassName("disabled");
        }
    }
}

