/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.domelements;

import com.ait.lienzo.test.LienzoMockitoTestRunner;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.user.client.ui.AbsolutePanel;
import org.drools.workbench.screens.scenariosimulation.client.collectioneditor.CollectionViewImpl;
import org.drools.workbench.screens.scenariosimulation.client.domelements.CollectionEditorDOMElement;
import org.drools.workbench.screens.scenariosimulation.client.events.SetGridCellValueEvent;
import org.drools.workbench.screens.scenariosimulation.client.factories.AbstractFactoriesTest;
import org.drools.workbench.screens.scenariosimulation.client.widgets.ScenarioGridCell;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.wires.core.grids.client.model.GridCellValue;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;
import org.uberfire.ext.wires.core.grids.client.widget.layer.GridLayer;

@RunWith(value=LienzoMockitoTestRunner.class)
public class CollectionEditorDOMElementTest
extends AbstractFactoriesTest {
    private static final String WIDGET_VALUE = "WIDGET VALUE";
    private static final int TAB_INDEX = 1;
    @Mock
    private ScenarioGridCell scenarioGridCellMock;
    @Mock
    private CollectionViewImpl widgetMock;
    @Mock
    private GridCellValue gridCellValueMock;
    private CollectionEditorDOMElement collectionEditorDOMElementSpy;

    @Override
    @Before
    public void setup() {
        super.setup();
        Mockito.when((Object)this.elementMock.getStyle()).thenReturn((Object)this.styleMock);
        Mockito.when((Object)this.widgetMock.getElement()).thenReturn((Object)this.elementMock);
        Mockito.when((Object)this.widgetMock.getValue()).thenReturn((Object)WIDGET_VALUE);
        Mockito.when((Object)this.widgetMock.getTabIndex()).thenReturn((Object)1);
        Mockito.when((Object)this.scenarioGridLayerMock.getDomElementContainer()).thenReturn((Object)new AbsolutePanel());
        Mockito.when((Object)this.scenarioGridCellMock.getValue()).thenReturn((Object)this.gridCellValueMock);
        this.collectionEditorDOMElementSpy = (CollectionEditorDOMElement)Mockito.spy((Object)new CollectionEditorDOMElement(this.widgetMock, (GridLayer)this.scenarioGridLayerMock, (GridWidget)this.scenarioGridMock){
            {
                this.context = CollectionEditorDOMElementTest.this.contextMock;
                this.scenarioGridCell = CollectionEditorDOMElementTest.this.scenarioGridCellMock;
            }
        });
    }

    @Test
    public void getValue() {
        Assert.assertEquals((Object)WIDGET_VALUE, (Object)this.collectionEditorDOMElementSpy.getValue());
    }

    @Test
    public void setValue() {
        String newValue = "New Value";
        this.collectionEditorDOMElementSpy.setValue("New Value");
        ((CollectionViewImpl)Mockito.verify((Object)this.widgetMock, (VerificationMode)Mockito.times((int)1))).setValue((String)Matchers.eq((Object)"New Value"));
    }

    @Test
    public void getTabIndex() {
        Assert.assertEquals((long)1L, (long)this.collectionEditorDOMElementSpy.getTabIndex());
    }

    @Test
    public void setTabIndex() {
        int newIndex = 2;
        this.collectionEditorDOMElementSpy.setTabIndex(2);
        ((CollectionViewImpl)Mockito.verify((Object)this.widgetMock, (VerificationMode)Mockito.times((int)1))).setTabIndex(Matchers.eq((int)2));
    }

    @Test
    public void setAccessKey() {
        int newAccessKey = 105;
        this.collectionEditorDOMElementSpy.setAccessKey('i');
        ((CollectionViewImpl)Mockito.verify((Object)this.widgetMock, (VerificationMode)Mockito.times((int)1))).setAccessKey(Matchers.eq((char)'i'));
    }

    @Test
    public void setFocus() {
        this.collectionEditorDOMElementSpy.setFocus(true);
        ((CollectionViewImpl)Mockito.verify((Object)this.widgetMock, (VerificationMode)Mockito.times((int)1))).setFocus(Matchers.eq((boolean)true));
        Mockito.reset((Object[])new CollectionViewImpl[]{this.widgetMock});
        this.collectionEditorDOMElementSpy.setFocus(false);
        ((CollectionViewImpl)Mockito.verify((Object)this.widgetMock, (VerificationMode)Mockito.times((int)1))).setFocus(Matchers.eq((boolean)false));
    }

    @Test
    public void flushNullGridCell() {
        this.collectionEditorDOMElementSpy.scenarioGridCell = null;
        String newValue = "New Value";
        this.collectionEditorDOMElementSpy.flush("New Value");
        ((ScenarioGridCell)Mockito.verify((Object)this.scenarioGridCellMock, (VerificationMode)Mockito.never())).setEditingMode(Matchers.anyBoolean());
        ((ScenarioGridCell)Mockito.verify((Object)this.scenarioGridCellMock, (VerificationMode)Mockito.never())).getValue();
        ((CollectionEditorDOMElement)Mockito.verify((Object)this.collectionEditorDOMElementSpy, (VerificationMode)Mockito.times((int)1))).internalFlush((String)Matchers.eq((Object)"New Value"));
    }

    @Test
    public void flushNotNullGridCell() {
        String newValue = "New Value";
        this.collectionEditorDOMElementSpy.flush("New Value");
        ((ScenarioGridCell)Mockito.verify((Object)this.scenarioGridCellMock, (VerificationMode)Mockito.times((int)1))).setEditingMode(Matchers.anyBoolean());
        ((ScenarioGridCell)Mockito.verify((Object)this.scenarioGridCellMock, (VerificationMode)Mockito.times((int)1))).getValue();
        ((CollectionEditorDOMElement)Mockito.verify((Object)this.collectionEditorDOMElementSpy, (VerificationMode)Mockito.times((int)1))).internalFlush((String)Matchers.eq((Object)"New Value"));
    }

    @Test
    public void internalFlush() {
        String newValue = "New Value";
        this.collectionEditorDOMElementSpy.internalFlush("New Value");
        ((EventBus)Mockito.verify((Object)this.eventBusMock, (VerificationMode)Mockito.times((int)1))).fireEvent((GwtEvent)Matchers.isA(SetGridCellValueEvent.class));
    }
}

