/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.domelements;

import com.ait.lienzo.test.LienzoMockitoTestRunner;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.ui.AbsolutePanel;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import org.drools.workbench.screens.scenariosimulation.client.domelements.ScenarioCellTextAreaDOMElement;
import org.drools.workbench.screens.scenariosimulation.client.events.SetGridCellValueEvent;
import org.drools.workbench.screens.scenariosimulation.client.factories.AbstractFactoriesTest;
import org.drools.workbench.screens.scenariosimulation.client.widgets.ScenarioGridCell;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.wires.core.grids.client.model.GridCellValue;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;
import org.uberfire.ext.wires.core.grids.client.widget.layer.GridLayer;

@RunWith(value=LienzoMockitoTestRunner.class)
public class ScenarioCellTextAreaDOMElementTest
extends AbstractFactoriesTest {
    @Mock
    private ScenarioGridCell scenarioGridCellMock;
    @Mock
    private GridCellValue gridCellValueMock;
    @Mock
    private Element elementMock;
    @Mock
    private Style styleMock;
    @Mock
    private SimplePanel simplePanelMock;
    private ScenarioCellTextAreaDOMElement scenarioCellTextAreaDOMElementSpy;

    @Override
    @Before
    public void setup() {
        super.setup();
        Mockito.when((Object)this.scenarioGridLayerMock.getDomElementContainer()).thenReturn((Object)new AbsolutePanel());
        Mockito.when((Object)this.scenarioGridCellMock.getValue()).thenReturn((Object)this.gridCellValueMock);
        Mockito.when((Object)this.textAreaMock.getElement()).thenReturn((Object)this.elementMock);
        Mockito.when((Object)this.elementMock.getStyle()).thenReturn((Object)this.styleMock);
        this.scenarioCellTextAreaDOMElementSpy = (ScenarioCellTextAreaDOMElement)Mockito.spy((Object)new ScenarioCellTextAreaDOMElement(this.textAreaMock, (GridLayer)this.scenarioGridLayerMock, (GridWidget)this.scenarioGridMock){
            {
                this.context = ScenarioCellTextAreaDOMElementTest.this.contextMock;
                this.scenarioGridCell = ScenarioCellTextAreaDOMElementTest.this.scenarioGridCellMock;
            }

            protected SimplePanel getContainer() {
                return ScenarioCellTextAreaDOMElementTest.this.simplePanelMock;
            }
        });
    }

    @Test
    public void init() {
        ((Style)Mockito.verify((Object)this.styleMock, (VerificationMode)Mockito.times((int)1))).setWidth(100.0, Style.Unit.PCT);
        ((Style)Mockito.verify((Object)this.styleMock, (VerificationMode)Mockito.times((int)1))).setHeight(100.0, Style.Unit.PCT);
        ((Style)Mockito.verify((Object)this.styleMock, (VerificationMode)Mockito.times((int)1))).setFontSize(12.0, Style.Unit.PX);
        ((Style)Mockito.verify((Object)this.styleMock, (VerificationMode)Mockito.times((int)1))).setProperty("resize", "none");
        ((SimplePanel)Mockito.verify((Object)this.simplePanelMock, (VerificationMode)Mockito.times((int)1))).setWidget((Widget)Matchers.eq((Object)this.textAreaMock));
    }

    @Test
    public void flushSameValue() {
        Mockito.when((Object)this.gridCellValueMock.getValue()).thenReturn((Object)"MULTIPART.VALUE");
        this.scenarioCellTextAreaDOMElementSpy.flush("MULTIPART.VALUE");
        ((ScenarioGridCell)Mockito.verify((Object)this.scenarioGridCellMock, (VerificationMode)Mockito.times((int)1))).setEditingMode(Matchers.eq((boolean)false));
        ((ScenarioCellTextAreaDOMElement)Mockito.verify((Object)this.scenarioCellTextAreaDOMElementSpy, (VerificationMode)Mockito.never())).internalFlush(Matchers.anyString());
    }

    @Test
    public void flushDifferentValue() {
        Mockito.when((Object)this.gridCellValueMock.getValue()).thenReturn((Object)"test");
        this.scenarioCellTextAreaDOMElementSpy.flush("MULTIPART.VALUE");
        ((ScenarioGridCell)Mockito.verify((Object)this.scenarioGridCellMock, (VerificationMode)Mockito.times((int)1))).setEditingMode(Matchers.eq((boolean)false));
        ((ScenarioCellTextAreaDOMElement)Mockito.verify((Object)this.scenarioCellTextAreaDOMElementSpy, (VerificationMode)Mockito.times((int)1))).internalFlush((String)Matchers.eq((Object)"MULTIPART.VALUE"));
    }

    @Test
    public void flushNullString() {
        Mockito.when((Object)this.gridCellValueMock.getValue()).thenReturn((Object)"");
        this.scenarioCellTextAreaDOMElementSpy.flush(null);
        ((ScenarioGridCell)Mockito.verify((Object)this.scenarioGridCellMock, (VerificationMode)Mockito.times((int)1))).setEditingMode(Matchers.eq((boolean)false));
        ((ScenarioCellTextAreaDOMElement)Mockito.verify((Object)this.scenarioCellTextAreaDOMElementSpy, (VerificationMode)Mockito.times((int)1))).internalFlush((String)Matchers.eq(null));
    }

    @Test
    public void flushEmptyStringToNullConversion() {
        Mockito.when((Object)this.gridCellValueMock.getValue()).thenReturn((Object)"");
        this.scenarioCellTextAreaDOMElementSpy.flush("");
        ((ScenarioGridCell)Mockito.verify((Object)this.scenarioGridCellMock, (VerificationMode)Mockito.times((int)1))).setEditingMode(Matchers.eq((boolean)false));
        ((ScenarioCellTextAreaDOMElement)Mockito.verify((Object)this.scenarioCellTextAreaDOMElementSpy, (VerificationMode)Mockito.times((int)1))).internalFlush((String)Matchers.eq(null));
    }

    @Test
    public void internalFlush() {
        this.scenarioCellTextAreaDOMElementSpy.internalFlush("MULTIPART.VALUE");
        ((EventBus)Mockito.verify((Object)this.eventBusMock, (VerificationMode)Mockito.times((int)1))).fireEvent((GwtEvent)Matchers.isA(SetGridCellValueEvent.class));
    }

    @Test
    public void testDetachCancelEditMode() {
        this.scenarioCellTextAreaDOMElementSpy.detach();
        ((ScenarioGridCell)Mockito.verify((Object)this.scenarioGridCellMock)).setEditingMode(false);
    }
}

