/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.rightpanel;

import com.google.gwt.dom.client.DivElement;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.FieldItemPresenter;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.FieldItemView;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.ListGroupItemView;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.TestToolsView;
import org.drools.workbench.screens.scenariosimulation.client.utils.ViewsProvider;
import org.drools.workbench.screens.scenariosimulation.model.typedescriptor.FactModelTree;

@Dependent
public class ListGroupItemPresenter
implements ListGroupItemView.Presenter {
    @Inject
    protected ViewsProvider viewsProvider;
    @Inject
    protected FieldItemPresenter fieldItemPresenter;
    protected TestToolsView.Presenter testToolsPresenter;
    protected Map<String, ListGroupItemView> listGroupItemViewMap = new HashMap<String, ListGroupItemView>();
    private AtomicBoolean disabled = new AtomicBoolean(true);
    private String filterTerm = null;

    @Override
    public void enable() {
        this.disabled.set(false);
        this.filterTerm = null;
    }

    @Override
    public void enable(String filterTerm) {
        this.disabled.set(false);
        this.filterTerm = filterTerm;
    }

    @Override
    public void unselectAll() {
        this.listGroupItemViewMap.values().forEach(ListGroupItemView::unselect);
    }

    @Override
    public void showAll() {
        this.fieldItemPresenter.showAll();
    }

    @Override
    public void selectProperty(String factName, List<String> propertyParts) {
        String key;
        ListGroupItemView instanceListGroupItemView = this.listGroupItemViewMap.get(factName);
        if (!instanceListGroupItemView.isShown()) {
            this.onToggleRowExpansion(instanceListGroupItemView, false);
        }
        for (int i = 1; i < propertyParts.size(); ++i) {
            String subPart = String.join((CharSequence)".", propertyParts.subList(0, i));
            key = factName + "." + subPart;
            ListGroupItemView subListGroupItemView = this.listGroupItemViewMap.get(key);
            if (subListGroupItemView == null || subListGroupItemView.isShown()) continue;
            this.onToggleRowExpansion(subListGroupItemView, false);
        }
        key = factName + "." + String.join((CharSequence)".", propertyParts);
        if (this.fieldItemPresenter.fieldItemMap.containsKey(key)) {
            this.fieldItemPresenter.fieldItemMap.get(key).onFieldElementSelected();
        } else {
            instanceListGroupItemView.showCheck(true);
        }
    }

    @Override
    public void hideProperty(String factName, List<String> propertyParts) {
        String key = factName + "." + String.join((CharSequence)".", propertyParts);
        if (this.fieldItemPresenter.fieldItemMap.containsKey(key)) {
            this.fieldItemPresenter.fieldItemMap.get(key).hide();
        }
    }

    @Override
    public boolean isInstanceAssigned(String factName) {
        return this.listGroupItemViewMap.get(factName).isInstanceAssigned();
    }

    @Override
    public void setInstanceAssigned(String factName, boolean assigned) {
        this.listGroupItemViewMap.get(factName).setInstanceAssigned(assigned);
    }

    @Override
    public void disable() {
        this.disabled.set(true);
        this.filterTerm = null;
        this.listGroupItemViewMap.values().forEach(ListGroupItemView::closeRow);
        this.unselectAll();
        this.fieldItemPresenter.unselectAll();
    }

    @Override
    public void init(TestToolsView.Presenter testToolsPresenter) {
        this.testToolsPresenter = testToolsPresenter;
        this.fieldItemPresenter.setListGroupItemPresenter(this);
    }

    @Override
    public DivElement getDivElement(String factName, FactModelTree factModelTree) {
        ListGroupItemView listGroupItemView = this.commonGetListGroupItemView("", factName, false);
        this.populateListGroupItemView(listGroupItemView, "", factName, factModelTree);
        return listGroupItemView.getListGroupItem();
    }

    @Override
    public DivElement getDivElement(String fullPath, String factName, String factModelTreeClass) {
        ListGroupItemView listGroupItemView = this.commonGetListGroupItemView(fullPath, factName, true);
        this.populateListGroupItemView(listGroupItemView, factName, factModelTreeClass);
        return listGroupItemView.getListGroupExpansion();
    }

    @Override
    public void onToggleRowExpansion(ListGroupItemView listGroupItemView, boolean currentlyShown) {
        if (this.disabled.get()) {
            return;
        }
        if (currentlyShown) {
            listGroupItemView.closeRow();
        } else {
            FactModelTree factModelTree;
            if (listGroupItemView.isToExpand() && (factModelTree = this.testToolsPresenter.getFactModelTreeFromFactTypeMap(listGroupItemView.getFactType()).orElseGet(() -> this.testToolsPresenter.getFactModelTreeFromHiddenMap(listGroupItemView.getFactType()))) != null) {
                this.populateListGroupItemView(listGroupItemView, listGroupItemView.getParentPath(), listGroupItemView.getFactName(), factModelTree);
                listGroupItemView.setToExpand(false);
            }
            listGroupItemView.expandRow();
        }
    }

    @Override
    public void onSelectedElement(ListGroupItemView selected) {
        this.testToolsPresenter.setSelectedElement(selected);
        this.listGroupItemViewMap.values().stream().filter(listGroupItemView -> !listGroupItemView.equals(selected)).forEach(ListGroupItemView::unselect);
        this.fieldItemPresenter.unselectAll();
    }

    @Override
    public void onSelectedElement(FieldItemView selected) {
        this.testToolsPresenter.setSelectedElement(selected);
        this.listGroupItemViewMap.values().forEach(ListGroupItemView::unselect);
    }

    @Override
    public void reset() {
        this.fieldItemPresenter.reset();
        this.listGroupItemViewMap.clear();
    }

    @Override
    public String getFilterTerm() {
        return this.filterTerm;
    }

    protected void populateListGroupItemView(ListGroupItemView toPopulate, String parentPath, String factName, FactModelTree factModelTree) {
        if (factName.equals(factModelTree.getFactName())) {
            toPopulate.setFactName(factName);
        } else {
            toPopulate.setFactNameAndType(factName, factModelTree.getFactName());
        }
        String fullPath = parentPath.isEmpty() ? factName : parentPath + "." + factName;
        factModelTree.getSimpleProperties().entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(entry -> toPopulate.addFactField(this.fieldItemPresenter.getLIElement(fullPath, factName, (String)entry.getKey(), ((FactModelTree.PropertyTypeName)entry.getValue()).getTypeName(), ((FactModelTree.PropertyTypeName)entry.getValue()).getPropertyTypeNameToVisualize())));
        factModelTree.getExpandableProperties().entrySet().stream().sorted(Map.Entry.comparingByValue()).forEach(entry -> toPopulate.addExpandableFactField(this.getDivElement(fullPath, (String)entry.getKey(), (String)entry.getValue())));
    }

    protected void populateListGroupItemView(ListGroupItemView toPopulate, String factName, String factType) {
        toPopulate.setFactNameAndType(factName, factType);
    }

    protected ListGroupItemView commonGetListGroupItemView(String parentPath, String factName, boolean toExpand) {
        String key = parentPath.isEmpty() ? factName : parentPath + "." + factName;
        ListGroupItemView toReturn = this.viewsProvider.getListGroupItemView();
        toReturn.init(this);
        toReturn.setToExpand(toExpand);
        toReturn.setParentPath(parentPath);
        this.listGroupItemViewMap.put(key, toReturn);
        return toReturn;
    }
}

