/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.collectioneditor;

import com.google.gwt.dom.client.LIElement;
import com.google.gwt.dom.client.Node;
import com.google.gwt.dom.client.Style;
import com.google.gwt.dom.client.UListElement;
import com.google.gwtmockito.GwtMockitoTestRunner;
import org.drools.workbench.screens.scenariosimulation.client.TestProperties;
import org.drools.workbench.screens.scenariosimulation.client.collectioneditor.CollectionPresenter;
import org.drools.workbench.screens.scenariosimulation.client.collectioneditor.ElementPresenterTest;
import org.drools.workbench.screens.scenariosimulation.client.collectioneditor.ElementView;
import org.drools.workbench.screens.scenariosimulation.client.collectioneditor.KeyValueElementPresenter;
import org.drools.workbench.screens.scenariosimulation.client.collectioneditor.KeyValueElementView;
import org.drools.workbench.screens.scenariosimulation.client.collectioneditor.PropertyPresenter;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=GwtMockitoTestRunner.class)
public class KeyValueElementPresenterTest
extends ElementPresenterTest<KeyValueElementView, KeyValueElementView.Presenter> {
    @Mock
    private LIElement propertyFieldsMock;
    @Mock
    private UListElement keyContainerMock;
    @Mock
    private UListElement valueContainerMock;
    @Mock
    private LIElement keyLabelMock;
    @Mock
    private LIElement valueLabelMock;

    @Override
    @Before
    public void setup() {
        this.elementView1Mock = (ElementView)Mockito.mock(KeyValueElementView.class);
        this.elementView2Mock = (ElementView)Mockito.mock(KeyValueElementView.class);
        Mockito.when((Object)((KeyValueElementView)this.elementView1Mock).getKeyContainer()).thenReturn((Object)this.keyContainerMock);
        Mockito.when((Object)((KeyValueElementView)this.elementView2Mock).getKeyContainer()).thenReturn((Object)this.keyContainerMock);
        Mockito.when((Object)((KeyValueElementView)this.elementView1Mock).getValueContainer()).thenReturn((Object)this.valueContainerMock);
        Mockito.when((Object)((KeyValueElementView)this.elementView2Mock).getValueContainer()).thenReturn((Object)this.valueContainerMock);
        Mockito.when((Object)((KeyValueElementView)this.elementView1Mock).getItemId()).thenReturn((Object)"ELEMENT1_ID");
        Mockito.when((Object)((KeyValueElementView)this.elementView2Mock).getItemId()).thenReturn((Object)"ELEMENT2_ID");
        Mockito.when((Object)this.keyLabelMock.getStyle()).thenReturn((Object)this.styleMock);
        Mockito.when((Object)this.valueLabelMock.getStyle()).thenReturn((Object)this.styleMock);
        Mockito.when((Object)((KeyValueElementView)this.elementView1Mock).getKeyLabel()).thenReturn((Object)this.keyLabelMock);
        Mockito.when((Object)((KeyValueElementView)this.elementView2Mock).getKeyLabel()).thenReturn((Object)this.keyLabelMock);
        Mockito.when((Object)((KeyValueElementView)this.elementView1Mock).getValueLabel()).thenReturn((Object)this.valueLabelMock);
        Mockito.when((Object)((KeyValueElementView)this.elementView2Mock).getValueLabel()).thenReturn((Object)this.valueLabelMock);
        super.setup();
        Mockito.when((Object)this.viewsProviderMock.getKeyValueElementView()).thenReturn((Object)this.elementView1Mock);
        Mockito.when((Object)this.propertyPresenterMock.getPropertyFields(Matchers.anyString(), Matchers.anyString(), Matchers.anyString())).thenReturn((Object)this.propertyFieldsMock);
        this.elementPresenter = (ElementView.Presenter)Mockito.spy((Object)new KeyValueElementPresenter(){
            {
                this.viewsProvider = KeyValueElementPresenterTest.this.viewsProviderMock;
                this.propertyPresenter = KeyValueElementPresenterTest.this.propertyPresenterMock;
                this.elementViewList = KeyValueElementPresenterTest.this.elementViewListLocal;
                this.collectionEditorPresenter = KeyValueElementPresenterTest.this.collectionPresenterMock;
            }
        });
    }

    @Test
    public void getKeyValueContainer() {
        this.elementViewListLocal.clear();
        LIElement keyValueContainer = ((KeyValueElementView.Presenter)this.elementPresenter).getKeyValueContainer("TEST-ITEM-ID", TestProperties.TEST_KEY_PROPERTY_MAP, TestProperties.TEST_VALUE_PROPERTYY_MAP);
        ((KeyValueElementView)Mockito.verify((Object)this.elementView1Mock, (VerificationMode)Mockito.times((int)1))).init((Object)this.elementPresenter);
        ((KeyValueElementView)Mockito.verify((Object)this.elementView1Mock, (VerificationMode)Mockito.times((int)1))).setItemId("TEST-ITEM-ID");
        ((KeyValueElementView)Mockito.verify((Object)this.elementView1Mock, (VerificationMode)Mockito.times((int)1))).getKeyContainer();
        ((UListElement)Mockito.verify((Object)this.keyContainerMock, (VerificationMode)Mockito.times((int)1))).appendChild((Node)this.propertyFieldsMock);
        ((KeyValueElementView)Mockito.verify((Object)this.elementView1Mock, (VerificationMode)Mockito.times((int)1))).getValueContainer();
        ((UListElement)Mockito.verify((Object)this.valueContainerMock, (VerificationMode)Mockito.times((int)1))).appendChild((Node)this.propertyFieldsMock);
        Assert.assertNotNull((Object)keyValueContainer);
        Assert.assertTrue((boolean)this.elementViewListLocal.contains(this.elementView1Mock));
    }

    @Test
    public void onEditItemShown() {
        ((KeyValueElementView)Mockito.doReturn((Object)true).when((Object)this.elementView1Mock)).isShown();
        ((KeyValueElementView.Presenter)this.elementPresenter).onEditItem(this.elementView1Mock);
        ((KeyValueElementView.Presenter)Mockito.verify((Object)this.elementPresenter, (VerificationMode)Mockito.never())).onToggleRowExpansion((ElementView)Matchers.eq((Object)this.elementView1Mock), Matchers.eq((boolean)false));
        ((PropertyPresenter)Mockito.verify((Object)this.propertyPresenterMock, (VerificationMode)Mockito.times((int)2))).editProperties(Matchers.anyString());
        ((Style)Mockito.verify((Object)this.styleMock, (VerificationMode)Mockito.times((int)1))).setDisplay(Style.Display.INLINE);
        ((CollectionPresenter)Mockito.verify((Object)this.collectionPresenterMock, (VerificationMode)Mockito.times((int)1))).toggleEditingStatus(Matchers.eq((boolean)true));
    }

    @Test
    public void onEditItemNotShown() {
        ((KeyValueElementView)Mockito.doReturn((Object)false).when((Object)this.elementView1Mock)).isShown();
        ((KeyValueElementView.Presenter)this.elementPresenter).onEditItem(this.elementView1Mock);
        ((PropertyPresenter)Mockito.verify((Object)this.propertyPresenterMock, (VerificationMode)Mockito.times((int)2))).editProperties(Matchers.anyString());
        ((Style)Mockito.verify((Object)this.styleMock, (VerificationMode)Mockito.times((int)1))).setDisplay(Style.Display.INLINE);
        ((CollectionPresenter)Mockito.verify((Object)this.collectionPresenterMock, (VerificationMode)Mockito.times((int)1))).toggleEditingStatus(Matchers.eq((boolean)true));
    }

    @Test
    public void onStopEditingItem() {
        ((KeyValueElementView.Presenter)this.elementPresenter).onStopEditingItem(this.elementView1Mock);
        ((PropertyPresenter)Mockito.verify((Object)this.propertyPresenterMock, (VerificationMode)Mockito.times((int)1))).stopEditProperties((String)Matchers.eq((Object)"ELEMENT1_ID#key"));
        ((PropertyPresenter)Mockito.verify((Object)this.propertyPresenterMock, (VerificationMode)Mockito.times((int)1))).stopEditProperties((String)Matchers.eq((Object)"ELEMENT1_ID#value"));
        ((Style)Mockito.verify((Object)this.styleMock, (VerificationMode)Mockito.times((int)1))).setDisplay(Style.Display.NONE);
        ((CollectionPresenter)Mockito.verify((Object)this.collectionPresenterMock, (VerificationMode)Mockito.times((int)1))).toggleEditingStatus(Matchers.eq((boolean)false));
    }

    @Test
    public void onDeleteItem() {
        ((KeyValueElementView.Presenter)this.elementPresenter).onDeleteItem(this.elementView1Mock);
        ((PropertyPresenter)Mockito.verify((Object)this.propertyPresenterMock, (VerificationMode)Mockito.times((int)1))).deleteProperties((String)Matchers.eq((Object)"ELEMENT1_ID#key"));
        ((PropertyPresenter)Mockito.verify((Object)this.propertyPresenterMock, (VerificationMode)Mockito.times((int)1))).deleteProperties((String)Matchers.eq((Object)"ELEMENT1_ID#value"));
        ((LIElement)Mockito.verify((Object)this.itemContainerMock, (VerificationMode)Mockito.times((int)1))).removeFromParent();
        Assert.assertFalse((boolean)this.elementViewListLocal.contains(this.elementView1Mock));
        ((CollectionPresenter)Mockito.verify((Object)this.collectionPresenterMock, (VerificationMode)Mockito.times((int)1))).toggleEditingStatus(Matchers.eq((boolean)false));
    }

    @Test
    public void updateItem() {
        ((KeyValueElementView.Presenter)this.elementPresenter).updateItem(this.elementView1Mock);
        ((PropertyPresenter)Mockito.verify((Object)this.propertyPresenterMock, (VerificationMode)Mockito.times((int)2))).updateProperties(Matchers.anyString());
        ((Style)Mockito.verify((Object)this.styleMock, (VerificationMode)Mockito.times((int)1))).setDisplay(Style.Display.NONE);
        ((CollectionPresenter)Mockito.verify((Object)this.collectionPresenterMock, (VerificationMode)Mockito.times((int)1))).toggleEditingStatus(Matchers.eq((boolean)false));
    }
}

