/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.commands.actualcommands;

import java.util.Date;
import java.util.Map;
import javax.enterprise.context.Dependent;
import org.drools.scenariosimulation.api.model.FactMappingType;
import org.drools.workbench.screens.scenariosimulation.client.commands.ScenarioSimulationContext;
import org.drools.workbench.screens.scenariosimulation.client.commands.actualcommands.AbstractScenarioGridCommand;
import org.drools.workbench.screens.scenariosimulation.client.commands.actualcommands.ReloadTestToolsCommand;
import org.drools.workbench.screens.scenariosimulation.client.enums.GridWidget;
import org.drools.workbench.screens.scenariosimulation.client.resources.i18n.ScenarioSimulationEditorConstants;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;

@Dependent
public class DeleteColumnCommand
extends AbstractScenarioGridCommand {
    public DeleteColumnCommand(GridWidget gridWidget) {
        super(gridWidget);
    }

    private DeleteColumnCommand() {
    }

    @Override
    protected void internalExecute(ScenarioSimulationContext context) {
        ScenarioSimulationContext.Status status = context.getStatus();
        int newColumnPosition = -1;
        if (status.isAsProperty()) {
            context.getAbstractScesimGridModelByGridWidget(this.gridWidget).deleteColumn(status.getColumnIndex());
            newColumnPosition = status.getColumnIndex();
        } else {
            newColumnPosition = context.getAbstractScesimGridModelByGridWidget(this.gridWidget).getInstanceLimits(status.getColumnIndex()).getMinRowIndex();
            context.getAbstractScesimGridModelByGridWidget(this.gridWidget).deleteInstance(status.getColumnIndex());
        }
        this.createColumnIfEmptyGroup(context, status, newColumnPosition);
        new ReloadTestToolsCommand().execute(context);
    }

    protected void createColumnIfEmptyGroup(ScenarioSimulationContext context, ScenarioSimulationContext.Status status, int newColumnPosition) {
        if (context.getAbstractScesimGridModelByGridWidget(this.gridWidget).getGroupSize(status.getColumnGroup()) < 1L) {
            FactMappingType factMappingType = FactMappingType.valueOf((String)status.getColumnGroup().toUpperCase());
            Map.Entry<String, String> validPlaceholders = context.getAbstractScesimGridModelByGridWidget(this.gridWidget).getValidPlaceholders();
            String instanceTitle = validPlaceholders.getKey();
            String propertyTitle = validPlaceholders.getValue();
            context.getAbstractScesimGridModelByGridWidget(this.gridWidget).insertColumn(newColumnPosition, (GridColumn<?>)this.getScenarioGridColumnLocal(instanceTitle, propertyTitle, String.valueOf(new Date().getTime()), status.getColumnGroup(), factMappingType, context.getScenarioHeaderTextBoxSingletonDOMElementFactory(this.gridWidget), context.getScenarioCellTextAreaSingletonDOMElementFactory(this.gridWidget), ScenarioSimulationEditorConstants.INSTANCE.defineValidType()));
        }
    }
}

