/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.handlers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import javax.inject.Inject;
import org.drools.workbench.screens.scenariosimulation.client.resources.i18n.ScenarioSimulationEditorConstants;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.CheatSheetView;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.SettingsView;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.SubDockView;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.TestToolsView;
import org.kie.workbench.common.widgets.client.docks.AbstractWorkbenchDocksHandler;
import org.kie.workbench.common.widgets.client.docks.AuthoringEditorDock;
import org.uberfire.client.mvp.AbstractWorkbenchActivity;
import org.uberfire.client.mvp.Activity;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.mvp.PlaceStatus;
import org.uberfire.client.workbench.docks.UberfireDock;
import org.uberfire.client.workbench.docks.UberfireDockPosition;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;

public abstract class AbstractScenarioSimulationDocksHandler
extends AbstractWorkbenchDocksHandler {
    public static final String SCESIMEDITOR_ID = "scesimeditorid";
    @Inject
    protected AuthoringEditorDock authoringWorkbenchDocks;
    @Inject
    protected PlaceManager placeManager;
    private UberfireDock settingsDock;
    private UberfireDock toolsDock;
    private UberfireDock cheatSheetDock;
    private String currentScesimEditorId;

    public Collection<UberfireDock> provideDocks(String perspectiveIdentifier) {
        ArrayList<UberfireDock> result = new ArrayList<UberfireDock>();
        this.settingsDock = new UberfireDock(UberfireDockPosition.EAST, "SLIDERS", (PlaceRequest)new DefaultPlaceRequest("org.drools.scenariosimulation.Settings"), perspectiveIdentifier);
        result.add(this.settingsDock.withSize(450.0).withLabel(ScenarioSimulationEditorConstants.INSTANCE.settings()));
        this.toolsDock = new UberfireDock(UberfireDockPosition.EAST, "INFO_CIRCLE", (PlaceRequest)new DefaultPlaceRequest("org.drools.scenariosimulation.TestTools"), perspectiveIdentifier);
        result.add(this.toolsDock.withSize(450.0).withLabel(ScenarioSimulationEditorConstants.INSTANCE.testTools()));
        this.cheatSheetDock = new UberfireDock(UberfireDockPosition.EAST, "FILE_TEXT", (PlaceRequest)new DefaultPlaceRequest("org.drools.scenariosimulation.CheatSheet"), perspectiveIdentifier);
        result.add(this.cheatSheetDock.withSize(450.0).withLabel(ScenarioSimulationEditorConstants.INSTANCE.scenarioCheatSheet()));
        return result;
    }

    public void addDocks() {
        this.refreshDocks(true, false);
    }

    public void removeDocks() {
        this.refreshDocks(true, true);
    }

    protected void refreshDocks(boolean shouldRefresh, boolean shouldDisable) {
        super.refreshDocks(shouldRefresh, shouldDisable);
    }

    public void expandToolsDock() {
        if (PlaceStatus.CLOSE.equals((Object)this.placeManager.getStatus(this.getTestToolsPlaceManager()))) {
            this.authoringWorkbenchDocks.expandAuthoringDock(this.toolsDock);
        }
    }

    public void expandSettingsDock() {
        if (PlaceStatus.CLOSE.equals((Object)this.placeManager.getStatus(this.getSettingsPlaceManager()))) {
            this.authoringWorkbenchDocks.expandAuthoringDock(this.settingsDock);
        }
    }

    public abstract void expandTestResultsDock();

    public void resetDocks() {
        this.getSettingsPresenter().ifPresent(SubDockView.Presenter::reset);
        this.getCheatSheetPresenter().ifPresent(SubDockView.Presenter::reset);
        this.getTestToolsPresenter().ifPresent(SubDockView.Presenter::reset);
    }

    public void setScesimEditorId(String scesimEditorId) {
        this.currentScesimEditorId = scesimEditorId;
        this.settingsDock.getPlaceRequest().addParameter(SCESIMEDITOR_ID, scesimEditorId);
        this.toolsDock.getPlaceRequest().addParameter(SCESIMEDITOR_ID, scesimEditorId);
        this.cheatSheetDock.getPlaceRequest().addParameter(SCESIMEDITOR_ID, scesimEditorId);
    }

    public Optional<CheatSheetView.Presenter> getCheatSheetPresenter() {
        Optional<CheatSheetView> cheatSheetView = this.getCheatSheetView(this.getCurrentRightDockPlaceRequest("org.drools.scenariosimulation.CheatSheet"));
        return cheatSheetView.map(SubDockView::getPresenter);
    }

    public Optional<TestToolsView.Presenter> getTestToolsPresenter() {
        Optional<TestToolsView> testToolsView = this.getTestToolsView(this.getTestToolsPlaceManager());
        return testToolsView.map(TestToolsView::getPresenter);
    }

    public Optional<SettingsView.Presenter> getSettingsPresenter() {
        Optional<SettingsView> settingsView = this.getSettingsView(this.getSettingsPlaceManager());
        return settingsView.map(SubDockView::getPresenter);
    }

    protected PlaceRequest getSettingsPlaceManager() {
        return this.getCurrentRightDockPlaceRequest("org.drools.scenariosimulation.Settings");
    }

    protected PlaceRequest getTestToolsPlaceManager() {
        return this.getCurrentRightDockPlaceRequest("org.drools.scenariosimulation.TestTools");
    }

    protected PlaceRequest getCurrentRightDockPlaceRequest(String identifier) {
        DefaultPlaceRequest toReturn = new DefaultPlaceRequest(identifier);
        toReturn.addParameter(SCESIMEDITOR_ID, String.valueOf(this.currentScesimEditorId));
        return toReturn;
    }

    protected Optional<TestToolsView> getTestToolsView(PlaceRequest placeRequest) {
        Activity activity = this.placeManager.getActivity(placeRequest);
        if (activity == null) {
            return Optional.empty();
        }
        AbstractWorkbenchActivity testToolsActivity = (AbstractWorkbenchActivity)activity;
        return Optional.of((TestToolsView)testToolsActivity.getWidget());
    }

    protected Optional<CheatSheetView> getCheatSheetView(PlaceRequest placeRequest) {
        Activity activity = this.placeManager.getActivity(placeRequest);
        if (activity == null) {
            return Optional.empty();
        }
        AbstractWorkbenchActivity cheatSheetActivity = (AbstractWorkbenchActivity)activity;
        return Optional.of((CheatSheetView)cheatSheetActivity.getWidget());
    }

    protected Optional<SettingsView> getSettingsView(PlaceRequest placeRequest) {
        Activity activity = this.placeManager.getActivity(placeRequest);
        if (activity == null) {
            return Optional.empty();
        }
        AbstractWorkbenchActivity settingsActivity = (AbstractWorkbenchActivity)activity;
        return Optional.of((SettingsView)settingsActivity.getWidget());
    }
}

