/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.popover;

import com.google.gwt.core.client.Scheduler;
import com.google.gwt.user.client.ui.RootPanel;
import java.util.Optional;
import org.drools.workbench.screens.scenariosimulation.client.popover.PopoverView;
import org.jboss.errai.common.client.dom.Div;
import org.jboss.errai.common.client.dom.Element;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.common.client.ui.ElementWrapperWidget;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.uberfire.client.views.pfly.widgets.JQueryProducer;
import org.uberfire.client.views.pfly.widgets.Popover;
import org.uberfire.client.views.pfly.widgets.PopoverOptions;

public abstract class AbstractPopoverView
implements PopoverView {
    public static final String TOP = "top";
    public static final String LEFT = "left";
    public static final String POSITION = "position";
    public static final String PX = "px";
    public static final String ABSOLUTE = "absolute";
    public static final String TITLE = "title";
    @DataField(value="popover")
    protected Div popoverElement;
    @DataField(value="popover-container")
    protected Div popoverContainerElement;
    @DataField(value="popover-content")
    protected Div popoverContentElement;
    protected JQueryProducer.JQuery<Popover> jQueryPopover;
    protected Popover popover;
    protected ElementWrapperWidget<?> wrappedWidget;
    protected PopoverOptions options = new PopoverOptions();

    public AbstractPopoverView() {
    }

    public AbstractPopoverView(Div popoverElement, Div popoverContainerElement, Div popoverContentElement, JQueryProducer.JQuery<Popover> jQueryPopover) {
        this.popoverElement = popoverElement;
        this.popoverContainerElement = popoverContainerElement;
        this.popoverContentElement = popoverContentElement;
        this.jQueryPopover = jQueryPopover;
        this.options.setContent(element -> popoverContentElement);
        this.options.setAnimation(Boolean.valueOf(false));
        this.options.setHtml(Boolean.valueOf(true));
    }

    @Override
    public void setup(Optional<String> editorTitle, int mx, int my, PopoverView.Position position) {
        if (this.isShown()) {
            this.hide();
        }
        HTMLElement element = this.getElement();
        this.popover = (Popover)this.jQueryPopover.wrap((Element)element);
        this.wrappedWidget = ElementWrapperWidget.getWidget((HTMLElement)element);
        this.addWidgetToRootPanel();
        editorTitle.ifPresent(t -> this.popoverElement.setAttribute(TITLE, t));
        this.popoverElement.getStyle().setProperty(TOP, my + PX);
        this.popoverElement.getStyle().setProperty(LEFT, mx + PX);
        this.popoverElement.getStyle().setProperty(POSITION, ABSOLUTE);
        this.options.setPlacement(position.toString().toLowerCase());
        this.popover.popover(this.options);
    }

    @Override
    public void show() {
        this.scheduleTask();
    }

    @Override
    public boolean isShown() {
        return this.wrappedWidget != null && RootPanel.get().getWidgetIndex(this.wrappedWidget) != -1;
    }

    @Override
    public void hide() {
        if (this.isShown()) {
            this.removeWidgetFromRootPanel();
            this.popover.destroy();
            this.wrappedWidget = null;
        }
    }

    public int getActualHeight() {
        return this.wrappedWidget != null ? this.wrappedWidget.getElement().getScrollHeight() : 0;
    }

    protected void addWidgetToRootPanel() {
        RootPanel.get().add(this.wrappedWidget);
    }

    protected void removeWidgetFromRootPanel() {
        RootPanel.get().remove(this.wrappedWidget);
    }

    protected void scheduleTask() {
        Scheduler.get().scheduleDeferred(() -> this.popover.show());
    }
}

