/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.editor.strategies;

import com.google.gwt.event.shared.EventBus;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.HashMap;
import java.util.SortedMap;
import java.util.TreeMap;
import junit.framework.TestCase;
import org.drools.workbench.screens.scenariosimulation.client.commands.ScenarioSimulationContext;
import org.drools.workbench.screens.scenariosimulation.client.editor.AbstractScenarioSimulationEditorTest;
import org.drools.workbench.screens.scenariosimulation.client.editor.strategies.AbstractDMNDataManagementStrategy;
import org.drools.workbench.screens.scenariosimulation.client.editor.strategies.AbstractDataManagementStrategy;
import org.drools.workbench.screens.scenariosimulation.client.enums.GridWidget;
import org.drools.workbench.screens.scenariosimulation.client.models.AbstractScesimGridModel;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.TestToolsView;
import org.drools.workbench.screens.scenariosimulation.model.ScenarioSimulationModelContent;
import org.drools.workbench.screens.scenariosimulation.model.typedescriptor.FactModelTree;
import org.drools.workbench.screens.scenariosimulation.model.typedescriptor.FactModelTuple;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.backend.vfs.ObservablePath;
import org.uberfire.backend.vfs.Path;

@RunWith(value=GwtMockitoTestRunner.class)
public class AbstractDMNDataManagementStrategyTest
extends AbstractScenarioSimulationEditorTest {
    private AbstractDMNDataManagementStrategy abstractDMNDataManagementStrategySpy;
    private AbstractDataManagementStrategy.ResultHolder factModelTreeHolderlocal;
    private FactModelTuple factModelTupleLocal;
    private SortedMap<String, FactModelTree> visibleFactsLocal = new TreeMap<String, FactModelTree>();
    private SortedMap<String, FactModelTree> hiddenFactsLocal = new TreeMap<String, FactModelTree>();
    private final String DMN_FILE_PATH = "DMN_FILE_PATH";

    @Override
    @Before
    public void setup() {
        super.setup();
        this.factModelTupleLocal = new FactModelTuple(this.visibleFactsLocal, this.hiddenFactsLocal);
        this.factModelTreeHolderlocal = new AbstractDataManagementStrategy.ResultHolder();
        this.factModelTreeHolderlocal.setFactModelTuple(this.factModelTupleLocal);
        Mockito.when((Object)this.dmnTypeServiceMock.retrieveFactModelTuple((Path)Matchers.any(), Matchers.anyString())).thenReturn((Object)this.factModelTupleLocal);
        this.modelLocal.getSettings().setDmnFilePath("DMN_FILE_PATH");
        this.abstractDMNDataManagementStrategySpy = (AbstractDMNDataManagementStrategy)Mockito.spy((Object)new AbstractDMNDataManagementStrategy((EventBus)Mockito.mock(EventBus.class)){
            {
                this.currentPath = (Path)Mockito.mock(Path.class);
                this.model = AbstractDMNDataManagementStrategyTest.this.modelLocal;
                this.factModelTreeHolder = AbstractDMNDataManagementStrategyTest.this.factModelTreeHolderlocal;
                this.dmnFilePath = "DMN_FILE_PATH";
            }

            protected void retrieveFactModelTuple(TestToolsView.Presenter testToolsPresenter, ScenarioSimulationContext context, GridWidget gridWidget) {
            }
        });
    }

    @Test
    public void populateTestToolsWithoutFactModelTuple() {
        this.factModelTreeHolderlocal.setFactModelTuple(null);
        this.abstractDMNDataManagementStrategySpy.populateTestTools((TestToolsView.Presenter)this.testToolsPresenterMock, this.scenarioSimulationContextLocal, GridWidget.SIMULATION);
        ((AbstractDMNDataManagementStrategy)Mockito.verify((Object)this.abstractDMNDataManagementStrategySpy, (VerificationMode)Mockito.times((int)1))).retrieveFactModelTuple((TestToolsView.Presenter)Matchers.eq((Object)this.testToolsPresenterMock), (ScenarioSimulationContext)Matchers.eq((Object)this.scenarioSimulationContextLocal), (GridWidget)Matchers.eq((Object)GridWidget.SIMULATION));
        ((AbstractDMNDataManagementStrategy)Mockito.verify((Object)this.abstractDMNDataManagementStrategySpy, (VerificationMode)Mockito.never())).getSuccessCallback((TestToolsView.Presenter)this.testToolsPresenterMock, this.scenarioSimulationContextLocal, GridWidget.SIMULATION);
        ((AbstractDMNDataManagementStrategy)Mockito.verify((Object)this.abstractDMNDataManagementStrategySpy, (VerificationMode)Mockito.never())).getSuccessCallbackMethod((FactModelTuple)Matchers.eq((Object)this.factModelTupleLocal), (TestToolsView.Presenter)Matchers.eq((Object)this.testToolsPresenterMock), (ScenarioSimulationContext)Matchers.eq((Object)this.scenarioSimulationContextLocal), (GridWidget)Matchers.eq((Object)GridWidget.SIMULATION));
    }

    @Test
    public void populateTestToolsWithoutFactModelTupleAndDifferentDMNPath() {
        this.factModelTreeHolderlocal.setFactModelTuple(null);
        this.modelLocal.getSettings().setDmnName("/src/test.dmn");
        this.abstractDMNDataManagementStrategySpy.populateTestTools((TestToolsView.Presenter)this.testToolsPresenterMock, this.scenarioSimulationContextLocal, GridWidget.SIMULATION);
        ((AbstractDMNDataManagementStrategy)Mockito.verify((Object)this.abstractDMNDataManagementStrategySpy, (VerificationMode)Mockito.times((int)1))).retrieveFactModelTuple((TestToolsView.Presenter)Matchers.eq((Object)this.testToolsPresenterMock), (ScenarioSimulationContext)Matchers.eq((Object)this.scenarioSimulationContextLocal), (GridWidget)Matchers.eq((Object)GridWidget.SIMULATION));
        ((AbstractDMNDataManagementStrategy)Mockito.verify((Object)this.abstractDMNDataManagementStrategySpy, (VerificationMode)Mockito.never())).getSuccessCallback((TestToolsView.Presenter)this.testToolsPresenterMock, this.scenarioSimulationContextLocal, GridWidget.SIMULATION);
        ((AbstractDMNDataManagementStrategy)Mockito.verify((Object)this.abstractDMNDataManagementStrategySpy, (VerificationMode)Mockito.never())).getSuccessCallbackMethod((FactModelTuple)Matchers.eq((Object)this.factModelTupleLocal), (TestToolsView.Presenter)Matchers.eq((Object)this.testToolsPresenterMock), (ScenarioSimulationContext)Matchers.eq((Object)this.scenarioSimulationContextLocal), (GridWidget)Matchers.eq((Object)GridWidget.SIMULATION));
    }

    @Test
    public void populateTestToolsWithFactDifferentDMNPath() {
        this.modelLocal.getSettings().setDmnName("/src/test.dmn");
        this.abstractDMNDataManagementStrategySpy.populateTestTools((TestToolsView.Presenter)this.testToolsPresenterMock, this.scenarioSimulationContextLocal, GridWidget.SIMULATION);
        ((AbstractDMNDataManagementStrategy)Mockito.verify((Object)this.abstractDMNDataManagementStrategySpy, (VerificationMode)Mockito.never())).retrieveFactModelTuple((TestToolsView.Presenter)Matchers.any(), (ScenarioSimulationContext)Matchers.any(), (GridWidget)Matchers.any());
        ((AbstractDMNDataManagementStrategy)Mockito.verify((Object)this.abstractDMNDataManagementStrategySpy, (VerificationMode)Mockito.times((int)1))).getSuccessCallback((TestToolsView.Presenter)this.testToolsPresenterMock, this.scenarioSimulationContextLocal, GridWidget.SIMULATION);
        ((AbstractDMNDataManagementStrategy)Mockito.verify((Object)this.abstractDMNDataManagementStrategySpy, (VerificationMode)Mockito.times((int)1))).getSuccessCallbackMethod((FactModelTuple)Matchers.eq((Object)this.factModelTupleLocal), (TestToolsView.Presenter)Matchers.eq((Object)this.testToolsPresenterMock), (ScenarioSimulationContext)Matchers.eq((Object)this.scenarioSimulationContextLocal), (GridWidget)Matchers.eq((Object)GridWidget.SIMULATION));
    }

    @Test
    public void populateTestToolsWithFactModelTuple() {
        this.abstractDMNDataManagementStrategySpy.populateTestTools((TestToolsView.Presenter)this.testToolsPresenterMock, this.scenarioSimulationContextLocal, GridWidget.SIMULATION);
        ((AbstractDMNDataManagementStrategy)Mockito.verify((Object)this.abstractDMNDataManagementStrategySpy, (VerificationMode)Mockito.never())).retrieveFactModelTuple((TestToolsView.Presenter)Matchers.any(), (ScenarioSimulationContext)Matchers.any(), (GridWidget)Matchers.any());
        ((AbstractDMNDataManagementStrategy)Mockito.verify((Object)this.abstractDMNDataManagementStrategySpy, (VerificationMode)Mockito.times((int)1))).getSuccessCallback((TestToolsView.Presenter)this.testToolsPresenterMock, this.scenarioSimulationContextLocal, GridWidget.SIMULATION);
        ((AbstractDMNDataManagementStrategy)Mockito.verify((Object)this.abstractDMNDataManagementStrategySpy, (VerificationMode)Mockito.times((int)1))).getSuccessCallbackMethod((FactModelTuple)Matchers.eq((Object)this.factModelTupleLocal), (TestToolsView.Presenter)Matchers.eq((Object)this.testToolsPresenterMock), (ScenarioSimulationContext)Matchers.eq((Object)this.scenarioSimulationContextLocal), (GridWidget)Matchers.eq((Object)GridWidget.SIMULATION));
    }

    @Test
    public void manageScenarioSimulationModelContent() {
        ScenarioSimulationModelContent contentMock = (ScenarioSimulationModelContent)Mockito.spy((Object)this.content);
        this.abstractDMNDataManagementStrategySpy.manageScenarioSimulationModelContent(this.observablePathMock, contentMock);
        ((ObservablePath)Mockito.verify((Object)this.observablePathMock, (VerificationMode)Mockito.times((int)1))).getOriginal();
        ((ScenarioSimulationModelContent)Mockito.verify((Object)contentMock, (VerificationMode)Mockito.times((int)1))).getModel();
    }

    @Test
    public void isADataType() {
        this.visibleFactsLocal.clear();
        this.hiddenFactsLocal.clear();
        this.commonIsADataType("TEST", false);
        this.visibleFactsLocal.put("TEST", new FactModelTree());
        this.commonIsADataType("TOAST", false);
        this.commonIsADataType("TEST", true);
        this.visibleFactsLocal.clear();
        this.hiddenFactsLocal.put("TEST", new FactModelTree());
        this.commonIsADataType("TOAST", false);
        this.commonIsADataType("TEST", true);
    }

    private void commonIsADataType(String value, boolean expected) {
        boolean retrieved = this.abstractDMNDataManagementStrategySpy.isADataType(value);
        if (expected) {
            TestCase.assertTrue((boolean)retrieved);
        } else {
            Assert.assertFalse((boolean)retrieved);
        }
    }

    @Test
    public void getSuccessCallbackMethod() {
        HashMap alreadyAssignedProperties = new HashMap();
        this.factModelTreeHolderlocal.setFactModelTuple(null);
        ((AbstractDMNDataManagementStrategy)Mockito.doReturn(alreadyAssignedProperties).when((Object)this.abstractDMNDataManagementStrategySpy)).getPropertiesToHide((AbstractScesimGridModel)this.scenarioGridModelMock);
        this.abstractDMNDataManagementStrategySpy.getSuccessCallbackMethod(this.factModelTupleLocal, (TestToolsView.Presenter)this.testToolsPresenterMock, this.scenarioSimulationContextLocal, GridWidget.SIMULATION);
        ((AbstractDMNDataManagementStrategy)Mockito.verify((Object)this.abstractDMNDataManagementStrategySpy, (VerificationMode)Mockito.times((int)1))).getPropertiesToHide((AbstractScesimGridModel)Matchers.eq((Object)this.scenarioGridModelMock));
        ((AbstractDMNDataManagementStrategy)Mockito.verify((Object)this.abstractDMNDataManagementStrategySpy, (VerificationMode)Mockito.times((int)1))).storeData((FactModelTuple)Matchers.eq((Object)this.factModelTupleLocal), (TestToolsView.Presenter)Matchers.eq((Object)this.testToolsPresenterMock), (ScenarioSimulationContext)Matchers.eq((Object)this.scenarioSimulationContextLocal), (GridWidget)Matchers.eq((Object)GridWidget.SIMULATION));
        ((AbstractDMNDataManagementStrategy)Mockito.verify((Object)this.abstractDMNDataManagementStrategySpy, (VerificationMode)Mockito.times((int)1))).showErrorsAndCleanupState((FactModelTuple)Matchers.eq((Object)this.factModelTupleLocal));
        Assert.assertEquals((Object)this.factModelTupleLocal, (Object)this.factModelTreeHolderlocal.getFactModelTuple());
    }
}

