/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.rightpanel;

import com.google.gwt.dom.client.DivElement;
import com.google.gwt.dom.client.LIElement;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.drools.workbench.screens.scenariosimulation.client.TestProperties;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.AbstractTestToolsTest;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.FieldItemPresenter;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.FieldItemView;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.ListGroupItemPresenter;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.ListGroupItemView;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.TestToolsPresenter;
import org.drools.workbench.screens.scenariosimulation.model.typedescriptor.FactModelTree;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.InOrder;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.verification.VerificationMode;

@RunWith(value=GwtMockitoTestRunner.class)
public class ListGroupItemPresenterTest
extends AbstractTestToolsTest {
    private ListGroupItemPresenter listGroupItemPresenter;
    @Mock
    private ListGroupItemView listGroupItemViewMock;
    @Mock
    private DivElement divElementMock;
    @Spy
    private FieldItemPresenter fieldItemPresenterSpy = new FieldItemPresenter();
    @Mock
    private FieldItemView fieldItemViewMock;
    @Mock
    private Map<String, ListGroupItemView> listGroupItemViewMapMock;
    @Mock
    private List<ListGroupItemView> listGroupItemViewValuesMock;
    @Mock
    private TestToolsPresenter testToolsPresenterMock;

    @Override
    @Before
    public void setup() {
        super.setup();
        Mockito.when((Object)this.viewsProviderMock.getListGroupItemView()).thenReturn((Object)this.listGroupItemViewMock);
        Mockito.when((Object)this.viewsProviderMock.getFieldItemView()).thenReturn((Object)this.fieldItemViewMock);
        Mockito.when((Object)this.listGroupItemViewMock.getListGroupItem()).thenReturn((Object)this.divElementMock);
        Mockito.when((Object)this.listGroupItemViewMock.getListGroupExpansion()).thenReturn((Object)this.divElementMock);
        Mockito.when(this.listGroupItemViewMapMock.values()).thenReturn(this.listGroupItemViewValuesMock);
        this.listGroupItemPresenter = (ListGroupItemPresenter)Mockito.spy((Object)new ListGroupItemPresenter(){
            {
                this.listGroupItemViewMap = ListGroupItemPresenterTest.this.listGroupItemViewMapMock;
                this.fieldItemPresenter = ListGroupItemPresenterTest.this.fieldItemPresenterSpy;
                this.viewsProvider = ListGroupItemPresenterTest.this.viewsProviderMock;
                this.testToolsPresenter = ListGroupItemPresenterTest.this.testToolsPresenterMock;
            }
        });
        this.fieldItemPresenterSpy.viewsProvider = this.viewsProviderMock;
    }

    @Test
    public void getDivElementByFactModel() {
        DivElement retrieved = this.listGroupItemPresenter.getDivElement("FACT_NAME", this.FACT_MODEL_TREE);
        Assert.assertNotNull((Object)retrieved);
        Assert.assertEquals((Object)this.divElementMock, (Object)retrieved);
        ((ListGroupItemPresenter)Mockito.verify((Object)this.listGroupItemPresenter, (VerificationMode)Mockito.times((int)1))).commonGetListGroupItemView((List)Matchers.eq(Collections.emptyList()), (String)Matchers.eq((Object)"FACT_NAME"), Matchers.eq((boolean)false));
        ((ListGroupItemPresenter)Mockito.verify((Object)this.listGroupItemPresenter, (VerificationMode)Mockito.times((int)1))).populateListGroupItemView((ListGroupItemView)Matchers.eq((Object)this.listGroupItemViewMock), (List)Matchers.eq(Collections.emptyList()), (String)Matchers.eq((Object)"FACT_NAME"), (FactModelTree)Matchers.eq((Object)this.FACT_MODEL_TREE));
    }

    @Test
    public void getDivElementByStrings() {
        DivElement retrieved = this.listGroupItemPresenter.getDivElement(TestProperties.FULL_PACKAGE_ELEMENTS, "MULTIPART.VALUE", TestProperties.VALUE_CLASS_NAME);
        Assert.assertNotNull((Object)retrieved);
        Assert.assertEquals((Object)this.divElementMock, (Object)retrieved);
        ((ListGroupItemPresenter)Mockito.verify((Object)this.listGroupItemPresenter, (VerificationMode)Mockito.times((int)1))).commonGetListGroupItemView((List)Matchers.eq(TestProperties.FULL_PACKAGE_ELEMENTS), (String)Matchers.eq((Object)"MULTIPART.VALUE"), Matchers.eq((boolean)true));
        ((ListGroupItemPresenter)Mockito.verify((Object)this.listGroupItemPresenter, (VerificationMode)Mockito.times((int)1))).populateListGroupItemView((ListGroupItemView)Matchers.eq((Object)this.listGroupItemViewMock), (String)Matchers.eq((Object)"MULTIPART.VALUE"), (String)Matchers.eq((Object)TestProperties.VALUE_CLASS_NAME));
    }

    @Test
    public void onToggleRowExpansionDisabled() {
        this.listGroupItemPresenter.disable();
        Mockito.reset((Object[])new Map[]{this.listGroupItemViewMapMock});
        Mockito.when((Object)this.listGroupItemViewValuesMock.contains(this.listGroupItemViewMock)).thenReturn((Object)true);
        this.listGroupItemPresenter.onToggleRowExpansion(this.listGroupItemViewMock, true);
        ((List)Mockito.verify(this.listGroupItemViewValuesMock, (VerificationMode)Mockito.never())).contains(Matchers.eq((Object)this.listGroupItemViewMock));
        ((ListGroupItemView)Mockito.verify((Object)this.listGroupItemViewMock, (VerificationMode)Mockito.never())).closeRow();
        Mockito.reset((Object[])new Map[]{this.listGroupItemViewMapMock});
        Mockito.when((Object)this.listGroupItemViewValuesMock.contains(this.listGroupItemViewMock)).thenReturn((Object)true);
        Mockito.reset((Object[])new ListGroupItemView[]{this.listGroupItemViewMock});
        this.listGroupItemPresenter.onToggleRowExpansion(this.listGroupItemViewMock, false);
        ((List)Mockito.verify(this.listGroupItemViewValuesMock, (VerificationMode)Mockito.never())).contains(Matchers.eq((Object)this.listGroupItemViewMock));
        ((ListGroupItemView)Mockito.verify((Object)this.listGroupItemViewMock, (VerificationMode)Mockito.never())).expandRow();
    }

    @Test
    public void onToggleRowExpansionWithoutFactName() {
        this.listGroupItemPresenter.enable();
        Mockito.reset((Object[])new Map[]{this.listGroupItemViewMapMock});
        Mockito.when((Object)this.listGroupItemViewValuesMock.contains(this.listGroupItemViewMock)).thenReturn((Object)true);
        this.listGroupItemPresenter.onToggleRowExpansion(this.listGroupItemViewMock, true);
        ((ListGroupItemView)Mockito.verify((Object)this.listGroupItemViewMock, (VerificationMode)Mockito.times((int)1))).closeRow();
        Mockito.reset((Object[])new Map[]{this.listGroupItemViewMapMock});
        Mockito.when((Object)this.listGroupItemViewValuesMock.contains(this.listGroupItemViewMock)).thenReturn((Object)true);
        Mockito.reset((Object[])new ListGroupItemView[]{this.listGroupItemViewMock});
        this.listGroupItemPresenter.onToggleRowExpansion(this.listGroupItemViewMock, false);
        ((ListGroupItemView)Mockito.verify((Object)this.listGroupItemViewMock, (VerificationMode)Mockito.times((int)1))).expandRow();
    }

    @Test
    public void onToggleRowExpansionWithFactName() {
        this.listGroupItemPresenter.enable("FACT_NAME");
        Mockito.reset((Object[])new Map[]{this.listGroupItemViewMapMock});
        Mockito.when((Object)this.listGroupItemViewValuesMock.contains(this.listGroupItemViewMock)).thenReturn((Object)true);
        this.listGroupItemPresenter.onToggleRowExpansion(this.listGroupItemViewMock, true);
        ((ListGroupItemView)Mockito.verify((Object)this.listGroupItemViewMock, (VerificationMode)Mockito.times((int)1))).closeRow();
        Mockito.reset((Object[])new Map[]{this.listGroupItemViewMapMock});
        Mockito.when((Object)this.listGroupItemViewValuesMock.contains(this.listGroupItemViewMock)).thenReturn((Object)true);
        Mockito.reset((Object[])new ListGroupItemView[]{this.listGroupItemViewMock});
        this.listGroupItemPresenter.onToggleRowExpansion(this.listGroupItemViewMock, false);
        ((ListGroupItemView)Mockito.verify((Object)this.listGroupItemViewMock, (VerificationMode)Mockito.times((int)1))).expandRow();
    }

    @Test
    public void onToggleRowExpansionWithFactNameHidden() {
        this.listGroupItemPresenter.enable("FACT_NAME");
        Mockito.when((Object)this.listGroupItemViewMock.isToExpand()).thenReturn((Object)true);
        Mockito.when((Object)this.testToolsPresenterMock.getFactModelTreeFromFactTypeMap(Matchers.anyString())).thenReturn(Optional.empty());
        this.listGroupItemPresenter.onToggleRowExpansion(this.listGroupItemViewMock, false);
        ((TestToolsPresenter)Mockito.verify((Object)this.testToolsPresenterMock, (VerificationMode)Mockito.times((int)1))).getFactModelTreeFromFactTypeMap((String)ArgumentMatchers.any());
        ((TestToolsPresenter)Mockito.verify((Object)this.testToolsPresenterMock, (VerificationMode)Mockito.times((int)1))).getFactModelTreeFromHiddenMap((String)ArgumentMatchers.any());
        ((ListGroupItemView)Mockito.verify((Object)this.listGroupItemViewMock, (VerificationMode)Mockito.times((int)1))).expandRow();
    }

    @Test
    public void populateListGroupItemView() {
        this.listGroupItemPresenter.populateListGroupItemView(this.listGroupItemViewMock, Collections.emptyList(), this.FACT_MODEL_TREE.getFactName(), this.FACT_MODEL_TREE);
        ((ListGroupItemView)Mockito.verify((Object)this.listGroupItemViewMock, (VerificationMode)Mockito.times((int)1))).setFactName((String)Matchers.eq((Object)this.FACT_MODEL_TREE.getFactName()));
        Map simpleProperties = this.FACT_MODEL_TREE.getSimpleProperties();
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.fieldItemPresenterSpy});
        simpleProperties.keySet().stream().sorted().forEach(key -> {
            FactModelTree.PropertyTypeName value = (FactModelTree.PropertyTypeName)simpleProperties.get(key);
            ((FieldItemPresenter)inOrder.verify((Object)this.fieldItemPresenterSpy, Mockito.times((int)1))).getLIElement((List)Matchers.eq(Arrays.asList(this.FACT_MODEL_TREE.getFactName())), (String)Matchers.eq((Object)this.FACT_MODEL_TREE.getFactName()), (String)Matchers.eq((Object)key), (String)Matchers.eq((Object)value.getTypeName()), (String)Matchers.eq((Object)value.getPropertyTypeNameToVisualize()));
        });
        ((ListGroupItemView)Mockito.verify((Object)this.listGroupItemViewMock, (VerificationMode)Mockito.times((int)simpleProperties.size()))).addFactField((LIElement)Matchers.anyObject());
        Mockito.reset((Object[])new ListGroupItemView[]{this.listGroupItemViewMock});
        Map expandableProperties = this.FACT_MODEL_TREE.getExpandableProperties();
        expandableProperties.entrySet().stream().sorted().forEach(entry -> ((ListGroupItemPresenter)inOrder.verify((Object)this.listGroupItemPresenter, Mockito.times((int)1))).getDivElement((List)Matchers.eq(Collections.emptyList()), (String)Matchers.eq(entry.getKey()), (String)Matchers.eq(entry.getValue())));
        ((ListGroupItemView)Mockito.verify((Object)this.listGroupItemViewMock, (VerificationMode)Mockito.times((int)expandableProperties.size()))).addExpandableFactField((DivElement)Matchers.anyObject());
    }

    @Test
    public void resetTest() {
        this.listGroupItemPresenter.reset();
        ((Map)Mockito.verify(this.listGroupItemViewMapMock, (VerificationMode)Mockito.times((int)1))).clear();
        ((FieldItemPresenter)Mockito.verify((Object)this.fieldItemPresenterSpy, (VerificationMode)Mockito.times((int)1))).reset();
    }

    @Test
    public void testSelectPropertyNoFieldAvailableJustExpression() {
        String instance = "Applicant";
        String property = "expression";
        Mockito.when((Object)this.listGroupItemViewMapMock.get("Applicant")).thenReturn((Object)this.listGroupItemViewMock);
        this.fieldItemPresenterSpy.fieldItemMap = Collections.emptyMap();
        this.listGroupItemPresenter.selectProperty("Applicant", Collections.singletonList("expression"));
        ((ListGroupItemView)Mockito.verify((Object)this.listGroupItemViewMock)).showCheck(true);
    }
}

