/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.commands.actualcommands;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.drools.scenariosimulation.api.model.ExpressionElement;
import org.drools.scenariosimulation.api.model.FactIdentifier;
import org.drools.scenariosimulation.api.model.FactMapping;
import org.drools.scenariosimulation.api.model.FactMappingType;
import org.drools.scenariosimulation.api.model.FactMappingValueType;
import org.drools.scenariosimulation.api.model.ScenarioSimulationModel;
import org.drools.scenariosimulation.api.model.ScesimModelDescriptor;
import org.drools.workbench.screens.scenariosimulation.client.TestProperties;
import org.drools.workbench.screens.scenariosimulation.client.commands.ScenarioSimulationContext;
import org.drools.workbench.screens.scenariosimulation.client.commands.actualcommands.AbstractScenarioGridCommand;
import org.drools.workbench.screens.scenariosimulation.client.commands.actualcommands.AbstractScenarioGridCommandTest;
import org.drools.workbench.screens.scenariosimulation.client.commands.actualcommands.AbstractSelectedColumnCommand;
import org.drools.workbench.screens.scenariosimulation.client.editor.ScenarioSimulationEditorPresenter;
import org.drools.workbench.screens.scenariosimulation.client.enums.GridWidget;
import org.drools.workbench.screens.scenariosimulation.client.factories.ScenarioCellTextAreaSingletonDOMElementFactory;
import org.drools.workbench.screens.scenariosimulation.client.factories.ScenarioHeaderTextBoxSingletonDOMElementFactory;
import org.drools.workbench.screens.scenariosimulation.client.metadata.ScenarioHeaderMetaData;
import org.drools.workbench.screens.scenariosimulation.client.models.ScenarioGridModel;
import org.drools.workbench.screens.scenariosimulation.client.resources.i18n.ScenarioSimulationEditorConstants;
import org.drools.workbench.screens.scenariosimulation.client.widgets.ScenarioGridColumn;
import org.drools.workbench.screens.scenariosimulation.model.typedescriptor.FactModelTree;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.widget.dom.single.impl.BaseSingletonDOMElementFactory;

public abstract class AbstractSelectedColumnCommandTest
extends AbstractScenarioGridCommandTest {
    @Mock
    protected List<GridColumn<?>> gridColumnsMock;
    @Mock
    protected FactModelTree factModelTreeMock;

    @Override
    public void setup() {
        super.setup();
        Mockito.when((Object)this.gridColumnsMock.indexOf(this.gridColumnMock)).thenReturn((Object)3);
        Mockito.when((Object)this.factModelTreeMock.getExpandableProperties()).thenReturn(Mockito.mock(SortedMap.class));
        Mockito.when(this.dataObjectFieldsMapMock.get(ArgumentMatchers.anyString())).thenReturn((Object)this.factModelTreeMock);
        this.scenarioSimulationContextLocal.getStatus().setFullPackage("test.scesim");
        this.scenarioSimulationContextLocal.getStatus().setValue("MULTIPART.VALUE");
        this.scenarioSimulationContextLocal.getStatus().setValueClassName(TestProperties.VALUE_CLASS_NAME);
        this.scenarioSimulationContextLocal.getStatus().setColumnId("COLUMN ID");
        this.scenarioSimulationContextLocal.getStatus().setColumnIndex(3);
        this.scenarioSimulationContextLocal.getStatus().setPropertyNameElements(TestProperties.MULTIPART_VALUE_ELEMENTS);
        this.scenarioSimulationContextLocal.getStatus().setClassName("TestClass");
    }

    @Test
    public void executeIfSelected() {
        this.commandSpy.execute(this.scenarioSimulationContextLocal);
        ((AbstractSelectedColumnCommand)Mockito.verify((Object)((AbstractSelectedColumnCommand)this.commandSpy), (VerificationMode)Mockito.times((int)1))).executeIfSelectedColumn(this.scenarioSimulationContextLocal, this.gridColumnMock);
    }

    @Test
    public void executeIfSelected_NoColumn() {
        this.gridColumnMock = null;
        this.commandSpy.execute(this.scenarioSimulationContextLocal);
        ((AbstractSelectedColumnCommand)Mockito.verify((Object)((AbstractSelectedColumnCommand)this.commandSpy), (VerificationMode)Mockito.never())).executeIfSelectedColumn(this.scenarioSimulationContextLocal, this.gridColumnMock);
    }

    @Test
    public void insertNewColumn_NotToClone() {
        this.insertNewColumnCommon(3, false);
    }

    @Test
    public void insertNewColumn_ToClone() {
        this.insertNewColumnCommon(3, true);
    }

    protected void insertNewColumnCommon(int columnIndex, boolean cloneInstance) {
        int instanceNum = this.simulationDescriptorMock.getUnmodifiableFactMappings().size();
        ScenarioGridColumn createdColumn = ((AbstractSelectedColumnCommand)this.commandSpy).insertNewColumn(this.scenarioSimulationContextLocal, this.gridColumnMock, columnIndex, cloneInstance);
        String columnGroup = this.gridColumnMock.getInformationHeaderMetaData().getColumnGroup();
        String originalInstanceTitle = this.gridColumnMock.getInformationHeaderMetaData().getTitle();
        String instanceTitle = cloneInstance ? originalInstanceTitle : "INSTANCE " + instanceNum;
        String propertyTitle = "PROPERTY " + instanceNum;
        FactMappingType factMappingType = FactMappingType.valueOf((String)columnGroup.toUpperCase());
        ((AbstractScenarioGridCommand)Mockito.verify((Object)this.commandSpy, (VerificationMode)Mockito.times((int)1))).getScenarioGridColumnLocal((String)ArgumentMatchers.eq((Object)instanceTitle), (String)ArgumentMatchers.eq((Object)propertyTitle), ArgumentMatchers.anyString(), (String)ArgumentMatchers.eq((Object)columnGroup), (FactMappingType)ArgumentMatchers.eq((Object)factMappingType), (ScenarioHeaderTextBoxSingletonDOMElementFactory)ArgumentMatchers.eq((Object)this.scenarioHeaderTextBoxSingletonDOMElementFactorySpy), (ScenarioCellTextAreaSingletonDOMElementFactory)ArgumentMatchers.eq((Object)this.scenarioCellTextAreaSingletonDOMElementFactorySpy), (String)ArgumentMatchers.eq((Object)ScenarioSimulationEditorConstants.INSTANCE.defineValidType()));
        if (cloneInstance) {
            ((ScenarioGridColumn)Mockito.verify((Object)createdColumn, (VerificationMode)Mockito.times((int)1))).setFactIdentifier((FactIdentifier)ArgumentMatchers.eq((Object)this.gridColumnMock.getFactIdentifier()));
        } else {
            ((ScenarioGridColumn)Mockito.verify((Object)createdColumn, (VerificationMode)Mockito.never())).setFactIdentifier((FactIdentifier)ArgumentMatchers.any());
        }
        ((ScenarioGridColumn)Mockito.verify((Object)createdColumn, (VerificationMode)Mockito.times((int)1))).setInstanceAssigned(ArgumentMatchers.eq((boolean)cloneInstance));
        ((ScenarioGridModel)Mockito.verify((Object)this.scenarioGridModelMock, (VerificationMode)Mockito.times((int)1))).insertColumn(3, (GridColumn)createdColumn);
    }

    @Test
    public void executeKeepDataFalseDMN() {
        this.scenarioSimulationContextLocal.getStatus().setKeepData(false);
        this.settingsLocal.setType(ScenarioSimulationModel.Type.DMN);
        this.commonSetPropertyHeader(ScenarioSimulationModel.Type.DMN, false, TestProperties.MULTIPART_VALUE_ELEMENTS, TestProperties.VALUE_CLASS_NAME);
    }

    @Test
    public void executeKeepDataFalseRule() {
        this.scenarioSimulationContextLocal.getStatus().setKeepData(false);
        this.commonSetPropertyHeader(ScenarioSimulationModel.Type.RULE, false, TestProperties.MULTIPART_VALUE_ELEMENTS, TestProperties.VALUE_CLASS_NAME);
    }

    @Test
    public void executeKeepDataTrue() {
        this.scenarioSimulationContextLocal.getStatus().setKeepData(true);
        this.commonSetPropertyHeader(ScenarioSimulationModel.Type.RULE, true, TestProperties.MULTIPART_VALUE_ELEMENTS, TestProperties.VALUE_CLASS_NAME);
    }

    @Test
    public void executeWithPropertyAsCollection() {
        this.scenarioSimulationContextLocal.getStatus().setValueClassName(TestProperties.LIST_CLASS_NAME);
        this.scenarioSimulationContextLocal.getStatus().setValue("TestClass.listProperty");
        ((AbstractSelectedColumnCommand)Mockito.doReturn((Object)this.factIdentifierMock).when((Object)((AbstractSelectedColumnCommand)this.commandSpy))).setEditableHeadersAndGetFactIdentifier((ScenarioSimulationContext)ArgumentMatchers.eq((Object)this.scenarioSimulationContextLocal), (ScenarioGridColumn)ArgumentMatchers.eq((Object)this.gridColumnMock), (String)ArgumentMatchers.eq((Object)"TestClass"), (String)ArgumentMatchers.eq((Object)"test.scesim.TestClass"));
        ((AbstractSelectedColumnCommand)this.commandSpy).setPropertyHeader(this.scenarioSimulationContextLocal, this.gridColumnMock, "test.scesim.TestClass", TestProperties.FULL_PROPERTY_PATH_ELEMENTS, TestProperties.LIST_CLASS_NAME);
        ((AbstractSelectedColumnCommand)Mockito.verify((Object)((AbstractSelectedColumnCommand)this.commandSpy), (VerificationMode)Mockito.times((int)2))).setInstanceHeaderMetaData((ScenarioGridColumn)ArgumentMatchers.eq((Object)this.gridColumnMock), (String)ArgumentMatchers.eq((Object)"TestClass"), (FactIdentifier)ArgumentMatchers.eq((Object)this.factIdentifierMock));
        ((ScenarioHeaderMetaData)Mockito.verify((Object)this.propertyHeaderMetaDataMock, (VerificationMode)Mockito.times((int)1))).setColumnGroup(ArgumentMatchers.anyString());
        ((ScenarioHeaderMetaData)Mockito.verify((Object)this.propertyHeaderMetaDataMock, (VerificationMode)Mockito.times((int)1))).setTitle((String)ArgumentMatchers.eq((Object)"listProperty"));
        ((ScenarioHeaderMetaData)Mockito.verify((Object)this.propertyHeaderMetaDataMock, (VerificationMode)Mockito.times((int)1))).setReadOnly(ArgumentMatchers.eq((boolean)false));
        ((ScenarioGridModel)Mockito.verify((Object)this.scenarioGridModelMock, (VerificationMode)Mockito.times((int)1))).updateColumnProperty(ArgumentMatchers.anyInt(), (GridColumn)ArgumentMatchers.eq((Object)this.gridColumnMock), (List)ArgumentMatchers.eq(TestProperties.FULL_PROPERTY_PATH_ELEMENTS), (String)ArgumentMatchers.eq((Object)TestProperties.LIST_CLASS_NAME), ArgumentMatchers.anyBoolean(), (FactMappingValueType)ArgumentMatchers.isA(FactMappingValueType.class), (ScenarioSimulationModel.Type)ArgumentMatchers.eq((Object)ScenarioSimulationModel.Type.RULE));
        ((AbstractSelectedColumnCommand)Mockito.verify((Object)((AbstractSelectedColumnCommand)this.commandSpy), (VerificationMode)Mockito.times((int)1))).manageCollectionProperty((ScenarioSimulationContext)ArgumentMatchers.eq((Object)this.scenarioSimulationContextLocal), (ScenarioGridColumn)ArgumentMatchers.eq((Object)this.gridColumnMock), (String)ArgumentMatchers.eq((Object)"TestClass"), ArgumentMatchers.eq((int)0), (List)ArgumentMatchers.eq(TestProperties.FULL_PROPERTY_PATH_ELEMENTS));
        ((AbstractSelectedColumnCommand)Mockito.verify((Object)((AbstractSelectedColumnCommand)this.commandSpy), (VerificationMode)Mockito.times((int)1))).navigateComplexObject((FactModelTree)ArgumentMatchers.eq((Object)this.factModelTreeMock), (List)ArgumentMatchers.eq(TestProperties.FULL_PROPERTY_PATH_ELEMENTS), (SortedMap)ArgumentMatchers.eq((Object)this.scenarioSimulationContextLocal.getDataObjectFieldsMap()));
    }

    @Test
    public void executePropertyWithSameInstance() {
        this.scenarioSimulationContextLocal.getStatus().setValueClassName(TestProperties.LIST_CLASS_NAME);
        this.scenarioSimulationContextLocal.getStatus().setValue("TestClass.listProperty");
        Mockito.when((Object)this.gridColumnMock.isInstanceAssigned()).thenReturn((Object)true);
        Mockito.when((Object)this.gridColumnMock.getInformationHeaderMetaData().getTitle()).thenReturn((Object)"TestClass");
        ((AbstractSelectedColumnCommand)this.commandSpy).setPropertyHeader(this.scenarioSimulationContextLocal, this.gridColumnMock, "test.scesim.TestClass", TestProperties.FULL_PROPERTY_PATH_ELEMENTS, TestProperties.LIST_CLASS_NAME);
        ((AbstractSelectedColumnCommand)Mockito.verify((Object)((AbstractSelectedColumnCommand)this.commandSpy), (VerificationMode)Mockito.never())).setInstanceHeaderMetaData((ScenarioGridColumn)ArgumentMatchers.eq((Object)this.gridColumnMock), (String)ArgumentMatchers.eq((Object)"TestClass"), (FactIdentifier)ArgumentMatchers.eq((Object)this.factIdentifierMock));
        ((ScenarioHeaderMetaData)Mockito.verify((Object)this.propertyHeaderMetaDataMock, (VerificationMode)Mockito.times((int)1))).setColumnGroup(ArgumentMatchers.anyString());
        ((ScenarioHeaderMetaData)Mockito.verify((Object)this.propertyHeaderMetaDataMock, (VerificationMode)Mockito.times((int)1))).setTitle((String)ArgumentMatchers.eq((Object)"listProperty"));
        ((ScenarioHeaderMetaData)Mockito.verify((Object)this.propertyHeaderMetaDataMock, (VerificationMode)Mockito.times((int)1))).setReadOnly(ArgumentMatchers.eq((boolean)false));
        ((ScenarioGridModel)Mockito.verify((Object)this.scenarioGridModelMock, (VerificationMode)Mockito.times((int)1))).updateColumnProperty(ArgumentMatchers.anyInt(), (GridColumn)ArgumentMatchers.eq((Object)this.gridColumnMock), (List)ArgumentMatchers.eq(TestProperties.FULL_PROPERTY_PATH_ELEMENTS), (String)ArgumentMatchers.eq((Object)TestProperties.LIST_CLASS_NAME), ArgumentMatchers.anyBoolean(), (FactMappingValueType)ArgumentMatchers.isA(FactMappingValueType.class), (ScenarioSimulationModel.Type)ArgumentMatchers.eq((Object)ScenarioSimulationModel.Type.RULE));
        ((AbstractSelectedColumnCommand)Mockito.verify((Object)((AbstractSelectedColumnCommand)this.commandSpy), (VerificationMode)Mockito.times((int)1))).manageCollectionProperty((ScenarioSimulationContext)ArgumentMatchers.eq((Object)this.scenarioSimulationContextLocal), (ScenarioGridColumn)ArgumentMatchers.eq((Object)this.gridColumnMock), (String)ArgumentMatchers.eq((Object)"TestClass"), ArgumentMatchers.eq((int)0), (List)ArgumentMatchers.eq(TestProperties.FULL_PROPERTY_PATH_ELEMENTS));
        ((AbstractSelectedColumnCommand)Mockito.verify((Object)((AbstractSelectedColumnCommand)this.commandSpy), (VerificationMode)Mockito.times((int)1))).navigateComplexObject((FactModelTree)ArgumentMatchers.eq((Object)this.factModelTreeMock), (List)ArgumentMatchers.eq(TestProperties.FULL_PROPERTY_PATH_ELEMENTS), (SortedMap)ArgumentMatchers.eq((Object)this.scenarioSimulationContextLocal.getDataObjectFieldsMap()));
    }

    @Test
    public void executePropertyWithPropertyTitle() {
        this.scenarioSimulationContextLocal.getStatus().setValueClassName(TestProperties.LIST_CLASS_NAME);
        this.scenarioSimulationContextLocal.getStatus().setValue("TestClass.listProperty");
        Mockito.when((Object)this.gridColumnMock.isInstanceAssigned()).thenReturn((Object)true);
        Mockito.when((Object)this.gridColumnMock.getInformationHeaderMetaData().getTitle()).thenReturn((Object)"TestClass");
        ((AbstractSelectedColumnCommand)this.commandSpy).setPropertyHeader(this.scenarioSimulationContextLocal, this.gridColumnMock, "test.scesim.TestClass", TestProperties.FULL_PROPERTY_PATH_ELEMENTS, TestProperties.LIST_CLASS_NAME, "testProperty");
        ((AbstractSelectedColumnCommand)Mockito.verify((Object)((AbstractSelectedColumnCommand)this.commandSpy), (VerificationMode)Mockito.never())).setInstanceHeaderMetaData((ScenarioGridColumn)ArgumentMatchers.eq((Object)this.gridColumnMock), (String)ArgumentMatchers.eq((Object)"TestClass"), (FactIdentifier)ArgumentMatchers.eq((Object)this.factIdentifierMock));
        ((ScenarioHeaderMetaData)Mockito.verify((Object)this.propertyHeaderMetaDataMock, (VerificationMode)Mockito.times((int)1))).setColumnGroup(ArgumentMatchers.anyString());
        ((ScenarioHeaderMetaData)Mockito.verify((Object)this.propertyHeaderMetaDataMock, (VerificationMode)Mockito.times((int)1))).setTitle((String)ArgumentMatchers.eq((Object)"testProperty"));
        ((ScenarioHeaderMetaData)Mockito.verify((Object)this.propertyHeaderMetaDataMock, (VerificationMode)Mockito.times((int)1))).setReadOnly(ArgumentMatchers.eq((boolean)false));
        ((ScenarioGridModel)Mockito.verify((Object)this.scenarioGridModelMock, (VerificationMode)Mockito.times((int)1))).updateColumnProperty(ArgumentMatchers.anyInt(), (GridColumn)ArgumentMatchers.eq((Object)this.gridColumnMock), (List)ArgumentMatchers.eq(TestProperties.FULL_PROPERTY_PATH_ELEMENTS), (String)ArgumentMatchers.eq((Object)TestProperties.LIST_CLASS_NAME), ArgumentMatchers.anyBoolean(), (FactMappingValueType)ArgumentMatchers.isA(FactMappingValueType.class), (ScenarioSimulationModel.Type)ArgumentMatchers.eq((Object)ScenarioSimulationModel.Type.RULE));
        ((AbstractSelectedColumnCommand)Mockito.verify((Object)((AbstractSelectedColumnCommand)this.commandSpy), (VerificationMode)Mockito.times((int)1))).manageCollectionProperty((ScenarioSimulationContext)ArgumentMatchers.eq((Object)this.scenarioSimulationContextLocal), (ScenarioGridColumn)ArgumentMatchers.eq((Object)this.gridColumnMock), (String)ArgumentMatchers.eq((Object)"TestClass"), ArgumentMatchers.eq((int)0), (List)ArgumentMatchers.eq(TestProperties.FULL_PROPERTY_PATH_ELEMENTS));
        ((AbstractSelectedColumnCommand)Mockito.verify((Object)((AbstractSelectedColumnCommand)this.commandSpy), (VerificationMode)Mockito.times((int)1))).navigateComplexObject((FactModelTree)ArgumentMatchers.eq((Object)this.factModelTreeMock), (List)ArgumentMatchers.eq(TestProperties.FULL_PROPERTY_PATH_ELEMENTS), (SortedMap)ArgumentMatchers.eq((Object)this.scenarioSimulationContextLocal.getDataObjectFieldsMap()));
    }

    @Test(expected=IllegalArgumentException.class)
    public void executePropertyWithWrongInstance() {
        this.scenarioSimulationContextLocal.getStatus().setValueClassName(TestProperties.LIST_CLASS_NAME);
        this.scenarioSimulationContextLocal.getStatus().setValue("TestClass.listProperty");
        Mockito.when((Object)this.gridColumnMock.isInstanceAssigned()).thenReturn((Object)true);
        ((AbstractSelectedColumnCommand)this.commandSpy).setPropertyHeader(this.scenarioSimulationContextLocal, this.gridColumnMock, "test.scesim.TestClass", TestProperties.FULL_PROPERTY_PATH_ELEMENTS, TestProperties.LIST_CLASS_NAME);
        ((AbstractSelectedColumnCommand)Mockito.verify((Object)((AbstractSelectedColumnCommand)this.commandSpy), (VerificationMode)Mockito.never())).setInstanceHeaderMetaData((ScenarioGridColumn)ArgumentMatchers.eq((Object)this.gridColumnMock), (String)ArgumentMatchers.eq((Object)"TestClass"), (FactIdentifier)ArgumentMatchers.eq((Object)this.factIdentifierMock));
        ((ScenarioHeaderMetaData)Mockito.verify((Object)this.propertyHeaderMetaDataMock, (VerificationMode)Mockito.never())).setColumnGroup(ArgumentMatchers.anyString());
        ((ScenarioHeaderMetaData)Mockito.verify((Object)this.propertyHeaderMetaDataMock, (VerificationMode)Mockito.never())).setTitle(ArgumentMatchers.anyString());
        ((ScenarioHeaderMetaData)Mockito.verify((Object)this.propertyHeaderMetaDataMock, (VerificationMode)Mockito.never())).setReadOnly(ArgumentMatchers.anyBoolean());
        ((ScenarioGridModel)Mockito.verify((Object)this.scenarioGridModelMock, (VerificationMode)Mockito.never())).updateColumnProperty(ArgumentMatchers.anyInt(), (GridColumn)ArgumentMatchers.eq((Object)this.gridColumnMock), (List)ArgumentMatchers.eq(TestProperties.FULL_PROPERTY_PATH_ELEMENTS), (String)ArgumentMatchers.eq((Object)TestProperties.LIST_CLASS_NAME), ArgumentMatchers.anyBoolean(), (FactMappingValueType)ArgumentMatchers.isA(FactMappingValueType.class), (ScenarioSimulationModel.Type)ArgumentMatchers.eq((Object)ScenarioSimulationModel.Type.RULE));
        ((AbstractSelectedColumnCommand)Mockito.verify((Object)((AbstractSelectedColumnCommand)this.commandSpy), (VerificationMode)Mockito.never())).manageCollectionProperty((ScenarioSimulationContext)ArgumentMatchers.eq((Object)this.scenarioSimulationContextLocal), (ScenarioGridColumn)ArgumentMatchers.eq((Object)this.gridColumnMock), (String)ArgumentMatchers.eq((Object)"TestClass"), ArgumentMatchers.eq((int)0), (List)ArgumentMatchers.eq(TestProperties.FULL_PROPERTY_PATH_ELEMENTS));
        ((AbstractSelectedColumnCommand)Mockito.verify((Object)((AbstractSelectedColumnCommand)this.commandSpy), (VerificationMode)Mockito.never())).navigateComplexObject((FactModelTree)ArgumentMatchers.eq((Object)this.factModelTreeMock), (List)ArgumentMatchers.eq(TestProperties.FULL_PROPERTY_PATH_ELEMENTS), (SortedMap)ArgumentMatchers.eq((Object)this.scenarioSimulationContextLocal.getDataObjectFieldsMap()));
    }

    @Test
    public void setInstanceHeaderMetaData() {
        ((AbstractSelectedColumnCommand)this.commandSpy).setInstanceHeaderMetaData(this.gridColumnMock, "FACT_NAME", this.factIdentifierMock);
        ((AbstractSelectedColumnCommand)Mockito.verify((Object)((AbstractSelectedColumnCommand)this.commandSpy))).setInstanceHeaderMetaData((ScenarioGridColumn)ArgumentMatchers.eq((Object)this.gridColumnMock), (String)ArgumentMatchers.eq((Object)"FACT_NAME"), (FactIdentifier)ArgumentMatchers.eq((Object)this.factIdentifierMock));
        ((ScenarioGridColumn)Mockito.verify((Object)this.gridColumnMock, (VerificationMode)Mockito.times((int)1))).setInstanceAssigned(true);
        ((ScenarioGridColumn)Mockito.verify((Object)this.gridColumnMock, (VerificationMode)Mockito.times((int)1))).setFactIdentifier((FactIdentifier)ArgumentMatchers.eq((Object)this.factIdentifierMock));
        ((ScenarioHeaderMetaData)Mockito.verify((Object)this.informationHeaderMetaDataMock, (VerificationMode)Mockito.times((int)1))).setTitle((String)ArgumentMatchers.eq((Object)"FACT_NAME"));
    }

    @Test
    public void getFullPackage() {
        this.scenarioSimulationContextLocal.getStatus().setFullPackage("test.scesim");
        String fullPackage = ((AbstractSelectedColumnCommand)this.commandSpy).getFullPackage(this.scenarioSimulationContextLocal);
        Assert.assertEquals((Object)fullPackage, (Object)"test.scesim.");
        this.scenarioSimulationContextLocal.getStatus().setFullPackage("");
        fullPackage = ((AbstractSelectedColumnCommand)this.commandSpy).getFullPackage(this.scenarioSimulationContextLocal);
        Assert.assertEquals((Object)"", (Object)fullPackage);
        this.scenarioSimulationContextLocal.getStatus().setFullPackage(null);
        fullPackage = ((AbstractSelectedColumnCommand)this.commandSpy).getFullPackage(this.scenarioSimulationContextLocal);
        Assert.assertEquals((Object)"", (Object)fullPackage);
    }

    public void manageCollectionProperty() {
        this.scenarioSimulationContextLocal.getStatus().setValueClassName(TestProperties.LIST_CLASS_NAME);
        this.scenarioSimulationContextLocal.getStatus().setValue("TestClass.listProperty");
        List<String> fullPropertyPathElements = Arrays.asList("TestClass.listProperty".split("\\."));
        ((AbstractSelectedColumnCommand)this.commandSpy).manageCollectionProperty(this.scenarioSimulationContextLocal, this.gridColumnMock, "TestClass.listProperty", 0, fullPropertyPathElements);
        ((AbstractSelectedColumnCommand)Mockito.verify((Object)((AbstractSelectedColumnCommand)this.commandSpy), (VerificationMode)Mockito.times((int)1))).navigateComplexObject((FactModelTree)ArgumentMatchers.eq((Object)this.factModelTreeMock), (List)ArgumentMatchers.eq(fullPropertyPathElements), (SortedMap)ArgumentMatchers.eq((Object)this.scenarioSimulationContextLocal.getDataObjectFieldsMap()));
        ((ScenarioGridColumn)Mockito.verify((Object)this.gridColumnMock, (VerificationMode)Mockito.times((int)1))).setFactory((BaseSingletonDOMElementFactory)ArgumentMatchers.eq((Object)this.scenarioSimulationContextLocal.getCollectionEditorSingletonDOMElementFactory(GridWidget.SIMULATION)));
        ((FactMapping)Mockito.verify((Object)this.factMappingMock, (VerificationMode)Mockito.times((int)1))).setGenericTypes((List)ArgumentMatchers.eq((Object)this.factModelTreeMock.getGenericTypeInfo("listProperty")));
    }

    public void manageSimpleTypeCollectionProperty() {
        Mockito.when((Object)this.factModelTreeMock.isSimple()).thenReturn((Object)true);
        this.scenarioSimulationContextLocal.getStatus().setValueClassName(TestProperties.LIST_CLASS_NAME);
        this.scenarioSimulationContextLocal.getStatus().setValue("TestClass.listProperty");
        List<String> fullPropertyPathElements = Arrays.asList("TestClass.listProperty".split("\\."));
        ((AbstractSelectedColumnCommand)this.commandSpy).manageCollectionProperty(this.scenarioSimulationContextLocal, this.gridColumnMock, "TestClass.listProperty", 0, fullPropertyPathElements);
        ((AbstractSelectedColumnCommand)Mockito.verify((Object)((AbstractSelectedColumnCommand)this.commandSpy), (VerificationMode)Mockito.never())).navigateComplexObject((FactModelTree)ArgumentMatchers.any(), (List)ArgumentMatchers.any(), (SortedMap)ArgumentMatchers.any());
        ((ScenarioGridColumn)Mockito.verify((Object)this.gridColumnMock, (VerificationMode)Mockito.times((int)1))).setFactory((BaseSingletonDOMElementFactory)ArgumentMatchers.eq((Object)this.scenarioSimulationContextLocal.getCollectionEditorSingletonDOMElementFactory(GridWidget.SIMULATION)));
        ((FactMapping)Mockito.verify((Object)this.factMappingMock, (VerificationMode)Mockito.times((int)1))).setGenericTypes((List)ArgumentMatchers.eq((Object)this.factModelTreeMock.getGenericTypeInfo("value")));
    }

    protected void commonSetPropertyHeader(ScenarioSimulationModel.Type type, boolean keepData, List<String> propertyNameElements, String propertyClass) {
        ((AbstractSelectedColumnCommand)this.commandSpy).setPropertyHeader(this.scenarioSimulationContextLocal, this.gridColumnMock, "test.scesim.TestClass", propertyNameElements, propertyClass);
        ((ScenarioGridColumn)Mockito.verify((Object)this.gridColumnMock, (VerificationMode)Mockito.times((int)1))).setEditableHeaders(ArgumentMatchers.eq((!type.equals((Object)ScenarioSimulationModel.Type.DMN) ? 1 : 0) != 0));
        ((ScenarioHeaderMetaData)Mockito.verify((Object)this.propertyHeaderMetaDataMock, (VerificationMode)Mockito.times((int)1))).setColumnGroup(ArgumentMatchers.anyString());
        ((ScenarioHeaderMetaData)Mockito.verify((Object)this.propertyHeaderMetaDataMock, (VerificationMode)Mockito.times((int)1))).setTitle(String.join((CharSequence)".", propertyNameElements.subList(1, propertyNameElements.size())));
        ((ScenarioHeaderMetaData)Mockito.verify((Object)this.propertyHeaderMetaDataMock, (VerificationMode)Mockito.times((int)1))).setReadOnly(false);
        ((ScenarioGridModel)Mockito.verify((Object)this.scenarioGridModelMock, (VerificationMode)Mockito.times((int)1))).updateColumnProperty(ArgumentMatchers.anyInt(), (GridColumn)ArgumentMatchers.eq((Object)this.gridColumnMock), (List)ArgumentMatchers.eq(propertyNameElements), (String)ArgumentMatchers.eq((Object)propertyClass), ArgumentMatchers.eq((boolean)keepData), (FactMappingValueType)ArgumentMatchers.isA(FactMappingValueType.class), (ScenarioSimulationModel.Type)ArgumentMatchers.eq((Object)type));
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.scenarioSimulationContextLocal.getScenarioSimulationEditorPresenter(), (VerificationMode)Mockito.times((int)1))).reloadTestTools(false);
    }

    protected void navigateComplexObject() {
        FactModelTree book = new FactModelTree("Book", "com.Book", new HashMap(), new HashMap());
        book.addExpandableProperty("author", "Author");
        FactModelTree author = new FactModelTree("Author", "com.Author", new HashMap(), new HashMap());
        SortedMap sortedMap = (SortedMap)Mockito.spy(new TreeMap());
        sortedMap.put("Book", book);
        sortedMap.put("Author", author);
        List<String> elements = Arrays.asList("Book", "author", "currentlyPrinted");
        FactModelTree target = ((AbstractSelectedColumnCommand)this.commandSpy).navigateComplexObject(book, elements, sortedMap);
        Assert.assertEquals((Object)target, (Object)author);
        ((SortedMap)Mockito.verify((Object)sortedMap, (VerificationMode)Mockito.times((int)1))).get("Author");
    }

    protected void navigateComplexObject3Levels() {
        FactModelTree book = new FactModelTree("Book", "com.Book", new HashMap(), new HashMap());
        book.addExpandableProperty("author", "Author");
        FactModelTree author = new FactModelTree("Author", "com.Author", new HashMap(), new HashMap());
        author.addExpandableProperty("firstBook", "Book");
        SortedMap sortedMap = (SortedMap)Mockito.spy(new TreeMap());
        sortedMap.put("Book", book);
        sortedMap.put("Author", author);
        List<String> elements = Arrays.asList("Book", "author", "firstBook", "topics");
        FactModelTree target = ((AbstractSelectedColumnCommand)this.commandSpy).navigateComplexObject(book, elements, sortedMap);
        Assert.assertEquals((Object)target, (Object)book);
        ((SortedMap)Mockito.verify((Object)sortedMap, (VerificationMode)Mockito.times((int)1))).get("Author");
    }

    protected void getPropertyHeaderTitle() {
        Optional emptyMatching = Optional.empty();
        ((AbstractSelectedColumnCommand)Mockito.doReturn(emptyMatching).when((Object)((AbstractSelectedColumnCommand)this.commandSpy))).getMatchingExpressionAlias((ScenarioSimulationContext)ArgumentMatchers.eq((Object)this.scenarioSimulationContextLocal), (List)ArgumentMatchers.eq(TestProperties.MULTIPART_VALUE_ELEMENTS), (FactIdentifier)ArgumentMatchers.eq((Object)this.factIdentifierMock));
        String retrieved = ((AbstractSelectedColumnCommand)this.commandSpy).getPropertyHeaderTitle(this.scenarioSimulationContextLocal, TestProperties.MULTIPART_VALUE_ELEMENTS, this.factIdentifierMock);
        ArrayList<String> propertyNameElements = new ArrayList<String>();
        propertyNameElements.add("TestClass");
        propertyNameElements.addAll(TestProperties.MULTIPART_VALUE_ELEMENTS.subList(1, TestProperties.MULTIPART_VALUE_ELEMENTS.size()));
        ((AbstractSelectedColumnCommand)Mockito.verify((Object)((AbstractSelectedColumnCommand)this.commandSpy), (VerificationMode)Mockito.times((int)1))).getMatchingExpressionAlias((ScenarioSimulationContext)ArgumentMatchers.eq((Object)this.scenarioSimulationContextLocal), (List)ArgumentMatchers.eq(propertyNameElements), (FactIdentifier)ArgumentMatchers.eq((Object)this.factIdentifierMock));
        String expected = String.join((CharSequence)".", TestProperties.MULTIPART_VALUE_ELEMENTS.subList(1, TestProperties.MULTIPART_VALUE_ELEMENTS.size()));
        Assert.assertEquals((Object)expected, (Object)retrieved);
        String EXPECTED_VALUE_STRING = "EXPECTED_VALUE_STRING";
        Optional<String> expectedValue = Optional.of("EXPECTED_VALUE_STRING");
        ((AbstractSelectedColumnCommand)Mockito.doReturn(expectedValue).when((Object)((AbstractSelectedColumnCommand)this.commandSpy))).getMatchingExpressionAlias((ScenarioSimulationContext)ArgumentMatchers.eq((Object)this.scenarioSimulationContextLocal), (List)ArgumentMatchers.eq(TestProperties.FULL_PROPERTY_NAME_ELEMENTS), (FactIdentifier)ArgumentMatchers.eq((Object)this.factIdentifierMock));
        retrieved = ((AbstractSelectedColumnCommand)this.commandSpy).getPropertyHeaderTitle(this.scenarioSimulationContextLocal, TestProperties.FULL_PROPERTY_NAME_ELEMENTS, this.factIdentifierMock);
        ((AbstractSelectedColumnCommand)Mockito.verify((Object)((AbstractSelectedColumnCommand)this.commandSpy), (VerificationMode)Mockito.times((int)1))).getMatchingExpressionAlias((ScenarioSimulationContext)ArgumentMatchers.eq((Object)this.scenarioSimulationContextLocal), (List)ArgumentMatchers.eq(TestProperties.FULL_PROPERTY_NAME_ELEMENTS), (FactIdentifier)ArgumentMatchers.eq((Object)this.factIdentifierMock));
        Assert.assertEquals((Object)EXPECTED_VALUE_STRING, (Object)retrieved);
        List<String> aliasedPropertyNameElements = Arrays.asList("TestClass_ALIAS", "testProperty");
        retrieved = ((AbstractSelectedColumnCommand)this.commandSpy).getPropertyHeaderTitle(this.scenarioSimulationContextLocal, aliasedPropertyNameElements, this.factIdentifierMock);
        ((AbstractSelectedColumnCommand)Mockito.verify((Object)((AbstractSelectedColumnCommand)this.commandSpy), (VerificationMode)Mockito.times((int)2))).getMatchingExpressionAlias((ScenarioSimulationContext)ArgumentMatchers.eq((Object)this.scenarioSimulationContextLocal), (List)ArgumentMatchers.eq(TestProperties.FULL_PROPERTY_NAME_ELEMENTS), (FactIdentifier)ArgumentMatchers.eq((Object)this.factIdentifierMock));
        Assert.assertEquals((Object)EXPECTED_VALUE_STRING, (Object)retrieved);
    }

    protected void getPropertyHeaderTitle_Value() {
        Optional emptyMatching = Optional.empty();
        ((AbstractSelectedColumnCommand)Mockito.doReturn(emptyMatching).when((Object)((AbstractSelectedColumnCommand)this.commandSpy))).getMatchingExpressionAlias((ScenarioSimulationContext)ArgumentMatchers.eq((Object)this.scenarioSimulationContextLocal), (List)ArgumentMatchers.eq(Collections.singletonList("TestClass")), (FactIdentifier)ArgumentMatchers.eq((Object)this.factIdentifierMock));
        String retrieved = ((AbstractSelectedColumnCommand)this.commandSpy).getPropertyHeaderTitle(this.scenarioSimulationContextLocal, Collections.singletonList("TestClass"), this.factIdentifierMock);
        Assert.assertEquals((Object)"value", (Object)retrieved);
    }

    protected void getPropertyHeaderTitle_Expression() {
        Optional emptyMatching = Optional.empty();
        ((AbstractSelectedColumnCommand)Mockito.doReturn(emptyMatching).when((Object)((AbstractSelectedColumnCommand)this.commandSpy))).getMatchingExpressionAlias((ScenarioSimulationContext)ArgumentMatchers.eq((Object)this.scenarioSimulationContextLocal), (List)ArgumentMatchers.eq(Collections.singletonList("TestClass")), (FactIdentifier)ArgumentMatchers.eq((Object)this.factIdentifierMock));
        ((AbstractSelectedColumnCommand)this.commandSpy).factMappingValueType = FactMappingValueType.EXPRESSION;
        String retrieved = ((AbstractSelectedColumnCommand)this.commandSpy).getPropertyHeaderTitle(this.scenarioSimulationContextLocal, Collections.singletonList("TestClass"), this.factIdentifierMock);
        Assert.assertEquals((Object)"expression </>", (Object)retrieved);
    }

    protected void getMatchingExpressionAlias() {
        Optional retrieved = ((AbstractSelectedColumnCommand)this.commandSpy).getMatchingExpressionAlias(this.scenarioSimulationContextLocal, TestProperties.MULTIPART_VALUE_ELEMENTS, this.factIdentifierMock);
        ((ScesimModelDescriptor)Mockito.verify((Object)this.simulationDescriptorMock, (VerificationMode)Mockito.times((int)1))).getFactMappingsByFactName((String)ArgumentMatchers.eq((Object)this.factIdentifierMock.getName()));
        Assert.assertEquals(Optional.empty(), (Object)retrieved);
        ArrayList<FactMapping> factMappingList = new ArrayList<FactMapping>();
        factMappingList.add(this.factMappingMock);
        Mockito.when((Object)this.simulationDescriptorMock.getFactMappingsByFactName("FACT_IDENTIFIER_NAME")).thenReturn(factMappingList.stream());
        String EXPRESSION_ALIAS = "EXPRESSION_ALIAS";
        Mockito.when((Object)this.factMappingMock.getExpressionAlias()).thenReturn((Object)EXPRESSION_ALIAS);
        retrieved = ((AbstractSelectedColumnCommand)this.commandSpy).getMatchingExpressionAlias(this.scenarioSimulationContextLocal, TestProperties.FULL_PROPERTY_NAME_ELEMENTS, this.factIdentifierMock);
        Assert.assertEquals(Optional.empty(), (Object)retrieved);
        List expressionElements = TestProperties.FULL_PROPERTY_NAME_ELEMENTS.stream().map(ExpressionElement::new).collect(Collectors.toList());
        Mockito.when((Object)this.factMappingMock.getExpressionElements()).thenReturn(expressionElements);
        Mockito.when((Object)this.simulationDescriptorMock.getFactMappingsByFactName("FACT_IDENTIFIER_NAME")).thenReturn(factMappingList.stream());
        retrieved = ((AbstractSelectedColumnCommand)this.commandSpy).getMatchingExpressionAlias(this.scenarioSimulationContextLocal, TestProperties.FULL_PROPERTY_NAME_ELEMENTS, this.factIdentifierMock);
        Assert.assertEquals(Optional.of(EXPRESSION_ALIAS), (Object)retrieved);
    }
}

