/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.editor.menu;

import com.google.gwt.dom.client.LIElement;
import com.google.gwtmockito.GwtMockitoTestRunner;
import com.google.web.bindery.event.shared.Event;
import java.util.Objects;
import org.drools.workbench.screens.scenariosimulation.client.editor.menu.AbstractColumnMenuPresenter;
import org.drools.workbench.screens.scenariosimulation.client.editor.menu.AbstractMenuTest;
import org.drools.workbench.screens.scenariosimulation.client.enums.GridWidget;
import org.drools.workbench.screens.scenariosimulation.client.events.DeleteColumnEvent;
import org.drools.workbench.screens.scenariosimulation.client.events.DuplicateInstanceEvent;
import org.drools.workbench.screens.scenariosimulation.client.events.InsertColumnEvent;
import org.drools.workbench.screens.scenariosimulation.client.resources.i18n.ScenarioSimulationEditorConstants;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=GwtMockitoTestRunner.class)
public class AbstractColumnMenuPresenterTest
extends AbstractMenuTest {
    @Override
    @Before
    public void setup() {
        this.abstractColumnMenuPresenter = new AbstractColumnMenuPresenter(){

            protected void updateExecutableMenuItemAttributes(LIElement toUpdate, String id, String label, String i18n) {
            }

            public void show(GridWidget gridWidget, int mx, int my) {
            }
        };
        super.setup();
    }

    @Test
    public void initMenu() {
        Assert.assertNull((Object)this.abstractColumnMenuPresenter.columnContextLIElement);
        Assert.assertNull((Object)this.abstractColumnMenuPresenter.insertColumnLeftLIElement);
        Assert.assertNull((Object)this.abstractColumnMenuPresenter.insertColumnRightLIElement);
        Assert.assertNull((Object)this.abstractColumnMenuPresenter.deleteColumnInstanceLIElement);
        Assert.assertNull((Object)this.abstractColumnMenuPresenter.duplicateInstanceLIElement);
        this.abstractColumnMenuPresenter.initMenu();
        Assert.assertNotNull((Object)this.abstractColumnMenuPresenter.columnContextLIElement);
        Assert.assertNotNull((Object)this.abstractColumnMenuPresenter.insertColumnLeftLIElement);
        Assert.assertNotNull((Object)this.abstractColumnMenuPresenter.insertColumnRightLIElement);
        Assert.assertNotNull((Object)this.abstractColumnMenuPresenter.deleteColumnInstanceLIElement);
        Assert.assertNotNull((Object)this.abstractColumnMenuPresenter.duplicateInstanceLIElement);
    }

    @Test
    public void showFalseFalseSimulation() {
        this.commonShow(GridWidget.SIMULATION, 4, 5, false, false, false);
    }

    @Test
    public void showFalseTrueSimulation() {
        this.commonShow(GridWidget.SIMULATION, 4, 5, false, true, false);
    }

    @Test
    public void showTrueFalseSimulation() {
        this.commonShow(GridWidget.SIMULATION, 4, 5, true, false, false);
    }

    @Test
    public void showTrueTrueSimulation() {
        this.commonShow(GridWidget.SIMULATION, 4, 5, true, true, false);
    }

    @Test
    public void showTrueTrueSimulation_NullDuplicateElement() {
        this.commonShow(GridWidget.SIMULATION, 4, 5, true, true, true);
    }

    @Test
    public void showFalseFalseBackground() {
        this.commonShow(GridWidget.BACKGROUND, 4, 5, false, false, false);
    }

    @Test
    public void showFalseTrueBackground() {
        this.commonShow(GridWidget.BACKGROUND, 4, 5, false, true, false);
    }

    @Test
    public void showTrueFalseBackground() {
        this.commonShow(GridWidget.BACKGROUND, 4, 5, true, false, false);
    }

    @Test
    public void showTrueTrueBackground_NotNullDuplicateInstanceLIElement() {
        this.commonShow(GridWidget.BACKGROUND, 4, 5, true, true, false);
    }

    @Test
    public void showTrueTrueBackground_NullDuplicateInstanceLIElement() {
        this.commonShow(GridWidget.BACKGROUND, 4, 5, true, true, true);
    }

    private void commonShow(GridWidget gridWidget, int mx, int my, boolean asProperty, boolean showDuplicateInstance, boolean nullDuplicateElement) {
        this.abstractColumnMenuPresenterSpy.initMenu();
        if (nullDuplicateElement) {
            this.abstractColumnMenuPresenterSpy.duplicateInstanceLIElement = null;
        }
        LIElement duplicateInstanceLIElementOriginal = this.abstractColumnMenuPresenterSpy.duplicateInstanceLIElement;
        LIElement deleteColumnInstanceLIElementOriginal = this.abstractColumnMenuPresenterSpy.deleteColumnInstanceLIElement;
        this.abstractColumnMenuPresenterSpy.show(gridWidget, mx, my, 1, "GIVEN", asProperty, showDuplicateInstance);
        if (Objects.equals(GridWidget.BACKGROUND, gridWidget)) {
            ((AbstractColumnMenuPresenter)Mockito.verify((Object)this.abstractColumnMenuPresenterSpy, (VerificationMode)Mockito.times((int)1))).updateMenuItemAttributes((LIElement)Matchers.eq((Object)this.gridTitleElementMock), (String)Matchers.any(), (String)Matchers.eq((Object)ScenarioSimulationEditorConstants.INSTANCE.background()), (String)Matchers.eq((Object)"background"));
        } else {
            ((AbstractColumnMenuPresenter)Mockito.verify((Object)this.abstractColumnMenuPresenterSpy, (VerificationMode)Mockito.times((int)1))).updateMenuItemAttributes((LIElement)Matchers.eq((Object)this.gridTitleElementMock), (String)Matchers.any(), (String)Matchers.eq((Object)ScenarioSimulationEditorConstants.INSTANCE.scenario()), (String)Matchers.eq((Object)"scenario"));
        }
        if (!Objects.equals(GridWidget.SIMULATION, gridWidget) || !showDuplicateInstance) {
            if (!nullDuplicateElement) {
                ((AbstractColumnMenuPresenter)Mockito.verify((Object)this.abstractColumnMenuPresenterSpy, (VerificationMode)Mockito.times((int)1))).removeMenuItem((LIElement)Matchers.eq((Object)duplicateInstanceLIElementOriginal));
            }
            Assert.assertNull((Object)this.abstractColumnMenuPresenterSpy.duplicateInstanceLIElement);
        } else if (nullDuplicateElement) {
            ((AbstractColumnMenuPresenter)Mockito.verify((Object)this.abstractColumnMenuPresenterSpy, (VerificationMode)Mockito.times((int)1))).addExecutableMenuItemAfter((String)Matchers.eq((Object)this.abstractColumnMenuPresenter.COLUMNCONTEXTMENU_DUPLICATE_INSTANCE), (String)Matchers.eq((Object)this.abstractColumnMenuPresenter.constants.duplicateInstance()), (String)Matchers.eq((Object)"duplicateInstance"), (LIElement)Matchers.eq((Object)deleteColumnInstanceLIElementOriginal));
        }
        ((AbstractColumnMenuPresenter)Mockito.verify((Object)this.abstractColumnMenuPresenterSpy, (VerificationMode)Mockito.atLeastOnce())).mapEvent((LIElement)Matchers.eq((Object)this.abstractColumnMenuPresenterSpy.insertColumnLeftLIElement), (Event)Matchers.isA(InsertColumnEvent.class));
        ((AbstractColumnMenuPresenter)Mockito.verify((Object)this.abstractColumnMenuPresenterSpy, (VerificationMode)Mockito.atLeastOnce())).mapEvent((LIElement)Matchers.eq((Object)this.abstractColumnMenuPresenterSpy.insertColumnRightLIElement), (Event)Matchers.isA(InsertColumnEvent.class));
        if (asProperty) {
            ((AbstractColumnMenuPresenter)Mockito.verify((Object)this.abstractColumnMenuPresenterSpy, (VerificationMode)Mockito.atLeastOnce())).updateExecutableMenuItemAttributes((LIElement)Matchers.eq((Object)this.abstractColumnMenuPresenterSpy.deleteColumnInstanceLIElement), (String)Matchers.eq((Object)this.abstractColumnMenuPresenter.COLUMNCONTEXTMENU_DELETE_COLUMN), (String)Matchers.eq((Object)this.abstractColumnMenuPresenter.constants.deleteColumn()), (String)Matchers.eq((Object)"deleteColumn"));
            ((AbstractColumnMenuPresenter)Mockito.verify((Object)this.abstractColumnMenuPresenterSpy, (VerificationMode)Mockito.atLeastOnce())).mapEvent((LIElement)Matchers.eq((Object)this.abstractColumnMenuPresenterSpy.deleteColumnInstanceLIElement), (Event)Matchers.isA(DeleteColumnEvent.class));
        } else {
            ((AbstractColumnMenuPresenter)Mockito.verify((Object)this.abstractColumnMenuPresenterSpy, (VerificationMode)Mockito.atLeastOnce())).updateExecutableMenuItemAttributes((LIElement)Matchers.eq((Object)deleteColumnInstanceLIElementOriginal), (String)Matchers.eq((Object)this.abstractColumnMenuPresenter.COLUMNCONTEXTMENU_DELETE_INSTANCE), (String)Matchers.eq((Object)this.abstractColumnMenuPresenter.constants.deleteInstance()), (String)Matchers.eq((Object)"deleteInstance"));
            ((AbstractColumnMenuPresenter)Mockito.verify((Object)this.abstractColumnMenuPresenterSpy, (VerificationMode)Mockito.atLeastOnce())).mapEvent((LIElement)Matchers.eq((Object)this.abstractColumnMenuPresenterSpy.deleteColumnInstanceLIElement), (Event)Matchers.isA(DeleteColumnEvent.class));
        }
        if (this.abstractColumnMenuPresenter.duplicateInstanceLIElement != null) {
            ((AbstractColumnMenuPresenter)Mockito.verify((Object)this.abstractColumnMenuPresenterSpy, (VerificationMode)Mockito.atLeastOnce())).mapEvent((LIElement)Matchers.eq((Object)this.abstractColumnMenuPresenterSpy.duplicateInstanceLIElement), (Event)Matchers.isA(DuplicateInstanceEvent.class));
        }
        ((AbstractColumnMenuPresenter)Mockito.verify((Object)this.abstractColumnMenuPresenterSpy, (VerificationMode)Mockito.atLeastOnce())).show((GridWidget)Matchers.eq((Object)gridWidget), Matchers.eq((int)mx), Matchers.eq((int)my));
        Mockito.reset((Object[])new AbstractColumnMenuPresenter[]{this.abstractColumnMenuPresenterSpy});
    }
}

