/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.commands.actualcommands;

import com.google.gwtmockito.GwtMockitoTestRunner;
import org.drools.workbench.screens.scenariosimulation.client.commands.actualcommands.AbstractScenarioSimulationCommand;
import org.drools.workbench.screens.scenariosimulation.client.commands.actualcommands.AbstractScenarioSimulationCommandTest;
import org.drools.workbench.screens.scenariosimulation.client.commands.actualcommands.ReloadTestToolsCommand;
import org.drools.workbench.screens.scenariosimulation.client.editor.ScenarioSimulationEditorPresenter;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=GwtMockitoTestRunner.class)
public class ReloadTestToolsCommandTest
extends AbstractScenarioSimulationCommandTest {
    @Override
    @Before
    public void setup() {
        super.setup();
        this.command = (AbstractScenarioSimulationCommand)Mockito.spy((Object)new ReloadTestToolsCommand());
        this.scenarioSimulationContextLocal.setScenarioSimulationEditorPresenter(this.scenarioSimulationEditorPresenterMock);
    }

    @Test
    public void executeDisableOpen() {
        this.scenarioSimulationContextLocal.getStatus().setDisable(true);
        this.scenarioSimulationContextLocal.getStatus().setOpenDock(true);
        this.command.execute(this.scenarioSimulationContextLocal);
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.scenarioSimulationEditorPresenterMock, (VerificationMode)Mockito.times((int)1))).expandToolsDock();
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.scenarioSimulationEditorPresenterMock, (VerificationMode)Mockito.times((int)1))).reloadTestTools(Matchers.eq((boolean)true));
    }

    @Test
    public void executeNotDisableOpen() {
        this.scenarioSimulationContextLocal.getStatus().setDisable(false);
        this.scenarioSimulationContextLocal.getStatus().setOpenDock(true);
        this.command.execute(this.scenarioSimulationContextLocal);
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.scenarioSimulationEditorPresenterMock, (VerificationMode)Mockito.times((int)1))).expandToolsDock();
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.scenarioSimulationEditorPresenterMock, (VerificationMode)Mockito.times((int)1))).reloadTestTools(Matchers.eq((boolean)false));
    }

    @Test
    public void executeDisableNotOpen() {
        this.scenarioSimulationContextLocal.getStatus().setDisable(true);
        this.scenarioSimulationContextLocal.getStatus().setOpenDock(false);
        this.command.execute(this.scenarioSimulationContextLocal);
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.scenarioSimulationEditorPresenterMock, (VerificationMode)Mockito.never())).expandToolsDock();
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.scenarioSimulationEditorPresenterMock, (VerificationMode)Mockito.times((int)1))).reloadTestTools(Matchers.eq((boolean)true));
    }
}

