/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.models;

import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.GwtEvent;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.drools.scenariosimulation.api.model.AbstractScesimData;
import org.drools.scenariosimulation.api.model.AbstractScesimModel;
import org.drools.scenariosimulation.api.model.ExpressionElement;
import org.drools.scenariosimulation.api.model.ExpressionIdentifier;
import org.drools.scenariosimulation.api.model.FactIdentifier;
import org.drools.scenariosimulation.api.model.FactMapping;
import org.drools.scenariosimulation.api.model.FactMappingType;
import org.drools.scenariosimulation.api.model.FactMappingValue;
import org.drools.scenariosimulation.api.model.FactMappingValueStatus;
import org.drools.scenariosimulation.api.model.FactMappingValueType;
import org.drools.scenariosimulation.api.model.ScenarioSimulationModel;
import org.drools.scenariosimulation.api.model.ScesimModelDescriptor;
import org.drools.scenariosimulation.api.utils.ScenarioSimulationSharedUtils;
import org.drools.workbench.screens.scenariosimulation.client.enums.GridWidget;
import org.drools.workbench.screens.scenariosimulation.client.events.ReloadTestToolsEvent;
import org.drools.workbench.screens.scenariosimulation.client.events.ScenarioGridReloadEvent;
import org.drools.workbench.screens.scenariosimulation.client.events.ScenarioNotificationEvent;
import org.drools.workbench.screens.scenariosimulation.client.factories.CollectionEditorSingletonDOMElementFactory;
import org.drools.workbench.screens.scenariosimulation.client.factories.ScenarioCellTextAreaSingletonDOMElementFactory;
import org.drools.workbench.screens.scenariosimulation.client.factories.ScenarioExpressionCellTextAreaSingletonDOMElementFactory;
import org.drools.workbench.screens.scenariosimulation.client.factories.ScenarioHeaderTextBoxSingletonDOMElementFactory;
import org.drools.workbench.screens.scenariosimulation.client.metadata.ScenarioHeaderMetaData;
import org.drools.workbench.screens.scenariosimulation.client.resources.i18n.ScenarioSimulationEditorConstants;
import org.drools.workbench.screens.scenariosimulation.client.utils.ScenarioSimulationUtils;
import org.drools.workbench.screens.scenariosimulation.client.values.ScenarioGridCellValue;
import org.drools.workbench.screens.scenariosimulation.client.widgets.ScenarioGridCell;
import org.drools.workbench.screens.scenariosimulation.client.widgets.ScenarioGridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridCell;
import org.uberfire.ext.wires.core.grids.client.model.GridCellValue;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.model.GridRow;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridData;
import org.uberfire.ext.wires.core.grids.client.widget.dom.single.impl.BaseSingletonDOMElementFactory;
import org.uberfire.workbench.events.NotificationEvent;

public abstract class AbstractScesimGridModel<T extends AbstractScesimModel<E>, E extends AbstractScesimData>
extends BaseGridData {
    public static final int HEADER_ROW_COUNT = 3;
    protected T abstractScesimModel;
    protected EventBus eventBus;
    protected AtomicInteger columnCounter = new AtomicInteger(0);
    protected GridColumn<?> selectedColumn = null;
    protected Set<String> simpleJavaTypeInstancesName;
    protected CollectionEditorSingletonDOMElementFactory collectionEditorSingletonDOMElementFactory;
    protected ScenarioCellTextAreaSingletonDOMElementFactory scenarioCellTextAreaSingletonDOMElementFactory;
    protected ScenarioHeaderTextBoxSingletonDOMElementFactory scenarioHeaderTextBoxSingletonDOMElementFactory;
    protected ScenarioExpressionCellTextAreaSingletonDOMElementFactory scenarioExpressionCellTextAreaSingletonDOMElementFactory;

    public AbstractScesimGridModel() {
    }

    public AbstractScesimGridModel(boolean isMerged) {
        super(isMerged);
        this.setHeaderRowCount(3);
    }

    public abstract GridWidget getGridWidget();

    public void bindContent(T abstractScesimModel) {
        this.abstractScesimModel = abstractScesimModel;
        this.checkSimulation();
        this.columnCounter.set(abstractScesimModel.getScesimModelDescriptor().getUnmodifiableFactMappings().size());
    }

    public void setEventBus(EventBus eventBus) {
        this.eventBus = eventBus;
    }

    public int nextColumnCount() {
        return this.columnCounter.getAndIncrement();
    }

    public Map.Entry<String, String> getValidPlaceholders() {
        String propertyTitle;
        String instanceTitle;
        do {
            int nextColumnCount = this.nextColumnCount();
            instanceTitle = FactMapping.getInstancePlaceHolder((int)nextColumnCount);
            propertyTitle = FactMapping.getPropertyPlaceHolder((int)nextColumnCount);
        } while (!this.isNewInstanceName(instanceTitle) || !this.isNewPropertyName(propertyTitle));
        return new AbstractMap.SimpleEntry<String, String>(instanceTitle, propertyTitle);
    }

    public CollectionEditorSingletonDOMElementFactory getCollectionEditorSingletonDOMElementFactory() {
        return this.collectionEditorSingletonDOMElementFactory;
    }

    public void setCollectionEditorSingletonDOMElementFactory(CollectionEditorSingletonDOMElementFactory collectionEditorSingletonDOMElementFactory) {
        this.collectionEditorSingletonDOMElementFactory = collectionEditorSingletonDOMElementFactory;
    }

    public ScenarioCellTextAreaSingletonDOMElementFactory getScenarioCellTextAreaSingletonDOMElementFactory() {
        return this.scenarioCellTextAreaSingletonDOMElementFactory;
    }

    public void setScenarioCellTextAreaSingletonDOMElementFactory(ScenarioCellTextAreaSingletonDOMElementFactory scenarioCellTextAreaSingletonDOMElementFactory) {
        this.scenarioCellTextAreaSingletonDOMElementFactory = scenarioCellTextAreaSingletonDOMElementFactory;
    }

    public ScenarioHeaderTextBoxSingletonDOMElementFactory getScenarioHeaderTextBoxSingletonDOMElementFactory() {
        return this.scenarioHeaderTextBoxSingletonDOMElementFactory;
    }

    public void setScenarioHeaderTextBoxSingletonDOMElementFactory(ScenarioHeaderTextBoxSingletonDOMElementFactory scenarioHeaderTextBoxSingletonDOMElementFactory) {
        this.scenarioHeaderTextBoxSingletonDOMElementFactory = scenarioHeaderTextBoxSingletonDOMElementFactory;
    }

    public ScenarioExpressionCellTextAreaSingletonDOMElementFactory getScenarioExpressionCellTextAreaSingletonDOMElementFactory() {
        return this.scenarioExpressionCellTextAreaSingletonDOMElementFactory;
    }

    public void setScenarioExpressionCellTextAreaSingletonDOMElementFactory(ScenarioExpressionCellTextAreaSingletonDOMElementFactory scenarioExpressionCellTextAreaSingletonDOMElementFactory) {
        this.scenarioExpressionCellTextAreaSingletonDOMElementFactory = scenarioExpressionCellTextAreaSingletonDOMElementFactory;
    }

    public void destroyAllTextAreaDOMElementFactoryResources() {
        this.scenarioCellTextAreaSingletonDOMElementFactory.destroyResources();
        this.scenarioExpressionCellTextAreaSingletonDOMElementFactory.destroyResources();
        this.scenarioHeaderTextBoxSingletonDOMElementFactory.destroyResources();
    }

    public void appendRow(GridRow row) {
        this.checkSimulation();
        super.appendRow(row);
        int rowIndex = this.getRowCount() - 1;
        this.commonAddRow(rowIndex);
    }

    public abstract void insertRowGridOnly(int var1, GridRow var2, E var3);

    public void insertRowGridOnly(int rowIndex, GridRow row) {
        this.checkSimulation();
        super.insertRow(rowIndex, row);
    }

    public void insertRow(int rowIndex, GridRow row) {
        this.insertRowGridOnly(rowIndex, row);
        this.commonAddRow(rowIndex);
    }

    public GridData.Range deleteRow(int rowIndex) {
        this.checkSimulation();
        GridData.Range toReturn = super.deleteRow(rowIndex);
        this.abstractScesimModel.removeDataByIndex(rowIndex);
        this.updateIndexColumn();
        return toReturn;
    }

    public void duplicateRow(int rowIndex, GridRow row) {
        this.checkSimulation();
        int newRowIndex = rowIndex + 1;
        AbstractScesimData toDuplicate = this.abstractScesimModel.cloneData(rowIndex, newRowIndex);
        this.insertRowGridOnly(newRowIndex, row, toDuplicate);
    }

    public void duplicateColumnValues(int originalColumnIndex, int newColumnIndex) {
        this.checkSimulation();
        ArrayList originalValues = new ArrayList();
        IntStream.range(0, this.getRowCount()).forEach(rowIndex -> originalValues.add(this.getCell(rowIndex, originalColumnIndex).getValue()));
        IntStream.range(0, this.getRowCount()).forEach(rowIndex -> this.setCellValue(rowIndex, newColumnIndex, (GridCellValue)originalValues.get(rowIndex)));
    }

    public void insertColumnGridOnly(int index, GridColumn<?> column) {
        this.checkSimulation();
        super.insertColumn(index, column);
    }

    public void insertColumn(int index, GridColumn<?> column) {
        this.checkSimulation();
        this.commonAddColumn(index, column);
    }

    public void deleteColumn(int columnIndex) {
        this.checkSimulation();
        GridColumn toDelete = (GridColumn)this.getColumns().get(columnIndex);
        this.deleteColumn(toDelete);
        this.abstractScesimModel.removeFactMappingByIndex(columnIndex);
    }

    public void deleteInstance(int columnIndex) {
        this.checkSimulation();
        GridData.Range instanceRange = this.getInstanceLimits(columnIndex);
        IntStream.iterate(instanceRange.getMaxRowIndex(), i -> i - 1).limit((long)(instanceRange.getMaxRowIndex() - instanceRange.getMinRowIndex()) + 1L).forEach(this::deleteColumn);
    }

    public void updateColumnInstance(int columnIndex, GridColumn<?> column) {
        this.checkSimulation();
        this.replaceColumn(columnIndex, column);
    }

    public void updateColumnProperty(int columnIndex, GridColumn<?> column, List<String> propertyNameElements, String lastLevelClassName, boolean keepData, FactMappingValueType valueType, ScenarioSimulationModel.Type type) {
        this.checkSimulation();
        ArrayList originalValues = new ArrayList();
        if (keepData) {
            IntStream.range(0, this.getRowCount()).forEach(rowIndex -> originalValues.add(this.getCell(rowIndex, columnIndex).getValue()));
        }
        this.replaceColumn(columnIndex, column);
        FactMapping factMappingByIndex = this.abstractScesimModel.getScesimModelDescriptor().getFactMappingByIndex(columnIndex);
        factMappingByIndex.setFactMappingValueType(valueType);
        List<String> propertyNameElementsClone = ScenarioSimulationUtils.getPropertyNameElementsWithoutAlias(propertyNameElements, factMappingByIndex.getFactIdentifier(), type);
        IntStream.range(0, propertyNameElementsClone.size()).forEach(stepIndex -> factMappingByIndex.addExpressionElement((String)propertyNameElementsClone.get(stepIndex), lastLevelClassName));
        if (keepData) {
            IntStream.range(0, this.getRowCount()).forEach(rowIndex -> this.setCellValue(rowIndex, columnIndex, (GridCellValue)originalValues.get(rowIndex)));
        }
    }

    protected void replaceColumn(int columnIndex, GridColumn<?> column) {
        List widthsToRestore = this.getColumns().stream().map(GridColumn::getWidth).collect(Collectors.toList());
        this.deleteColumn(columnIndex);
        String group = ((ScenarioGridColumn)column).getInformationHeaderMetaData().getColumnGroup();
        String columnId = ((ScenarioGridColumn)column).getInformationHeaderMetaData().getColumnId();
        ExpressionIdentifier ei = ExpressionIdentifier.create((String)columnId, (FactMappingType)FactMappingType.valueOf((String)group));
        this.commonAddColumn(columnIndex, column, ei);
        IntStream.range(0, widthsToRestore.size()).forEach(index -> ((GridColumn)this.getColumns().get(index)).setWidth(((Double)widthsToRestore.get(index)).doubleValue()));
    }

    public GridData.Range setCellGridOnly(int rowIndex, int columnIndex, Supplier<GridCell<?>> cellSupplier) {
        this.checkSimulation();
        return super.setCell(rowIndex, columnIndex, cellSupplier);
    }

    public GridData.Range setCell(int rowIndex, int columnIndex, Supplier<GridCell<?>> cellSupplier) {
        this.checkSimulation();
        GridData.Range toReturn = super.setCell(rowIndex, columnIndex, cellSupplier);
        try {
            Optional<?> optionalValue = this.getCellValue(this.getCell(rowIndex, columnIndex));
            Object rawValue = optionalValue.orElse(null);
            String cellValue = rawValue instanceof String ? (String)rawValue : null;
            AbstractScesimData scenarioByIndex = this.abstractScesimModel.getDataByIndex(rowIndex);
            FactMapping factMappingByIndex = this.abstractScesimModel.getScesimModelDescriptor().getFactMappingByIndex(columnIndex);
            FactIdentifier factIdentifier = factMappingByIndex.getFactIdentifier();
            ExpressionIdentifier expressionIdentifier = factMappingByIndex.getExpressionIdentifier();
            scenarioByIndex.addOrUpdateMappingValue(factIdentifier, expressionIdentifier, (Object)cellValue);
        }
        catch (Exception e) {
            toReturn = super.deleteCell(rowIndex, columnIndex);
            this.eventBus.fireEvent((GwtEvent)new ScenarioGridReloadEvent(this.getGridWidget()));
        }
        return toReturn;
    }

    public GridData.Range setCellValue(int rowIndex, int columnIndex, GridCellValue<?> value) {
        return this.setCell(rowIndex, columnIndex, () -> {
            ScenarioGridCell newCell = new ScenarioGridCell((ScenarioGridCellValue)value);
            FactMapping factMappingByIndex = this.abstractScesimModel.getScesimModelDescriptor().getFactMappingByIndex(columnIndex);
            if (ScenarioSimulationSharedUtils.isCollection((String)factMappingByIndex.getClassName())) {
                newCell.setListMap(ScenarioSimulationSharedUtils.isList((String)factMappingByIndex.getClassName()));
            }
            return newCell;
        });
    }

    public GridData.Range deleteCell(int rowIndex, int columnIndex) {
        FactMapping factMapping = this.abstractScesimModel.getScesimModelDescriptor().getFactMappingByIndex(columnIndex);
        this.abstractScesimModel.getDataByIndex(rowIndex).removeFactMappingValueByIdentifiers(factMapping.getFactIdentifier(), factMapping.getExpressionIdentifier());
        return super.deleteCell(rowIndex, columnIndex);
    }

    public abstract GridData.Range getInstanceLimits(int var1);

    public List<ScenarioGridColumn> getInstanceScenarioGridColumns(int columnIndex) {
        GridData.Range instanceRange = this.getInstanceLimits(columnIndex);
        return this.columns.subList(instanceRange.getMinRowIndex(), instanceRange.getMaxRowIndex() + 1).stream().map(gridColumn -> (ScenarioGridColumn)((Object)gridColumn)).collect(Collectors.toList());
    }

    public List<ScenarioGridColumn> getInstanceScenarioGridColumns(ScenarioGridColumn selectedColumn) {
        int columnIndex = this.columns.indexOf((Object)selectedColumn);
        return this.getInstanceScenarioGridColumns(columnIndex);
    }

    public int getFirstIndexLeftOfGroup(String groupName) {
        List columns = this.getColumns();
        Optional<Integer> first = columns.stream().filter(gridColumn -> ((ScenarioGridColumn)((Object)gridColumn)).getInformationHeaderMetaData().getColumnGroup().equals(groupName)).findFirst().map(gridColumn -> {
            int indexOfColumn = columns.indexOf(gridColumn);
            return indexOfColumn > -1 ? indexOfColumn : 0;
        });
        return first.orElseGet(() -> 0);
    }

    public int getFirstIndexRightOfGroup(String groupName) {
        Optional<Integer> last = this.getColumns().stream().filter(gridColumn -> ((ScenarioGridColumn)((Object)gridColumn)).getInformationHeaderMetaData().getColumnGroup().equals(groupName)).reduce((first, second) -> second).map(gridColumn -> {
            int indexOfColumn = this.getColumns().indexOf(gridColumn);
            return indexOfColumn > -1 ? indexOfColumn + 1 : this.getColumnCount();
        });
        return last.orElseGet(() -> ((AbstractScesimGridModel)this).getColumnCount());
    }

    public long getGroupSize(String groupName) {
        return this.getColumns().stream().filter(gridColumn -> ((ScenarioGridColumn)((Object)gridColumn)).getInformationHeaderMetaData().getColumnGroup().equals(groupName)).count();
    }

    public int getInstancesCount(String className) {
        return this.abstractScesimModel.getScesimModelDescriptor().getUnmodifiableFactMappings().stream().filter(factMapping -> factMapping.getFactIdentifier().getClassName().equals(className)).collect(Collectors.groupingBy(FactMapping::getFactAlias)).size();
    }

    public void updateHeader(int columnIndex, int headerRowIndex, String headerCellValue) {
        ScenarioHeaderMetaData editedMetadata = (ScenarioHeaderMetaData)((Object)((GridColumn)this.getColumns().get(columnIndex)).getHeaderMetaData().get(headerRowIndex));
        if (Objects.equals(editedMetadata.getTitle(), headerCellValue)) {
            return;
        }
        ScesimModelDescriptor simulationDescriptor = this.abstractScesimModel.getScesimModelDescriptor();
        FactMapping factMappingToEdit = simulationDescriptor.getFactMappingByIndex(columnIndex);
        ScenarioHeaderMetaData.MetadataType metadataType = editedMetadata.getMetadataType();
        IntStream.range(0, this.getColumnCount()).forEach(index -> this.updateFactMapping(simulationDescriptor, factMappingToEdit, index, headerCellValue, metadataType));
        if (editedMetadata.getMetadataType().equals((Object)ScenarioHeaderMetaData.MetadataType.INSTANCE)) {
            this.eventBus.fireEvent((GwtEvent)new ReloadTestToolsEvent(false));
        }
    }

    public void clear() {
        int to = this.getRowCount();
        IntStream.range(0, to).map(i -> to - i - 1).forEach(x$0 -> super.deleteRow(x$0));
        ArrayList copyList = new ArrayList(this.getColumns());
        copyList.forEach(x$0 -> super.deleteColumn(x$0));
        if (this.abstractScesimModel != null) {
            this.abstractScesimModel.clear();
        }
    }

    public void clearSelections() {
        super.clearSelections();
        this.selectedColumn = null;
    }

    public boolean forceRefreshWidth() {
        return this.internalRefreshWidth(true, OptionalDouble.empty());
    }

    public void synchronizeFactMappingsWidths() {
        this.getColumns().forEach(this::synchronizeFactMappingWidth);
    }

    public void synchronizeFactMappingWidth(GridColumn<?> column) {
        if (!column.isVisible()) {
            return;
        }
        int columnIndex = this.getColumns().indexOf(column);
        FactMapping factMapping = this.abstractScesimModel.getScesimModelDescriptor().getFactMappingByIndex(columnIndex);
        factMapping.setColumnWidth(Double.valueOf(column.getWidth()));
    }

    public void loadFactMappingsWidth() {
        for (GridColumn column : this.getColumns()) {
            int columnIndex = this.getColumns().indexOf(column);
            FactMapping factMapping = this.abstractScesimModel.getScesimModelDescriptor().getFactMappingByIndex(columnIndex);
            if (factMapping.getColumnWidth() == null) continue;
            column.setWidth(factMapping.getColumnWidth().doubleValue());
        }
    }

    public void selectColumn(int columnIndex) {
        if (columnIndex > this.getColumnCount() - 1 || columnIndex < 0) {
            throw new IllegalArgumentException("Wrong column index: " + columnIndex);
        }
        this.selectedColumn = (GridColumn)this.getColumns().get(columnIndex);
    }

    public void selectRow(int rowIndex) {
        if (rowIndex > this.getRowCount() - 1) {
            return;
        }
        int columns = this.getColumnCount();
        IntStream.range(0, columns).forEach(columnIndex -> this.selectCell(rowIndex, columnIndex));
    }

    public GridColumn<?> getSelectedColumn() {
        return this.selectedColumn;
    }

    public Optional<T> getAbstractScesimModel() {
        return Optional.ofNullable(this.abstractScesimModel);
    }

    public boolean isSelectedColumnEmpty() {
        return this.selectedColumn == null || this.isColumnEmpty(this.getColumns().indexOf(this.selectedColumn));
    }

    public boolean isColumnEmpty(int columnIndex) {
        return IntStream.range(0, this.getRowCount()).noneMatch(rowIndex -> this.getCellValue(this.getCell(rowIndex, columnIndex)).isPresent());
    }

    public boolean isAlreadyAssignedProperty(List<String> propertyNameElements) {
        boolean toReturn;
        boolean bl = toReturn = this.selectedColumn == null;
        if (!toReturn) {
            try {
                this.checkAlreadyAssignedProperty(this.getColumns().indexOf(this.selectedColumn), propertyNameElements);
            }
            catch (Exception e) {
                toReturn = true;
            }
        }
        return toReturn;
    }

    public void checkAlreadyAssignedProperty(int columnIndex, List<String> propertyNameElements) {
        GridData.Range instanceLimits = this.getInstanceLimits(columnIndex);
        ScesimModelDescriptor simulationDescriptor = this.abstractScesimModel.getScesimModelDescriptor();
        FactIdentifier factIdentifier = simulationDescriptor.getFactMappingByIndex(columnIndex).getFactIdentifier();
        ArrayList<String> propertyNameElementsClone = new ArrayList<String>();
        propertyNameElementsClone.add(factIdentifier.getClassNameWithoutPackage());
        propertyNameElementsClone.addAll(propertyNameElements.subList(1, propertyNameElements.size()));
        if (IntStream.range(instanceLimits.getMinRowIndex(), instanceLimits.getMaxRowIndex() + 1).filter(index -> index != columnIndex).mapToObj(arg_0 -> ((ScesimModelDescriptor)simulationDescriptor).getFactMappingByIndex(arg_0)).anyMatch(factMapping -> {
            List factMappingPropertyNameElements = factMapping.getExpressionElements().stream().map(ExpressionElement::getStep).collect(Collectors.toList());
            return Objects.equals(factMappingPropertyNameElements, propertyNameElementsClone);
        })) {
            throw new IllegalStateException(String.join((CharSequence)".", propertyNameElements) + " has already been used in the current instance.");
        }
    }

    public boolean isSameSelectedColumnProperty(List<String> propertyNameElements) {
        return this.selectedColumn == null || this.isSameSelectedColumnProperty(this.getColumns().indexOf(this.selectedColumn), propertyNameElements);
    }

    public boolean isSameSelectedColumnProperty(int columnIndex, List<String> propertyNameElements) {
        String propertyName = String.join((CharSequence)".", propertyNameElements);
        ScesimModelDescriptor simulationDescriptor = this.abstractScesimModel.getScesimModelDescriptor();
        FactMapping factMappingByIndex = simulationDescriptor.getFactMappingByIndex(columnIndex);
        String expressionElement = factMappingByIndex.getExpressionElements().stream().map(ExpressionElement::getStep).collect(Collectors.joining("."));
        return Objects.equals(expressionElement, propertyName);
    }

    public boolean isSameSelectedColumnType(String className) {
        return this.selectedColumn == null || this.isSameSelectedColumnType(this.getColumns().indexOf(this.selectedColumn), className);
    }

    public boolean isSameSelectedColumnType(int columnIndex, String className) {
        ScesimModelDescriptor simulationDescriptor = this.abstractScesimModel.getScesimModelDescriptor();
        FactMapping factMappingByIndex = simulationDescriptor.getFactMappingByIndex(columnIndex);
        return factMappingByIndex.getClassName().equals(className);
    }

    public boolean isSameInstanceType(String className) {
        return this.selectedColumn == null || this.isSameInstanceType(this.getColumns().indexOf(this.selectedColumn), className);
    }

    public void checkSameInstanceHeader(int columnIndex, String headerName) {
        if (!this.isSameInstanceType(columnIndex, headerName)) {
            throw new IllegalStateException(headerName + " is not the class of the current column.");
        }
    }

    public boolean isSameInstanceType(int columnIndex, String headerName) {
        ScesimModelDescriptor simulationDescriptor = this.abstractScesimModel.getScesimModelDescriptor();
        FactIdentifier factIdentifierByIndex = simulationDescriptor.getFactMappingByIndex(columnIndex).getFactIdentifier();
        return Objects.equals(factIdentifierByIndex.getClassNameWithoutPackage(), headerName);
    }

    public void checkSamePropertyHeader(int columnIndex, List<String> propertyNameElements) {
        ScesimModelDescriptor simulationDescriptor = this.abstractScesimModel.getScesimModelDescriptor();
        FactMapping factMapping = simulationDescriptor.getFactMappingByIndex(columnIndex);
        List columnPropertyName = factMapping.getExpressionElementsWithoutClass().stream().map(ExpressionElement::getStep).collect(Collectors.toList());
        if (!Objects.equals(columnPropertyName, propertyNameElements)) {
            throw new IllegalStateException(String.join((CharSequence)".", propertyNameElements) + " is not the same property of the current column.");
        }
    }

    public void resetErrors() {
        IntStream.range(0, this.getRowCount()).forEach(this::resetErrors);
    }

    public void resetErrors(int rowIndex) {
        AbstractScesimData scesimDataByIndex = this.abstractScesimModel.getDataByIndex(rowIndex);
        scesimDataByIndex.resetErrors();
        this.refreshErrors();
    }

    public void resetError(int rowIndex, int columnIndex) {
        AbstractScesimData scesimDataByIndex = this.abstractScesimModel.getDataByIndex(rowIndex);
        FactMapping factMapping = this.abstractScesimModel.getScesimModelDescriptor().getFactMappingByIndex(columnIndex);
        Optional factMappingValue = scesimDataByIndex.getFactMappingValue(factMapping);
        factMappingValue.ifPresent(FactMappingValue::resetStatus);
        this.refreshErrors();
    }

    public void refreshErrors() {
        IntStream.range(0, this.getRowCount()).forEach(this::refreshErrorsRow);
    }

    public void setSimpleJavaTypeInstancesName(Set<String> simpleJavaTypeInstancesName) {
        this.simpleJavaTypeInstancesName = simpleJavaTypeInstancesName;
    }

    public void validateInstanceHeaderUpdate(String instanceHeaderCellValue, int columnIndex, boolean isADataType) {
        if (isADataType) {
            this.checkSameInstanceHeader(columnIndex, instanceHeaderCellValue);
            this.checkValidAndUniqueInstanceHeaderTitle(instanceHeaderCellValue, columnIndex);
        } else {
            this.checkValidAndUniqueInstanceHeaderTitle(instanceHeaderCellValue, columnIndex);
        }
    }

    public void validatePropertyHeaderUpdate(String propertyHeaderCellValue, int columnIndex, boolean isPropertyType) {
        List<String> propertyNameElements = Collections.unmodifiableList(Arrays.asList(propertyHeaderCellValue.split("\\.")));
        if (isPropertyType) {
            this.checkSamePropertyHeader(columnIndex, propertyNameElements);
            this.checkUniquePropertyHeaderTitle(propertyHeaderCellValue, columnIndex);
        } else {
            this.checkAlreadyAssignedProperty(columnIndex, propertyNameElements);
            this.checkValidAndUniquePropertyHeaderTitle(propertyHeaderCellValue, columnIndex);
        }
    }

    public boolean isSimpleType(String factClassName) {
        return this.simpleJavaTypeInstancesName != null && this.simpleJavaTypeInstancesName.contains(factClassName);
    }

    protected GridData.Range getInstanceLimits(int columnIndex, int columnIndexStart) {
        int rightPosition;
        int leftPosition;
        ScenarioGridColumn column = (ScenarioGridColumn)((Object)this.columns.get(columnIndex));
        String originalColumnGroup = column.getInformationHeaderMetaData().getColumnGroup();
        ScenarioHeaderMetaData selectedInformationHeaderMetaData = column.getInformationHeaderMetaData();
        String originalColumnTitle = selectedInformationHeaderMetaData.getTitle();
        for (leftPosition = columnIndex; leftPosition > columnIndexStart && ((ScenarioGridColumn)((Object)this.columns.get(leftPosition - 1))).getInformationHeaderMetaData().getColumnGroup().equals(originalColumnGroup) && ((ScenarioGridColumn)((Object)this.columns.get(leftPosition - 1))).getInformationHeaderMetaData().getTitle().equals(originalColumnTitle); --leftPosition) {
        }
        for (rightPosition = columnIndex; rightPosition < this.columns.size() - 1 && ((ScenarioGridColumn)((Object)this.columns.get(rightPosition + 1))).getInformationHeaderMetaData().getColumnGroup().equals(originalColumnGroup) && ((ScenarioGridColumn)((Object)this.columns.get(rightPosition + 1))).getInformationHeaderMetaData().getTitle().equals(originalColumnTitle); ++rightPosition) {
        }
        return new GridData.Range(leftPosition, rightPosition);
    }

    protected void updateFactMapping(ScesimModelDescriptor simulationDescriptor, FactMapping factMappingReference, int index, String value, ScenarioHeaderMetaData.MetadataType metadataType) {
        boolean toUpdate;
        FactIdentifier factIdentifierReference = factMappingReference.getFactIdentifier();
        FactMapping factMappingToCheck = simulationDescriptor.getFactMappingByIndex(index);
        FactIdentifier factIdentifierToCheck = factMappingToCheck.getFactIdentifier();
        boolean bl = toUpdate = Objects.equals(FactIdentifier.EMPTY, factIdentifierReference) && Objects.equals(factIdentifierToCheck, factIdentifierReference) && Objects.equals(factMappingReference.getFactAlias(), factMappingToCheck.getFactAlias()) || Objects.equals(factIdentifierToCheck, factIdentifierReference);
        if (toUpdate) {
            switch (metadataType) {
                case INSTANCE: {
                    ((ScenarioGridColumn)((Object)this.columns.get(index))).getInformationHeaderMetaData().setTitle(value);
                    factMappingToCheck.setFactAlias(value);
                    break;
                }
                case PROPERTY: {
                    if (!Objects.equals(factMappingToCheck.getFullExpression(), factMappingReference.getFullExpression())) break;
                    ((ScenarioGridColumn)((Object)this.columns.get(index))).getPropertyHeaderMetaData().setTitle(value);
                    factMappingToCheck.setExpressionAlias(value);
                    break;
                }
            }
        }
    }

    protected void commonAddColumn(int index, GridColumn<?> column) {
        String group = ((ScenarioGridColumn)column).getInformationHeaderMetaData().getColumnGroup();
        String columnId = ((ScenarioGridColumn)column).getInformationHeaderMetaData().getColumnId();
        ExpressionIdentifier ei = ExpressionIdentifier.create((String)columnId, (FactMappingType)FactMappingType.valueOf((String)group));
        this.commonAddColumn(index, column, ei);
    }

    protected void commonAddColumn(int index, GridColumn<?> column, ExpressionIdentifier ei) {
        ScesimModelDescriptor simulationDescriptor = this.abstractScesimModel.getScesimModelDescriptor();
        String instanceTitle = ((ScenarioGridColumn)column).getInformationHeaderMetaData().getTitle();
        String propertyTitle = ((ScenarioGridColumn)column).getPropertyHeaderMetaData().getTitle();
        int columnIndex = index == -1 ? this.getColumnCount() : index;
        try {
            FactMapping createdFactMapping = simulationDescriptor.addFactMapping(columnIndex, instanceTitle, ((ScenarioGridColumn)column).getFactIdentifier(), ei);
            createdFactMapping.setExpressionAlias(propertyTitle);
            if (index == -1) {
                super.appendColumn(column);
            } else {
                super.insertColumn(index, column);
            }
            GridData.Range instanceLimits = this.getInstanceLimits(columnIndex);
            IntStream.range(instanceLimits.getMinRowIndex(), instanceLimits.getMaxRowIndex() + 1).filter(currentIndex -> currentIndex != columnIndex).forEach(currentIndex -> simulationDescriptor.getFactMappingByIndex(currentIndex).setFactAlias(createdFactMapping.getFactAlias()));
        }
        catch (Exception e) {
            this.eventBus.fireEvent((GwtEvent)new ScenarioNotificationEvent("Error during column creation: " + e.getMessage(), NotificationEvent.NotificationType.ERROR));
            this.eventBus.fireEvent((GwtEvent)new ScenarioGridReloadEvent(this.getGridWidget()));
            return;
        }
        List unmodifiableScesimData = this.abstractScesimModel.getUnmodifiableData();
        String placeHolder = ((ScenarioGridColumn)column).getPlaceHolder();
        IntStream.range(0, unmodifiableScesimData.size()).forEach(rowIndex -> this.setCell(rowIndex, columnIndex, () -> new ScenarioGridCell(new ScenarioGridCellValue(null, placeHolder))));
    }

    protected abstract void commonAddRow(int var1);

    protected void commonAddRow(int rowIndex, int columnIndexStart) {
        AbstractScesimData scesimData = this.abstractScesimModel.addData(rowIndex);
        ScesimModelDescriptor simulationDescriptor = this.abstractScesimModel.getScesimModelDescriptor();
        IntStream.range(columnIndexStart, this.getColumnCount()).forEach(columnIndex -> {
            FactMapping factMappingByIndex = simulationDescriptor.getFactMappingByIndex(columnIndex);
            scesimData.addMappingValue(factMappingByIndex.getFactIdentifier(), factMappingByIndex.getExpressionIdentifier(), null);
            ScenarioGridColumn column = (ScenarioGridColumn)((Object)((Object)this.columns.get(columnIndex)));
            String placeHolder = ScenarioSimulationUtils.getPlaceHolder(column.isInstanceAssigned(), column.isPropertyAssigned(), factMappingByIndex.getFactMappingValueType(), factMappingByIndex.getClassName());
            this.setCell(rowIndex, columnIndex, () -> {
                ScenarioGridCell newCell = new ScenarioGridCell(new ScenarioGridCellValue(null, placeHolder));
                if (ScenarioSimulationSharedUtils.isCollection((String)factMappingByIndex.getClassName())) {
                    newCell.setListMap(ScenarioSimulationSharedUtils.isList((String)factMappingByIndex.getClassName()));
                }
                return newCell;
            });
        });
    }

    protected void updateIndexColumn() {
        Optional<GridColumn> indexColumn = this.getColumns().stream().filter(gridColumn -> ((ScenarioGridColumn)((Object)gridColumn)).getInformationHeaderMetaData().getTitle().equals(FactIdentifier.INDEX.getName())).findFirst();
        indexColumn.ifPresent(column -> {
            int indexOfColumn = this.getColumns().indexOf(column);
            IntStream.range(0, this.getRowCount()).forEach(rowIndex -> {
                String value = String.valueOf(rowIndex + 1);
                this.setCellValue(rowIndex, indexOfColumn, (GridCellValue<?>)new ScenarioGridCellValue(value));
            });
        });
    }

    protected void checkSimulation() {
        Objects.requireNonNull(this.abstractScesimModel, "Bind a simulation to the ScenarioGridModel to use it");
    }

    protected void checkValidAndUniqueInstanceHeaderTitle(String instanceHeaderCellValue, int columnIndex) {
        if (instanceHeaderCellValue.contains(".")) {
            throw new IllegalArgumentException(ScenarioSimulationEditorConstants.INSTANCE.instanceTitleWithPeriodsError());
        }
        GridData.Range instanceLimits = this.getInstanceLimits(columnIndex);
        ScesimModelDescriptor simulationDescriptor = this.abstractScesimModel.getScesimModelDescriptor();
        FactIdentifier factIdentifier = simulationDescriptor.getFactMappingByIndex(columnIndex).getFactIdentifier();
        if (IntStream.range(0, this.getColumnCount()).filter(index -> index < instanceLimits.getMinRowIndex() || index > instanceLimits.getMaxRowIndex()).filter(index -> !Objects.equals(factIdentifier, simulationDescriptor.getFactMappingByIndex(index).getFactIdentifier())).mapToObj(index -> (ScenarioGridColumn)((Object)((Object)this.getColumns().get(index)))).filter(elem -> elem.getInformationHeaderMetaData() != null).map(ScenarioGridColumn::getInformationHeaderMetaData).anyMatch(elem -> Objects.equals(elem.getTitle(), instanceHeaderCellValue))) {
            throw new IllegalArgumentException(ScenarioSimulationEditorConstants.INSTANCE.instanceTitleAssignedError(instanceHeaderCellValue));
        }
    }

    protected void checkValidAndUniquePropertyHeaderTitle(String propertyHeaderCellValue, int columnIndex) {
        if (propertyHeaderCellValue.contains(".")) {
            throw new IllegalArgumentException(ScenarioSimulationEditorConstants.INSTANCE.propertyTitleWithPeriodsError());
        }
        this.checkUniquePropertyHeaderTitle(propertyHeaderCellValue, columnIndex);
    }

    protected void checkUniquePropertyHeaderTitle(String propertyHeaderCellValue, int columnIndex) {
        ScesimModelDescriptor simulationDescriptor = this.abstractScesimModel.getScesimModelDescriptor();
        FactIdentifier factIdentifier = simulationDescriptor.getFactMappingByIndex(columnIndex).getFactIdentifier();
        if (IntStream.range(0, this.getColumnCount()).filter(index -> index != columnIndex).filter(index -> Objects.equals(factIdentifier, simulationDescriptor.getFactMappingByIndex(index).getFactIdentifier())).mapToObj(index -> (ScenarioGridColumn)((Object)((Object)this.getColumns().get(index)))).filter(elem -> elem.getPropertyHeaderMetaData() != null).map(ScenarioGridColumn::getPropertyHeaderMetaData).anyMatch(elem -> Objects.equals(elem.getTitle(), propertyHeaderCellValue))) {
            throw new IllegalArgumentException(ScenarioSimulationEditorConstants.INSTANCE.propertyTitleAssignedError(propertyHeaderCellValue));
        }
    }

    protected boolean isNewInstanceName(String value) {
        return this.getColumns().stream().map(elem -> ((ScenarioGridColumn)((Object)elem)).getInformationHeaderMetaData()).filter(Objects::nonNull).noneMatch(elem -> Objects.equals(elem.getTitle(), value));
    }

    protected boolean isNewPropertyName(String value) {
        return this.getColumns().stream().map(elem -> ((ScenarioGridColumn)((Object)elem)).getPropertyHeaderMetaData()).filter(Objects::nonNull).noneMatch(elem -> Objects.equals(elem.getTitle(), value));
    }

    protected void refreshErrorsRow(int rowIndex) {
        ScesimModelDescriptor simulationDescriptor = this.abstractScesimModel.getScesimModelDescriptor();
        AbstractScesimData scesimDataByIndex = this.abstractScesimModel.getDataByIndex(rowIndex);
        IntStream.range(0, this.getColumnCount()).forEach(columnIndex -> {
            ScenarioGridCell cell = (ScenarioGridCell)this.getCell(rowIndex, columnIndex);
            if (cell == null) {
                return;
            }
            FactMapping factMappingByIndex = simulationDescriptor.getFactMappingByIndex(columnIndex);
            Optional factMappingValue = scesimDataByIndex.getFactMappingValue(factMappingByIndex.getFactIdentifier(), factMappingByIndex.getExpressionIdentifier());
            if (factMappingValue.isPresent()) {
                cell.setErrorMode(FactMappingValueStatus.SUCCESS != ((FactMappingValue)factMappingValue.get()).getStatus());
            } else {
                cell.setErrorMode(false);
            }
        });
    }

    public BaseSingletonDOMElementFactory getDOMElementFactory(String className, ScenarioSimulationModel.Type modelType, FactMappingValueType valueType) {
        boolean isRuleScenario = Objects.equals(ScenarioSimulationModel.Type.RULE, modelType);
        if (ScenarioSimulationSharedUtils.isCollection((String)className) && Objects.equals(FactMappingValueType.NOT_EXPRESSION, valueType)) {
            return this.collectionEditorSingletonDOMElementFactory;
        }
        if (Objects.equals(FactMappingValueType.EXPRESSION, valueType) && isRuleScenario) {
            return this.scenarioExpressionCellTextAreaSingletonDOMElementFactory;
        }
        return this.scenarioCellTextAreaSingletonDOMElementFactory;
    }

    private Optional<?> getCellValue(GridCell<?> gridCell) {
        if (gridCell == null || gridCell.getValue() == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(gridCell.getValue().getValue());
    }
}

