/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.widgets;

import com.google.gwt.user.client.ui.Widget;
import com.google.gwtmockito.GwtMockitoTestRunner;
import org.drools.scenariosimulation.api.model.AbstractScesimModel;
import org.drools.workbench.screens.scenariosimulation.client.AbstractScenarioSimulationTest;
import org.drools.workbench.screens.scenariosimulation.client.models.ScenarioGridModel;
import org.drools.workbench.screens.scenariosimulation.client.widgets.ScenarioGrid;
import org.drools.workbench.screens.scenariosimulation.client.widgets.ScenarioGridPanel;
import org.drools.workbench.screens.scenariosimulation.client.widgets.ScenarioGridWidget;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=GwtMockitoTestRunner.class)
public class ScenarioGridWidgetTest
extends AbstractScenarioSimulationTest {
    public static final int WIDTH = 44;
    public static final int HEIGHT = 82;
    @Mock
    private Widget parentWidget;
    private ScenarioGridWidget scenarioGridWidget;

    @Override
    @Before
    public void setup() {
        super.setup();
        this.scenarioGridWidget = (ScenarioGridWidget)Mockito.spy((Object)new ScenarioGridWidget());
        this.scenarioGridWidget.setScenarioGridPanel(this.scenarioGridPanelMock);
        Mockito.when((Object)this.scenarioGridWidget.getParent()).thenReturn((Object)this.parentWidget);
        Mockito.when((Object)this.parentWidget.getOffsetHeight()).thenReturn((Object)82);
        Mockito.when((Object)this.parentWidget.getOffsetWidth()).thenReturn((Object)44);
    }

    @Test
    public void refreshContent() {
        this.scenarioGridWidget.refreshContent((AbstractScesimModel)this.simulationMock);
        ((ScenarioGridModel)Mockito.verify((Object)this.scenarioGridModelMock, (VerificationMode)Mockito.times((int)1))).bindContent((AbstractScesimModel)Matchers.eq((Object)this.simulationMock));
        ((ScenarioGridModel)Mockito.verify((Object)this.scenarioGridModelMock, (VerificationMode)Mockito.times((int)1))).refreshErrors();
        ((ScenarioGridWidget)Mockito.verify((Object)this.scenarioGridWidget, (VerificationMode)Mockito.times((int)1))).onResize();
    }

    @Test
    public void onResize() {
        this.scenarioGridWidget.onResize();
        ((ScenarioGridWidget)Mockito.verify((Object)this.scenarioGridWidget, (VerificationMode)Mockito.times((int)1))).setPixelSize(Matchers.eq((int)44), Matchers.eq((int)82));
        ((ScenarioGridPanel)Mockito.verify((Object)this.scenarioGridPanelMock, (VerificationMode)Mockito.times((int)1))).onResize();
    }

    @Test
    public void unregister() {
        this.scenarioGridWidget.unregister();
        ((ScenarioGridPanel)Mockito.verify((Object)this.scenarioGridPanelMock, (VerificationMode)Mockito.times((int)1))).unregister();
    }

    @Test
    public void clearSelection() {
        this.scenarioGridWidget.clearSelections();
        ((ScenarioGridModel)Mockito.verify((Object)this.scenarioGridModelMock, (VerificationMode)Mockito.times((int)1))).clearSelections();
    }

    @Test
    public void resetErrors() {
        this.scenarioGridWidget.resetErrors();
        ((ScenarioGridModel)Mockito.verify((Object)this.scenarioGridModelMock, (VerificationMode)Mockito.times((int)1))).resetErrors();
    }

    @Test
    public void selectAndFocus() {
        this.scenarioGridWidget.selectAndFocus();
        ((ScenarioGrid)Mockito.verify((Object)this.scenarioGridMock, (VerificationMode)Mockito.times((int)1))).select();
        ((ScenarioGridPanel)Mockito.verify((Object)this.scenarioGridPanelMock, (VerificationMode)Mockito.times((int)1))).setFocus(Matchers.eq((boolean)true));
        ((ScenarioGridPanel)Mockito.verify((Object)this.scenarioGridPanelMock, (VerificationMode)Mockito.times((int)1))).ensureCellIsSelected();
        Assert.assertTrue((boolean)this.scenarioGridWidget.selected);
    }

    @Test
    public void deselectAndUnFocus() {
        this.scenarioGridWidget.deselectAndUnFocus();
        ((ScenarioGrid)Mockito.verify((Object)this.scenarioGridMock, (VerificationMode)Mockito.times((int)1))).deselect();
        ((ScenarioGridPanel)Mockito.verify((Object)this.scenarioGridPanelMock, (VerificationMode)Mockito.times((int)1))).setFocus(Matchers.eq((boolean)false));
        Assert.assertFalse((boolean)this.scenarioGridWidget.selected);
    }
}

