/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.editor.menu;

import com.google.gwt.dom.client.LIElement;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.shared.EventBus;
import com.google.gwtmockito.GwtMockitoTestRunner;
import com.google.web.bindery.event.shared.Event;
import java.util.Map;
import org.drools.workbench.screens.scenariosimulation.client.editor.menu.BaseMenu;
import org.drools.workbench.screens.scenariosimulation.client.editor.menu.ExecutableMenuItemPresenter;
import org.drools.workbench.screens.scenariosimulation.client.editor.menu.ExecutableMenuItemView;
import org.drools.workbench.screens.scenariosimulation.client.editor.menu.ExecutableMenuItemViewImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=GwtMockitoTestRunner.class)
public class ExecutableMenuItemPresenterTest {
    @Mock
    private ExecutableMenuItemViewImpl mockExecutableMenuItemViewImpl;
    @Mock
    private LIElement mockLIElement;
    @Mock
    private Map<LIElement, Event> mockMenuItemsEventMap;
    @Mock
    private Event mockEvent;
    @Mock
    private EventBus mockEventBus;
    @Mock
    private BaseMenu mockparent;
    private ExecutableMenuItemPresenter executableMenuItemPresenter;

    @Before
    public void setup() {
        Mockito.when((Object)this.mockExecutableMenuItemViewImpl.getLExecutableMenuElement()).thenReturn((Object)this.mockLIElement);
        Mockito.when((Object)this.mockMenuItemsEventMap.containsKey(this.mockLIElement)).thenReturn((Object)true);
        Mockito.when((Object)this.mockMenuItemsEventMap.get(this.mockLIElement)).thenReturn((Object)this.mockEvent);
        this.executableMenuItemPresenter = (ExecutableMenuItemPresenter)Mockito.spy((Object)new ExecutableMenuItemPresenter(){
            {
                this.menuItemsEventMap = ExecutableMenuItemPresenterTest.this.mockMenuItemsEventMap;
                this.eventBus = ExecutableMenuItemPresenterTest.this.mockEventBus;
                this.parent = ExecutableMenuItemPresenterTest.this.mockparent;
            }

            protected ExecutableMenuItemView getMenuItemView() {
                return ExecutableMenuItemPresenterTest.this.mockExecutableMenuItemViewImpl;
            }
        });
    }

    @Test
    public void onClickEvent() {
        ClickEvent mockClickEvent = (ClickEvent)Mockito.mock(ClickEvent.class);
        this.executableMenuItemPresenter.onClickEvent(mockClickEvent, this.mockLIElement);
        ((ClickEvent)Mockito.verify((Object)mockClickEvent, (VerificationMode)Mockito.times((int)1))).preventDefault();
        ((ClickEvent)Mockito.verify((Object)mockClickEvent, (VerificationMode)Mockito.times((int)1))).stopPropagation();
        ((BaseMenu)Mockito.verify((Object)this.mockparent, (VerificationMode)Mockito.times((int)1))).hide();
        ((ExecutableMenuItemPresenter)Mockito.verify((Object)this.executableMenuItemPresenter, (VerificationMode)Mockito.times((int)1))).fireEvent((LIElement)Matchers.eq((Object)this.mockLIElement));
    }

    @Test
    public void fireEvent() {
        this.executableMenuItemPresenter.fireEvent(this.mockLIElement);
        ((Map)Mockito.verify(this.mockMenuItemsEventMap, (VerificationMode)Mockito.times((int)1))).containsKey(this.mockLIElement);
        ((EventBus)Mockito.verify((Object)this.mockEventBus, (VerificationMode)Mockito.times((int)1))).fireEvent((Event)Matchers.eq((Object)this.mockEvent));
    }

    @Test
    public void getLIElement() {
        LIElement liElement = this.executableMenuItemPresenter.getLExecutableMenuElement("TEST-ID", "TEST-LABEL", this.mockEvent);
        Assert.assertNotNull((Object)liElement);
        ((Map)Mockito.verify(this.mockMenuItemsEventMap, (VerificationMode)Mockito.times((int)1))).put(liElement, this.mockEvent);
    }
}

