/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.handlers;

import com.ait.lienzo.client.core.event.NodeMouseMoveEvent;
import com.ait.lienzo.client.core.types.Point2D;
import com.google.gwt.event.shared.GwtEvent;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.IntStream;
import javax.enterprise.context.Dependent;
import org.drools.scenariosimulation.api.model.AbstractScesimData;
import org.drools.scenariosimulation.api.model.AbstractScesimModel;
import org.drools.scenariosimulation.api.model.FactMapping;
import org.drools.scenariosimulation.api.model.FactMappingValue;
import org.drools.scenariosimulation.api.model.FactMappingValueStatus;
import org.drools.workbench.screens.scenariosimulation.client.events.SetGridCellValueEvent;
import org.drools.workbench.screens.scenariosimulation.client.handlers.AbstractScenarioSimulationGridPanelHandler;
import org.drools.workbench.screens.scenariosimulation.client.handlers.ScenarioSimulationGridPanelMouseMoveHandler;
import org.drools.workbench.screens.scenariosimulation.client.metadata.ScenarioHeaderMetaData;
import org.drools.workbench.screens.scenariosimulation.client.popover.ErrorReportPopoverPresenter;
import org.drools.workbench.screens.scenariosimulation.client.popover.PopoverView;
import org.drools.workbench.screens.scenariosimulation.client.resources.i18n.ScenarioSimulationEditorConstants;
import org.drools.workbench.screens.scenariosimulation.client.utils.ScenarioSimulationUtils;
import org.drools.workbench.screens.scenariosimulation.client.widgets.ScenarioGridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;
import org.uberfire.ext.wires.core.grids.client.widget.layer.GridLayer;

@Dependent
public class ScenarioSimulationMainGridPanelMouseMoveHandler
extends AbstractScenarioSimulationGridPanelHandler
implements ScenarioSimulationGridPanelMouseMoveHandler {
    private static final int POPOVER_WIDTH = 220;
    private static final String NULL = "null";
    private static final String BR = "<br>";
    protected ErrorReportPopoverPresenter errorReportPopupPresenter;
    protected Integer currentlyShownBodyRowIndex = -1;
    protected Integer currentlyShownBodyColumnIndex = -1;

    public void onNodeMouseMove(NodeMouseMoveEvent event) {
        this.manageCoordinates(event.getX(), event.getY());
    }

    @Override
    public void hidePopover() {
        this.errorReportPopupPresenter.hide();
    }

    @Override
    public void setErrorReportPopupPresenter(ErrorReportPopoverPresenter errorReportPopupPresenter) {
        this.errorReportPopupPresenter = errorReportPopupPresenter;
    }

    @Override
    protected boolean manageGivenExpectHeaderCoordinates(ScenarioHeaderMetaData clickedScenarioHeaderMetadata, ScenarioGridColumn scenarioGridColumn, String group, Integer uiColumnIndex) {
        return false;
    }

    @Override
    protected boolean manageBodyCoordinates(Integer uiRowIndex, Integer uiColumnIndex) {
        if (uiColumnIndex == -1 || uiRowIndex == -1) {
            return false;
        }
        if (uiRowIndex.equals(this.currentlyShownBodyRowIndex) && uiColumnIndex.equals(this.currentlyShownBodyColumnIndex) && this.errorReportPopupPresenter.isShown()) {
            return true;
        }
        this.currentlyShownBodyRowIndex = uiRowIndex;
        this.currentlyShownBodyColumnIndex = uiColumnIndex;
        Optional optionalAbstractScesimModel = this.scenarioGrid.getModel().getAbstractScesimModel();
        AbstractScesimModel scesimModel = (AbstractScesimModel)optionalAbstractScesimModel.orElseThrow(IllegalStateException::new);
        AbstractScesimData scenarioByIndex = scesimModel.getDataByIndex(uiRowIndex.intValue());
        FactMapping factMapping = scesimModel.getScesimModelDescriptor().getFactMappingByIndex(uiColumnIndex.intValue());
        Optional factMappingValueOptional = scenarioByIndex.getFactMappingValue(factMapping);
        factMappingValueOptional.ifPresent(factMappingValue -> this.manageFactMappingValue((FactMappingValue)factMappingValue, uiRowIndex, uiColumnIndex));
        return true;
    }

    protected void manageFactMappingValue(FactMappingValue toManage, Integer uiRowIndex, Integer uiColumnIndex) {
        if (toManage.getStatus() != null && FactMappingValueStatus.SUCCESS != toManage.getStatus()) {
            this.manageFailedFactMappingValue(toManage, uiRowIndex, uiColumnIndex);
        }
    }

    protected void manageFailedFactMappingValue(FactMappingValue toManage, Integer uiRowIndex, Integer uiColumnIndex) {
        GridColumn column = (GridColumn)this.scenarioGrid.getModel().getColumns().get(uiColumnIndex);
        Point2D cellXYMiddleCoordinates = this.retrieveCellMiddleXYPosition(column, uiRowIndex);
        int cellHeight = this.getCellHeight(column, uiRowIndex);
        PopoverView.Position position = PopoverView.Position.RIGHT;
        int xMiddleWidth = (int)column.getWidth() / 2;
        int xPosition = (int)cellXYMiddleCoordinates.getX() + xMiddleWidth;
        int yPosition = (int)cellXYMiddleCoordinates.getY();
        if (xPosition + 220 > this.scenarioGrid.getLayer().getWidth()) {
            xPosition = (int)cellXYMiddleCoordinates.getX() - xMiddleWidth;
            position = PopoverView.Position.LEFT;
        }
        if (xPosition <= this.scenarioGrid.getLayer().getElement().getAbsoluteLeft()) {
            xPosition = (int)cellXYMiddleCoordinates.getX();
            yPosition = (int)cellXYMiddleCoordinates.getY() - cellHeight / 2;
            position = PopoverView.Position.TOP;
        }
        int scrollX = this.scenarioGridPanel.getScrollPanel().getElement().getScrollLeft();
        int scrollY = this.scenarioGridPanel.getScrollPanel().getElement().getScrollTop();
        this.setupPopupPresenter(toManage, uiRowIndex, uiColumnIndex, xPosition -= scrollX, yPosition -= scrollY, position);
        this.errorReportPopupPresenter.show();
    }

    protected void setupPopupPresenter(FactMappingValue factMappingValue, int uiRowIndex, int uiColumnIndex, int xPosition, int yPosition, PopoverView.Position position) {
        Object expectedValue = factMappingValue.getRawValue();
        Object errorValue = factMappingValue.getErrorValue();
        if (FactMappingValueStatus.FAILED_WITH_ERROR == factMappingValue.getStatus()) {
            if (Objects.isNull(factMappingValue.getCollectionPathToValue())) {
                this.showErrorPopoverWithSuggestion(expectedValue, errorValue, uiRowIndex, uiColumnIndex, xPosition, yPosition, position);
            } else {
                this.showErrorPopoverWithoutSuggestion(this.getCollectionHTMLErrorMessage(errorValue, factMappingValue.getCollectionPathToValue()), xPosition, yPosition, position);
            }
        } else if (FactMappingValueStatus.FAILED_WITH_EXCEPTION == factMappingValue.getStatus()) {
            this.showErrorPopoverWithoutSuggestion(factMappingValue.getExceptionMessage(), xPosition, yPosition, position);
        }
    }

    protected void showErrorPopoverWithoutSuggestion(String errorMessage, int xPosition, int yPosition, PopoverView.Position position) {
        this.errorReportPopupPresenter.setup(ScenarioSimulationEditorConstants.INSTANCE.errorReason(), errorMessage, ScenarioSimulationEditorConstants.INSTANCE.close(), xPosition, yPosition, position);
    }

    protected void showErrorPopoverWithSuggestion(Object expectedValue, Object errorValue, int uiRowIndex, int uiColumnIndex, int xPosition, int yPosition, PopoverView.Position position) {
        this.errorReportPopupPresenter.setup(ScenarioSimulationEditorConstants.INSTANCE.errorReason(), ScenarioSimulationEditorConstants.INSTANCE.errorPopoverMessageFailedWithError(this.decorateWithStrongHTMLTag(expectedValue != null ? expectedValue.toString() : NULL), this.decorateWithStrongHTMLTag(errorValue != null ? errorValue.toString() : NULL)), ScenarioSimulationEditorConstants.INSTANCE.keep(), ScenarioSimulationEditorConstants.INSTANCE.apply(), () -> this.scenarioGrid.getEventBus().fireEvent((GwtEvent)new SetGridCellValueEvent(this.scenarioGrid.getGridWidget(), uiRowIndex, uiColumnIndex, errorValue != null ? errorValue.toString() : NULL)), xPosition, yPosition, position);
    }

    protected String getCollectionHTMLErrorMessage(Object wrongValue, List<String> pathToWrongValue) {
        if (pathToWrongValue.isEmpty()) {
            return ScenarioSimulationEditorConstants.INSTANCE.errorPopoverGenericCollectionErrorMessage();
        }
        if (pathToWrongValue.size() == 1) {
            StringBuilder builder = new StringBuilder();
            builder.append(ScenarioSimulationEditorConstants.INSTANCE.errorPopoverCollectionHTMLFailureMessage(this.decorateWithEMHTMLTag(pathToWrongValue.get(0))));
            if (wrongValue != null) {
                builder.append(BR);
                builder.append(ScenarioSimulationEditorConstants.INSTANCE.errorPopoverCollectionHTMLValue(this.decorateWithStrongHTMLTag(wrongValue.toString())));
            }
            return builder.toString();
        }
        StringBuilder builder = new StringBuilder();
        builder.append(ScenarioSimulationEditorConstants.INSTANCE.errorPopoverCollectionHTMLFailureMessage(this.decorateWithEMHTMLTag(pathToWrongValue.get(0))));
        builder.append(BR);
        builder.append(ScenarioSimulationEditorConstants.INSTANCE.errorPopoverCollectionHTMLField(this.decorateWithEMHTMLTag(this.generateFieldsHierarchy(pathToWrongValue.subList(1, pathToWrongValue.size())))));
        if (wrongValue != null) {
            builder.append(ScenarioSimulationEditorConstants.INSTANCE.errorPopoverCollectionHTMLValue(this.decorateWithStrongHTMLTag(wrongValue.toString())));
        }
        return builder.toString();
    }

    protected String decorateWithStrongHTMLTag(String value) {
        return "<strong>\"" + value + "\"</strong>";
    }

    protected String decorateWithEMHTMLTag(String value) {
        return "<em>" + value + "</em>";
    }

    protected String generateFieldsHierarchy(List<String> hierarchy) {
        if (hierarchy.size() == 1) {
            return hierarchy.get(0) + BR;
        }
        StringBuilder builder = new StringBuilder();
        hierarchy.forEach(step -> builder.append("<ul><li>" + step));
        IntStream.range(0, hierarchy.size()).forEach(i -> builder.append("</li></ul>"));
        return builder.toString();
    }

    protected Point2D retrieveCellMiddleXYPosition(GridColumn<?> column, int uiRowIndex) {
        return ScenarioSimulationUtils.getMiddleXYCell((GridWidget)this.scenarioGrid, column, false, uiRowIndex, (GridLayer)this.scenarioGrid.getLayer());
    }

    protected int getCellHeight(GridColumn<?> column, int uiRowIndex) {
        return ScenarioSimulationUtils.getCellHeight((GridWidget)this.scenarioGrid, column, false, uiRowIndex);
    }
}

