/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.collectioneditor;

import com.google.gwt.dom.client.LIElement;
import com.google.gwt.dom.client.Node;
import com.google.gwt.dom.client.Style;
import com.google.gwt.dom.client.UListElement;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Map;
import org.drools.workbench.screens.scenariosimulation.client.TestProperties;
import org.drools.workbench.screens.scenariosimulation.client.collectioneditor.CollectionPresenter;
import org.drools.workbench.screens.scenariosimulation.client.collectioneditor.ElementPresenterTest;
import org.drools.workbench.screens.scenariosimulation.client.collectioneditor.ElementView;
import org.drools.workbench.screens.scenariosimulation.client.collectioneditor.ItemElementPresenter;
import org.drools.workbench.screens.scenariosimulation.client.collectioneditor.ItemElementView;
import org.drools.workbench.screens.scenariosimulation.client.collectioneditor.PropertyPresenter;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=GwtMockitoTestRunner.class)
public class ItemElementPresenterTest
extends ElementPresenterTest<ItemElementView, ItemElementView.Presenter> {
    @Mock
    private LIElement propertyFieldsMock;

    @Override
    @Before
    public void setup() {
        this.elementView1Mock = (ElementView)Mockito.mock(ItemElementView.class);
        this.elementView2Mock = (ElementView)Mockito.mock(ItemElementView.class);
        super.setup();
        Mockito.when((Object)this.viewsProviderMock.getListEditorElementView()).thenReturn((Object)((ItemElementView)this.elementView1Mock));
        Mockito.when((Object)this.propertyPresenterMock.getPropertyFields(Matchers.anyString(), Matchers.anyString(), Matchers.anyString())).thenReturn((Object)this.propertyFieldsMock);
        this.elementPresenter = (ElementView.Presenter)Mockito.spy((Object)new ItemElementPresenter(){
            {
                this.viewsProvider = ItemElementPresenterTest.this.viewsProviderMock;
                this.propertyPresenter = ItemElementPresenterTest.this.propertyPresenterMock;
                this.elementViewList = ItemElementPresenterTest.this.elementViewListLocal;
                this.collectionEditorPresenter = ItemElementPresenterTest.this.collectionPresenterMock;
                this.itemIdExpandablePropertiesMap = TestProperties.ITEM_ID_EXPANDABLE_PROPERTIES_MAP_LOCAL;
            }
        });
        TestProperties.ITEM_ID_EXPANDABLE_PROPERTIES_MAP_LOCAL.put(((ItemElementView)this.elementView1Mock).getItemId(), TestProperties.EXPANDABLE_PROPERTIES);
        TestProperties.ITEM_ID_EXPANDABLE_PROPERTIES_MAP_LOCAL.put(((ItemElementView)this.elementView2Mock).getItemId(), TestProperties.EXPANDABLE_PROPERTIES);
    }

    @Test
    public void getItemContainer() {
        this.elementViewListLocal.clear();
        TestProperties.ITEM_ID_EXPANDABLE_PROPERTIES_MAP_LOCAL.clear();
        LIElement itemContainer = ((ItemElementView.Presenter)this.elementPresenter).getItemContainer("TEST-ITEM-ID", TestProperties.TEST_PROPERTIES_MAP, TestProperties.EXPANDABLE_PROPERTIES_VALUES);
        ((ItemElementView)Mockito.verify((Object)((ItemElementView)this.elementView1Mock), (VerificationMode)Mockito.times((int)(1 + TestProperties.EXPANDABLE_PROPERTIES_VALUES.size())))).init((Object)((ItemElementView.Presenter)this.elementPresenter));
        ((ItemElementView)Mockito.verify((Object)((ItemElementView)this.elementView1Mock), (VerificationMode)Mockito.times((int)1))).setItemId("TEST-ITEM-ID");
        ((ItemElementView)Mockito.verify((Object)((ItemElementView)this.elementView1Mock), (VerificationMode)Mockito.times((int)(1 + TestProperties.EXPANDABLE_PROPERTIES_VALUES.size())))).getItemContainer();
        ((ItemElementView)Mockito.verify((Object)((ItemElementView)this.elementView1Mock), (VerificationMode)Mockito.times((int)3))).getSaveChange();
        TestProperties.TEST_PROPERTIES_MAP.forEach((propertyName, propertyValue) -> {
            ((PropertyPresenter)Mockito.verify((Object)this.propertyPresenterMock, (VerificationMode)Mockito.times((int)1))).getPropertyFields((String)Matchers.eq((Object)"TEST-ITEM-ID"), (String)Matchers.eq((Object)propertyName), (String)Matchers.eq((Object)propertyValue));
            ((UListElement)Mockito.verify((Object)this.innerItemContainerMock, (VerificationMode)Mockito.times((int)1))).insertBefore((Node)this.propertyFieldsMock, (Node)this.saveChangeMock);
            Mockito.reset((Object[])new UListElement[]{this.innerItemContainerMock});
        });
        Assert.assertTrue((boolean)TestProperties.ITEM_ID_EXPANDABLE_PROPERTIES_MAP_LOCAL.containsKey("TEST-ITEM-ID"));
        TestProperties.EXPANDABLE_PROPERTIES_VALUES.forEach((nestedPropertyName, nestedPropertiesValues) -> {
            Assert.assertTrue((boolean)TestProperties.ITEM_ID_EXPANDABLE_PROPERTIES_MAP_LOCAL.get("TEST-ITEM-ID").contains(nestedPropertyName));
            ((ItemElementPresenter)Mockito.verify((Object)((ItemElementPresenter)this.elementPresenter), (VerificationMode)Mockito.times((int)1))).addExpandableItemElementView((ItemElementView)Matchers.eq((Object)((ItemElementView)this.elementView1Mock)), (Map)Matchers.eq((Object)nestedPropertiesValues), (String)Matchers.eq((Object)nestedPropertyName));
        });
        Assert.assertNotNull((Object)itemContainer);
        Assert.assertTrue((boolean)this.elementViewListLocal.contains(this.elementView1Mock));
    }

    @Test
    public void onEditItemShown() {
        ((ItemElementView)Mockito.doReturn((Object)true).when((Object)((ItemElementView)this.elementView1Mock))).isShown();
        ((ItemElementView.Presenter)this.elementPresenter).onEditItem((ElementView)((ItemElementView)this.elementView1Mock));
        ((ItemElementView.Presenter)Mockito.verify((Object)((ItemElementView.Presenter)this.elementPresenter), (VerificationMode)Mockito.never())).onToggleRowExpansion((ElementView)((ItemElementView)Matchers.eq((Object)((ItemElementView)this.elementView1Mock))), Matchers.eq((boolean)false));
        ((PropertyPresenter)Mockito.verify((Object)this.propertyPresenterMock, (VerificationMode)Mockito.times((int)1))).editProperties((String)Matchers.eq((Object)((ItemElementView)this.elementView1Mock).getItemId()));
        for (String expandableProperty : TestProperties.EXPANDABLE_PROPERTIES) {
            ((PropertyPresenter)Mockito.verify((Object)this.propertyPresenterMock, (VerificationMode)Mockito.times((int)1))).editProperties((String)Matchers.eq((Object)("ELEMENT1_ID." + expandableProperty)));
        }
        ((Style)Mockito.verify((Object)this.styleMock, (VerificationMode)Mockito.times((int)1))).setDisplay(Style.Display.INLINE);
        ((CollectionPresenter)Mockito.verify((Object)this.collectionPresenterMock, (VerificationMode)Mockito.times((int)1))).toggleEditingStatus(Matchers.eq((boolean)true));
    }

    @Test
    public void onEditItemNotShown() {
        ((ItemElementView)Mockito.doReturn((Object)false).when((Object)((ItemElementView)this.elementView1Mock))).isShown();
        ((ItemElementView.Presenter)this.elementPresenter).onEditItem((ElementView)((ItemElementView)this.elementView1Mock));
        ((ItemElementView.Presenter)Mockito.verify((Object)((ItemElementView.Presenter)this.elementPresenter), (VerificationMode)Mockito.times((int)1))).onToggleRowExpansion((ElementView)((ItemElementView)Matchers.eq((Object)((ItemElementView)this.elementView1Mock))), Matchers.eq((boolean)false));
        ((PropertyPresenter)Mockito.verify((Object)this.propertyPresenterMock, (VerificationMode)Mockito.times((int)1))).editProperties((String)Matchers.eq((Object)((ItemElementView)this.elementView1Mock).getItemId()));
        for (String expandableProperty : TestProperties.EXPANDABLE_PROPERTIES) {
            ((PropertyPresenter)Mockito.verify((Object)this.propertyPresenterMock, (VerificationMode)Mockito.times((int)1))).editProperties((String)Matchers.eq((Object)("ELEMENT1_ID." + expandableProperty)));
        }
        ((Style)Mockito.verify((Object)this.styleMock, (VerificationMode)Mockito.times((int)1))).setDisplay(Style.Display.INLINE);
        ((CollectionPresenter)Mockito.verify((Object)this.collectionPresenterMock, (VerificationMode)Mockito.times((int)1))).toggleEditingStatus(Matchers.eq((boolean)true));
    }

    @Test
    public void onStopEditingItem() {
        ((ItemElementView.Presenter)this.elementPresenter).onStopEditingItem((ElementView)((ItemElementView)this.elementView1Mock));
        ((ItemElementView.Presenter)Mockito.verify((Object)((ItemElementView.Presenter)this.elementPresenter), (VerificationMode)Mockito.never())).onToggleRowExpansion((ElementView)((ItemElementView)Matchers.eq((Object)((ItemElementView)this.elementView1Mock))), Matchers.eq((boolean)false));
        ((PropertyPresenter)Mockito.verify((Object)this.propertyPresenterMock, (VerificationMode)Mockito.times((int)1))).stopEditProperties((String)Matchers.eq((Object)"ELEMENT1_ID"));
        ((Style)Mockito.verify((Object)this.styleMock, (VerificationMode)Mockito.times((int)1))).setDisplay((Style.Display)Matchers.eq((Object)Style.Display.NONE));
        ((CollectionPresenter)Mockito.verify((Object)this.collectionPresenterMock, (VerificationMode)Mockito.times((int)1))).toggleEditingStatus(Matchers.eq((boolean)false));
    }

    @Test
    public void onDeleteItem() {
        ((ItemElementView.Presenter)this.elementPresenter).onDeleteItem((ElementView)((ItemElementView)this.elementView1Mock));
        ((PropertyPresenter)Mockito.verify((Object)this.propertyPresenterMock, (VerificationMode)Mockito.times((int)1))).deleteProperties((String)Matchers.eq((Object)"ELEMENT1_ID"));
        ((LIElement)Mockito.verify((Object)this.itemContainerMock, (VerificationMode)Mockito.times((int)1))).removeFromParent();
        Assert.assertFalse((boolean)this.elementViewListLocal.contains(this.elementView1Mock));
        ((CollectionPresenter)Mockito.verify((Object)this.collectionPresenterMock, (VerificationMode)Mockito.times((int)1))).toggleEditingStatus(Matchers.eq((boolean)false));
    }

    @Test
    public void updateItem() {
        ((ItemElementView.Presenter)this.elementPresenter).updateItem((ElementView)((ItemElementView)this.elementView1Mock));
        ((PropertyPresenter)Mockito.verify((Object)this.propertyPresenterMock, (VerificationMode)Mockito.times((int)1))).updateProperties((String)Matchers.eq((Object)((ItemElementView)this.elementView1Mock).getItemId()));
        for (String expandableProperty : TestProperties.EXPANDABLE_PROPERTIES) {
            ((PropertyPresenter)Mockito.verify((Object)this.propertyPresenterMock, (VerificationMode)Mockito.times((int)1))).updateProperties((String)Matchers.eq((Object)("ELEMENT1_ID." + expandableProperty)));
        }
        ((Style)Mockito.verify((Object)this.styleMock, (VerificationMode)Mockito.times((int)1))).setDisplay(Style.Display.NONE);
        ((CollectionPresenter)Mockito.verify((Object)this.collectionPresenterMock, (VerificationMode)Mockito.times((int)1))).toggleEditingStatus(Matchers.eq((boolean)false));
    }

    @Test
    public void getItemsProperties() {
        Map itemsProperties = ((ItemElementView.Presenter)this.elementPresenter).getSimpleItemsProperties();
        Assert.assertNotNull((Object)itemsProperties);
    }
}

