/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.handlers;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Arrays;
import java.util.Collections;
import org.drools.workbench.screens.scenariosimulation.client.handlers.ScenarioSimulationKeyboardEditHandler;
import org.drools.workbench.screens.scenariosimulation.client.models.ScenarioGridModel;
import org.drools.workbench.screens.scenariosimulation.client.widgets.ScenarioGrid;
import org.drools.workbench.screens.scenariosimulation.client.widgets.ScenarioGridColumn;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;
import org.uberfire.ext.wires.core.grids.client.widget.layer.GridLayer;

@RunWith(value=GwtMockitoTestRunner.class)
public class ScenarioSimulationKeyboardEditHandlerTest {
    @Mock
    private GridLayer gridLayerMock;
    @Mock
    private ScenarioGrid scenarioGridMock;
    @Mock
    private ScenarioGridModel scenarioGridModelMock;
    @Mock
    private ScenarioGridColumn gridColumnMock;
    @Mock
    private ScenarioGridColumn gridColumnMock2;
    private ScenarioSimulationKeyboardEditHandler handler;
    private GridData.SelectedCell selectedCell;
    private GridData.SelectedCell selectedCell2;

    @Before
    public void setup() {
        this.selectedCell = new GridData.SelectedCell(0, 0);
        this.selectedCell2 = new GridData.SelectedCell(1, 1);
        this.handler = (ScenarioSimulationKeyboardEditHandler)Mockito.spy((Object)new ScenarioSimulationKeyboardEditHandler(this.gridLayerMock){

            protected boolean startEdit(ScenarioGrid scenarioGrid, int uiColumnIndex, int uiRowIndex, ScenarioGridColumn column, boolean isHeader) {
                return true;
            }
        });
        Mockito.when((Object)this.scenarioGridMock.getModel()).thenReturn((Object)this.scenarioGridModelMock);
        Mockito.when((Object)this.scenarioGridModelMock.getColumns()).thenReturn(Arrays.asList(this.gridColumnMock, this.gridColumnMock2));
    }

    @Test
    public void isExecutable_NoSelection() {
        Mockito.when((Object)this.scenarioGridModelMock.getSelectedCells()).thenReturn(Collections.emptyList());
        Mockito.when((Object)this.scenarioGridModelMock.getSelectedHeaderCells()).thenReturn(Collections.emptyList());
        Assert.assertFalse((boolean)this.handler.isExecutable((GridWidget)this.scenarioGridMock));
    }

    @Test
    public void isExecutable_CellSelected() {
        Mockito.when((Object)this.scenarioGridModelMock.getSelectedCells()).thenReturn(Arrays.asList(this.selectedCell));
        Mockito.when((Object)this.scenarioGridModelMock.getSelectedHeaderCells()).thenReturn(Collections.emptyList());
        Assert.assertTrue((boolean)this.handler.isExecutable((GridWidget)this.scenarioGridMock));
    }

    @Test
    public void isExecutable_CellsSelected() {
        Mockito.when((Object)this.scenarioGridModelMock.getSelectedCells()).thenReturn(Arrays.asList(this.selectedCell, this.selectedCell2));
        Mockito.when((Object)this.scenarioGridModelMock.getSelectedHeaderCells()).thenReturn(Collections.emptyList());
        Assert.assertFalse((boolean)this.handler.isExecutable((GridWidget)this.scenarioGridMock));
    }

    @Test
    public void isExecutable_HeaderCellSelected() {
        Mockito.when((Object)this.scenarioGridModelMock.getSelectedCells()).thenReturn(Collections.emptyList());
        Mockito.when((Object)this.scenarioGridModelMock.getSelectedHeaderCells()).thenReturn(Arrays.asList(this.selectedCell, this.selectedCell2));
        Assert.assertTrue((boolean)this.handler.isExecutable((GridWidget)this.scenarioGridMock));
    }

    @Test
    public void isExecutable_HeaderCellsSelected() {
        Mockito.when((Object)this.scenarioGridModelMock.getSelectedCells()).thenReturn(Collections.emptyList());
        Mockito.when((Object)this.scenarioGridModelMock.getSelectedHeaderCells()).thenReturn(Arrays.asList(this.selectedCell));
        Assert.assertTrue((boolean)this.handler.isExecutable((GridWidget)this.scenarioGridMock));
    }

    @Test
    public void isExecutable_CellsAndHeaderCellsSelected() {
        Mockito.when((Object)this.scenarioGridModelMock.getSelectedCells()).thenReturn(Arrays.asList(this.selectedCell));
        Mockito.when((Object)this.scenarioGridModelMock.getSelectedHeaderCells()).thenReturn(Arrays.asList(this.selectedCell2));
        Assert.assertFalse((boolean)this.handler.isExecutable((GridWidget)this.scenarioGridMock));
    }

    @Test
    public void perform_NoSelection() {
        Mockito.when((Object)this.scenarioGridModelMock.getSelectedCells()).thenReturn(Collections.emptyList());
        Mockito.when((Object)this.scenarioGridModelMock.getSelectedHeaderCells()).thenReturn(Collections.emptyList());
        Assert.assertFalse((boolean)this.handler.perform((GridWidget)this.scenarioGridMock, false, false));
        ((ScenarioSimulationKeyboardEditHandler)Mockito.verify((Object)this.handler, (VerificationMode)Mockito.never())).startEdit((ScenarioGrid)Matchers.any(), Matchers.anyInt(), Matchers.anyInt(), (ScenarioGridColumn)Matchers.any(), Matchers.anyBoolean());
    }

    @Test
    public void perform_CellSelected() {
        Mockito.when((Object)this.scenarioGridModelMock.getSelectedCells()).thenReturn(Arrays.asList(this.selectedCell));
        Mockito.when((Object)this.scenarioGridModelMock.getSelectedHeaderCells()).thenReturn(Collections.emptyList());
        Mockito.when((Object)this.scenarioGridModelMock.getSelectedCellsOrigin()).thenReturn((Object)this.selectedCell);
        this.handler.perform((GridWidget)this.scenarioGridMock, false, false);
        ((ScenarioSimulationKeyboardEditHandler)Mockito.verify((Object)this.handler, (VerificationMode)Mockito.times((int)1))).startEdit((ScenarioGrid)Matchers.eq((Object)this.scenarioGridMock), Matchers.eq((int)0), Matchers.eq((int)0), (ScenarioGridColumn)Matchers.eq((Object)this.gridColumnMock), Matchers.eq((boolean)false));
    }

    @Test
    public void perform_CellsSelected() {
        Mockito.when((Object)this.scenarioGridModelMock.getSelectedCells()).thenReturn(Arrays.asList(this.selectedCell, this.selectedCell2));
        Mockito.when((Object)this.scenarioGridModelMock.getSelectedHeaderCells()).thenReturn(Collections.emptyList());
        Mockito.when((Object)this.scenarioGridModelMock.getSelectedCellsOrigin()).thenReturn((Object)this.selectedCell);
        Assert.assertFalse((boolean)this.handler.perform((GridWidget)this.scenarioGridMock, false, false));
        ((ScenarioSimulationKeyboardEditHandler)Mockito.verify((Object)this.handler, (VerificationMode)Mockito.never())).startEdit((ScenarioGrid)Matchers.any(), Matchers.anyInt(), Matchers.anyInt(), (ScenarioGridColumn)Matchers.any(), Matchers.anyBoolean());
    }

    @Test
    public void perform_HeaderCellSelected() {
        Mockito.when((Object)this.scenarioGridModelMock.getSelectedCells()).thenReturn(Collections.emptyList());
        Mockito.when((Object)this.scenarioGridModelMock.getSelectedHeaderCells()).thenReturn(Arrays.asList(this.selectedCell));
        this.handler.perform((GridWidget)this.scenarioGridMock, false, false);
        ((ScenarioSimulationKeyboardEditHandler)Mockito.verify((Object)this.handler, (VerificationMode)Mockito.times((int)1))).startEdit((ScenarioGrid)Matchers.eq((Object)this.scenarioGridMock), Matchers.eq((int)0), Matchers.eq((int)0), (ScenarioGridColumn)Matchers.eq((Object)this.gridColumnMock), Matchers.eq((boolean)true));
    }

    @Test
    public void perform_HeaderCellsSelected() {
        Mockito.when((Object)this.scenarioGridModelMock.getSelectedCells()).thenReturn(Collections.emptyList());
        Mockito.when((Object)this.scenarioGridModelMock.getSelectedHeaderCells()).thenReturn(Arrays.asList(this.selectedCell, this.selectedCell2));
        this.handler.perform((GridWidget)this.scenarioGridMock, false, false);
        ((ScenarioSimulationKeyboardEditHandler)Mockito.verify((Object)this.handler, (VerificationMode)Mockito.times((int)1))).startEdit((ScenarioGrid)Matchers.eq((Object)this.scenarioGridMock), Matchers.eq((int)0), Matchers.eq((int)0), (ScenarioGridColumn)Matchers.eq((Object)this.gridColumnMock), Matchers.eq((boolean)true));
    }

    @Test
    public void perform_CellAndHeaderCellsSelected() {
        Mockito.when((Object)this.scenarioGridModelMock.getSelectedCells()).thenReturn(Arrays.asList(this.selectedCell));
        Mockito.when((Object)this.scenarioGridModelMock.getSelectedHeaderCells()).thenReturn(Arrays.asList(this.selectedCell2));
        Assert.assertFalse((boolean)this.handler.perform((GridWidget)this.scenarioGridMock, false, false));
        ((ScenarioSimulationKeyboardEditHandler)Mockito.verify((Object)this.handler, (VerificationMode)Mockito.never())).startEdit((ScenarioGrid)Matchers.any(), Matchers.anyInt(), Matchers.anyInt(), (ScenarioGridColumn)Matchers.any(), Matchers.anyBoolean());
    }
}

