/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.models;

import com.ait.lienzo.test.LienzoMockitoTestRunner;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import org.drools.scenariosimulation.api.model.BackgroundData;
import org.drools.scenariosimulation.api.model.ExpressionIdentifier;
import org.drools.scenariosimulation.api.model.FactIdentifier;
import org.drools.scenariosimulation.api.model.FactMapping;
import org.drools.scenariosimulation.api.model.FactMappingValueStatus;
import org.drools.workbench.screens.scenariosimulation.client.AbstractScenarioSimulationTest;
import org.drools.workbench.screens.scenariosimulation.client.TestProperties;
import org.drools.workbench.screens.scenariosimulation.client.enums.GridWidget;
import org.drools.workbench.screens.scenariosimulation.client.metadata.ScenarioHeaderMetaData;
import org.drools.workbench.screens.scenariosimulation.client.models.BackgroundGridModel;
import org.drools.workbench.screens.scenariosimulation.client.values.ScenarioGridCellValue;
import org.drools.workbench.screens.scenariosimulation.client.widgets.ScenarioGridCell;
import org.drools.workbench.screens.scenariosimulation.client.widgets.ScenarioGridColumn;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.wires.core.grids.client.model.GridCell;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.model.GridRow;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridRow;

@RunWith(value=LienzoMockitoTestRunner.class)
public class BackgroundGridModelTest
extends AbstractScenarioSimulationTest {
    private BackgroundGridModel backgroundGridModelSpy;
    @Mock
    private ScenarioGridColumn scenarioIndexGridColumnMock;
    @Mock
    private BaseGridRow gridRowMock;
    @Mock
    private ScenarioHeaderMetaData groupHeaderMetaDataMock;
    @Mock
    private ScenarioHeaderMetaData indexHeaderMetaDataMock;
    @Mock
    private ScenarioGridCell gridCellMock;
    @Mock
    private ScenarioGridCellValue gridCellValueMock;
    @Mock
    private BackgroundData backgroundDataMock;

    @Override
    @Before
    public void setup() {
        super.setup();
        TestProperties.HEADER_META_DATA.add((GridColumn.HeaderMetaData)this.groupHeaderMetaDataMock);
        TestProperties.HEADER_META_DATA.add((GridColumn.HeaderMetaData)this.informationHeaderMetaDataMock);
        TestProperties.HEADER_META_DATA.add((GridColumn.HeaderMetaData)this.propertyHeaderMetaDataMock);
        ((ScenarioGridCell)Mockito.doReturn((Object)this.gridCellValueMock).when((Object)this.gridCellMock)).getValue();
        Mockito.when((Object)this.informationHeaderMetaDataMock.getMetadataType()).thenReturn((Object)ScenarioHeaderMetaData.MetadataType.INSTANCE);
        Mockito.when((Object)this.informationHeaderMetaDataMock.getTitle()).thenReturn((Object)"GRID_COLUMN_TITLE");
        Mockito.when((Object)this.informationHeaderMetaDataMock.getColumnGroup()).thenReturn((Object)"GIVEN");
        Mockito.when((Object)this.informationHeaderMetaDataMock.getColumnId()).thenReturn((Object)"GRID_COLUMN_ID");
        Mockito.when((Object)this.indexHeaderMetaDataMock.getTitle()).thenReturn((Object)ExpressionIdentifier.INDEX.getName());
        Mockito.when((Object)this.scenarioIndexGridColumnMock.getInformationHeaderMetaData()).thenReturn((Object)this.indexHeaderMetaDataMock);
        Mockito.when((Object)this.gridColumnMock.getHeaderMetaData()).thenReturn(TestProperties.HEADER_META_DATA);
        Mockito.when((Object)this.gridCellMock.getValue()).thenReturn((Object)this.gridCellValueMock);
        Mockito.when((Object)((String)this.gridCellValueMock.getValue())).thenReturn((Object)"GRID_CELL_TEXT");
        Mockito.when((Object)this.backgroundDataMock.getUnmodifiableFactMappingValues()).thenReturn((Object)this.factMappingValuesLocal);
        TestProperties.GRID_ROWS.clear();
        IntStream.range(0, 3).forEach(rowIndex -> {
            Mockito.when((Object)this.backgroundMock.addData(rowIndex)).thenReturn((Object)this.backgroundDataMock);
            Mockito.when((Object)((BackgroundData)this.backgroundMock.getDataByIndex(rowIndex))).thenReturn((Object)this.backgroundDataMock);
            Mockito.when((Object)((BackgroundData)this.backgroundMock.cloneData(rowIndex, rowIndex + 1))).thenReturn((Object)this.backgroundDataMock);
            TestProperties.GRID_ROWS.add((GridRow)this.gridRowMock);
        });
        Mockito.when((Object)this.backgroundMock.addData(3)).thenReturn((Object)this.backgroundDataMock);
        Mockito.when((Object)((BackgroundData)this.backgroundMock.getDataByIndex(3))).thenReturn((Object)this.backgroundDataMock);
        Mockito.when((Object)((BackgroundData)this.backgroundMock.cloneData(3, 4))).thenReturn((Object)this.backgroundDataMock);
        Mockito.when((Object)this.backgroundDataMock.getFactMappingValue((FactIdentifier)Matchers.any(), (ExpressionIdentifier)Matchers.any())).thenReturn(Optional.of(this.factMappingValueMock));
        Mockito.when((Object)this.backgroundDataMock.getFactMappingValue((FactMapping)Matchers.isA(FactMapping.class))).thenReturn(Optional.of(this.factMappingValueMock));
        Mockito.when((Object)this.factMappingValueMock.getStatus()).thenReturn((Object)FactMappingValueStatus.FAILED_WITH_ERROR);
        this.backgroundGridModelSpy = (BackgroundGridModel)Mockito.spy((Object)new BackgroundGridModel(false){
            {
                this.abstractScesimModel = BackgroundGridModelTest.this.backgroundMock;
                this.eventBus = BackgroundGridModelTest.this.eventBusMock;
                this.rows = TestProperties.GRID_ROWS;
                this.columns = BackgroundGridModelTest.this.gridColumns;
            }

            public void deleteColumn(GridColumn<?> column) {
            }

            public GridCell<?> getCell(int rowIndex, int columnIndex) {
                if (rowIndex < 0 || rowIndex > this.rows.size() - 1) {
                    return null;
                }
                return BackgroundGridModelTest.this.gridCellMock;
            }
        });
    }

    @Test
    public void getGridWidget() {
        Assert.assertEquals((Object)GridWidget.BACKGROUND, (Object)this.backgroundGridModelSpy.getGridWidget());
    }

    @Test
    public void getInstanceLimits() {
        GridData.Range retrieved = this.backgroundGridModelSpy.getInstanceLimits(1);
        Assert.assertNotNull((Object)retrieved);
        Assert.assertEquals((long)0L, (long)retrieved.getMinRowIndex());
        Assert.assertEquals((long)3L, (long)retrieved.getMaxRowIndex());
    }

    @Test
    public void insertRowGridOnly() {
        int setCellInvocations = this.backgroundDataMock.getUnmodifiableFactMappingValues().size();
        this.backgroundGridModelSpy.insertRowGridOnly(2, (GridRow)this.gridRowMock, this.backgroundDataMock);
        ((BackgroundGridModel)Mockito.verify((Object)this.backgroundGridModelSpy, (VerificationMode)Mockito.atLeast((int)1))).checkSimulation();
        ((BackgroundGridModel)Mockito.verify((Object)this.backgroundGridModelSpy, (VerificationMode)Mockito.never())).insertRow(Matchers.eq((int)2), (GridRow)Matchers.eq((Object)this.gridRowMock));
        ((BackgroundGridModel)Mockito.verify((Object)this.backgroundGridModelSpy, (VerificationMode)Mockito.times((int)setCellInvocations))).setCell(Matchers.anyInt(), Matchers.anyInt(), (Supplier)Matchers.isA(Supplier.class));
        Mockito.reset((Object[])new BackgroundGridModel[]{this.backgroundGridModelSpy});
        FactMapping factMappingByIndexMock = (FactMapping)Mockito.mock(FactMapping.class);
        Mockito.when((Object)factMappingByIndexMock.getClassName()).thenReturn((Object)List.class.getName());
        Mockito.when((Object)this.simulationDescriptorMock.getFactMappingByIndex(2)).thenReturn((Object)factMappingByIndexMock);
        this.backgroundGridModelSpy.insertRowGridOnly(2, (GridRow)this.gridRowMock, this.backgroundDataMock);
        ((BackgroundGridModel)Mockito.verify((Object)this.backgroundGridModelSpy, (VerificationMode)Mockito.atLeast((int)1))).checkSimulation();
        ((BackgroundGridModel)Mockito.verify((Object)this.backgroundGridModelSpy, (VerificationMode)Mockito.never())).insertRow(Matchers.eq((int)2), (GridRow)Matchers.eq((Object)this.gridRowMock));
        ((BackgroundGridModel)Mockito.verify((Object)this.backgroundGridModelSpy, (VerificationMode)Mockito.times((int)setCellInvocations))).setCell(Matchers.anyInt(), Matchers.anyInt(), (Supplier)Matchers.isA(Supplier.class));
    }

    @Test
    public void commonAddRow() {
        this.backgroundGridModelSpy.commonAddRow(1);
        ((BackgroundGridModel)Mockito.verify((Object)this.backgroundGridModelSpy, (VerificationMode)Mockito.times((int)1))).commonAddRow(1, 0);
    }
}

