/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.dropdown;

import elemental2.dom.HTMLElement;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.drools.workbench.screens.scenariosimulation.client.dropdown.ScenarioSimulationAssetsDropdownProvider;
import org.junit.Assert;
import org.junit.Test;
import org.kie.workbench.common.widgets.client.assets.dropdown.KieAssetsDropdown;
import org.kie.workbench.common.widgets.client.assets.dropdown.KieAssetsDropdownItem;
import org.kie.workbench.common.widgets.client.assets.dropdown.KieAssetsDropdownView;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.mvp.Command;

public abstract class AbstractScenarioSimulationDropdownTest {
    protected static final int ITEM_NUMBER = 3;
    @Mock
    protected KieAssetsDropdownItem kieAssetsDropdownItemMock;
    @Mock
    protected ScenarioSimulationAssetsDropdownProvider dataProviderMock;
    @Mock
    protected Command onValueChangeHandlerMock;
    @Mock
    protected HTMLElement htmlElementMock;
    protected List<KieAssetsDropdownItem> assetList = IntStream.range(0, 3).mapToObj(i -> new KieAssetsDropdownItem("File_" + i + ".txt", "", "DEFAULT_VALUE", new HashMap())).collect(Collectors.toList());
    protected KieAssetsDropdown assetsDropdown;
    protected KieAssetsDropdownView viewMock;

    public void setup() {
        Mockito.when((Object)this.viewMock.getElement()).thenReturn((Object)this.htmlElementMock);
        Mockito.when((Object)this.viewMock.getValue()).thenReturn((Object)"DEFAULT_VALUE");
    }

    @Test
    public void init() {
        this.assetsDropdown.init();
        ((KieAssetsDropdownView)Mockito.verify((Object)this.viewMock, (VerificationMode)Mockito.times((int)1))).init((KieAssetsDropdown)Matchers.eq((Object)this.assetsDropdown));
    }

    @Test
    public void loadAssets() {
        this.assetsDropdown.loadAssets();
        ((KieAssetsDropdown)Mockito.verify((Object)this.assetsDropdown, (VerificationMode)Mockito.times((int)1))).clear();
        ((KieAssetsDropdown)Mockito.verify((Object)this.assetsDropdown, (VerificationMode)Mockito.times((int)1))).initializeDropdown();
    }

    @Test
    public void initialize() {
        this.assetsDropdown.initialize();
        ((KieAssetsDropdownView)Mockito.verify((Object)this.viewMock, (VerificationMode)Mockito.times((int)1))).refreshSelectPicker();
    }

    @Test
    public void clear() {
        this.assetsDropdown.clear();
        ((KieAssetsDropdownView)Mockito.verify((Object)this.viewMock, (VerificationMode)Mockito.times((int)1))).clear();
    }

    @Test
    public void getElement() {
        HTMLElement retrieved = this.assetsDropdown.getElement();
        ((KieAssetsDropdownView)Mockito.verify((Object)this.viewMock, (VerificationMode)Mockito.times((int)1))).getElement();
        Assert.assertEquals((Object)this.htmlElementMock, (Object)retrieved);
    }

    @Test
    public void getValue() {
        Mockito.when((Object)this.viewMock.getValue()).thenReturn((Object)"DEFAULT_VALUE");
        Optional retrieved = this.assetsDropdown.getValue();
        Assert.assertNotNull((Object)retrieved);
        Assert.assertTrue((boolean)retrieved.isPresent());
        ((KieAssetsDropdownView)Mockito.verify((Object)this.viewMock, (VerificationMode)Mockito.times((int)1))).getValue();
        Mockito.reset((Object[])new KieAssetsDropdownView[]{this.viewMock});
        Mockito.when((Object)this.viewMock.getValue()).thenReturn((Object)"UNKNOWN");
        retrieved = this.assetsDropdown.getValue();
        Assert.assertNotNull((Object)retrieved);
        Assert.assertFalse((boolean)retrieved.isPresent());
    }

    @Test
    public void onValueChanged() {
        this.assetsDropdown.onValueChanged();
        ((Command)Mockito.verify((Object)this.onValueChangeHandlerMock, (VerificationMode)Mockito.times((int)1))).execute();
    }

    @Test
    public void initializeDropdown() {
        this.assetsDropdown.initializeDropdown();
        ((ScenarioSimulationAssetsDropdownProvider)Mockito.verify((Object)this.dataProviderMock, (VerificationMode)Mockito.times((int)1))).getItems((Consumer)Matchers.isA(Consumer.class));
    }

    @Test
    public void addValue() {
        this.assetsDropdown.addValue(this.kieAssetsDropdownItemMock);
        ((KieAssetsDropdownView)Mockito.verify((Object)this.viewMock, (VerificationMode)Mockito.times((int)1))).addValue((KieAssetsDropdownItem)Matchers.eq((Object)this.kieAssetsDropdownItemMock));
    }
}

