/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.models;

import com.ait.lienzo.test.LienzoMockitoTestRunner;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import org.drools.scenariosimulation.api.model.ExpressionIdentifier;
import org.drools.scenariosimulation.api.model.FactIdentifier;
import org.drools.scenariosimulation.api.model.FactMapping;
import org.drools.scenariosimulation.api.model.FactMappingValueStatus;
import org.drools.scenariosimulation.api.model.Scenario;
import org.drools.workbench.screens.scenariosimulation.client.AbstractScenarioSimulationTest;
import org.drools.workbench.screens.scenariosimulation.client.TestProperties;
import org.drools.workbench.screens.scenariosimulation.client.enums.GridWidget;
import org.drools.workbench.screens.scenariosimulation.client.metadata.ScenarioHeaderMetaData;
import org.drools.workbench.screens.scenariosimulation.client.models.ScenarioGridModel;
import org.drools.workbench.screens.scenariosimulation.client.values.ScenarioGridCellValue;
import org.drools.workbench.screens.scenariosimulation.client.widgets.ScenarioGridCell;
import org.drools.workbench.screens.scenariosimulation.client.widgets.ScenarioGridColumn;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.wires.core.grids.client.model.GridCell;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.model.GridRow;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridRow;

@RunWith(value=LienzoMockitoTestRunner.class)
public class SimulationGridModelTest
extends AbstractScenarioSimulationTest {
    private ScenarioGridModel scenarioGridModelSpy;
    @Mock
    private ScenarioGridColumn scenarioIndexGridColumnMock;
    @Mock
    private BaseGridRow gridRowMock;
    @Mock
    private ScenarioHeaderMetaData groupHeaderMetaDataMock;
    @Mock
    private ScenarioHeaderMetaData indexHeaderMetaDataMock;
    @Mock
    private ScenarioGridCell gridCellMock;
    @Mock
    private ScenarioGridCellValue gridCellValueMock;
    @Mock
    private Scenario scenarioMock;

    @Override
    @Before
    public void setup() {
        super.setup();
        TestProperties.HEADER_META_DATA.add((GridColumn.HeaderMetaData)this.groupHeaderMetaDataMock);
        TestProperties.HEADER_META_DATA.add((GridColumn.HeaderMetaData)this.informationHeaderMetaDataMock);
        TestProperties.HEADER_META_DATA.add((GridColumn.HeaderMetaData)this.propertyHeaderMetaDataMock);
        ((ScenarioGridCell)Mockito.doReturn((Object)this.gridCellValueMock).when((Object)this.gridCellMock)).getValue();
        Mockito.when((Object)this.informationHeaderMetaDataMock.getMetadataType()).thenReturn((Object)ScenarioHeaderMetaData.MetadataType.INSTANCE);
        Mockito.when((Object)this.informationHeaderMetaDataMock.getTitle()).thenReturn((Object)"GRID_COLUMN_TITLE");
        Mockito.when((Object)this.informationHeaderMetaDataMock.getColumnGroup()).thenReturn((Object)"GIVEN");
        Mockito.when((Object)this.informationHeaderMetaDataMock.getColumnId()).thenReturn((Object)"GRID_COLUMN_ID");
        Mockito.when((Object)this.indexHeaderMetaDataMock.getTitle()).thenReturn((Object)ExpressionIdentifier.INDEX.getName());
        Mockito.when((Object)this.scenarioIndexGridColumnMock.getInformationHeaderMetaData()).thenReturn((Object)this.indexHeaderMetaDataMock);
        Mockito.when((Object)this.gridColumnMock.getHeaderMetaData()).thenReturn(TestProperties.HEADER_META_DATA);
        Mockito.when((Object)this.gridCellMock.getValue()).thenReturn((Object)this.gridCellValueMock);
        Mockito.when((Object)((String)this.gridCellValueMock.getValue())).thenReturn((Object)"GRID_CELL_TEXT");
        Mockito.when((Object)this.scenarioMock.getUnmodifiableFactMappingValues()).thenReturn((Object)this.factMappingValuesLocal);
        TestProperties.GRID_ROWS.clear();
        IntStream.range(0, 3).forEach(rowIndex -> {
            Mockito.when((Object)this.simulationMock.addData(rowIndex)).thenReturn((Object)this.scenarioMock);
            Mockito.when((Object)((Scenario)this.simulationMock.getDataByIndex(rowIndex))).thenReturn((Object)this.scenarioMock);
            Mockito.when((Object)((Scenario)this.simulationMock.cloneData(rowIndex, rowIndex + 1))).thenReturn((Object)this.scenarioMock);
            TestProperties.GRID_ROWS.add((GridRow)this.gridRowMock);
        });
        Mockito.when((Object)this.simulationMock.addData(3)).thenReturn((Object)this.scenarioMock);
        Mockito.when((Object)((Scenario)this.simulationMock.getDataByIndex(3))).thenReturn((Object)this.scenarioMock);
        Mockito.when((Object)((Scenario)this.simulationMock.cloneData(3, 4))).thenReturn((Object)this.scenarioMock);
        Mockito.when((Object)this.scenarioMock.getFactMappingValue((FactIdentifier)Matchers.any(), (ExpressionIdentifier)Matchers.any())).thenReturn(Optional.of(this.factMappingValueMock));
        Mockito.when((Object)this.scenarioMock.getFactMappingValue((FactMapping)Matchers.isA(FactMapping.class))).thenReturn(Optional.of(this.factMappingValueMock));
        Mockito.when((Object)this.factMappingValueMock.getStatus()).thenReturn((Object)FactMappingValueStatus.FAILED_WITH_ERROR);
        this.scenarioGridModelSpy = (ScenarioGridModel)Mockito.spy((Object)new ScenarioGridModel(false){
            {
                this.abstractScesimModel = SimulationGridModelTest.this.simulationMock;
                this.eventBus = SimulationGridModelTest.this.eventBusMock;
                this.rows = TestProperties.GRID_ROWS;
                this.columns = SimulationGridModelTest.this.gridColumns;
            }

            public void deleteColumn(GridColumn<?> column) {
            }

            public GridCell<?> getCell(int rowIndex, int columnIndex) {
                if (rowIndex < 0 || rowIndex > this.rows.size() - 1) {
                    return null;
                }
                return SimulationGridModelTest.this.gridCellMock;
            }
        });
    }

    @Test
    public void getGridWidget() {
        Assert.assertEquals((Object)GridWidget.SIMULATION, (Object)this.scenarioGridModelSpy.getGridWidget());
    }

    @Test
    public void getInstanceLimits() {
        GridData.Range retrieved = this.scenarioGridModelSpy.getInstanceLimits(2);
        Assert.assertNotNull((Object)retrieved);
        Assert.assertEquals((long)1L, (long)retrieved.getMinRowIndex());
        Assert.assertEquals((long)3L, (long)retrieved.getMaxRowIndex());
    }

    @Test
    public void insertRowGridOnly() {
        int setCellInvocations = this.scenarioMock.getUnmodifiableFactMappingValues().size();
        this.scenarioGridModelSpy.insertRowGridOnly(2, (GridRow)this.gridRowMock, this.scenarioMock);
        ((ScenarioGridModel)Mockito.verify((Object)this.scenarioGridModelSpy, (VerificationMode)Mockito.atLeast((int)1))).checkSimulation();
        ((ScenarioGridModel)Mockito.verify((Object)this.scenarioGridModelSpy, (VerificationMode)Mockito.never())).insertRow(Matchers.eq((int)2), (GridRow)Matchers.eq((Object)this.gridRowMock));
        ((ScenarioGridModel)Mockito.verify((Object)this.scenarioGridModelSpy, (VerificationMode)Mockito.times((int)1))).updateIndexColumn();
        ((ScenarioGridModel)Mockito.verify((Object)this.scenarioGridModelSpy, (VerificationMode)Mockito.times((int)setCellInvocations))).setCell(Matchers.anyInt(), Matchers.anyInt(), (Supplier)Matchers.isA(Supplier.class));
        Mockito.reset((Object[])new ScenarioGridModel[]{this.scenarioGridModelSpy});
        FactMapping factMappingByIndexMock = (FactMapping)Mockito.mock(FactMapping.class);
        Mockito.when((Object)factMappingByIndexMock.getClassName()).thenReturn((Object)List.class.getName());
        Mockito.when((Object)this.simulationDescriptorMock.getFactMappingByIndex(2)).thenReturn((Object)factMappingByIndexMock);
        this.scenarioGridModelSpy.insertRowGridOnly(2, (GridRow)this.gridRowMock, this.scenarioMock);
        ((ScenarioGridModel)Mockito.verify((Object)this.scenarioGridModelSpy, (VerificationMode)Mockito.atLeast((int)1))).checkSimulation();
        ((ScenarioGridModel)Mockito.verify((Object)this.scenarioGridModelSpy, (VerificationMode)Mockito.never())).insertRow(Matchers.eq((int)2), (GridRow)Matchers.eq((Object)this.gridRowMock));
        ((ScenarioGridModel)Mockito.verify((Object)this.scenarioGridModelSpy, (VerificationMode)Mockito.times((int)1))).updateIndexColumn();
        ((ScenarioGridModel)Mockito.verify((Object)this.scenarioGridModelSpy, (VerificationMode)Mockito.times((int)setCellInvocations))).setCell(Matchers.anyInt(), Matchers.anyInt(), (Supplier)Matchers.isA(Supplier.class));
    }

    @Test
    public void commonAddRow() {
        this.scenarioGridModelSpy.commonAddRow(1);
        ((ScenarioGridModel)Mockito.verify((Object)this.scenarioGridModelSpy, (VerificationMode)Mockito.times((int)1))).commonAddRow(1, 1);
    }
}

