/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.handlers;

import java.util.ArrayList;
import java.util.Collection;
import javax.inject.Inject;
import org.drools.workbench.screens.scenariosimulation.client.resources.i18n.ScenarioSimulationEditorConstants;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.CheatSheetPresenter;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.CheatSheetView;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.SettingsPresenter;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.SettingsView;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.TestToolsPresenter;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.TestToolsView;
import org.kie.workbench.common.widgets.client.docks.AbstractWorkbenchDocksHandler;
import org.kie.workbench.common.widgets.client.docks.AuthoringEditorDock;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.mvp.PlaceStatus;
import org.uberfire.client.workbench.docks.UberfireDock;
import org.uberfire.client.workbench.docks.UberfireDockPosition;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;

public abstract class AbstractScenarioSimulationDocksHandler
extends AbstractWorkbenchDocksHandler {
    public static final String SCESIMEDITOR_ID = "scesimeditorid";
    @Inject
    protected AuthoringEditorDock authoringWorkbenchDocks;
    @Inject
    protected PlaceManager placeManager;
    @Inject
    protected TestToolsPresenter testToolsPresenter;
    @Inject
    protected SettingsPresenter settingsPresenter;
    @Inject
    protected CheatSheetPresenter cheatSheetPresenter;
    private UberfireDock settingsDock;
    private UberfireDock toolsDock;
    private UberfireDock cheatSheetDock;
    private String currentScesimEditorId;

    public Collection<UberfireDock> provideDocks(String perspectiveIdentifier) {
        ArrayList<UberfireDock> result = new ArrayList<UberfireDock>();
        this.settingsDock = new UberfireDock(UberfireDockPosition.EAST, "SLIDERS", (PlaceRequest)new DefaultPlaceRequest("org.drools.scenariosimulation.Settings"), perspectiveIdentifier);
        result.add(this.settingsDock.withSize(450.0).withLabel(ScenarioSimulationEditorConstants.INSTANCE.settings()));
        this.toolsDock = new UberfireDock(UberfireDockPosition.EAST, "INFO_CIRCLE", (PlaceRequest)new DefaultPlaceRequest("org.drools.scenariosimulation.TestTools"), perspectiveIdentifier);
        result.add(this.toolsDock.withSize(450.0).withLabel(ScenarioSimulationEditorConstants.INSTANCE.testTools()));
        this.cheatSheetDock = new UberfireDock(UberfireDockPosition.EAST, "FILE_TEXT", (PlaceRequest)new DefaultPlaceRequest("org.drools.scenariosimulation.CheatSheet"), perspectiveIdentifier);
        result.add(this.cheatSheetDock.withSize(450.0).withLabel(ScenarioSimulationEditorConstants.INSTANCE.scenarioCheatSheet()));
        return result;
    }

    public void addDocks() {
        this.refreshDocks(true, false);
    }

    public void removeDocks() {
        this.refreshDocks(true, true);
    }

    protected void refreshDocks(boolean shouldRefresh, boolean shouldDisable) {
        super.refreshDocks(shouldRefresh, shouldDisable);
    }

    public void expandToolsDock() {
        if (PlaceStatus.CLOSE.equals((Object)this.placeManager.getStatus(this.getTestToolsPlaceManager()))) {
            this.authoringWorkbenchDocks.expandAuthoringDock(this.toolsDock);
        }
    }

    public void expandSettingsDock() {
        if (PlaceStatus.CLOSE.equals((Object)this.placeManager.getStatus(this.getSettingsPlaceManager()))) {
            this.authoringWorkbenchDocks.expandAuthoringDock(this.settingsDock);
        }
    }

    public abstract void expandTestResultsDock();

    public void resetDocks() {
        this.settingsPresenter.reset();
        this.cheatSheetPresenter.reset();
        this.testToolsPresenter.reset();
    }

    public void setScesimEditorId(String scesimEditorId) {
        this.currentScesimEditorId = scesimEditorId;
        this.settingsDock.getPlaceRequest().addParameter(SCESIMEDITOR_ID, scesimEditorId);
        this.toolsDock.getPlaceRequest().addParameter(SCESIMEDITOR_ID, scesimEditorId);
        this.cheatSheetDock.getPlaceRequest().addParameter(SCESIMEDITOR_ID, scesimEditorId);
    }

    public CheatSheetView.Presenter getCheatSheetPresenter() {
        return this.cheatSheetPresenter;
    }

    public TestToolsView.Presenter getTestToolsPresenter() {
        return this.testToolsPresenter;
    }

    public SettingsView.Presenter getSettingsPresenter() {
        return this.settingsPresenter;
    }

    protected PlaceRequest getSettingsPlaceManager() {
        return this.getCurrentRightDockPlaceRequest("org.drools.scenariosimulation.Settings");
    }

    protected PlaceRequest getTestToolsPlaceManager() {
        return this.getCurrentRightDockPlaceRequest("org.drools.scenariosimulation.TestTools");
    }

    protected PlaceRequest getCurrentRightDockPlaceRequest(String identifier) {
        DefaultPlaceRequest toReturn = new DefaultPlaceRequest(identifier);
        toReturn.addParameter(SCESIMEDITOR_ID, String.valueOf(this.currentScesimEditorId));
        return toReturn;
    }
}

