/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client;

import java.util.stream.IntStream;
import org.drools.scenariosimulation.api.model.ExpressionIdentifier;
import org.drools.scenariosimulation.api.model.FactIdentifier;
import org.drools.scenariosimulation.api.model.FactMappingType;
import org.drools.scenariosimulation.api.model.Scenario;
import org.drools.scenariosimulation.api.model.ScesimModelDescriptor;
import org.drools.scenariosimulation.api.model.Simulation;

public class TestUtils {
    public static Simulation getSimulation(int numberOfColumns, int numberOfRows) {
        Simulation simulation = new Simulation();
        ScesimModelDescriptor simulationDescriptor = simulation.getScesimModelDescriptor();
        simulationDescriptor.addFactMapping(FactIdentifier.DESCRIPTION, ExpressionIdentifier.DESCRIPTION);
        IntStream.range(0, numberOfColumns).forEach(columnIndex -> simulationDescriptor.addFactMapping(FactIdentifier.create((String)TestUtils.getFactName(columnIndex), (String)String.class.getCanonicalName()), ExpressionIdentifier.create((String)TestUtils.getColName(columnIndex), (FactMappingType)FactMappingType.EXPECT)));
        IntStream.range(0, numberOfRows).forEach(rowIndex -> {
            Scenario scenario = (Scenario)simulation.addData();
            scenario.setDescription(TestUtils.getRowName(rowIndex));
            IntStream.range(0, numberOfColumns).forEach(columnIndex -> scenario.addMappingValue(FactIdentifier.create((String)TestUtils.getFactName(columnIndex), (String)String.class.getCanonicalName()), ExpressionIdentifier.create((String)TestUtils.getColName(columnIndex), (FactMappingType)FactMappingType.EXPECT), (Object)TestUtils.getCellValue(columnIndex, rowIndex)));
        });
        return simulation;
    }

    public static String getColName(int index) {
        return "COL-" + index;
    }

    public static String getRowName(int index) {
        return "ROW-" + index;
    }

    public static String getFactName(int index) {
        return "GROUP_COL-" + index;
    }

    public static String getCellValue(int col, int row) {
        return "VAL_COL-" + col + "-ROW-" + row;
    }
}

