/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.editor.menu;

import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.LIElement;
import com.google.gwt.dom.client.Node;
import com.google.gwt.dom.client.NodeList;
import com.google.gwt.dom.client.Style;
import com.google.gwt.dom.client.UListElement;
import com.google.gwt.event.dom.client.ContextMenuEvent;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwtmockito.GwtMockitoTestRunner;
import com.google.web.bindery.event.shared.Event;
import org.drools.workbench.screens.scenariosimulation.client.editor.menu.BaseMenu;
import org.drools.workbench.screens.scenariosimulation.client.editor.menu.BaseMenuView;
import org.drools.workbench.screens.scenariosimulation.client.editor.menu.ExecutableMenuItemPresenter;
import org.drools.workbench.screens.scenariosimulation.client.editor.menu.MenuItemPresenter;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=GwtMockitoTestRunner.class)
public class BaseMenuTest {
    @Mock
    private RootPanel rootPanelMock;
    @Mock
    private MenuItemPresenter menuItemPresenterMock;
    @Mock
    private ExecutableMenuItemPresenter executableMenuItemPresenterMock;
    @Mock
    private BaseMenuView viewMock;
    @Mock
    private UListElement contextMenuDropdownMock;
    @Mock
    private Style styleMock;
    private BaseMenu baseMenu;

    @Before
    public void setup() {
        Mockito.when((Object)this.contextMenuDropdownMock.getStyle()).thenReturn((Object)this.styleMock);
        Mockito.when((Object)this.viewMock.getContextMenuDropdown()).thenReturn((Object)this.contextMenuDropdownMock);
        this.baseMenu = (BaseMenu)Mockito.spy((Object)new BaseMenu(){
            {
                this.view = BaseMenuTest.this.viewMock;
                this.menuItemPresenter = BaseMenuTest.this.menuItemPresenterMock;
                this.executableMenuItemPresenter = BaseMenuTest.this.executableMenuItemPresenterMock;
            }

            protected RootPanel getRootPanel() {
                return BaseMenuTest.this.rootPanelMock;
            }
        });
    }

    @Test
    public void initialise() {
        this.baseMenu.initialise();
        ((BaseMenuView)Mockito.verify((Object)this.viewMock, (VerificationMode)Mockito.times((int)1))).init((Object)this.baseMenu);
    }

    @Test
    public void addMenuItem() {
        String id = "TEST-ID";
        String label = "TEST-LABEL";
        String i18n = "TEST-i18n";
        this.baseMenu.addMenuItem(id, label, i18n);
        ((UListElement)Mockito.verify((Object)this.contextMenuDropdownMock, (VerificationMode)Mockito.times((int)1))).appendChild((Node)this.menuItemPresenterMock.getLabelMenuElement(id, label));
    }

    @Test
    public void addExecutableMenuItemWithEvent() {
        Event mockEvent = (Event)Mockito.mock(Event.class);
        String id = "TEST-ID";
        String label = "TEST-LABEL";
        String i18n = "TEST-i18n";
        this.baseMenu.addExecutableMenuItem(id, label, i18n, mockEvent);
        ((UListElement)Mockito.verify((Object)this.contextMenuDropdownMock, (VerificationMode)Mockito.times((int)1))).appendChild((Node)this.executableMenuItemPresenterMock.getLExecutableMenuElement(id, label, mockEvent));
    }

    @Test
    public void addExecutableMenuItemWithoutEvent() {
        String id = "TEST-ID";
        String label = "TEST-LABEL";
        String i18n = "TEST-i18n";
        this.baseMenu.addExecutableMenuItem(id, label, i18n);
        ((UListElement)Mockito.verify((Object)this.contextMenuDropdownMock, (VerificationMode)Mockito.times((int)1))).appendChild((Node)this.executableMenuItemPresenterMock.getLExecutableMenuElement(id, label));
    }

    @Test
    public void removeMenuItem() {
        LIElement toRemoveMock = (LIElement)Mockito.mock(LIElement.class);
        this.baseMenu.removeMenuItem(toRemoveMock);
        ((UListElement)Mockito.verify((Object)this.contextMenuDropdownMock, (VerificationMode)Mockito.times((int)1))).removeChild((Node)Matchers.eq((Object)toRemoveMock));
    }

    @Test
    public void mapEvent() {
        LIElement executableMenuItemMock = (LIElement)Mockito.mock(LIElement.class);
        Event toBeMappedMock = (Event)Mockito.mock(Event.class);
        this.baseMenu.mapEvent(executableMenuItemMock, toBeMappedMock);
        ((ExecutableMenuItemPresenter)Mockito.verify((Object)this.executableMenuItemPresenterMock, (VerificationMode)Mockito.times((int)1))).mapEvent((LIElement)Matchers.eq((Object)executableMenuItemMock), (Event)Matchers.eq((Object)toBeMappedMock));
    }

    @Test
    public void asWidget() {
        this.baseMenu.asWidget();
        ((BaseMenuView)Mockito.verify((Object)this.viewMock, (VerificationMode)Mockito.times((int)1))).asWidget();
    }

    @Test
    public void show() {
        int x = 10;
        int y = 20;
        this.baseMenu.show(x, y);
        ((BaseMenu)Mockito.verify((Object)this.baseMenu, (VerificationMode)Mockito.times((int)1))).hide();
        ((Style)Mockito.verify((Object)this.styleMock, (VerificationMode)Mockito.times((int)1))).setLeft((double)x, Style.Unit.PX);
        ((Style)Mockito.verify((Object)this.styleMock, (VerificationMode)Mockito.times((int)1))).setTop((double)y, Style.Unit.PX);
        ((Style)Mockito.verify((Object)this.styleMock, (VerificationMode)Mockito.times((int)1))).setDisplay(Style.Display.BLOCK);
    }

    @Test
    public void hide() {
        Mockito.when((Object)this.rootPanelMock.getWidgetIndex((IsWidget)this.viewMock)).thenReturn((Object)1);
        this.baseMenu.hide();
        ((BaseMenu)Mockito.verify((Object)this.baseMenu, (VerificationMode)Mockito.times((int)1))).isShown();
        ((Style)Mockito.verify((Object)this.styleMock, (VerificationMode)Mockito.times((int)1))).setDisplay(Style.Display.NONE);
        Mockito.when((Object)this.rootPanelMock.getWidgetIndex((IsWidget)this.viewMock)).thenReturn((Object)-1);
        Mockito.reset((Object[])new BaseMenu[]{this.baseMenu});
        Mockito.reset((Object[])new Style[]{this.styleMock});
        this.baseMenu.hide();
        ((BaseMenu)Mockito.verify((Object)this.baseMenu, (VerificationMode)Mockito.times((int)1))).isShown();
        ((Style)Mockito.verify((Object)this.styleMock, (VerificationMode)Mockito.times((int)0))).setDisplay(Style.Display.NONE);
    }

    @Test
    public void getView() {
        BaseMenuView retrieved = this.baseMenu.getView();
        Assert.assertNotNull((Object)retrieved);
    }

    @Test
    public void isShown() {
        Mockito.when((Object)this.rootPanelMock.getWidgetIndex((IsWidget)this.viewMock)).thenReturn((Object)1);
        Assert.assertTrue((boolean)this.baseMenu.isShown());
        Mockito.when((Object)this.rootPanelMock.getWidgetIndex((IsWidget)this.viewMock)).thenReturn((Object)-1);
        Assert.assertFalse((boolean)this.baseMenu.isShown());
    }

    @Test
    public void onContextMenuEvent() {
        ContextMenuEvent mockEvent = (ContextMenuEvent)Mockito.mock(ContextMenuEvent.class);
        this.baseMenu.onContextMenuEvent(mockEvent);
        ((ContextMenuEvent)Mockito.verify((Object)mockEvent, (VerificationMode)Mockito.times((int)1))).preventDefault();
        ((ContextMenuEvent)Mockito.verify((Object)mockEvent, (VerificationMode)Mockito.times((int)1))).stopPropagation();
        ((BaseMenu)Mockito.verify((Object)this.baseMenu, (VerificationMode)Mockito.times((int)1))).hide();
    }

    @Test
    public void enableElement() {
        Element mockElement = (Element)Mockito.mock(Element.class);
        this.baseMenu.enableElement(mockElement, true);
        ((Element)Mockito.verify((Object)mockElement, (VerificationMode)Mockito.times((int)1))).removeClassName("disabled");
        Mockito.reset((Object[])new Element[]{mockElement});
        this.baseMenu.enableElement(mockElement, false);
        ((Element)Mockito.verify((Object)mockElement, (VerificationMode)Mockito.times((int)1))).addClassName("disabled");
    }

    @Test
    public void isDisabled() {
        Element elementMock = (Element)Mockito.mock(Element.class);
        Mockito.when((Object)elementMock.getClassName()).thenReturn((Object)"disabled");
        Assert.assertTrue((boolean)this.baseMenu.isDisabled(elementMock));
        Mockito.when((Object)elementMock.getClassName()).thenReturn((Object)"dropdown-menu");
        Assert.assertFalse((boolean)this.baseMenu.isDisabled(elementMock));
    }

    @Test
    public void updateExecutableMenuItemAttributes() {
        LIElement toUpdateMock = (LIElement)Mockito.mock(LIElement.class);
        NodeList elementsByTagNameMock = (NodeList)Mockito.mock(NodeList.class);
        Element itemMock = (Element)Mockito.mock(Element.class);
        Mockito.when((Object)((Element)elementsByTagNameMock.getItem(0))).thenReturn((Object)itemMock);
        Mockito.when((Object)toUpdateMock.getElementsByTagName("span")).thenReturn((Object)elementsByTagNameMock);
        String id = "TEST-ID";
        String label = "TEST-LABEL";
        String i18n = "TEST-i18n";
        this.baseMenu.updateExecutableMenuItemAttributes(toUpdateMock, id, label, i18n);
        ((LIElement)Mockito.verify((Object)toUpdateMock, (VerificationMode)Mockito.times((int)1))).setId((String)Matchers.eq((Object)id));
        ((Element)Mockito.verify((Object)itemMock, (VerificationMode)Mockito.times((int)1))).setInnerHTML((String)Matchers.eq((Object)label));
    }

    @Test
    public void updateMenuItemAttributes() {
        LIElement toUpdateMock = (LIElement)Mockito.mock(LIElement.class);
        NodeList elementsByTagNameMock = (NodeList)Mockito.mock(NodeList.class);
        Element itemMock = (Element)Mockito.mock(Element.class);
        Mockito.when((Object)((Element)elementsByTagNameMock.getItem(0))).thenReturn((Object)itemMock);
        Mockito.when((Object)toUpdateMock.getElementsByTagName("span")).thenReturn((Object)elementsByTagNameMock);
        String id = "TEST-ID";
        String label = "TEST-LABEL";
        String i18n = "TEST-i18n";
        String boldLabel = "<b>" + label + "</b>";
        this.baseMenu.updateMenuItemAttributes(toUpdateMock, id, label, i18n);
        ((LIElement)Mockito.verify((Object)toUpdateMock, (VerificationMode)Mockito.times((int)1))).setId((String)Matchers.eq((Object)id));
        ((Element)Mockito.verify((Object)itemMock, (VerificationMode)Mockito.times((int)1))).setInnerHTML((String)Matchers.eq((Object)boldLabel));
    }
}

