/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.commands;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Optional;
import org.drools.scenariosimulation.api.model.AbstractScesimModel;
import org.drools.scenariosimulation.api.model.ScenarioSimulationModel;
import org.drools.workbench.screens.scenariosimulation.client.AbstractScenarioSimulationTest;
import org.drools.workbench.screens.scenariosimulation.client.editor.ScenarioSimulationEditorPresenter;
import org.drools.workbench.screens.scenariosimulation.client.enums.GridWidget;
import org.drools.workbench.screens.scenariosimulation.client.models.AbstractScesimGridModel;
import org.drools.workbench.screens.scenariosimulation.client.widgets.ScenarioGridPanel;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=GwtMockitoTestRunner.class)
public class ScenarioSimulationContextTest
extends AbstractScenarioSimulationTest {
    @Override
    @Before
    public void setup() {
        super.setup();
    }

    @Test
    public void getSelectedScenarioGridPanelSIMULATION() {
        Mockito.when((Object)this.backgroundGridWidgetSpy.isSelected()).thenReturn((Object)false);
        Mockito.when((Object)this.scenarioGridWidgetSpy.isSelected()).thenReturn((Object)true);
        Assert.assertEquals(Optional.of(this.scenarioGridPanelMock), (Object)this.scenarioSimulationContextLocal.getSelectedScenarioGridPanel());
    }

    @Test
    public void getSelectedScenarioGridPanelBACKGROUND() {
        Mockito.when((Object)this.backgroundGridWidgetSpy.isSelected()).thenReturn((Object)true);
        Mockito.when((Object)this.scenarioGridWidgetSpy.isSelected()).thenReturn((Object)false);
        Assert.assertEquals(Optional.of(this.backgroundGridPanelMock), (Object)this.scenarioSimulationContextLocal.getSelectedScenarioGridPanel());
    }

    @Test
    public void getSelectedScenarioGridPanelNone() {
        Mockito.when((Object)this.backgroundGridWidgetSpy.isSelected()).thenReturn((Object)false);
        Mockito.when((Object)this.scenarioGridWidgetSpy.isSelected()).thenReturn((Object)false);
        Assert.assertEquals(Optional.empty(), (Object)this.scenarioSimulationContextLocal.getSelectedScenarioGridPanel());
    }

    @Test
    public void getSelectedScenarioGridWidgetSIMULATION() {
        Mockito.when((Object)this.backgroundGridWidgetSpy.isSelected()).thenReturn((Object)false);
        Mockito.when((Object)this.scenarioGridWidgetSpy.isSelected()).thenReturn((Object)true);
        Assert.assertEquals(Optional.of(this.scenarioGridWidgetSpy), (Object)this.scenarioSimulationContextLocal.getSelectedScenarioGridWidget());
    }

    @Test
    public void getSelectedScenarioGridWidgetBACKGROUND() {
        Mockito.when((Object)this.backgroundGridWidgetSpy.isSelected()).thenReturn((Object)true);
        Mockito.when((Object)this.scenarioGridWidgetSpy.isSelected()).thenReturn((Object)false);
        Assert.assertEquals(Optional.of(this.backgroundGridWidgetSpy), (Object)this.scenarioSimulationContextLocal.getSelectedScenarioGridWidget());
    }

    @Test
    public void getSelectedScenarioGridWidgetNone() {
        Mockito.when((Object)this.backgroundGridWidgetSpy.isSelected()).thenReturn((Object)false);
        Mockito.when((Object)this.scenarioGridWidgetSpy.isSelected()).thenReturn((Object)false);
        Assert.assertEquals(Optional.empty(), (Object)this.scenarioSimulationContextLocal.getSelectedScenarioGridWidget());
    }

    @Test(expected=IllegalStateException.class)
    public void getSelectedScenarioGridWidgetFail() {
        Mockito.when((Object)this.backgroundGridWidgetSpy.isSelected()).thenReturn((Object)true);
        Mockito.when((Object)this.scenarioGridWidgetSpy.isSelected()).thenReturn((Object)true);
        this.scenarioSimulationContextLocal.getSelectedScenarioGridWidget();
    }

    @Test
    public void getSelectedScenarioGridModelSIMULATION() {
        Mockito.when((Object)this.backgroundGridWidgetSpy.isSelected()).thenReturn((Object)false);
        Mockito.when((Object)this.scenarioGridWidgetSpy.isSelected()).thenReturn((Object)true);
        Assert.assertEquals(Optional.of(this.scenarioGridModelMock), (Object)this.scenarioSimulationContextLocal.getSelectedScenarioGridModel());
    }

    @Test
    public void getSelectedScenarioGridModelBACKGROUND() {
        Mockito.when((Object)this.backgroundGridWidgetSpy.isSelected()).thenReturn((Object)true);
        Mockito.when((Object)this.scenarioGridWidgetSpy.isSelected()).thenReturn((Object)false);
        Assert.assertEquals(Optional.of(this.backgroundGridModelMock), (Object)this.scenarioSimulationContextLocal.getSelectedScenarioGridModel());
    }

    @Test
    public void getSelectedScenarioGridModelNone() {
        Mockito.when((Object)this.backgroundGridWidgetSpy.isSelected()).thenReturn((Object)false);
        Mockito.when((Object)this.scenarioGridWidgetSpy.isSelected()).thenReturn((Object)false);
        Assert.assertEquals(Optional.empty(), (Object)this.scenarioSimulationContextLocal.getSelectedScenarioGridModel());
    }

    @Test
    public void getSelectedScenarioGridLayerSIMULATION() {
        Mockito.when((Object)this.backgroundGridWidgetSpy.isSelected()).thenReturn((Object)false);
        Mockito.when((Object)this.scenarioGridWidgetSpy.isSelected()).thenReturn((Object)true);
        Assert.assertEquals(Optional.of(this.scenarioGridLayerMock), (Object)this.scenarioSimulationContextLocal.getSelectedScenarioGridLayer());
    }

    @Test
    public void getSelectedScenarioGridLayerBACKGROUND() {
        Mockito.when((Object)this.backgroundGridWidgetSpy.isSelected()).thenReturn((Object)true);
        Mockito.when((Object)this.scenarioGridWidgetSpy.isSelected()).thenReturn((Object)false);
        Assert.assertEquals(Optional.of(this.backgroundGridLayerMock), (Object)this.scenarioSimulationContextLocal.getSelectedScenarioGridLayer());
    }

    @Test
    public void getSelectedScenarioGridLayerNone() {
        Mockito.when((Object)this.backgroundGridWidgetSpy.isSelected()).thenReturn((Object)false);
        Mockito.when((Object)this.scenarioGridWidgetSpy.isSelected()).thenReturn((Object)false);
        Assert.assertEquals(Optional.empty(), (Object)this.scenarioSimulationContextLocal.getSelectedScenarioGridLayer());
    }

    @Test
    public void getScenarioGridPanelByGridWidget() {
        Assert.assertEquals((Object)this.scenarioGridPanelMock, (Object)this.scenarioSimulationContextLocal.getScenarioGridPanelByGridWidget(GridWidget.SIMULATION));
        Assert.assertEquals((Object)this.backgroundGridPanelMock, (Object)this.scenarioSimulationContextLocal.getScenarioGridPanelByGridWidget(GridWidget.BACKGROUND));
    }

    @Test
    public void getScenarioGridPanelByGridWidgetCheckSwitch() {
        for (GridWidget gridWidget : GridWidget.values()) {
            ScenarioGridPanel gridPanel = this.scenarioSimulationContextLocal.getScenarioGridPanelByGridWidget(gridWidget);
            if (GridWidget.BACKGROUND.equals((Object)gridWidget)) {
                Assert.assertEquals((Object)this.backgroundGridPanelMock, (Object)gridPanel);
                continue;
            }
            Assert.assertEquals((Object)this.scenarioGridPanelMock, (Object)gridPanel);
        }
    }

    @Test
    public void getAbstractScesimGridModelByGridWidget() {
        Assert.assertEquals((Object)this.scenarioGridModelMock, (Object)this.scenarioSimulationContextLocal.getAbstractScesimGridModelByGridWidget(GridWidget.SIMULATION));
        Assert.assertEquals((Object)this.backgroundGridModelMock, (Object)this.scenarioSimulationContextLocal.getAbstractScesimGridModelByGridWidget(GridWidget.BACKGROUND));
    }

    @Test
    public void getAbstractScesimGridModelByGridWidgetCheckSwitch() {
        for (GridWidget gridWidget : GridWidget.values()) {
            AbstractScesimGridModel model = this.scenarioSimulationContextLocal.getAbstractScesimGridModelByGridWidget(gridWidget);
            if (GridWidget.BACKGROUND.equals((Object)gridWidget)) {
                Assert.assertEquals((Object)this.backgroundGridModelMock, (Object)model);
                continue;
            }
            Assert.assertEquals((Object)this.scenarioGridModelMock, (Object)model);
        }
    }

    @Test
    public void getAbstractScesimModelByGridWidget() {
        Assert.assertEquals((Object)this.scenarioSimulationContextLocal.status.simulation, (Object)this.scenarioSimulationContextLocal.getAbstractScesimModelByGridWidget(GridWidget.SIMULATION));
        Assert.assertEquals((Object)this.scenarioSimulationContextLocal.status.background, (Object)this.scenarioSimulationContextLocal.getAbstractScesimModelByGridWidget(GridWidget.BACKGROUND));
    }

    @Test
    public void getAbstractScesimModelByGridWidgetCheckSwitch() {
        for (GridWidget gridWidget : GridWidget.values()) {
            AbstractScesimModel abstractScesimData = this.scenarioSimulationContextLocal.getAbstractScesimModelByGridWidget(gridWidget);
            if (GridWidget.BACKGROUND.equals((Object)gridWidget)) {
                Assert.assertEquals((Object)this.backgroundMock, (Object)abstractScesimData);
                continue;
            }
            Assert.assertEquals((Object)this.simulationMock, (Object)abstractScesimData);
        }
    }

    @Test
    public void getScenarioSimulationModel() {
        ScenarioSimulationModel model = this.scenarioSimulationContextLocal.getScenarioSimulationModel();
        Assert.assertSame((Object)this.scenarioSimulationModelMock, (Object)model);
    }

    @Test
    public void getCollectionEditorSingletonDOMElementFactory() {
        Assert.assertEquals((Object)this.collectionEditorSingletonDOMElementFactoryTest, (Object)this.scenarioSimulationContextLocal.getCollectionEditorSingletonDOMElementFactory(GridWidget.SIMULATION));
    }

    @Test
    public void getScenarioCellTextAreaSingletonDOMElementFactory() {
        Assert.assertEquals((Object)this.scenarioCellTextAreaSingletonDOMElementFactorySpy, (Object)this.scenarioSimulationContextLocal.getScenarioCellTextAreaSingletonDOMElementFactory(GridWidget.SIMULATION));
    }

    @Test
    public void getScenarioHeaderTextBoxSingletonDOMElementFactory() {
        Assert.assertEquals((Object)this.scenarioHeaderTextBoxSingletonDOMElementFactorySpy, (Object)this.scenarioSimulationContextLocal.getScenarioHeaderTextBoxSingletonDOMElementFactory(GridWidget.SIMULATION));
    }

    @Test
    public void getScenarioExpressionCellTextAreaSingletonDOMElementFactory() {
        Assert.assertEquals((Object)this.scenarioExpressionCellTextAreaSingletonDOMElementFactorySpy, (Object)this.scenarioSimulationContextLocal.getScenarioExpressionCellTextAreaSingletonDOMElementFactory(GridWidget.SIMULATION));
    }

    @Test
    public void setUndoButtonEnabledStatus() {
        this.scenarioSimulationContextLocal.setUndoButtonEnabledStatus(true);
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.scenarioSimulationEditorPresenterMock, (VerificationMode)Mockito.times((int)1))).setUndoButtonEnabledStatus(Matchers.eq((boolean)true));
    }

    @Test
    public void setRedoButtonEnabledStatus() {
        this.scenarioSimulationContextLocal.setRedoButtonEnabledStatus(true);
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.scenarioSimulationEditorPresenterMock, (VerificationMode)Mockito.times((int)1))).setRedoButtonEnabledStatus(Matchers.eq((boolean)true));
    }

    @Test
    public void getStatusFullPackage() {
        this.scenarioSimulationContextLocal.getStatus().setFullPackage(null);
        Assert.assertEquals((Object)"", (Object)this.scenarioSimulationContextLocal.getStatus().getFullPackage());
        this.scenarioSimulationContextLocal.getStatus().setFullPackage("test.scesim");
        Assert.assertEquals((Object)"test.scesim", (Object)this.scenarioSimulationContextLocal.getStatus().getFullPackage());
    }
}

