/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.models;

import com.ait.lienzo.test.LienzoMockitoTestRunner;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.GwtEvent;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import org.drools.scenariosimulation.api.model.AbstractScesimData;
import org.drools.scenariosimulation.api.model.ExpressionElement;
import org.drools.scenariosimulation.api.model.ExpressionIdentifier;
import org.drools.scenariosimulation.api.model.FactIdentifier;
import org.drools.scenariosimulation.api.model.FactMapping;
import org.drools.scenariosimulation.api.model.FactMappingValue;
import org.drools.scenariosimulation.api.model.FactMappingValueStatus;
import org.drools.scenariosimulation.api.model.FactMappingValueType;
import org.drools.scenariosimulation.api.model.Scenario;
import org.drools.scenariosimulation.api.model.ScenarioSimulationModel;
import org.drools.scenariosimulation.api.model.ScesimModelDescriptor;
import org.drools.scenariosimulation.api.model.Simulation;
import org.drools.workbench.screens.scenariosimulation.client.AbstractScenarioSimulationTest;
import org.drools.workbench.screens.scenariosimulation.client.TestProperties;
import org.drools.workbench.screens.scenariosimulation.client.enums.GridWidget;
import org.drools.workbench.screens.scenariosimulation.client.events.ReloadTestToolsEvent;
import org.drools.workbench.screens.scenariosimulation.client.factories.ScenarioCellTextAreaSingletonDOMElementFactory;
import org.drools.workbench.screens.scenariosimulation.client.factories.ScenarioExpressionCellTextAreaSingletonDOMElementFactory;
import org.drools.workbench.screens.scenariosimulation.client.factories.ScenarioHeaderTextBoxSingletonDOMElementFactory;
import org.drools.workbench.screens.scenariosimulation.client.metadata.ScenarioHeaderMetaData;
import org.drools.workbench.screens.scenariosimulation.client.models.AbstractScesimGridModel;
import org.drools.workbench.screens.scenariosimulation.client.models.ScenarioGridModel;
import org.drools.workbench.screens.scenariosimulation.client.values.ScenarioGridCellValue;
import org.drools.workbench.screens.scenariosimulation.client.widgets.ScenarioGridCell;
import org.drools.workbench.screens.scenariosimulation.client.widgets.ScenarioGridColumn;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.wires.core.grids.client.model.GridCell;
import org.uberfire.ext.wires.core.grids.client.model.GridCellValue;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.model.GridRow;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridRow;
import org.uberfire.ext.wires.core.grids.client.widget.dom.single.impl.BaseSingletonDOMElementFactory;

@RunWith(value=LienzoMockitoTestRunner.class)
public class AbstractScesimGridModelTest
extends AbstractScenarioSimulationTest {
    private AbstractScesimGridModel abstractScesimGridModelSpy;
    @Mock
    private ScenarioGridColumn scenarioIndexGridColumnMock;
    @Mock
    private BaseGridRow gridRowMock;
    @Mock
    private ScenarioHeaderMetaData groupHeaderMetaDataMock;
    @Mock
    private ScenarioHeaderMetaData indexHeaderMetaDataMock;
    @Mock
    private ScenarioGridCell gridCellMock;
    @Mock
    private ScenarioGridCellValue gridCellValueMock;
    @Mock
    private Scenario scenarioMock;
    private Supplier<GridCell<?>> gridCellSupplier;

    @Override
    @Before
    public void setup() {
        super.setup();
        TestProperties.HEADER_META_DATA.add((GridColumn.HeaderMetaData)this.groupHeaderMetaDataMock);
        TestProperties.HEADER_META_DATA.add((GridColumn.HeaderMetaData)this.informationHeaderMetaDataMock);
        TestProperties.HEADER_META_DATA.add((GridColumn.HeaderMetaData)this.propertyHeaderMetaDataMock);
        ((ScenarioGridCell)Mockito.doReturn((Object)this.gridCellValueMock).when((Object)this.gridCellMock)).getValue();
        Mockito.when((Object)this.informationHeaderMetaDataMock.getMetadataType()).thenReturn((Object)ScenarioHeaderMetaData.MetadataType.INSTANCE);
        Mockito.when((Object)this.informationHeaderMetaDataMock.getTitle()).thenReturn((Object)"GRID_COLUMN_TITLE");
        Mockito.when((Object)this.informationHeaderMetaDataMock.getColumnGroup()).thenReturn((Object)"GIVEN");
        Mockito.when((Object)this.informationHeaderMetaDataMock.getColumnId()).thenReturn((Object)"GRID_COLUMN_ID");
        Mockito.when((Object)this.indexHeaderMetaDataMock.getTitle()).thenReturn((Object)ExpressionIdentifier.INDEX.getName());
        Mockito.when((Object)this.scenarioIndexGridColumnMock.getInformationHeaderMetaData()).thenReturn((Object)this.indexHeaderMetaDataMock);
        Mockito.when((Object)this.gridColumnMock.getHeaderMetaData()).thenReturn(TestProperties.HEADER_META_DATA);
        Mockito.when((Object)this.gridCellMock.getValue()).thenReturn((Object)this.gridCellValueMock);
        Mockito.when((Object)((String)this.gridCellValueMock.getValue())).thenReturn((Object)"GRID_CELL_TEXT");
        Mockito.when((Object)this.scenarioMock.getUnmodifiableFactMappingValues()).thenReturn((Object)this.factMappingValuesLocal);
        TestProperties.GRID_ROWS.clear();
        IntStream.range(0, 3).forEach(rowIndex -> {
            Mockito.when((Object)this.simulationMock.addData(rowIndex)).thenReturn((Object)this.scenarioMock);
            Mockito.when((Object)((Scenario)this.simulationMock.getDataByIndex(rowIndex))).thenReturn((Object)this.scenarioMock);
            Mockito.when((Object)((Scenario)this.simulationMock.cloneData(rowIndex, rowIndex + 1))).thenReturn((Object)this.scenarioMock);
            TestProperties.GRID_ROWS.add((GridRow)this.gridRowMock);
        });
        Mockito.when((Object)this.simulationMock.addData(3)).thenReturn((Object)this.scenarioMock);
        Mockito.when((Object)((Scenario)this.simulationMock.getDataByIndex(3))).thenReturn((Object)this.scenarioMock);
        Mockito.when((Object)((Scenario)this.simulationMock.cloneData(3, 4))).thenReturn((Object)this.scenarioMock);
        Mockito.when((Object)this.scenarioMock.getFactMappingValue((FactIdentifier)ArgumentMatchers.any(), (ExpressionIdentifier)ArgumentMatchers.any())).thenReturn(Optional.of(this.factMappingValueMock));
        Mockito.when((Object)this.scenarioMock.getFactMappingValue((FactMapping)ArgumentMatchers.isA(FactMapping.class))).thenReturn(Optional.of(this.factMappingValueMock));
        Mockito.when((Object)this.factMappingValueMock.getStatus()).thenReturn((Object)FactMappingValueStatus.FAILED_WITH_ERROR);
        this.gridCellSupplier = () -> this.gridCellMock;
        this.abstractScesimGridModelSpy = (AbstractScesimGridModel)Mockito.spy((Object)new AbstractScesimGridModel(false){
            {
                this.abstractScesimModel = AbstractScesimGridModelTest.this.simulationMock;
                this.eventBus = AbstractScesimGridModelTest.this.eventBusMock;
                this.rows = TestProperties.GRID_ROWS;
                this.columns = AbstractScesimGridModelTest.this.gridColumns;
                this.scenarioExpressionCellTextAreaSingletonDOMElementFactory = AbstractScesimGridModelTest.this.scenarioExpressionCellTextAreaSingletonDOMElementFactorySpy;
                this.collectionEditorSingletonDOMElementFactory = AbstractScesimGridModelTest.this.collectionEditorSingletonDOMElementFactoryTest;
                this.scenarioCellTextAreaSingletonDOMElementFactory = AbstractScesimGridModelTest.this.scenarioCellTextAreaSingletonDOMElementFactorySpy;
                this.scenarioHeaderTextBoxSingletonDOMElementFactory = AbstractScesimGridModelTest.this.scenarioHeaderTextBoxSingletonDOMElementFactorySpy;
            }

            public void insertRowGridOnly(int rowIndex, GridRow row, AbstractScesimData abstractScesimData) {
            }

            public void deleteColumn(GridColumn<?> column) {
            }

            public GridCell<?> getCell(int rowIndex, int columnIndex) {
                if (rowIndex < 0 || rowIndex > this.rows.size() - 1) {
                    return null;
                }
                return AbstractScesimGridModelTest.this.gridCellMock;
            }

            public GridWidget getGridWidget() {
                return GridWidget.SIMULATION;
            }

            protected void commonAddRow(int rowIndex) {
            }

            public GridData.Range getInstanceLimits(int columnIndex) {
                return new GridData.Range(0, 0);
            }
        });
    }

    @Test
    public void bindContent() {
        Assert.assertTrue((boolean)this.abstractScesimGridModelSpy.getAbstractScesimModel().isPresent());
    }

    @Test
    public void setEventBus() {
        this.abstractScesimGridModelSpy.setEventBus(this.eventBusMock);
        Assert.assertEquals((Object)this.eventBusMock, (Object)this.abstractScesimGridModelSpy.eventBus);
    }

    @Test
    public void getValidPlaceholders() {
        ((AbstractScesimGridModel)Mockito.doReturn((Object)false).when((Object)this.abstractScesimGridModelSpy)).isSameInstanceType((String)ArgumentMatchers.eq((Object)FactMapping.getInstancePlaceHolder((int)0)));
        ((AbstractScesimGridModel)Mockito.doReturn((Object)false).when((Object)this.abstractScesimGridModelSpy)).isSameInstanceType((String)ArgumentMatchers.eq((Object)FactMapping.getInstancePlaceHolder((int)1)));
        ((AbstractScesimGridModel)Mockito.doReturn((Object)true).when((Object)this.abstractScesimGridModelSpy)).isSameInstanceType((String)ArgumentMatchers.eq((Object)FactMapping.getInstancePlaceHolder((int)2)));
        ((AbstractScesimGridModel)Mockito.doReturn((Object)false).when((Object)this.abstractScesimGridModelSpy)).isNewPropertyName((String)ArgumentMatchers.eq((Object)FactMapping.getPropertyPlaceHolder((int)0)));
        ((AbstractScesimGridModel)Mockito.doReturn((Object)false).when((Object)this.abstractScesimGridModelSpy)).isNewPropertyName((String)ArgumentMatchers.eq((Object)FactMapping.getPropertyPlaceHolder((int)1)));
        ((AbstractScesimGridModel)Mockito.doReturn((Object)false).when((Object)this.abstractScesimGridModelSpy)).isNewPropertyName((String)ArgumentMatchers.eq((Object)FactMapping.getPropertyPlaceHolder((int)2)));
        Map.Entry retrieved = this.abstractScesimGridModelSpy.getValidPlaceholders();
        Assert.assertNotNull((Object)retrieved);
        Assert.assertEquals((Object)FactMapping.getInstancePlaceHolder((int)3), retrieved.getKey());
        Assert.assertEquals((Object)FactMapping.getPropertyPlaceHolder((int)3), retrieved.getValue());
    }

    @Test
    public void appendRow() {
        this.abstractScesimGridModelSpy.appendRow((GridRow)this.gridRowMock);
        ((AbstractScesimGridModel)Mockito.verify((Object)this.abstractScesimGridModelSpy, (VerificationMode)Mockito.atLeast((int)1))).checkSimulation();
        ((AbstractScesimGridModel)Mockito.verify((Object)this.abstractScesimGridModelSpy, (VerificationMode)Mockito.times((int)1))).commonAddRow(ArgumentMatchers.eq((int)3));
    }

    @Test
    public void insertRow() {
        this.abstractScesimGridModelSpy.insertRow(2, (GridRow)this.gridRowMock);
        ((AbstractScesimGridModel)Mockito.verify((Object)this.abstractScesimGridModelSpy, (VerificationMode)Mockito.atLeast((int)1))).checkSimulation();
        ((AbstractScesimGridModel)Mockito.verify((Object)this.abstractScesimGridModelSpy, (VerificationMode)Mockito.times((int)1))).commonAddRow(ArgumentMatchers.eq((int)2));
    }

    @Test
    public void deleteRow() {
        this.abstractScesimGridModelSpy.deleteRow(2);
        ((AbstractScesimGridModel)Mockito.verify((Object)this.abstractScesimGridModelSpy, (VerificationMode)Mockito.atLeast((int)1))).checkSimulation();
        ((Simulation)Mockito.verify((Object)this.simulationMock, (VerificationMode)Mockito.times((int)1))).removeDataByIndex(ArgumentMatchers.eq((int)2));
        ((AbstractScesimGridModel)Mockito.verify((Object)this.abstractScesimGridModelSpy, (VerificationMode)Mockito.times((int)1))).updateIndexColumn();
    }

    @Test
    public void duplicateRow() {
        this.abstractScesimGridModelSpy.duplicateRow(2, (GridRow)this.gridRowMock);
        ((AbstractScesimGridModel)Mockito.verify((Object)this.abstractScesimGridModelSpy, (VerificationMode)Mockito.atLeast((int)1))).checkSimulation();
        ((Simulation)Mockito.verify((Object)this.simulationMock, (VerificationMode)Mockito.times((int)1))).cloneData(ArgumentMatchers.eq((int)2), ArgumentMatchers.eq((int)3));
        ((AbstractScesimGridModel)Mockito.verify((Object)this.abstractScesimGridModelSpy, (VerificationMode)Mockito.times((int)1))).insertRowGridOnly(ArgumentMatchers.eq((int)3), (GridRow)ArgumentMatchers.eq((Object)this.gridRowMock), (AbstractScesimData)ArgumentMatchers.isA(Scenario.class));
        ((AbstractScesimGridModel)Mockito.verify((Object)this.abstractScesimGridModelSpy, (VerificationMode)Mockito.never())).insertRow(ArgumentMatchers.eq((int)2), (GridRow)ArgumentMatchers.eq((Object)this.gridRowMock));
    }

    @Test
    public void duplicateColumnValues() {
        this.abstractScesimGridModelSpy.duplicateColumnValues(3, 2);
        ((AbstractScesimGridModel)Mockito.verify((Object)this.abstractScesimGridModelSpy, (VerificationMode)Mockito.times((int)this.abstractScesimGridModelSpy.getRowCount()))).getCell(ArgumentMatchers.anyInt(), ArgumentMatchers.eq((int)3));
        ((AbstractScesimGridModel)Mockito.verify((Object)this.abstractScesimGridModelSpy, (VerificationMode)Mockito.times((int)this.abstractScesimGridModelSpy.getRowCount()))).setCellValue(ArgumentMatchers.anyInt(), ArgumentMatchers.eq((int)2), (GridCellValue)ArgumentMatchers.any());
        Assert.assertTrue((boolean)IntStream.range(0, this.abstractScesimGridModelSpy.getRowCount()).allMatch(i -> this.abstractScesimGridModelSpy.getCell(i, 3).getValue().equals(this.abstractScesimGridModelSpy.getCell(i, 3).getValue())));
    }

    @Test
    public void insertColumnGridOnly() {
        this.abstractScesimGridModelSpy.insertColumnGridOnly(3, (GridColumn)this.gridColumnMock);
        ((AbstractScesimGridModel)Mockito.verify((Object)this.abstractScesimGridModelSpy, (VerificationMode)Mockito.times((int)1))).checkSimulation();
    }

    @Test
    public void insertColumn() {
        this.abstractScesimGridModelSpy.insertColumn(3, (GridColumn)this.gridColumnMock);
        ((AbstractScesimGridModel)Mockito.verify((Object)this.abstractScesimGridModelSpy, (VerificationMode)Mockito.times((int)1))).checkSimulation();
        ((AbstractScesimGridModel)Mockito.verify((Object)this.abstractScesimGridModelSpy, (VerificationMode)Mockito.times((int)1))).commonAddColumn(ArgumentMatchers.eq((int)3), (GridColumn)ArgumentMatchers.eq((Object)this.gridColumnMock));
    }

    @Test
    public void deleteColumn() {
        this.abstractScesimGridModelSpy.deleteColumn(3);
        ((AbstractScesimGridModel)Mockito.verify((Object)this.abstractScesimGridModelSpy, (VerificationMode)Mockito.times((int)1))).checkSimulation();
        ((AbstractScesimGridModel)Mockito.verify((Object)this.abstractScesimGridModelSpy, (VerificationMode)Mockito.times((int)1))).deleteColumn((GridColumn)ArgumentMatchers.eq((Object)this.gridColumnMock));
        ((Simulation)Mockito.verify((Object)this.simulationMock, (VerificationMode)Mockito.times((int)1))).removeFactMappingByIndex(ArgumentMatchers.eq((int)3));
    }

    @Test
    public void updateColumnTypeFalse() {
        this.abstractScesimGridModelSpy.updateColumnProperty(3, (GridColumn)this.gridColumnMock, TestProperties.MULTIPART_VALUE_ELEMENTS, TestProperties.VALUE_CLASS_NAME, false, FactMappingValueType.NOT_EXPRESSION, ScenarioSimulationModel.Type.RULE);
        ((AbstractScesimGridModel)Mockito.verify((Object)this.abstractScesimGridModelSpy, (VerificationMode)Mockito.times((int)2))).checkSimulation();
        ((FactMapping)Mockito.verify((Object)this.factMappingMock, (VerificationMode)Mockito.times((int)1))).setFactMappingValueType((FactMappingValueType)ArgumentMatchers.eq((Object)FactMappingValueType.NOT_EXPRESSION));
        ((AbstractScesimGridModel)Mockito.verify((Object)this.abstractScesimGridModelSpy, (VerificationMode)Mockito.times((int)1))).deleteColumn(ArgumentMatchers.eq((int)3));
        ((AbstractScesimGridModel)Mockito.verify((Object)this.abstractScesimGridModelSpy, (VerificationMode)Mockito.times((int)1))).commonAddColumn(ArgumentMatchers.eq((int)3), (GridColumn)ArgumentMatchers.eq((Object)this.gridColumnMock), (ExpressionIdentifier)ArgumentMatchers.isA(ExpressionIdentifier.class));
        ((AbstractScesimGridModel)Mockito.verify((Object)this.abstractScesimGridModelSpy, (VerificationMode)Mockito.never())).setCellValue(ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt(), (GridCellValue)ArgumentMatchers.any());
    }

    @Test
    public void updateColumnTypeTrue() {
        this.abstractScesimGridModelSpy.updateColumnProperty(3, (GridColumn)this.gridColumnMock, TestProperties.MULTIPART_VALUE_ELEMENTS, TestProperties.VALUE_CLASS_NAME, true, FactMappingValueType.NOT_EXPRESSION, ScenarioSimulationModel.Type.RULE);
        ((AbstractScesimGridModel)Mockito.verify((Object)this.abstractScesimGridModelSpy, (VerificationMode)Mockito.atLeast((int)2))).checkSimulation();
        ((AbstractScesimGridModel)Mockito.verify((Object)this.abstractScesimGridModelSpy, (VerificationMode)Mockito.atLeast((int)2))).getCell(ArgumentMatchers.anyInt(), ArgumentMatchers.eq((int)3));
        ((FactMapping)Mockito.verify((Object)this.factMappingMock, (VerificationMode)Mockito.times((int)1))).setFactMappingValueType((FactMappingValueType)ArgumentMatchers.eq((Object)FactMappingValueType.NOT_EXPRESSION));
        ((AbstractScesimGridModel)Mockito.verify((Object)this.abstractScesimGridModelSpy, (VerificationMode)Mockito.times((int)1))).deleteColumn(ArgumentMatchers.eq((int)3));
        ((AbstractScesimGridModel)Mockito.verify((Object)this.abstractScesimGridModelSpy, (VerificationMode)Mockito.times((int)1))).commonAddColumn(ArgumentMatchers.eq((int)3), (GridColumn)ArgumentMatchers.eq((Object)this.gridColumnMock), (ExpressionIdentifier)ArgumentMatchers.isA(ExpressionIdentifier.class));
        ((AbstractScesimGridModel)Mockito.verify((Object)this.abstractScesimGridModelSpy, (VerificationMode)Mockito.atLeast((int)2))).setCellValue(ArgumentMatchers.anyInt(), ArgumentMatchers.eq((int)3), (GridCellValue)ArgumentMatchers.isA(ScenarioGridCellValue.class));
    }

    @Test
    public void replaceColumnTest() {
        this.abstractScesimGridModelSpy.replaceColumn(2, (GridColumn)this.gridColumnMock);
        ((ScenarioGridColumn)Mockito.verify((Object)this.gridColumnMock, (VerificationMode)Mockito.times((int)4))).getWidth();
        ((ScenarioGridColumn)Mockito.verify((Object)this.gridColumnMock, (VerificationMode)Mockito.times((int)4))).setWidth(ArgumentMatchers.anyDouble());
        ((AbstractScesimGridModel)Mockito.verify((Object)this.abstractScesimGridModelSpy, (VerificationMode)Mockito.times((int)1))).deleteColumn(ArgumentMatchers.eq((int)2));
        ((AbstractScesimGridModel)Mockito.verify((Object)this.abstractScesimGridModelSpy, (VerificationMode)Mockito.times((int)1))).commonAddColumn(ArgumentMatchers.eq((int)2), (GridColumn)ArgumentMatchers.eq((Object)this.gridColumnMock), (ExpressionIdentifier)ArgumentMatchers.isA(ExpressionIdentifier.class));
    }

    @Test
    public void setCellGridOnly() {
        this.abstractScesimGridModelSpy.setCellGridOnly(2, 3, this.gridCellSupplier);
        ((AbstractScesimGridModel)Mockito.verify((Object)this.abstractScesimGridModelSpy, (VerificationMode)Mockito.times((int)1))).checkSimulation();
    }

    @Test
    public void setCell() {
        this.abstractScesimGridModelSpy.setCell(2, 3, this.gridCellSupplier);
        ((AbstractScesimGridModel)Mockito.verify((Object)this.abstractScesimGridModelSpy, (VerificationMode)Mockito.times((int)1))).setCell(ArgumentMatchers.eq((int)2), ArgumentMatchers.eq((int)3), (Supplier)ArgumentMatchers.eq(this.gridCellSupplier));
    }

    @Test
    public void setSelectedColumn() {
        this.abstractScesimGridModelSpy.selectColumn(3);
        Assert.assertEquals((Object)this.gridColumnMock, (Object)this.abstractScesimGridModelSpy.getSelectedColumn());
    }

    @Test(expected=IllegalArgumentException.class)
    public void setSelectedColumn_NegativeIndex() {
        int columnIndex = -1;
        this.abstractScesimGridModelSpy.selectColumn(columnIndex);
    }

    @Test(expected=IllegalArgumentException.class)
    public void setSelectedColumn_OverflowIndex() {
        int columnIndex = 7;
        this.abstractScesimGridModelSpy.selectColumn(columnIndex);
    }

    @Test
    public void getInstancesCount() {
        long count = this.abstractScesimGridModelSpy.getInstancesCount("test.scesim.TestClass");
        Assert.assertEquals((long)1L, (long)count);
    }

    @Test
    public void getInstanceScenarioGridColumns() {
        List retrieved = this.abstractScesimGridModelSpy.getInstanceScenarioGridColumns((ScenarioGridColumn)this.gridColumns.get(3));
        Assert.assertNotNull((Object)retrieved);
        Assert.assertEquals((long)1L, (long)retrieved.size());
    }

    @Test
    public void updateHeader() {
        String newValue = "NEW_VALUE";
        this.abstractScesimGridModelSpy.updateHeader(3, 1, newValue);
        ((EventBus)Mockito.verify((Object)this.eventBusMock, (VerificationMode)Mockito.times((int)1))).fireEvent((GwtEvent)ArgumentMatchers.isA(ReloadTestToolsEvent.class));
        Mockito.reset((Object[])new EventBus[]{this.eventBusMock});
        this.abstractScesimGridModelSpy.updateHeader(3, 2, newValue);
        ((EventBus)Mockito.verify((Object)this.eventBusMock, (VerificationMode)Mockito.never())).fireEvent((GwtEvent)ArgumentMatchers.any());
        Mockito.reset((Object[])new EventBus[]{this.eventBusMock});
        String title = ((GridColumn.HeaderMetaData)((GridColumn)this.abstractScesimGridModelSpy.getColumns().get(3)).getHeaderMetaData().get(1)).getTitle();
        this.abstractScesimGridModelSpy.updateHeader(3, 1, title);
        ((EventBus)Mockito.verify((Object)this.eventBusMock, (VerificationMode)Mockito.never())).fireEvent((GwtEvent)ArgumentMatchers.any());
    }

    @Test
    public void updateFactMappingInstance() {
        boolean INDEX = false;
        String ALIAS_1 = "ALIAS_1";
        String ALIAS_2 = "ALIAS_2";
        FactMapping factMappingReference = (FactMapping)Mockito.mock(FactMapping.class);
        FactMapping factMappingToCheck = (FactMapping)Mockito.mock(FactMapping.class);
        FactIdentifier factIdentifier1 = (FactIdentifier)Mockito.mock(FactIdentifier.class);
        FactIdentifier factIdentifier2 = (FactIdentifier)Mockito.mock(FactIdentifier.class);
        Mockito.when((Object)factMappingReference.getFactIdentifier()).thenReturn((Object)FactIdentifier.EMPTY);
        Mockito.when((Object)factMappingToCheck.getFactIdentifier()).thenReturn((Object)FactIdentifier.EMPTY);
        Mockito.when((Object)factMappingReference.getFactAlias()).thenReturn((Object)"ALIAS_1");
        Mockito.when((Object)factMappingToCheck.getFactAlias()).thenReturn((Object)"ALIAS_1");
        Mockito.when((Object)this.simulationDescriptorMock.getFactMappingByIndex(0)).thenReturn((Object)factMappingToCheck);
        this.abstractScesimGridModelSpy.updateFactMapping(this.simulationDescriptorMock, factMappingReference, 0, "MULTIPART.VALUE", ScenarioHeaderMetaData.MetadataType.INSTANCE);
        ((ScenarioHeaderMetaData)Mockito.verify((Object)this.informationHeaderMetaDataMock, (VerificationMode)Mockito.times((int)1))).setTitle((String)ArgumentMatchers.eq((Object)"MULTIPART.VALUE"));
        ((FactMapping)Mockito.verify((Object)factMappingToCheck, (VerificationMode)Mockito.times((int)1))).setFactAlias((String)ArgumentMatchers.eq((Object)"MULTIPART.VALUE"));
        Mockito.reset((Object[])new ScenarioHeaderMetaData[]{this.informationHeaderMetaDataMock});
        Mockito.reset((Object[])new FactMapping[]{factMappingToCheck});
        Mockito.when((Object)factMappingToCheck.getFactAlias()).thenReturn((Object)"ALIAS_2");
        this.abstractScesimGridModelSpy.updateFactMapping(this.simulationDescriptorMock, factMappingReference, 0, "MULTIPART.VALUE", ScenarioHeaderMetaData.MetadataType.INSTANCE);
        ((ScenarioHeaderMetaData)Mockito.verify((Object)this.informationHeaderMetaDataMock, (VerificationMode)Mockito.never())).setTitle((String)ArgumentMatchers.eq((Object)"MULTIPART.VALUE"));
        ((FactMapping)Mockito.verify((Object)factMappingToCheck, (VerificationMode)Mockito.never())).setFactAlias((String)ArgumentMatchers.eq((Object)"MULTIPART.VALUE"));
        Mockito.reset((Object[])new ScenarioHeaderMetaData[]{this.informationHeaderMetaDataMock});
        Mockito.reset((Object[])new FactMapping[]{factMappingToCheck});
        Mockito.when((Object)factMappingReference.getFactIdentifier()).thenReturn((Object)factIdentifier1);
        Mockito.when((Object)factMappingToCheck.getFactAlias()).thenReturn((Object)"ALIAS_1");
        this.abstractScesimGridModelSpy.updateFactMapping(this.simulationDescriptorMock, factMappingReference, 0, "MULTIPART.VALUE", ScenarioHeaderMetaData.MetadataType.INSTANCE);
        ((ScenarioHeaderMetaData)Mockito.verify((Object)this.informationHeaderMetaDataMock, (VerificationMode)Mockito.never())).setTitle((String)ArgumentMatchers.eq((Object)"MULTIPART.VALUE"));
        ((FactMapping)Mockito.verify((Object)factMappingToCheck, (VerificationMode)Mockito.never())).setFactAlias((String)ArgumentMatchers.eq((Object)"MULTIPART.VALUE"));
        Mockito.reset((Object[])new ScenarioHeaderMetaData[]{this.informationHeaderMetaDataMock});
        Mockito.reset((Object[])new FactMapping[]{factMappingToCheck});
        Mockito.when((Object)factMappingToCheck.getFactIdentifier()).thenReturn((Object)factIdentifier1);
        this.abstractScesimGridModelSpy.updateFactMapping(this.simulationDescriptorMock, factMappingReference, 0, "MULTIPART.VALUE", ScenarioHeaderMetaData.MetadataType.INSTANCE);
        ((ScenarioHeaderMetaData)Mockito.verify((Object)this.informationHeaderMetaDataMock, (VerificationMode)Mockito.times((int)1))).setTitle((String)ArgumentMatchers.eq((Object)"MULTIPART.VALUE"));
        ((FactMapping)Mockito.verify((Object)factMappingToCheck, (VerificationMode)Mockito.times((int)1))).setFactAlias((String)ArgumentMatchers.eq((Object)"MULTIPART.VALUE"));
        Mockito.reset((Object[])new ScenarioHeaderMetaData[]{this.informationHeaderMetaDataMock});
        Mockito.reset((Object[])new FactMapping[]{factMappingToCheck});
        Mockito.when((Object)factMappingToCheck.getFactIdentifier()).thenReturn((Object)factIdentifier2);
        this.abstractScesimGridModelSpy.updateFactMapping(this.simulationDescriptorMock, factMappingReference, 0, "MULTIPART.VALUE", ScenarioHeaderMetaData.MetadataType.INSTANCE);
        ((ScenarioHeaderMetaData)Mockito.verify((Object)this.informationHeaderMetaDataMock, (VerificationMode)Mockito.never())).setTitle((String)ArgumentMatchers.eq((Object)"MULTIPART.VALUE"));
        ((FactMapping)Mockito.verify((Object)factMappingToCheck, (VerificationMode)Mockito.never())).setFactAlias((String)ArgumentMatchers.eq((Object)"MULTIPART.VALUE"));
    }

    @Test
    public void updateFactMappingProperty() {
        boolean INDEX = false;
        String ALIAS_1 = "ALIAS_1";
        String ALIAS_2 = "ALIAS_2";
        FactMapping factMappingReference = (FactMapping)Mockito.mock(FactMapping.class);
        FactMapping factMappingToCheck = (FactMapping)Mockito.mock(FactMapping.class);
        FactIdentifier factIdentifier1 = (FactIdentifier)Mockito.mock(FactIdentifier.class);
        Mockito.when((Object)factMappingReference.getFactIdentifier()).thenReturn((Object)FactIdentifier.EMPTY);
        Mockito.when((Object)factMappingToCheck.getFactIdentifier()).thenReturn((Object)FactIdentifier.EMPTY);
        Mockito.when((Object)factMappingReference.getFactAlias()).thenReturn((Object)"ALIAS_1");
        Mockito.when((Object)factMappingToCheck.getFactAlias()).thenReturn((Object)"ALIAS_1");
        Mockito.when((Object)factMappingReference.getFullExpression()).thenReturn((Object)"ALIAS_1");
        Mockito.when((Object)factMappingToCheck.getFullExpression()).thenReturn((Object)"ALIAS_1");
        Mockito.when((Object)this.simulationDescriptorMock.getFactMappingByIndex(0)).thenReturn((Object)factMappingToCheck);
        this.abstractScesimGridModelSpy.updateFactMapping(this.simulationDescriptorMock, factMappingReference, 0, "MULTIPART.VALUE", ScenarioHeaderMetaData.MetadataType.PROPERTY);
        ((ScenarioHeaderMetaData)Mockito.verify((Object)this.propertyHeaderMetaDataMock, (VerificationMode)Mockito.times((int)1))).setTitle((String)ArgumentMatchers.eq((Object)"MULTIPART.VALUE"));
        ((FactMapping)Mockito.verify((Object)factMappingToCheck, (VerificationMode)Mockito.times((int)1))).setExpressionAlias((String)ArgumentMatchers.eq((Object)"MULTIPART.VALUE"));
        Mockito.reset((Object[])new ScenarioHeaderMetaData[]{this.propertyHeaderMetaDataMock});
        Mockito.reset((Object[])new FactMapping[]{factMappingToCheck});
        Mockito.when((Object)factMappingToCheck.getFactAlias()).thenReturn((Object)"ALIAS_2");
        this.abstractScesimGridModelSpy.updateFactMapping(this.simulationDescriptorMock, factMappingReference, 0, "MULTIPART.VALUE", ScenarioHeaderMetaData.MetadataType.PROPERTY);
        ((ScenarioHeaderMetaData)Mockito.verify((Object)this.propertyHeaderMetaDataMock, (VerificationMode)Mockito.never())).setTitle((String)ArgumentMatchers.eq((Object)"MULTIPART.VALUE"));
        ((FactMapping)Mockito.verify((Object)factMappingToCheck, (VerificationMode)Mockito.never())).setExpressionAlias((String)ArgumentMatchers.eq((Object)"MULTIPART.VALUE"));
        Mockito.reset((Object[])new ScenarioHeaderMetaData[]{this.propertyHeaderMetaDataMock});
        Mockito.reset((Object[])new FactMapping[]{factMappingToCheck});
        Mockito.when((Object)factMappingReference.getFactIdentifier()).thenReturn((Object)factIdentifier1);
        Mockito.when((Object)factMappingToCheck.getFactAlias()).thenReturn((Object)"ALIAS_1");
        Mockito.when((Object)factMappingToCheck.getFullExpression()).thenReturn((Object)"ALIAS_2");
        this.abstractScesimGridModelSpy.updateFactMapping(this.simulationDescriptorMock, factMappingReference, 0, "MULTIPART.VALUE", ScenarioHeaderMetaData.MetadataType.PROPERTY);
        ((ScenarioHeaderMetaData)Mockito.verify((Object)this.propertyHeaderMetaDataMock, (VerificationMode)Mockito.never())).setTitle((String)ArgumentMatchers.eq((Object)"MULTIPART.VALUE"));
        ((FactMapping)Mockito.verify((Object)factMappingToCheck, (VerificationMode)Mockito.never())).setExpressionAlias((String)ArgumentMatchers.eq((Object)"MULTIPART.VALUE"));
    }

    @Test
    public void commonAddColumn() {
        this.abstractScesimGridModelSpy.commonAddColumn(3, (GridColumn)this.gridColumnMock);
        ((AbstractScesimGridModel)Mockito.verify((Object)this.abstractScesimGridModelSpy, (VerificationMode)Mockito.times((int)0))).checkSimulation();
    }

    @Test
    public void updateIndexColumn() {
        this.abstractScesimGridModelSpy.updateIndexColumn();
        ((AbstractScesimGridModel)Mockito.verify((Object)this.abstractScesimGridModelSpy, (VerificationMode)Mockito.never())).setCellValue(ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt(), (GridCellValue)ArgumentMatchers.isA(ScenarioGridCellValue.class));
        Mockito.reset((Object[])new AbstractScesimGridModel[]{this.abstractScesimGridModelSpy});
        Mockito.when((Object)this.abstractScesimGridModelSpy.getRowCount()).thenReturn((Object)3);
        int indexColumnPosition = 0;
        this.gridColumns.add(indexColumnPosition, this.scenarioIndexGridColumnMock);
        Mockito.when((Object)this.abstractScesimGridModelSpy.getColumns()).thenReturn((Object)this.gridColumns);
        this.abstractScesimGridModelSpy.updateIndexColumn();
    }

    @Test
    public void isSameInstanceHeaderDifferent() {
        this.commonCheckSameInstanceHeader("TestClass", "TOAST", false);
    }

    @Test
    public void isSameInstanceHeaderEqualWithoutPackage() {
        this.commonCheckSameInstanceHeader("TestClass", "TestClass", true);
    }

    @Test
    public void isSameInstanceHeaderEqualWithPackage() {
        this.commonCheckSameInstanceHeader("test.scesim.TestClass", "TestClass", false);
    }

    @Test
    public void isSameInstanceHeader_Different() {
        this.isSameInstanceType("TestClass", "TOAST", false);
    }

    @Test
    public void isSameInstanceHeader_Equal() {
        this.isSameInstanceType("TestClass", "TestClass", true);
    }

    @Test
    public void refreshErrorsTest() {
        int expectedCalls = this.abstractScesimGridModelSpy.getRowCount() * this.abstractScesimGridModelSpy.getColumnCount();
        this.abstractScesimGridModelSpy.refreshErrors();
        ((ScenarioGridCell)Mockito.verify((Object)this.gridCellMock, (VerificationMode)Mockito.times((int)expectedCalls))).setErrorMode(ArgumentMatchers.eq((boolean)true));
        Mockito.when((Object)this.factMappingValueMock.getStatus()).thenReturn((Object)FactMappingValueStatus.SUCCESS);
        this.abstractScesimGridModelSpy.refreshErrors();
        ((ScenarioGridCell)Mockito.verify((Object)this.gridCellMock, (VerificationMode)Mockito.times((int)expectedCalls))).setErrorMode(ArgumentMatchers.eq((boolean)false));
    }

    @Test
    public void refreshErrorsRow() {
        int expectedCalls = this.abstractScesimGridModelSpy.getColumnCount();
        FactMappingValue factMappingValue = (FactMappingValue)Mockito.mock(FactMappingValue.class);
        Mockito.when((Object)factMappingValue.getStatus()).thenReturn((Object)FactMappingValueStatus.FAILED_WITH_ERROR);
        Mockito.when((Object)this.scenarioMock.getFactMappingValue((FactIdentifier)ArgumentMatchers.any(), (ExpressionIdentifier)ArgumentMatchers.any())).thenReturn(Optional.empty());
        this.abstractScesimGridModelSpy.refreshErrorsRow(0);
        ((ScenarioGridCell)Mockito.verify((Object)this.gridCellMock, (VerificationMode)Mockito.times((int)expectedCalls))).setErrorMode(false);
        Mockito.when((Object)this.scenarioMock.getFactMappingValue((FactIdentifier)ArgumentMatchers.any(), (ExpressionIdentifier)ArgumentMatchers.any())).thenReturn(Optional.of(factMappingValue));
        this.abstractScesimGridModelSpy.refreshErrorsRow(0);
        ((ScenarioGridCell)Mockito.verify((Object)this.gridCellMock, (VerificationMode)Mockito.times((int)expectedCalls))).setErrorMode(true);
    }

    @Test
    public void validateInstanceHeaderUpdate() throws Exception {
        this.commonValidateInstanceHeaderUpdate(1, false, false, false, false);
        this.commonValidateInstanceHeaderUpdate(1, false, false, true, true);
        this.commonValidateInstanceHeaderUpdate(1, false, true, false, false);
        this.commonValidateInstanceHeaderUpdate(1, false, true, true, true);
        this.commonValidateInstanceHeaderUpdate(1, true, false, false, false);
        this.commonValidateInstanceHeaderUpdate(1, true, false, true, false);
        this.commonValidateInstanceHeaderUpdate(1, true, true, false, false);
        this.commonValidateInstanceHeaderUpdate(1, true, true, true, false);
    }

    @Test
    public void validatePropertyHeaderUpdate() throws Exception {
        this.commonValidatePropertyUpdate(1, false, false, false, false);
        this.commonValidatePropertyUpdate(1, false, false, true, true);
        this.commonValidatePropertyUpdate(1, false, true, false, false);
        this.commonValidatePropertyUpdate(1, false, true, true, true);
        this.commonValidatePropertyUpdate(1, true, false, false, false);
        this.commonValidatePropertyUpdate(1, true, false, true, false);
        this.commonValidatePropertyUpdate(1, true, true, false, false);
        this.commonValidatePropertyUpdate(1, true, true, true, false);
    }

    private void isSameInstanceType(String columnClassName, String value, boolean expectedResult) {
        FactIdentifier factIdentifierMock = (FactIdentifier)Mockito.mock(FactIdentifier.class);
        Mockito.when((Object)factIdentifierMock.getClassNameWithoutPackage()).thenReturn((Object)columnClassName);
        Mockito.when((Object)this.factMappingMock.getFactIdentifier()).thenReturn((Object)factIdentifierMock);
        Mockito.when((Object)this.simulationDescriptorMock.getFactMappingByIndex(3)).thenReturn((Object)this.factMappingMock);
        boolean result = this.abstractScesimGridModelSpy.isSameInstanceType(3, value);
        ((Simulation)Mockito.verify((Object)this.simulationMock, (VerificationMode)Mockito.times((int)1))).getScesimModelDescriptor();
        ((ScesimModelDescriptor)Mockito.verify((Object)this.simulationDescriptorMock, (VerificationMode)Mockito.times((int)1))).getFactMappingByIndex(ArgumentMatchers.eq((int)3));
        Assert.assertEquals((Object)result, (Object)expectedResult);
    }

    private void commonCheckSameInstanceHeader(String columnClassName, String value, boolean expected) {
        block2: {
            FactIdentifier factIdentifierMock = (FactIdentifier)Mockito.mock(FactIdentifier.class);
            Mockito.when((Object)factIdentifierMock.getClassNameWithoutPackage()).thenReturn((Object)columnClassName);
            Mockito.when((Object)this.factMappingMock.getFactIdentifier()).thenReturn((Object)factIdentifierMock);
            Mockito.when((Object)this.simulationDescriptorMock.getFactMappingByIndex(3)).thenReturn((Object)this.factMappingMock);
            try {
                this.abstractScesimGridModelSpy.checkSameInstanceHeader(3, value);
                ((AbstractScesimGridModel)Mockito.verify((Object)this.abstractScesimGridModelSpy, (VerificationMode)Mockito.times((int)1))).isSameInstanceType(ArgumentMatchers.eq((int)3), (String)ArgumentMatchers.eq((Object)value));
            }
            catch (Exception e) {
                if (!expected) break block2;
                Assert.fail((String)("No exception expected, retrieved " + e.getMessage()));
            }
        }
    }

    private void commonValidateInstanceHeaderUpdate(int columnIndex, boolean isADataType, boolean isSameInstanceHeader, boolean isUnique, boolean expectedValid) throws Exception {
        block6: {
            if (isSameInstanceHeader) {
                ((AbstractScesimGridModel)Mockito.doThrow((Throwable[])new Throwable[]{new IllegalArgumentException("isSameInstanceHeader")}).when((Object)this.abstractScesimGridModelSpy)).checkSameInstanceHeader(columnIndex, TestProperties.MULTIPART_VALUE_ELEMENTS.get(TestProperties.MULTIPART_VALUE_ELEMENTS.size() - 1));
            } else {
                ((AbstractScesimGridModel)Mockito.doNothing().when((Object)this.abstractScesimGridModelSpy)).checkSameInstanceHeader(columnIndex, TestProperties.MULTIPART_VALUE_ELEMENTS.get(TestProperties.MULTIPART_VALUE_ELEMENTS.size() - 1));
            }
            if (isUnique) {
                ((AbstractScesimGridModel)Mockito.doNothing().when((Object)this.abstractScesimGridModelSpy)).checkValidAndUniqueInstanceHeaderTitle("MULTIPART.VALUE", columnIndex);
            } else {
                ((AbstractScesimGridModel)Mockito.doThrow((Throwable[])new Throwable[]{new IllegalArgumentException("isUnique")}).when((Object)this.abstractScesimGridModelSpy)).checkValidAndUniqueInstanceHeaderTitle("MULTIPART.VALUE", columnIndex);
            }
            try {
                this.abstractScesimGridModelSpy.validateInstanceHeaderUpdate("MULTIPART.VALUE", columnIndex, isADataType);
            }
            catch (Exception e) {
                if (!expectedValid) break block6;
                Assert.fail((String)("No exception expected, retrieved:  " + e.getMessage()));
            }
        }
        Mockito.reset((Object[])new EventBus[]{this.eventBusMock});
    }

    private void commonValidatePropertyUpdate(int columnIndex, boolean isPropertyType, boolean isSamePropertyHeader, boolean isUnique, boolean expectedValid) throws Exception {
        block6: {
            if (isSamePropertyHeader) {
                ((AbstractScesimGridModel)Mockito.doThrow((Throwable[])new Throwable[]{new IllegalArgumentException("isSamePropertyHeader")}).when((Object)this.abstractScesimGridModelSpy)).checkSamePropertyHeader(columnIndex, TestProperties.MULTIPART_VALUE_ELEMENTS);
            } else {
                ((AbstractScesimGridModel)Mockito.doNothing().when((Object)this.abstractScesimGridModelSpy)).checkSamePropertyHeader(columnIndex, TestProperties.MULTIPART_VALUE_ELEMENTS);
            }
            if (isUnique) {
                ((AbstractScesimGridModel)Mockito.doNothing().when((Object)this.abstractScesimGridModelSpy)).checkValidAndUniquePropertyHeaderTitle("MULTIPART.VALUE", columnIndex);
            } else {
                ((AbstractScesimGridModel)Mockito.doThrow((Throwable[])new Throwable[]{new IllegalArgumentException("isUnique")}).when((Object)this.abstractScesimGridModelSpy)).checkValidAndUniquePropertyHeaderTitle("MULTIPART.VALUE", columnIndex);
            }
            try {
                this.abstractScesimGridModelSpy.validatePropertyHeaderUpdate("MULTIPART.VALUE", columnIndex, isPropertyType);
            }
            catch (Exception e) {
                if (!expectedValid) break block6;
                Assert.fail((String)("No exception expected, retrieved:  " + e.getMessage()));
            }
        }
        Mockito.reset((Object[])new EventBus[]{this.eventBusMock});
    }

    @Test(expected=IllegalArgumentException.class)
    public void checkUniquePropertyHeaderTitle_AssignedLabel() {
        this.abstractScesimGridModelSpy.checkUniquePropertyHeaderTitle("GRID_PROPERTY_TITLE", 3);
    }

    @Test
    public void resetError() {
        this.abstractScesimGridModelSpy = (AbstractScesimGridModel)Mockito.spy((Object)new ScenarioGridModel(false){
            {
                this.abstractScesimModel = AbstractScesimGridModelTest.this.simulationMock;
                this.eventBus = AbstractScesimGridModelTest.this.eventBusMock;
                this.rows = TestProperties.GRID_ROWS;
                this.columns = AbstractScesimGridModelTest.this.gridColumns;
            }

            public void refreshErrors() {
            }

            public GridCell<?> getCell(int rowIndex, int columnIndex) {
                if (rowIndex < 0 || rowIndex > this.rows.size() - 1) {
                    return null;
                }
                return AbstractScesimGridModelTest.this.gridCellMock;
            }
        });
        this.abstractScesimGridModelSpy.resetError(2, 3);
        ((Simulation)Mockito.verify((Object)this.simulationMock, (VerificationMode)Mockito.times((int)1))).getDataByIndex(ArgumentMatchers.eq((int)2));
        ((ScesimModelDescriptor)Mockito.verify((Object)this.simulationDescriptorMock, (VerificationMode)Mockito.times((int)1))).getFactMappingByIndex(ArgumentMatchers.eq((int)3));
        ((Scenario)Mockito.verify((Object)this.scenarioMock, (VerificationMode)Mockito.times((int)1))).getFactMappingValue((FactMapping)ArgumentMatchers.eq((Object)this.factMappingMock));
        ((FactMappingValue)Mockito.verify((Object)this.factMappingValueMock, (VerificationMode)Mockito.times((int)1))).resetStatus();
        ((AbstractScesimGridModel)Mockito.verify((Object)this.abstractScesimGridModelSpy, (VerificationMode)Mockito.times((int)1))).refreshErrors();
    }

    @Test
    public void synchronizeFactMappingsWidths() {
        this.abstractScesimGridModelSpy.synchronizeFactMappingsWidths();
        ((AbstractScesimGridModel)Mockito.verify((Object)this.abstractScesimGridModelSpy, (VerificationMode)Mockito.times((int)this.gridColumns.size()))).synchronizeFactMappingWidth((GridColumn)ArgumentMatchers.isA(GridColumn.class));
    }

    @Test
    public void synchronizeFactMappingWidth() {
        Mockito.when((Object)this.gridColumnMock.isVisible()).thenReturn((Object)true);
        this.abstractScesimGridModelSpy.synchronizeFactMappingWidth((GridColumn)this.gridColumnMock);
        ((FactMapping)Mockito.verify((Object)this.factMappingMock, (VerificationMode)Mockito.times((int)1))).setColumnWidth(Double.valueOf(ArgumentMatchers.eq((double)this.gridColumnMock.getWidth())));
    }

    @Test
    public void synchronizeFactMappingWidth_NotVisibleColumn() {
        Mockito.when((Object)this.gridColumnMock.isVisible()).thenReturn((Object)false);
        this.abstractScesimGridModelSpy.synchronizeFactMappingWidth((GridColumn)this.gridColumnMock);
        ((FactMapping)Mockito.verify((Object)this.factMappingMock, (VerificationMode)Mockito.never())).setColumnWidth((Double)ArgumentMatchers.any());
    }

    @Test
    public void loadFactMappingsWidth_FactMappingWithoutWidth() {
        Mockito.when((Object)this.factMappingMock.getColumnWidth()).thenReturn(null);
        this.gridColumns.clear();
        this.gridColumns.add(this.gridColumnMock);
        this.abstractScesimGridModelSpy.loadFactMappingsWidth();
        ((ScenarioGridColumn)Mockito.verify((Object)this.gridColumnMock, (VerificationMode)Mockito.never())).setWidth(ArgumentMatchers.anyDouble());
    }

    @Test
    public void loadFactMappingsWidth_FactMappingWithWidth() {
        Mockito.when((Object)this.factMappingMock.getColumnWidth()).thenReturn((Object)54.32);
        this.gridColumns.clear();
        this.gridColumns.add(this.gridColumnMock);
        this.abstractScesimGridModelSpy.loadFactMappingsWidth();
        ((FactMapping)Mockito.verify((Object)this.factMappingMock, (VerificationMode)Mockito.never())).setColumnWidth(Double.valueOf(ArgumentMatchers.anyDouble()));
        ((ScenarioGridColumn)Mockito.verify((Object)this.gridColumnMock, (VerificationMode)Mockito.times((int)1))).setWidth(((Double)ArgumentMatchers.eq((Object)this.factMappingMock.getColumnWidth())).doubleValue());
    }

    @Test
    public void getDOMElementFactory_Collection() {
        BaseSingletonDOMElementFactory factory = this.abstractScesimGridModelSpy.getDOMElementFactory("java.util.List", ScenarioSimulationModel.Type.RULE, FactMappingValueType.NOT_EXPRESSION);
        Assert.assertSame((Object)this.collectionEditorSingletonDOMElementFactoryTest, (Object)factory);
        factory = this.abstractScesimGridModelSpy.getDOMElementFactory("java.util.Map", ScenarioSimulationModel.Type.RULE, FactMappingValueType.NOT_EXPRESSION);
        Assert.assertSame((Object)this.collectionEditorSingletonDOMElementFactoryTest, (Object)factory);
        factory = this.abstractScesimGridModelSpy.getDOMElementFactory("java.util.List", ScenarioSimulationModel.Type.DMN, FactMappingValueType.NOT_EXPRESSION);
        Assert.assertSame((Object)this.collectionEditorSingletonDOMElementFactoryTest, (Object)factory);
        factory = this.abstractScesimGridModelSpy.getDOMElementFactory("java.util.List", ScenarioSimulationModel.Type.DMN, FactMappingValueType.EXPRESSION);
        Assert.assertSame((Object)this.scenarioCellTextAreaSingletonDOMElementFactorySpy, (Object)factory);
        factory = this.abstractScesimGridModelSpy.getDOMElementFactory("java.util.List", ScenarioSimulationModel.Type.RULE, FactMappingValueType.EXPRESSION);
        Assert.assertSame((Object)this.scenarioExpressionCellTextAreaSingletonDOMElementFactorySpy, (Object)factory);
    }

    @Test
    public void getDOMElementFactory_Expression() {
        BaseSingletonDOMElementFactory factory = this.abstractScesimGridModelSpy.getDOMElementFactory("com.Test", ScenarioSimulationModel.Type.DMN, FactMappingValueType.EXPRESSION);
        Assert.assertSame((Object)this.scenarioCellTextAreaSingletonDOMElementFactorySpy, (Object)factory);
        factory = this.abstractScesimGridModelSpy.getDOMElementFactory("com.Test", ScenarioSimulationModel.Type.RULE, FactMappingValueType.EXPRESSION);
        Assert.assertSame((Object)this.scenarioExpressionCellTextAreaSingletonDOMElementFactorySpy, (Object)factory);
    }

    @Test
    public void getDOMElementFactory_NotExpressionNotCollection() {
        BaseSingletonDOMElementFactory factory = this.abstractScesimGridModelSpy.getDOMElementFactory("com.Test", ScenarioSimulationModel.Type.DMN, FactMappingValueType.NOT_EXPRESSION);
        Assert.assertSame((Object)this.scenarioCellTextAreaSingletonDOMElementFactorySpy, (Object)factory);
        factory = this.abstractScesimGridModelSpy.getDOMElementFactory("com.Test", ScenarioSimulationModel.Type.RULE, FactMappingValueType.NOT_EXPRESSION);
        Assert.assertSame((Object)this.scenarioCellTextAreaSingletonDOMElementFactorySpy, (Object)factory);
    }

    @Test
    public void destroyAllTextAreaDOMElementFactoryResources() {
        this.abstractScesimGridModelSpy.destroyAllTextAreaDOMElementFactoryResources();
        ((ScenarioCellTextAreaSingletonDOMElementFactory)Mockito.verify((Object)this.scenarioCellTextAreaSingletonDOMElementFactorySpy, (VerificationMode)Mockito.times((int)1))).destroyResources();
        ((ScenarioExpressionCellTextAreaSingletonDOMElementFactory)Mockito.verify((Object)this.scenarioExpressionCellTextAreaSingletonDOMElementFactorySpy, (VerificationMode)Mockito.times((int)1))).destroyResources();
        ((ScenarioHeaderTextBoxSingletonDOMElementFactory)Mockito.verify((Object)this.scenarioHeaderTextBoxSingletonDOMElementFactorySpy, (VerificationMode)Mockito.times((int)1))).destroyResources();
    }

    @Test
    public void isSameSelectedColumnProperty() {
        List<ExpressionElement> expressionList = Arrays.asList(new ExpressionElement("Fact"), new ExpressionElement("property"));
        Mockito.when((Object)this.factMappingMock.getExpressionElements()).thenReturn(expressionList);
        Mockito.when((Object)this.factMappingMock.getFactMappingValueType()).thenReturn((Object)FactMappingValueType.NOT_EXPRESSION);
        Assert.assertTrue((boolean)this.abstractScesimGridModelSpy.isSameSelectedColumnProperty(1, Arrays.asList("Fact", "property"), FactMappingValueType.NOT_EXPRESSION));
        Assert.assertFalse((boolean)this.abstractScesimGridModelSpy.isSameSelectedColumnProperty(1, Arrays.asList("Fact", "property2"), FactMappingValueType.NOT_EXPRESSION));
        Assert.assertFalse((boolean)this.abstractScesimGridModelSpy.isSameSelectedColumnProperty(1, Arrays.asList("property2"), FactMappingValueType.NOT_EXPRESSION));
        Assert.assertFalse((boolean)this.abstractScesimGridModelSpy.isSameSelectedColumnProperty(1, Arrays.asList("Fact", "property"), FactMappingValueType.EXPRESSION));
        Assert.assertFalse((boolean)this.abstractScesimGridModelSpy.isSameSelectedColumnProperty(1, Arrays.asList("Fact", "property2"), FactMappingValueType.EXPRESSION));
        Assert.assertFalse((boolean)this.abstractScesimGridModelSpy.isSameSelectedColumnProperty(1, Arrays.asList("property2"), FactMappingValueType.EXPRESSION));
        Mockito.when((Object)this.factMappingMock.getFactMappingValueType()).thenReturn((Object)FactMappingValueType.EXPRESSION);
        Assert.assertFalse((boolean)this.abstractScesimGridModelSpy.isSameSelectedColumnProperty(1, Arrays.asList("Fact", "property"), FactMappingValueType.NOT_EXPRESSION));
        Assert.assertFalse((boolean)this.abstractScesimGridModelSpy.isSameSelectedColumnProperty(1, Arrays.asList("Fact", "property2"), FactMappingValueType.NOT_EXPRESSION));
        Assert.assertFalse((boolean)this.abstractScesimGridModelSpy.isSameSelectedColumnProperty(1, Arrays.asList("property2"), FactMappingValueType.NOT_EXPRESSION));
        Assert.assertTrue((boolean)this.abstractScesimGridModelSpy.isSameSelectedColumnProperty(1, Arrays.asList("Fact", "property"), FactMappingValueType.EXPRESSION));
        Assert.assertFalse((boolean)this.abstractScesimGridModelSpy.isSameSelectedColumnProperty(1, Arrays.asList("Fact", "property2"), FactMappingValueType.EXPRESSION));
        Assert.assertFalse((boolean)this.abstractScesimGridModelSpy.isSameSelectedColumnProperty(1, Arrays.asList("property2"), FactMappingValueType.EXPRESSION));
    }
}

