/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.resources.i18n;

import com.google.gwtmockito.GwtMockitoTestRunner;
import org.drools.scenariosimulation.api.model.ExpressionIdentifier;
import org.drools.scenariosimulation.api.model.FactIdentifier;
import org.drools.scenariosimulation.api.model.FactMapping;
import org.drools.scenariosimulation.api.model.FactMappingType;
import org.drools.workbench.screens.scenariosimulation.client.resources.i18n.ScenarioSimulationEditorConstants;
import org.drools.workbench.screens.scenariosimulation.client.resources.i18n.ScenarioSimulationEditorI18nServerManager;
import org.drools.workbench.screens.scenariosimulation.model.FactMappingValidationError;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=GwtMockitoTestRunner.class)
public class ScenarioSimulationEditorI18nServerManagerTest {
    private FactMapping factMapping;

    @Before
    public void setup() {
        this.factMapping = new FactMapping(FactIdentifier.create((String)"myType", (String)"tMYTYPE"), ExpressionIdentifier.create((String)"value", (FactMappingType)FactMappingType.GIVEN));
        this.factMapping.setFactAlias("FactAlias");
        this.factMapping.setExpressionAlias("ExpressionAlias");
    }

    @Test(expected=IllegalArgumentException.class)
    public void retrieveMessageNullParameter() {
        ScenarioSimulationEditorI18nServerManager.retrieveMessage(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void retrieveMessageNullServerMessage() {
        ScenarioSimulationEditorI18nServerManager.retrieveMessage((FactMappingValidationError)FactMappingValidationError.createGenericError((FactMapping)this.factMapping, (String)"error"));
    }

    @Test
    public void retrieveMessageFieldAddedConstraint() {
        FactMappingValidationError error = FactMappingValidationError.createFieldAddedConstraintError((FactMapping)this.factMapping);
        String message = ScenarioSimulationEditorI18nServerManager.retrieveMessage((FactMappingValidationError)error);
        String expected = ScenarioSimulationEditorConstants.INSTANCE.scenarioValidationFieldAddedConstraintError();
        Assert.assertEquals((Object)expected, (Object)message);
    }

    @Test
    public void retrieveMessageFieldRemovedConstraint() {
        FactMappingValidationError error = FactMappingValidationError.createFieldRemovedConstraintError((FactMapping)this.factMapping);
        String message = ScenarioSimulationEditorI18nServerManager.retrieveMessage((FactMappingValidationError)error);
        String expected = ScenarioSimulationEditorConstants.INSTANCE.scenarioValidationFieldRemovedConstraintError();
        Assert.assertEquals((Object)expected, (Object)message);
    }

    @Test
    public void retrieveMessageFieldChangedError() {
        String newType = "newType";
        FactMappingValidationError error = FactMappingValidationError.createFieldChangedError((FactMapping)this.factMapping, (String)newType);
        String message = ScenarioSimulationEditorI18nServerManager.retrieveMessage((FactMappingValidationError)error);
        String expected = ScenarioSimulationEditorConstants.INSTANCE.scenarioValidationFieldChangedError("tMYTYPE", newType);
        Assert.assertEquals((Object)expected, (Object)message);
    }

    @Test
    public void retrieveMessageNodeChangedError() {
        String newType = "newType";
        FactMappingValidationError error = FactMappingValidationError.createNodeChangedError((FactMapping)this.factMapping, (String)newType);
        String message = ScenarioSimulationEditorI18nServerManager.retrieveMessage((FactMappingValidationError)error);
        String expected = ScenarioSimulationEditorConstants.INSTANCE.scenarioValidationNodeChangedError("tMYTYPE", newType);
        Assert.assertEquals((Object)expected, (Object)message);
    }
}

