/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.editor;

import com.google.gwt.core.client.GWT;
import com.google.gwtmockito.GwtMock;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Optional;
import org.drools.workbench.screens.scenariosimulation.client.editor.ScenarioSimulationEditorPresenter;
import org.drools.workbench.screens.scenariosimulation.client.editor.ScenarioSimulationView;
import org.drools.workbench.screens.scenariosimulation.client.type.ScenarioSimulationResourceType;
import org.drools.workbench.screens.scenariosimulation.model.ScenarioSimulationModel;
import org.drools.workbench.screens.scenariosimulation.model.ScenarioSimulationModelContent;
import org.drools.workbench.screens.scenariosimulation.service.ScenarioSimulationService;
import org.guvnor.common.services.project.client.context.WorkspaceProjectContext;
import org.guvnor.common.services.shared.metadata.model.Metadata;
import org.guvnor.common.services.shared.metadata.model.Overview;
import org.guvnor.messageconsole.client.console.widget.button.AlertsButtonMenuItemBuilder;
import org.jboss.errai.common.client.api.Caller;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.widgets.client.menu.FileMenuBuilder;
import org.kie.workbench.common.widgets.client.source.ViewDRLSourceWidget;
import org.kie.workbench.common.widgets.metadata.client.KieEditorWrapperView;
import org.kie.workbench.common.widgets.metadata.client.widget.OverviewWidgetPresenter;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.backend.vfs.ObservablePath;
import org.uberfire.backend.vfs.Path;
import org.uberfire.ext.editor.commons.client.history.VersionRecordManager;
import org.uberfire.ext.editor.commons.client.menu.common.SaveAndRenameCommandBuilder;
import org.uberfire.ext.editor.commons.client.validation.DefaultFileNameValidator;
import org.uberfire.ext.editor.commons.client.validation.Validator;
import org.uberfire.mocks.CallerMock;
import org.uberfire.mocks.EventSourceMock;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.workbench.events.NotificationEvent;
import org.uberfire.workbench.model.menu.MenuItem;

@RunWith(value=GwtMockitoTestRunner.class)
public class ScenarioSimulationEditorPresenterTest {
    @Mock
    private ScenarioSimulationView view;
    @Mock
    private KieEditorWrapperView mockKieView;
    @Mock
    private OverviewWidgetPresenter mockOverviewWidget;
    @Mock
    private VersionRecordManager mockVersionRecordManager;
    @Mock
    private FileMenuBuilder mockFileMenuBuilder;
    @Mock
    private DefaultFileNameValidator mockFileNameValidator;
    @Mock
    private ScenarioSimulationService scenarioSimulationService;
    @Mock
    private ObservablePath path;
    @Mock
    private PlaceRequest place;
    @Mock
    private Overview overview;
    @Mock
    private WorkspaceProjectContext mockWorkbenchContext;
    @Mock
    private SaveAndRenameCommandBuilder<String, Metadata> mockSaveAndRenameCommandBuilder;
    @Mock
    private AlertsButtonMenuItemBuilder mockAlertsButtonMenuItemBuilder;
    @GwtMock
    private ViewDRLSourceWidget sourceWidget;
    @Captor
    private ArgumentCaptor<String> enumStringArgumentCaptor;
    @Mock
    private EventSourceMock<NotificationEvent> mockNotification;
    private ScenarioSimulationResourceType type;
    private ScenarioSimulationEditorPresenter presenter;
    private ScenarioSimulationModelContent content;
    private ScenarioSimulationModel model;

    @Before
    public void setup() {
        this.type = (ScenarioSimulationResourceType)GWT.create(ScenarioSimulationResourceType.class);
        Mockito.when((Object)this.mockFileMenuBuilder.addSave((MenuItem)Mockito.any(MenuItem.class))).thenReturn((Object)this.mockFileMenuBuilder);
        Mockito.when((Object)this.mockFileMenuBuilder.addCopy((Path)Mockito.any(ObservablePath.class), (Validator)Mockito.any(DefaultFileNameValidator.class))).thenReturn((Object)this.mockFileMenuBuilder);
        Mockito.when((Object)this.mockFileMenuBuilder.addRename((Command)Mockito.any(Command.class))).thenReturn((Object)this.mockFileMenuBuilder);
        Mockito.when((Object)this.mockFileMenuBuilder.addDelete((Path)Mockito.any(ObservablePath.class))).thenReturn((Object)this.mockFileMenuBuilder);
        Mockito.when((Object)this.mockFileMenuBuilder.addValidate((Command)Mockito.any(Command.class))).thenReturn((Object)this.mockFileMenuBuilder);
        Mockito.when((Object)this.mockFileMenuBuilder.addNewTopLevelMenu((MenuItem)Mockito.any(MenuItem.class))).thenReturn((Object)this.mockFileMenuBuilder);
        Mockito.when((Object)this.mockVersionRecordManager.getCurrentPath()).thenReturn((Object)this.path);
        Mockito.when((Object)this.mockVersionRecordManager.getPathToLatest()).thenReturn((Object)this.path);
        Mockito.when((Object)this.mockWorkbenchContext.getActiveWorkspaceProject()).thenReturn(Optional.empty());
        this.model = new ScenarioSimulationModel();
        this.content = new ScenarioSimulationModelContent(this.model, this.overview);
        Mockito.when((Object)this.scenarioSimulationService.loadContent((Path)this.path)).thenReturn((Object)this.content);
        this.presenter = (ScenarioSimulationEditorPresenter)Mockito.spy((Object)new ScenarioSimulationEditorPresenter(this.view, (Caller)new CallerMock((Object)this.scenarioSimulationService), this.type){
            {
                this.kieView = ScenarioSimulationEditorPresenterTest.this.mockKieView;
                this.overviewWidget = ScenarioSimulationEditorPresenterTest.this.mockOverviewWidget;
                this.fileMenuBuilder = ScenarioSimulationEditorPresenterTest.this.mockFileMenuBuilder;
                this.fileNameValidator = ScenarioSimulationEditorPresenterTest.this.mockFileNameValidator;
                this.versionRecordManager = ScenarioSimulationEditorPresenterTest.this.mockVersionRecordManager;
                this.notification = ScenarioSimulationEditorPresenterTest.this.mockNotification;
                this.workbenchContext = ScenarioSimulationEditorPresenterTest.this.mockWorkbenchContext;
                this.alertsButtonMenuItemBuilder = ScenarioSimulationEditorPresenterTest.this.mockAlertsButtonMenuItemBuilder;
            }

            protected MenuItem downloadMenuItem() {
                return (MenuItem)Mockito.mock(MenuItem.class);
            }

            protected Command getSaveAndRename() {
                return (Command)Mockito.mock(Command.class);
            }
        });
    }

    @Test
    public void testOnStartup() {
        this.presenter.onStartup((ObservablePath)Mockito.mock(ObservablePath.class), (PlaceRequest)Mockito.mock(PlaceRequest.class));
        ((ScenarioSimulationView)Mockito.verify((Object)this.view)).showLoading();
        ((ScenarioSimulationView)Mockito.verify((Object)this.view)).hideBusyIndicator();
    }

    @Test
    public void validateButtonShouldNotBeAdded() {
        this.presenter.onStartup((ObservablePath)Mockito.mock(ObservablePath.class), (PlaceRequest)Mockito.mock(PlaceRequest.class));
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.never())).getValidateCommand();
    }

    @Test
    public void save() {
        this.presenter.onStartup((ObservablePath)Mockito.mock(ObservablePath.class), (PlaceRequest)Mockito.mock(PlaceRequest.class));
        Mockito.reset((Object[])new ScenarioSimulationView[]{this.view});
        this.presenter.save("save message");
        ((ScenarioSimulationView)Mockito.verify((Object)this.view)).hideBusyIndicator();
        ((EventSourceMock)Mockito.verify(this.mockNotification)).fire(Mockito.any(NotificationEvent.class));
        ((VersionRecordManager)Mockito.verify((Object)this.mockVersionRecordManager)).reloadVersions((Path)Mockito.any(Path.class));
    }
}

