/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.webapp.client.dropdown;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.drools.workbench.screens.scenariosimulation.webapp.client.dropdown.ScenarioSimulationKogitoRuntimeCreationAssetsDropdownProviderImpl;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.kogito.webapp.base.client.workarounds.KogitoResourceContentService;
import org.kie.workbench.common.widgets.client.assets.dropdown.KieAssetsDropdownItem;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.client.workbench.widgets.common.ErrorPopupPresenter;

@RunWith(value=GwtMockitoTestRunner.class)
public class ScenarioSimulationKogitoRuntimeCreationAssetsDropdownProviderImplTest {
    @Mock
    private KogitoResourceContentService kogitoResourceContentServiceMock;
    @Mock
    private ErrorPopupPresenter errorPopupPresenterMock;
    @Mock
    private Consumer<List<KieAssetsDropdownItem>> assetConsumer;
    @Captor
    private ArgumentCaptor<List<KieAssetsDropdownItem>> dropDownListCaptor;
    private ScenarioSimulationKogitoRuntimeCreationAssetsDropdownProviderImpl scenarioSimulationKogitoRuntimeCreationAssetsDropdownProviderImplSpy;

    @Before
    public void setup() {
        this.scenarioSimulationKogitoRuntimeCreationAssetsDropdownProviderImplSpy = (ScenarioSimulationKogitoRuntimeCreationAssetsDropdownProviderImpl)Mockito.spy((Object)new ScenarioSimulationKogitoRuntimeCreationAssetsDropdownProviderImpl(){
            {
                this.resourceContentService = ScenarioSimulationKogitoRuntimeCreationAssetsDropdownProviderImplTest.this.kogitoResourceContentServiceMock;
                this.errorPopupPresenter = ScenarioSimulationKogitoRuntimeCreationAssetsDropdownProviderImplTest.this.errorPopupPresenterMock;
            }
        });
    }

    @Test
    public void getItems() {
        this.scenarioSimulationKogitoRuntimeCreationAssetsDropdownProviderImplSpy.getItems(this.assetConsumer);
        ((KogitoResourceContentService)Mockito.verify((Object)this.kogitoResourceContentServiceMock, (VerificationMode)Mockito.times((int)1))).getFilteredItems((String)Matchers.eq((Object)"src/**/*.dmn"), (RemoteCallback)Matchers.isA(RemoteCallback.class), (ErrorCallback)Matchers.isA(ErrorCallback.class));
    }

    @Test
    public void getRemoteCallBack() {
        RemoteCallback remoteCallBack = this.scenarioSimulationKogitoRuntimeCreationAssetsDropdownProviderImplSpy.getRemoteCallback(this.assetConsumer);
        remoteCallBack.callback(Arrays.asList("path/B", "a"));
        ((Consumer)Mockito.verify(this.assetConsumer, (VerificationMode)Mockito.times((int)1))).accept(this.dropDownListCaptor.capture());
        Assert.assertTrue((((List)this.dropDownListCaptor.getValue()).size() == 2 ? 1 : 0) != 0);
        Assert.assertEquals((Object)"a", (Object)((KieAssetsDropdownItem)((List)this.dropDownListCaptor.getValue()).get(0)).getText());
        Assert.assertEquals((Object)"a", (Object)((KieAssetsDropdownItem)((List)this.dropDownListCaptor.getValue()).get(0)).getSubText());
        Assert.assertEquals((Object)"a", (Object)((KieAssetsDropdownItem)((List)this.dropDownListCaptor.getValue()).get(0)).getValue());
        Assert.assertEquals((Object)"B", (Object)((KieAssetsDropdownItem)((List)this.dropDownListCaptor.getValue()).get(1)).getText());
        Assert.assertEquals((Object)"path/B", (Object)((KieAssetsDropdownItem)((List)this.dropDownListCaptor.getValue()).get(1)).getSubText());
        Assert.assertEquals((Object)"path/B", (Object)((KieAssetsDropdownItem)((List)this.dropDownListCaptor.getValue()).get(1)).getValue());
    }

    @Test
    public void remoteCallBackSortedIgnoreCase() {
        RemoteCallback remoteCallBack = this.scenarioSimulationKogitoRuntimeCreationAssetsDropdownProviderImplSpy.getRemoteCallback(this.assetConsumer);
        List<String> dmnFiles = Arrays.asList("AS", "Ap");
        remoteCallBack.callback(dmnFiles);
        ((Consumer)Mockito.verify(this.assetConsumer, (VerificationMode)Mockito.times((int)1))).accept(this.dropDownListCaptor.capture());
        Collections.sort(dmnFiles, String::compareToIgnoreCase);
        Assert.assertEquals(dmnFiles, ((List)this.dropDownListCaptor.getValue()).stream().map(KieAssetsDropdownItem::getValue).collect(Collectors.toList()));
    }

    @Test
    public void getErrorCallback() {
        ErrorCallback errorCallback = this.scenarioSimulationKogitoRuntimeCreationAssetsDropdownProviderImplSpy.getErrorCallback();
        Assert.assertFalse((boolean)errorCallback.error((Object)"message", new Throwable("ex")));
        ((ErrorPopupPresenter)Mockito.verify((Object)this.errorPopupPresenterMock, (VerificationMode)Mockito.times((int)1))).showMessage((String)Matchers.eq((Object)"message: ex"));
    }

    @Test
    public void getKieAssetsDropdownItemFileWithoutPath() {
        String fullPath = "filename.etc";
        KieAssetsDropdownItem item = this.scenarioSimulationKogitoRuntimeCreationAssetsDropdownProviderImplSpy.getKieAssetsDropdownItem(fullPath);
        Assert.assertNotNull((Object)item);
        Assert.assertEquals((Object)fullPath, (Object)item.getValue());
        Assert.assertEquals((Object)fullPath, (Object)item.getSubText());
        Assert.assertEquals((Object)fullPath, (Object)item.getText());
    }

    @Test
    public void getKieAssetsDropdownItemFileWithPath() {
        String path = "path/";
        String fileName = "filename.etc";
        String fullPath = path + fileName;
        KieAssetsDropdownItem item = this.scenarioSimulationKogitoRuntimeCreationAssetsDropdownProviderImplSpy.getKieAssetsDropdownItem(fullPath);
        Assert.assertNotNull((Object)item);
        Assert.assertEquals((Object)fullPath, (Object)item.getValue());
        Assert.assertEquals((Object)fullPath, (Object)item.getSubText());
        Assert.assertEquals((Object)fileName, (Object)item.getText());
    }

    @Test
    public void getKieAssetsDropdownItemFileWithLongPath() {
        String path = "long/path/";
        String fileName = "filename.etc";
        String fullPath = path + fileName;
        KieAssetsDropdownItem item = this.scenarioSimulationKogitoRuntimeCreationAssetsDropdownProviderImplSpy.getKieAssetsDropdownItem(fullPath);
        Assert.assertNotNull((Object)item);
        Assert.assertEquals((Object)fullPath, (Object)item.getValue());
        Assert.assertEquals((Object)fullPath, (Object)item.getSubText());
        Assert.assertEquals((Object)fileName, (Object)item.getText());
    }

    @Test
    public void getKieAssetsDropdownItemFileWithPathWindows() {
        String path = "path\\";
        String fileName = "filename.etc";
        String fullPath = path + fileName;
        KieAssetsDropdownItem item = this.scenarioSimulationKogitoRuntimeCreationAssetsDropdownProviderImplSpy.getKieAssetsDropdownItem(fullPath);
        Assert.assertNotNull((Object)item);
        Assert.assertEquals((Object)fullPath, (Object)item.getValue());
        Assert.assertEquals((Object)fullPath, (Object)item.getSubText());
        Assert.assertEquals((Object)fileName, (Object)item.getText());
    }

    @Test
    public void getKieAssetsDropdownItemFileWithLongPathWindows() {
        String path = "long\\pat\\";
        String fileName = "filename.etc";
        String fullPath = path + fileName;
        KieAssetsDropdownItem item = this.scenarioSimulationKogitoRuntimeCreationAssetsDropdownProviderImplSpy.getKieAssetsDropdownItem(fullPath);
        Assert.assertNotNull((Object)item);
        Assert.assertEquals((Object)fullPath, (Object)item.getValue());
        Assert.assertEquals((Object)fullPath, (Object)item.getSubText());
        Assert.assertEquals((Object)fileName, (Object)item.getText());
    }
}

