/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.models.datamodel.util;

import org.drools.workbench.models.datamodel.util.ListSplitter;
import org.junit.Assert;
import org.junit.Test;

public class ListSplitterTest {
    @Test
    public void basicABC() throws Exception {
        String[] split = ListSplitter.split((String)"a,b,c");
        Assert.assertEquals((long)3L, (long)split.length);
        Assert.assertEquals((Object)"a", (Object)split[0]);
        Assert.assertEquals((Object)"b", (Object)split[1]);
        Assert.assertEquals((Object)"c", (Object)split[2]);
    }

    @Test
    public void keepSpacesABC() throws Exception {
        String[] split = ListSplitter.split((String)"a, b ,c");
        Assert.assertEquals((long)3L, (long)split.length);
        Assert.assertEquals((Object)"a", (Object)split[0]);
        Assert.assertEquals((Object)" b ", (Object)split[1]);
        Assert.assertEquals((Object)"c", (Object)split[2]);
    }

    @Test
    public void specialABC() throws Exception {
        String[] split = ListSplitter.split((String)"'a','b','c'");
        Assert.assertEquals((long)3L, (long)split.length);
        Assert.assertEquals((Object)"a", (Object)split[0]);
        Assert.assertEquals((Object)"b", (Object)split[1]);
        Assert.assertEquals((Object)"c", (Object)split[2]);
    }

    @Test
    public void specialABCSpaces() throws Exception {
        String[] split = ListSplitter.split((String)" 'a' , 'b' , 'c' ");
        Assert.assertEquals((long)3L, (long)split.length);
        Assert.assertEquals((Object)"a", (Object)split[0]);
        Assert.assertEquals((Object)"b", (Object)split[1]);
        Assert.assertEquals((Object)"c", (Object)split[2]);
    }

    @Test
    public void basicCharacters() throws Exception {
        String[] split = ListSplitter.split((String)"',!,%,)");
        Assert.assertEquals((long)4L, (long)split.length);
        Assert.assertEquals((Object)"'", (Object)split[0]);
        Assert.assertEquals((Object)"!", (Object)split[1]);
        Assert.assertEquals((Object)"%", (Object)split[2]);
        Assert.assertEquals((Object)")", (Object)split[3]);
    }

    @Test
    public void splitItemsWithCommas() throws Exception {
        String[] split = ListSplitter.split((String)"'One sentence.','Another one, but with comma.','Third one. I'll make things, if possible, even more complicated.'");
        Assert.assertEquals((long)3L, (long)split.length);
        Assert.assertEquals((Object)"One sentence.", (Object)split[0]);
        Assert.assertEquals((Object)"Another one, but with comma.", (Object)split[1]);
        Assert.assertEquals((Object)"Third one. I'll make things, if possible, even more complicated.", (Object)split[2]);
    }

    @Test
    public void changeQuoteCharacter() throws Exception {
        String[] split = ListSplitter.split((String)"\"", (boolean)true, (String)"\"Helsinki, Finland\", Boston");
        Assert.assertEquals((long)2L, (long)split.length);
        Assert.assertEquals((Object)"Helsinki, Finland", (Object)split[0]);
        Assert.assertEquals((Object)"Boston", (Object)split[1]);
    }

    @Test
    public void changeQuoteCharacterSkipTrimming() throws Exception {
        String[] split = ListSplitter.split((String)"\"", (boolean)false, (String)"\"Helsinki, Finland\", Boston");
        Assert.assertEquals((long)2L, (long)split.length);
        Assert.assertEquals((Object)"Helsinki, Finland", (Object)split[0]);
        Assert.assertEquals((Object)" Boston", (Object)split[1]);
    }

    @Test
    public void changeQuoteCharacterTrimming_One() throws Exception {
        String[] split = ListSplitter.split((String)"\"", (boolean)true, (String)"Boston, \"Helsinki, Finland\"");
        Assert.assertEquals((long)2L, (long)split.length);
        Assert.assertEquals((Object)"Boston", (Object)split[0]);
        Assert.assertEquals((Object)"Helsinki, Finland", (Object)split[1]);
    }

    @Test
    public void changeQuoteCharacterTrimming_Two() throws Exception {
        String[] split = ListSplitter.split((String)"\"", (boolean)true, (String)"Boston, \"Helsinki, Finland\", Prague");
        Assert.assertEquals((long)3L, (long)split.length);
        Assert.assertEquals((Object)"Boston", (Object)split[0]);
        Assert.assertEquals((Object)"Helsinki, Finland", (Object)split[1]);
        Assert.assertEquals((Object)"Prague", (Object)split[2]);
    }

    @Test
    public void changeQuoteCharacterTrimming_Three() throws Exception {
        String[] split = ListSplitter.split((String)"\"", (boolean)true, (String)"\"Boston\", \"Helsinki, Finland\", \"Prague\"");
        Assert.assertEquals((long)3L, (long)split.length);
        Assert.assertEquals((Object)"Boston", (Object)split[0]);
        Assert.assertEquals((Object)"Helsinki, Finland", (Object)split[1]);
        Assert.assertEquals((Object)"Prague", (Object)split[2]);
    }

    @Test
    public void changeQuoteCharacterTrimming_Four() throws Exception {
        String[] split = ListSplitter.split((String)"\"", (boolean)true, (String)"\"Boston\", \"'Helsinki', \"Finland\"\", \"Prague\"");
        Assert.assertEquals((long)3L, (long)split.length);
        Assert.assertEquals((Object)"Boston", (Object)split[0]);
        Assert.assertEquals((Object)"'Helsinki', \"Finland\"", (Object)split[1]);
        Assert.assertEquals((Object)"Prague", (Object)split[2]);
    }

    @Test
    public void changeQuoteCharacterTrimming_Five() throws Exception {
        String[] split = ListSplitter.split((String)"\"", (boolean)true, (String)"\"Boston\",\"'Helsinki',\"Finland\"\",\"Prague\"");
        Assert.assertEquals((long)3L, (long)split.length);
        Assert.assertEquals((Object)"Boston", (Object)split[0]);
        Assert.assertEquals((Object)"'Helsinki',\"Finland\"", (Object)split[1]);
        Assert.assertEquals((Object)"Prague", (Object)split[2]);
    }

    @Test
    public void changeQuoteCharacterTrimming_Six() throws Exception {
        String[] split = ListSplitter.split((String)"\"", (boolean)true, (String)"\"Boston,'Helsinki',Finland,Prague\"");
        Assert.assertEquals((long)1L, (long)split.length);
        Assert.assertEquals((Object)"Boston,'Helsinki',Finland,Prague", (Object)split[0]);
    }

    @Test
    public void changeQuoteCharacterTrimming_Seven() throws Exception {
        String[] split = ListSplitter.split((String)"\"", (boolean)true, (String)"\"Boston,'Helsinki',Finland,\"Prague\"\"");
        Assert.assertEquals((long)1L, (long)split.length);
        Assert.assertEquals((Object)"Boston,'Helsinki',Finland,\"Prague\"", (Object)split[0]);
    }
}

